<?php
/**
 * Kirki plugin compatibility for kirki pro controls
 *
 * @author     D-THEMES
 * @package    WP Alpha Core Framework
 * @subpackage Core
 * @version    1.0
 */

use Elementor\Controls_Manager;

defined( 'ABSPATH' ) || die;

class Alpha_Core_Kirki extends Alpha_Base {

	/**
	 * An array containing field identifieds and their doc urls.
	 *
	 * @access private
	 * @since 1.0
	 * @var array
	 */
	private $docs = [];

	/**
	 * Constructor
	 *
	 * @since 1.0
	 */
	public function __construct() {
		Kirki::add_config( 'option' );
		add_action( 'plugins_loaded', array( $this, 'remove_kirki_load_controls' ), 8 );
		add_action( 'plugins_loaded', array( $this, 'pro_load_controls' ) );
		add_action( 'customize_controls_print_footer_scripts', array( $this, 'customize_controls_print_footer_scripts' ) );
		add_filter( 'kirki_field_add_control_args', array( $this, 'filter_control_args' ), 10, 2 );
	}

	/**
	 * Prevent Kirki plugin's loading control
	 */
	public function remove_kirki_load_controls() {
		remove_action( 'plugins_loaded', 'kirki_pro_load_controls', 10 );
	}

	/**
	 * Load Kirki PRO controls
	 */
	public function pro_load_controls() {
		// Stop, if Kirki is not installed.
		if ( ! defined( 'KIRKI_VERSION' ) ) {
			return;
		}

		// Stop, if Kirki PRO is already installed.
		if ( defined( 'KIRKI_PRO_VERSION' ) ) {
			return;
		}

		if ( ! function_exists( 'get_plugin_data' ) ) {
			require_once ABSPATH . 'wp-admin/includes/plugin.php';
		}

		define( 'KIRKI_PRO_PLUGIN_FILE', KIRKI_PLUGIN_DIR . '/pro-src/pro-index.php' );
		define( 'KIRKI_PRO_PLUGIN_PATH', KIRKI_PLUGIN_DIR . '/pro-src' );

		$plugin_data = get_plugin_data( KIRKI_PRO_PLUGIN_FILE );

		define( 'KIRKI_PRO_VERSION', $plugin_data['Version'] );

		$this->pro_init_controls();
	}

	/**
	 * Init Kirki PRO controls
	 */
	public function pro_init_controls() {

		$packages = array(
			'headline-divider' => KIRKI_PRO_PLUGIN_PATH . '/packages/kirki-pro-headline-divider',
			'input-slider'     => KIRKI_PRO_PLUGIN_PATH . '/packages/kirki-pro-input-slider',
			'margin-padding'   => KIRKI_PRO_PLUGIN_PATH . '/packages/kirki-pro-margin-padding',
			'responsive'       => ALPHA_CORE_PATH . '/framework/plugins/kirki/packages/kirki-pro-responsive',
			'tabs'             => KIRKI_PRO_PLUGIN_PATH . '/packages/kirki-pro-tabs',
		);

		foreach ( $packages as $class_name => $package ) {
			$init_class_name = $class_name;
			$init_class_name = str_ireplace( '-', ' ', $init_class_name );
			$init_class_name = ucwords( $init_class_name );
			$init_class_name = str_ireplace( ' ', '', $init_class_name );
			$init_class_name = '\\Kirki\\Pro\\' . $init_class_name . '\\Init';

			$init_file_path = $package . '/' . basename( $package ) . '.php';
			$vendor_file    = $package . '/vendor/autoload.php';

			if ( file_exists( $init_file_path ) ) {
				include_once $init_file_path;
				include_once $vendor_file;
			}

			if ( class_exists( $init_class_name ) ) {
				new $init_class_name();
			}
		}

	}

	/**
	 * Enqueue scripts.
	 *
	 * @access public
	 * @since 1.0
	 */
	public function customize_controls_print_footer_scripts() {
		wp_localize_script( 'alpha-customizer', 'alphaKirkiDocs', $this->docs );
	}

	/**
	 * Filter control args.
	 *
	 * @access public
	 * @since 1.0
	 * @param array                $args         The field arguments.
	 * @param WP_Customize_Manager $wp_customize The customizer instance.
	 * @return array
	 */
	public function filter_control_args( $args, $wp_customize ) {
		if ( isset( $args['doc'] ) && $args['doc'] ) {
			$this->docs[ $args['settings'] ] = [
				'id'  => sanitize_key( $args['settings'] ),
				'url' => esc_url( $args['doc'] ),
			];
		}
		return $args;
	}
}

Alpha_Core_Kirki::get_instance();
