<?php
/**
 * Alpha Checkout Step Element
 *
 * @author  D-THEMES
 * @package Alpha Core Framework
 * @subpackage Core
 * @since 1.3.0
 */

use Elementor\Plugin;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

class Alpha_Checkout_Step_Elementor_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return ALPHA_NAME . '_widget_checkout_step';
	}

	public function get_title() {
		return esc_html__( 'Checkout Step', 'alpha-core' );
	}

	public function get_icon() {
		return 'alpha-elementor-widget-icon eicon-progress-tracker';
	}

	public function get_categories() {
		return array( 'alpha_widget' );
	}

	public function get_keywords() {
		return array( 'cart', 'checkout', 'order complete', 'step', 'header', 'page header' );
	}

	public function has_widget_inner_wrapper(): bool {
		return ! Plugin::$instance->experiments->is_feature_active( 'e_optimized_markup' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_step_general',
			array(
				'label' => __( 'General', 'alpha-core' ),
			)
		);

			$this->add_responsive_control(
				'step_align',
				array(
					'label'     => esc_html__( 'Alignment', 'alpha-core' ),
					'type'      => Controls_Manager::CHOOSE,
					'options'   => array(
						'flex-start' => array(
							'title' => esc_html__( 'Left', 'alpha-core' ),
							'icon'  => 'eicon-text-align-left',
						),
						'center'     => array(
							'title' => esc_html__( 'Center', 'alpha-core' ),
							'icon'  => 'eicon-text-align-center',
						),
						'flex-end'   => array(
							'title' => esc_html__( 'Right', 'alpha-core' ),
							'icon'  => 'eicon-text-align-right',
						),
					),
					'selectors' => array(
						'.elementor-element-{{ID}} .woo-page-header .breadcrumb' => 'justify-content: {{VALUE}};',
					),
				)
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				array(
					'name'     => 'step_typography',
					'selector' => '.elementor-element-{{ID}} .woo-page-header .breadcrumb',
				)
			);

			$this->add_control(
				'step_color',
				array(
					'label'     => esc_html__( 'Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .woo-page-header .delimiter, .elementor-element-{{ID}} .woo-page-header .breadcrumb a' => 'color: {{VALUE}};',
					),
				)
			);

			$this->add_control(
				'step_hover_color',
				array(
					'label'     => esc_html__( 'Hover Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .woo-page-header .breadcrumb a:hover' => 'color: {{VALUE}};',
					),
				)
			);

			$this->add_control(
				'step_active_color',
				array(
					'label'     => esc_html__( 'Active Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .woo-page-header .current a' => 'color: {{VALUE}};',
					),
				)
			);

		$this->end_controls_section();
	}

	protected function render() {
		alpha_print_checkout_steps();
	}
}
