/**
 * Alpha Image Gallery JS
 * 
 * @author     D-THEMES
 * @package    WP Alpha Core FrameWork
 * @subpackage Core
 * @version    1.2.0
 */

'use strict';
window.theme = window.theme || {};
(function ($) {
    /**
     * Run image gallery popup
     *
     * @since 1.0
     * @param {jQuery} Selector
     */
    theme.imageGallery = function (parent, selector) {

        $(parent).each(function () {
            $(this).magnificPopup(
                $.extend(
                    {},
                    theme.defaults.popup,
                    {
                        delegate: selector,
                        type: 'image',
                        closeOnContentClick: false,
                        closeOnBgClick: true,
                        mainClass: 'mfp-with-zoom mfp-img-mobile',
                        image: {
                            verticalFit: true,
                        },
                        gallery: {
                            enabled: true
                        }
                    }
                )
            );
        })
    }

    if (window.theme && theme.status == 'complete') {
        if ($.fn.magnificPopup) {
            theme.imageGallery('.image-gallery.use_lightbox', '.image-gallery-item a');
        }
    } else {
        $(window).on('alpha_complete', function () {
            if ($.fn.magnificPopup) {
                theme.imageGallery('.image-gallery.use_lightbox', '.image-gallery-item a');
            }
        });
    }
})(jQuery);