<?php
/**
 * Alpha Studio Blocks List Template
 *
 * @author     Andon
 * @package    Alpha Core Framework
 * @subpackage Core
 * @since      4.1
 */
defined( 'ABSPATH' ) || die;

$category_map = array();
foreach ( $args['studio']->get_block_categories() as $index => $category ) {
	$category_map[ $category['id'] ] = array(
		'title' => $args['studio']->get_category_title( $category['title'] ),
		'name'  => $category['title'],
	);
}

$post_id = 0;
if ( isset( $_REQUEST['post_id'] ) ) {
	$post_id = intval( $_REQUEST['post_id'] );
}
$template_type    = get_post_meta( $post_id, ALPHA_NAME . '_template_type', true );
$ignore_templates = array( 'block', 'type', 'error-404', 'favourites', 'my-templates' );

foreach ( $args['blocks'] as $block ) :
	if ( $block instanceof WP_Post ) :
		$block_template_type = get_post_meta( $block->ID, ALPHA_NAME . '_template_type', true );
		if ( 'shop_layout' == $block_template_type ) {
			$block_template_type = 'shop';
		}
		?>
		<div class="block block-template">
			<div class="block-category">
				<h4 class="block-title"><?php echo esc_html( $block->post_title ); ?></h4>
				<img src="<?php echo ALPHA_CORE_URI; ?>/assets/images/add-on/studio/<?php echo esc_attr( $block_template_type ); ?>.jpg">
				<div class="block-actions" data-id="<?php echo esc_attr( $block->ID ); ?>" data-category="<?php echo esc_attr( $block_template_type ); ?>">
					<button class="btn <?php echo boolval( $args['studio']->new_template_mode ) ? 'select' : 'import'; ?>">
						<i class="<?php echo ALPHA_ICON_PREFIX; ?>-icon-download2"></i><?php esc_html_e( 'Download', 'alpha-core' ); ?>
					</button>
				</div>
			</div>
		</div>
		<?php
	else :
		$class = 'block block-online';
		if ( isset( $args['favourites_map'][ $block['block_id'] ] ) ) {
			$class .= ' favour';
		}
		if ( isset( $block['c'] ) && isset( $category_map[ $block['c'] ]['name'] ) ) {
			$class .= ' ' . $category_map[ $block['c'] ]['name'];
		}
		$downloadable = 'block' == $category_map[ $block['c'] ]['name'] || ! in_array( $category_map[ $block['c'] ]['name'], $args['studio']->front_categories ) || $template_type == $category_map[ $block['c'] ]['name'] || in_array( $category_map[ $block['c'] ]['name'], $ignore_templates );
		?>
		<div class="<?php echo esc_attr( $class ); ?>">
			<!-- <?php if ( isset( $block['u'] ) ) : ?>
			<a href="<?php echo esc_url( $block['u'] ); ?>" target="_blank"></a>
			<?php endif; ?> -->
			<div class="block-img-wrapper">
				<div class="block-inner-img-wrapper" style="background-image: url(<?php echo esc_url( ALPHA_SERVER_URI . ( 'wpalpha' == ALPHA_NAME ? 'framework' : ALPHA_NAME ) . '/dummy/images/studio/' . intval( isset( $block['s'] ) ? $block['s'] : $block['block_id'] ) . '.jpg' ); ?>)">
					<img src="<?php echo esc_url( ALPHA_SERVER_URI . ( 'wpalpha' == ALPHA_NAME ? 'framework' : ALPHA_NAME ) . '/dummy/images/studio/' . intval( isset( $block['s'] ) ? $block['s'] : $block['block_id'] ) . '.jpg' ); ?>" alt="<?php echo esc_attr( $block['t'] ); ?>"<?php echo isset( $block['w'] ) && $block['w'] ? ' width="' . intval( $block['w'] ) . '"' : '', isset( $block['h'] ) && $block['h'] ? ' height="' . intval( $block['h'] ) . '"' : ''; ?>>
				</div>
				<div class="block-actions" data-id="<?php echo esc_attr( $block['block_id'] ); ?>" data-category="<?php echo esc_attr( $block['c'] ); ?>">
					<button class="btn favourite"><i class="<?php echo ALPHA_ICON_PREFIX; ?>-icon-heart"></i><?php esc_html_e( 'Favourite', 'alpha-core' ); ?></button>
					<?php
					if ( class_exists( 'Alpha_Admin' ) && Alpha_Admin::get_instance()->is_registered() ) {
						if ( $downloadable ) {
							?>
						<button class="btn <?php echo boolval( $args['studio']->new_template_mode ) ? 'select' : 'import'; ?>">
							<i class="<?php echo ALPHA_ICON_PREFIX; ?>-icon-download2"></i><?php esc_html_e( 'Download', 'alpha-core' ); ?>
						</button>
							<?php
						}
					}
					?>
				</div>
				<?php if ( ! $downloadable && isset( $category_map[ $block['c'] ]['title'] ) ) : ?>
					<span class="tip"><?php printf( esc_html__( 'For %s Builder', 'alpha-core' ), $category_map[ $block['c'] ]['title'] ); ?></span>
				<?php endif; ?>
			</div>

			<h5 class="block-title"><?php echo esc_html( $block['t'] ); ?></h5>
			<div class="block-details">
				<span class="like-count"><i></i><?php echo 10 <= $block['f'] ? ( intval( $block['f'] / 10 ) * 10 . '+' ) : (int) $block['f']; ?></span>
				<span class="download-count"><i></i><?php echo 10 <= $block['l'] ? ( intval( $block['l'] / 10 ) * 10 . '+' ) : (int) $block['l']; ?></span>
			</div>
		</div>
		<?php
	endif;
endforeach;
