<?php
/**
 * name             - Wireframe title
 * cat_name         - Comma separated list for multiple categories (cat display name)
 * custom_class     - Space separated list for multiple categories (cat ID)
 * dependency       - Array of dependencies
 * is_content_block - (optional) Best in a content block
 *
 * @version  1.0.0
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$wireframe_categories = UNCDWF_Dynamic::get_wireframe_categories();
$data                 = array();

// Wireframe properties

$data[ 'name' ]             = esc_html__( 'Shop Stacked', 'uncode-wireframes' );
$data[ 'cat_name' ]         = $wireframe_categories[ 'shop' ];
$data[ 'custom_class' ]     = 'shop';
$data[ 'image_path' ]       = UNCDWF_THUMBS_URL . 'shop/Shop-Stacked.jpg';
$data[ 'dependency' ]       = array();
$data[ 'is_content_block' ] = false;

// Wireframe content

$data[ 'content' ]      = '
[vc_row unlock_row_content="yes" row_height_percent="0" override_padding="yes" h_padding="5" top_padding="5" bottom_padding="5" back_color="'. uncode_wf_print_color( 'color-nhtu' ) .'" overlay_alpha="50" gutter_size="3" column_width_percent="100" shift_y="0" z_index="0" bottom_divider="step" css_animation="inner-rows" animation_origin="center" animation_scale_val="105" animation_opacity="100" animation_x="0" animation_x_alt="yes" animation_y="0" animation_blur="0" animation_rotate="0" animation_perspective="0" animation_rotate_alt="yes" animation_start_point="center" animation_inner_space="25" animation_ease_out="expo" content_parallax="0" uncode_shortcode_id="320727" back_color_type="uncode-palette" el_class="overflow-hidden"][vc_column column_width_percent="100" position_vertical="bottom" gutter_size="0" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/1" uncode_shortcode_id="460469"][vc_row_inner row_inner_height_percent="0" overlay_alpha="50" gutter_size="3" shift_y="0" z_index="1" sticky="yes" uncode_shortcode_id="192618" limit_content=""][vc_column_inner column_width_percent="36" position_horizontal="left" gutter_size="0" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/1" uncode_shortcode_id="577026"][uncode_index el_id="index-879821" index_type="css_grid" loop="size:1|order_by:date|post_type:product|taxonomy_count:10" grid_items="1" screen_lg_items="1" screen_lg_breakpoint="1000" screen_md_items="1" screen_md_breakpoint="600" screen_sm_items="1" screen_sm_breakpoint="480" gutter_size="0" product_items="media|featured|onpost|original|hide-sale|inherit-atc|inherit-w-atc|atc-typo-default|hide-atc,title,price|default" single_text="overlay" css_grid_images_size="four-five" single_style="dark" single_shape="round" radius="hg" single_overlay_opacity="15" single_overlay_anim="no" single_text_visible="yes" single_text_anim="no" single_image_anim="no" single_secondary="yes" single_v_position="top" single_padding="3" single_text_reduced="yes"  single_title_dimension="h3"   single_shadow="yes" shadow_weight="xl" shadow_darker="yes" single_border="yes" custom_cursor="diff" uncode_shortcode_id="195970"][/vc_column_inner][/vc_row_inner][vc_row_inner row_inner_height_percent="0" overlay_alpha="50" gutter_size="3" shift_y="0" z_index="2" sticky="yes" uncode_shortcode_id="814542" limit_content=""][vc_column_inner column_width_percent="36" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/1" uncode_shortcode_id="993045"][uncode_index el_id="index-8798215" index_type="css_grid" loop="size:1|order_by:date|post_type:product|taxonomy_count:10" grid_items="1" screen_lg_items="1" screen_lg_breakpoint="1000" screen_md_items="1" screen_md_breakpoint="600" screen_sm_items="1" screen_sm_breakpoint="480" gutter_size="0" product_items="media|featured|onpost|original|hide-sale|inherit-atc|inherit-w-atc|atc-typo-default|hide-atc,title,price|default" single_text="overlay" css_grid_images_size="four-five" single_style="dark" single_shape="round" radius="hg" single_overlay_opacity="15" single_overlay_anim="no" single_text_visible="yes" single_text_anim="no" single_image_anim="no" single_secondary="yes" single_v_position="top" single_padding="3" single_text_reduced="yes"  single_title_dimension="h3"   single_shadow="yes" shadow_weight="xl" shadow_darker="yes" single_border="yes" custom_cursor="diff" uncode_shortcode_id="102020" offset="1"][/vc_column_inner][/vc_row_inner][vc_row_inner row_inner_height_percent="0" overlay_alpha="50" gutter_size="3" shift_y="0" z_index="2" sticky="yes" uncode_shortcode_id="814542" limit_content=""][vc_column_inner column_width_percent="36" position_horizontal="right" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/1" uncode_shortcode_id="193767"][uncode_index el_id="index-8798210" index_type="css_grid" loop="size:1|order_by:date|post_type:product|taxonomy_count:10" grid_items="1" screen_lg_items="1" screen_lg_breakpoint="1000" screen_md_items="1" screen_md_breakpoint="600" screen_sm_items="1" screen_sm_breakpoint="480" gutter_size="0" product_items="media|featured|onpost|original|hide-sale|inherit-atc|inherit-w-atc|atc-typo-default|hide-atc,title,price|default" single_text="overlay" css_grid_images_size="four-five" single_style="dark" single_shape="round" radius="hg" single_overlay_opacity="15" single_overlay_anim="no" single_text_visible="yes" single_text_anim="no" single_image_anim="no" single_secondary="yes" single_v_position="top" single_padding="3" single_text_reduced="yes"  single_title_dimension="h3"   single_shadow="yes" shadow_weight="xl" shadow_darker="yes" single_border="yes" custom_cursor="diff" uncode_shortcode_id="767855" offset="2"][/vc_column_inner][/vc_row_inner][vc_row_inner row_inner_height_percent="0" overlay_alpha="50" gutter_size="3" shift_y="0" z_index="1" sticky="yes" uncode_shortcode_id="192618" limit_content=""][vc_column_inner column_width_percent="36" position_horizontal="left" gutter_size="0" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/1" uncode_shortcode_id="577026"][uncode_index el_id="index-8798217" index_type="css_grid" loop="size:1|order_by:date|post_type:product|taxonomy_count:10" grid_items="1" screen_lg_items="1" screen_lg_breakpoint="1000" screen_md_items="1" screen_md_breakpoint="600" screen_sm_items="1" screen_sm_breakpoint="480" gutter_size="0" product_items="media|featured|onpost|original|hide-sale|inherit-atc|inherit-w-atc|atc-typo-default|hide-atc,title,price|default" single_text="overlay" css_grid_images_size="four-five" single_style="dark" single_shape="round" radius="hg" single_overlay_opacity="15" single_overlay_anim="no" single_text_visible="yes" single_text_anim="no" single_image_anim="no" single_secondary="yes" single_v_position="top" single_padding="3" single_text_reduced="yes"  single_title_dimension="h3"   single_shadow="yes" shadow_weight="xl" shadow_darker="yes" single_border="yes" custom_cursor="diff" uncode_shortcode_id="113852" offset="3"][/vc_column_inner][/vc_row_inner][vc_row_inner row_inner_height_percent="0" overlay_alpha="50" gutter_size="3" shift_y="0" z_index="2" sticky="yes" uncode_shortcode_id="814542" limit_content=""][vc_column_inner column_width_percent="36" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/1" uncode_shortcode_id="993045"][uncode_index el_id="index-87982151" index_type="css_grid" loop="size:1|order_by:date|post_type:product|taxonomy_count:10" grid_items="1" screen_lg_items="1" screen_lg_breakpoint="1000" screen_md_items="1" screen_md_breakpoint="600" screen_sm_items="1" screen_sm_breakpoint="480" gutter_size="0" product_items="media|featured|onpost|original|hide-sale|inherit-atc|inherit-w-atc|atc-typo-default|hide-atc,title,price|default" single_text="overlay" css_grid_images_size="four-five" single_style="dark" single_shape="round" radius="hg" single_overlay_opacity="15" single_overlay_anim="no" single_text_visible="yes" single_text_anim="no" single_image_anim="no" single_secondary="yes" single_v_position="top" single_padding="3" single_text_reduced="yes"  single_title_dimension="h3"   single_shadow="yes" shadow_weight="xl" shadow_darker="yes" single_border="yes" custom_cursor="diff" uncode_shortcode_id="115761" offset="4"][/vc_column_inner][/vc_row_inner][vc_row_inner row_inner_height_percent="0" overlay_alpha="50" gutter_size="3" shift_y="0" z_index="2" sticky="yes" uncode_shortcode_id="814542" limit_content=""][vc_column_inner column_width_percent="36" position_horizontal="right" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/1" uncode_shortcode_id="193767"][uncode_index el_id="index-87982109" index_type="css_grid" loop="size:1|order_by:date|post_type:product|taxonomy_count:10" grid_items="1" screen_lg_items="1" screen_lg_breakpoint="1000" screen_md_items="1" screen_md_breakpoint="600" screen_sm_items="1" screen_sm_breakpoint="480" gutter_size="0" product_items="media|featured|onpost|original|hide-sale|inherit-atc|inherit-w-atc|atc-typo-default|hide-atc,title,price|default" single_text="overlay" css_grid_images_size="four-five" single_style="dark" single_shape="round" radius="hg" single_overlay_opacity="15" single_overlay_anim="no" single_text_visible="yes" single_text_anim="no" single_image_anim="no" single_secondary="yes" single_v_position="top" single_padding="3" single_text_reduced="yes"  single_title_dimension="h3"   single_shadow="yes" shadow_weight="xl" shadow_darker="yes" single_border="yes" custom_cursor="diff" uncode_shortcode_id="298563" offset="5"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
';

// Check if this wireframe is for a content block
if ( $data[ 'is_content_block' ] && ! $is_content_block ) {
	$data[ 'custom_class' ] .= ' for-content-blocks';
}

// Check if this wireframe requires a plugin
foreach ( $data[ 'dependency' ]  as $dependency ) {
	if ( ! UNCDWF_Dynamic::has_dependency( $dependency ) ) {
		$data[ 'custom_class' ] .= ' has-dependency needs-' . $dependency;
	}
}

vc_add_default_templates( $data );
