<?php
/**
 * name             - Wireframe title
 * cat_name         - Comma separated list for multiple categories (cat display name)
 * custom_class     - Space separated list for multiple categories (cat ID)
 * dependency       - Array of dependencies
 * is_content_block - (optional) Best in a content block
 *
 * @version  1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$wireframe_categories = UNCDWF_Dynamic::get_wireframe_categories();
$data                 = array();

// Wireframe properties

$data[ 'name' ]             = esc_html__( 'Pricing List Tabs Images', 'uncode-wireframes' );
$data[ 'cat_name' ]         = $wireframe_categories[ 'pricing_tables' ];
$data[ 'custom_class' ]     = 'pricing_tables';
$data[ 'image_path' ]       = UNCDWF_THUMBS_URL . 'pricing-tables/Pricing-List-Tabs-Images.jpg';
$data[ 'dependency' ]       = array();
$data[ 'is_content_block' ] = false;

// Wireframe content

$data[ 'content' ]      = '
[vc_row unlock_row_content="yes" row_height_percent="0" override_padding="yes" h_padding="3" top_padding="5" bottom_padding="5" back_color="'. uncode_wf_print_color( 'color-xsdn' ) .'" overlay_alpha="50" gutter_size="3" column_width_use_pixel="yes" shift_y="0" z_index="0" uncode_shortcode_id="101539" back_color_type="uncode-palette" column_width_pixel="1600"][vc_column column_width_percent="100" align_horizontal="align_center" gutter_size="4"  overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" css_animation="alpha-anim" animation_speed="1600" width="1/1" uncode_shortcode_id="252229"][vc_custom_heading text_color="accent" text_size="'. uncode_wf_print_font_size( 'fontsize-155944' ) .'" uncode_shortcode_id="281671" text_color_type="uncode-palette"]Medium headline[/vc_custom_heading][vc_empty_space empty_h="2" desktop_visibility="yes"][vc_tabs tab_no_fade="yes" tab_scrolling="yes" animation_active="yes" typography="advanced" tab_no_border="yes" titles_size="h5" titles_weight="600" gutter_simple="0" uncode_shortcode_id="632820"][vc_tab gutter_size="2" column_padding="3" title="Featured" tab_id="1671548483061-0-5167283140478516728331040301698674893862169997174201617002241090571715672341660" slug="featured"][vc_row_inner row_inner_height_percent="0" overlay_alpha="50" gutter_size="5" shift_y="0" z_index="0" uncode_shortcode_id="583380" limit_content=""][vc_column_inner column_width_percent="100" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/3" uncode_shortcode_id="136441"][uncode_pricing_list values="%5B%7B%22entry%22%3A%22Mediterranean%20Bliss%22%2C%22value%22%3A%22%2412%22%2C%22text%22%3A%22Beef%20patty%2C%20feta%20cheese%2C%20roasted%20red%20peppers%2C%20Kalamata%20olives%2C%20tzatziki%20sauce.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Balsamic%20Glaze%22%2C%22value%22%3A%22%2415%22%2C%22text%22%3A%22Beef%20patty%2C%20fresh%20mozzarella%2C%20tomato%20slices%2C%20basil%20leaves%2C%20balsamic%20glaze.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Smokey%20Mountain%22%2C%22value%22%3A%22%2416%22%2C%22text%22%3A%22Beef%20patty%2C%20smoked%20Gouda%20cheese%2C%20caramelized%20onions%2C%20crispy%20bacon.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Texas%20Heatwave%22%2C%22value%22%3A%22%2418%22%2C%22text%22%3A%22Beef%20patty%2C%20pepper%20jack%20cheese%2C%20jalape%C3%B1os%2C%20grilled%20onions%2C%20chipotle%20mayo.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Surf%20\'n\%20Turf%22%2C%22value%22%3A%22%2411%22%2C%22text%22%3A%22Beef%20patty%2C%20lobster%20meat%2C%20Swiss%20cheese%2C%20garlic%20butter%2C%20arugula.%22%2C%22media%22%3A%2280471%22%7D%5D" gutter_tab_h="2" tab_gap="2" media_break="mobile" media_width_percent="20" border_style="dashed" border_color="accent" heading_semantic="h6" text_size="'. uncode_wf_print_font_size( 'h4' ) .'" text_weight="600" uncode_shortcode_id="132472" border_color_type="uncode-palette" media_max_width="120"][/vc_column_inner][vc_column_inner column_width_percent="100" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/3" uncode_shortcode_id="128069"][uncode_pricing_list values="%5B%7B%22entry%22%3A%22Mediterranean%20Bliss%22%2C%22value%22%3A%22%2412%22%2C%22text%22%3A%22Beef%20patty%2C%20feta%20cheese%2C%20roasted%20red%20peppers%2C%20Kalamata%20olives%2C%20tzatziki%20sauce.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Surf%20\'n\%20Turf%22%2C%22value%22%3A%22%2411%22%2C%22text%22%3A%22Beef%20patty%2C%20lobster%20meat%2C%20Swiss%20cheese%2C%20garlic%20butter%2C%20arugula.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Texas%20Heatwave%22%2C%22value%22%3A%22%2418%22%2C%22text%22%3A%22Beef%20patty%2C%20pepper%20jack%20cheese%2C%20jalape%C3%B1os%2C%20grilled%20onions%2C%20chipotle%20mayo.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Balsamic%20Glaze%22%2C%22value%22%3A%22%2415%22%2C%22text%22%3A%22Beef%20patty%2C%20fresh%20mozzarella%2C%20tomato%20slices%2C%20basil%20leaves%2C%20balsamic%20glaze.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Smokey%20Mountain%22%2C%22value%22%3A%22%2416%22%2C%22text%22%3A%22Beef%20patty%2C%20smoked%20Gouda%20cheese%2C%20caramelized%20onions%2C%20crispy%20bacon.%22%2C%22media%22%3A%2280471%22%7D%5D" gutter_tab_h="2" tab_gap="2" media_break="mobile" media_width_percent="20" border_style="dashed" border_color="accent" heading_semantic="h6" text_size="'. uncode_wf_print_font_size( 'h4' ) .'" text_weight="600" uncode_shortcode_id="139490" border_color_type="uncode-palette" media_max_width="120"][/vc_column_inner][vc_column_inner column_width_percent="100" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/3" uncode_shortcode_id="988007"][uncode_pricing_list values="%5B%7B%22entry%22%3A%22Smokey%20Mountain%22%2C%22value%22%3A%22%2416%22%2C%22text%22%3A%22Beef%20patty%2C%20smoked%20Gouda%20cheese%2C%20caramelized%20onions%2C%20crispy%20bacon.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Balsamic%20Glaze%22%2C%22value%22%3A%22%2415%22%2C%22text%22%3A%22Beef%20patty%2C%20fresh%20mozzarella%2C%20tomato%20slices%2C%20basil%20leaves%2C%20balsamic%20glaze.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Surf%20\'n\%20Turf%22%2C%22value%22%3A%22%2411%22%2C%22text%22%3A%22Beef%20patty%2C%20lobster%20meat%2C%20Swiss%20cheese%2C%20garlic%20butter%2C%20arugula.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Texas%20Heatwave%22%2C%22value%22%3A%22%2418%22%2C%22text%22%3A%22Beef%20patty%2C%20pepper%20jack%20cheese%2C%20jalape%C3%B1os%2C%20grilled%20onions%2C%20chipotle%20mayo.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Mediterranean%20Bliss%22%2C%22value%22%3A%22%2412%22%2C%22text%22%3A%22Beef%20patty%2C%20feta%20cheese%2C%20roasted%20red%20peppers%2C%20Kalamata%20olives%2C%20tzatziki%20sauce.%22%2C%22media%22%3A%2280471%22%7D%5D" gutter_tab_h="2" tab_gap="2" media_break="mobile" media_width_percent="20" border_style="dashed" border_color="accent" heading_semantic="h6" text_size="'. uncode_wf_print_font_size( 'h4' ) .'" text_weight="600" uncode_shortcode_id="566055" border_color_type="uncode-palette" media_max_width="120"][/vc_column_inner][/vc_row_inner][/vc_tab][vc_tab gutter_size="2" column_padding="3" title="Beef Burgers" tab_id="1671548483489-0-9167283140478516728331040301698674893862169997174201617002241090571715672341660" slug="beef"][vc_row_inner row_inner_height_percent="0" overlay_alpha="50" gutter_size="5" shift_y="0" z_index="0" uncode_shortcode_id="583380" limit_content=""][vc_column_inner column_width_percent="100" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/3" uncode_shortcode_id="128069"][uncode_pricing_list values="%5B%7B%22entry%22%3A%22Texas%20Heatwave%22%2C%22value%22%3A%22%2418%22%2C%22text%22%3A%22Beef%20patty%2C%20pepper%20jack%20cheese%2C%20jalape%C3%B1os%2C%20grilled%20onions%2C%20chipotle%20mayo.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Mediterranean%20Bliss%22%2C%22value%22%3A%22%2412%22%2C%22text%22%3A%22Beef%20patty%2C%20feta%20cheese%2C%20roasted%20red%20peppers%2C%20Kalamata%20olives%2C%20tzatziki%20sauce.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Balsamic%20Glaze%22%2C%22value%22%3A%22%2415%22%2C%22text%22%3A%22Beef%20patty%2C%20fresh%20mozzarella%2C%20tomato%20slices%2C%20basil%20leaves%2C%20balsamic%20glaze.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Smokey%20Mountain%22%2C%22value%22%3A%22%2416%22%2C%22text%22%3A%22Beef%20patty%2C%20smoked%20Gouda%20cheese%2C%20caramelized%20onions%2C%20crispy%20bacon.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Surf%20\'n\%20Turf%22%2C%22value%22%3A%22%2411%22%2C%22text%22%3A%22Beef%20patty%2C%20lobster%20meat%2C%20Swiss%20cheese%2C%20garlic%20butter%2C%20arugula.%22%2C%22media%22%3A%2280471%22%7D%5D" gutter_tab_h="2" tab_gap="2" media_break="mobile" media_width_percent="20" border_style="dashed" border_color="accent" heading_semantic="h6" text_size="'. uncode_wf_print_font_size( 'h4' ) .'" text_weight="600" uncode_shortcode_id="151800" border_color_type="uncode-palette" media_max_width="120"][/vc_column_inner][vc_column_inner column_width_percent="100" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/3" uncode_shortcode_id="988007"][uncode_pricing_list values="%5B%7B%22entry%22%3A%22Texas%20Heatwave%22%2C%22value%22%3A%22%2418%22%2C%22text%22%3A%22Beef%20patty%2C%20pepper%20jack%20cheese%2C%20jalape%C3%B1os%2C%20grilled%20onions%2C%20chipotle%20mayo.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Balsamic%20Glaze%22%2C%22value%22%3A%22%2415%22%2C%22text%22%3A%22Beef%20patty%2C%20fresh%20mozzarella%2C%20tomato%20slices%2C%20basil%20leaves%2C%20balsamic%20glaze.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Mediterranean%20Bliss%22%2C%22value%22%3A%22%2412%22%2C%22text%22%3A%22Beef%20patty%2C%20feta%20cheese%2C%20roasted%20red%20peppers%2C%20Kalamata%20olives%2C%20tzatziki%20sauce.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Smokey%20Mountain%22%2C%22value%22%3A%22%2416%22%2C%22text%22%3A%22Beef%20patty%2C%20smoked%20Gouda%20cheese%2C%20caramelized%20onions%2C%20crispy%20bacon.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Surf%20\'n\%20Turf%22%2C%22value%22%3A%22%2411%22%2C%22text%22%3A%22Beef%20patty%2C%20lobster%20meat%2C%20Swiss%20cheese%2C%20garlic%20butter%2C%20arugula.%22%2C%22media%22%3A%2280471%22%7D%5D" gutter_tab_h="2" tab_gap="2" media_break="mobile" media_width_percent="20" border_style="dashed" border_color="accent" heading_semantic="h6" text_size="'. uncode_wf_print_font_size( 'h4' ) .'" text_weight="600" uncode_shortcode_id="183610" border_color_type="uncode-palette" media_max_width="120"][/vc_column_inner][vc_column_inner column_width_percent="100" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/3" uncode_shortcode_id="136441"][uncode_pricing_list values="%5B%7B%22entry%22%3A%22Texas%20Heatwave%22%2C%22value%22%3A%22%2418%22%2C%22text%22%3A%22Beef%20patty%2C%20pepper%20jack%20cheese%2C%20jalape%C3%B1os%2C%20grilled%20onions%2C%20chipotle%20mayo.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Mediterranean%20Bliss%22%2C%22value%22%3A%22%2412%22%2C%22text%22%3A%22Beef%20patty%2C%20feta%20cheese%2C%20roasted%20red%20peppers%2C%20Kalamata%20olives%2C%20tzatziki%20sauce.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Balsamic%20Glaze%22%2C%22value%22%3A%22%2415%22%2C%22text%22%3A%22Beef%20patty%2C%20fresh%20mozzarella%2C%20tomato%20slices%2C%20basil%20leaves%2C%20balsamic%20glaze.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Smokey%20Mountain%22%2C%22value%22%3A%22%2416%22%2C%22text%22%3A%22Beef%20patty%2C%20smoked%20Gouda%20cheese%2C%20caramelized%20onions%2C%20crispy%20bacon.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Surf%20\'n\%20Turf%22%2C%22value%22%3A%22%2411%22%2C%22text%22%3A%22Beef%20patty%2C%20lobster%20meat%2C%20Swiss%20cheese%2C%20garlic%20butter%2C%20arugula.%22%2C%22media%22%3A%2280471%22%7D%5D" gutter_tab_h="2" tab_gap="2" media_break="mobile" media_width_percent="20" border_style="dashed" border_color="accent" heading_semantic="h6" text_size="'. uncode_wf_print_font_size( 'h4' ) .'" text_weight="600" uncode_shortcode_id="151800" border_color_type="uncode-palette" media_max_width="120"][/vc_column_inner][/vc_row_inner][/vc_tab][vc_tab gutter_size="3" column_padding="3" title="Chicken" tab_id="1671548483266-0-3167283140478516728331040301698674893862169997174201617002241090571715672341660" slug="chicken"][vc_row_inner row_inner_height_percent="0" overlay_alpha="50" gutter_size="5" shift_y="0" z_index="0" uncode_shortcode_id="583380" limit_content=""][vc_column_inner column_width_percent="100" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/3" uncode_shortcode_id="988007"][uncode_pricing_list values="%5B%7B%22entry%22%3A%22Balsamic%20Glaze%22%2C%22value%22%3A%22%2415%22%2C%22text%22%3A%22Beef%20patty%2C%20fresh%20mozzarella%2C%20tomato%20slices%2C%20basil%20leaves%2C%20balsamic%20glaze.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Surf%20\'n\%20Turf%22%2C%22value%22%3A%22%2411%22%2C%22text%22%3A%22Beef%20patty%2C%20lobster%20meat%2C%20Swiss%20cheese%2C%20garlic%20butter%2C%20arugula.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Texas%20Heatwave%22%2C%22value%22%3A%22%2418%22%2C%22text%22%3A%22Beef%20patty%2C%20pepper%20jack%20cheese%2C%20jalape%C3%B1os%2C%20grilled%20onions%2C%20chipotle%20mayo.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Mediterranean%20Bliss%22%2C%22value%22%3A%22%2412%22%2C%22text%22%3A%22Beef%20patty%2C%20feta%20cheese%2C%20roasted%20red%20peppers%2C%20Kalamata%20olives%2C%20tzatziki%20sauce.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Smokey%20Mountain%22%2C%22value%22%3A%22%2416%22%2C%22text%22%3A%22Beef%20patty%2C%20smoked%20Gouda%20cheese%2C%20caramelized%20onions%2C%20crispy%20bacon.%22%2C%22media%22%3A%2280471%22%7D%5D" gutter_tab_h="2" tab_gap="2" media_break="mobile" media_width_percent="20" border_style="dashed" border_color="accent" heading_semantic="h6" text_size="'. uncode_wf_print_font_size( 'h4' ) .'" text_weight="600" uncode_shortcode_id="153334" border_color_type="uncode-palette" media_max_width="120"][/vc_column_inner][vc_column_inner column_width_percent="100" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/3" uncode_shortcode_id="136441"][uncode_pricing_list values="%5B%7B%22entry%22%3A%22Surf%20\'n\%20Turf%22%2C%22value%22%3A%22%2411%22%2C%22text%22%3A%22Beef%20patty%2C%20lobster%20meat%2C%20Swiss%20cheese%2C%20garlic%20butter%2C%20arugula.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Smokey%20Mountain%22%2C%22value%22%3A%22%2416%22%2C%22text%22%3A%22Beef%20patty%2C%20smoked%20Gouda%20cheese%2C%20caramelized%20onions%2C%20crispy%20bacon.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Texas%20Heatwave%22%2C%22value%22%3A%22%2418%22%2C%22text%22%3A%22Beef%20patty%2C%20pepper%20jack%20cheese%2C%20jalape%C3%B1os%2C%20grilled%20onions%2C%20chipotle%20mayo.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Mediterranean%20Bliss%22%2C%22value%22%3A%22%2412%22%2C%22text%22%3A%22Beef%20patty%2C%20feta%20cheese%2C%20roasted%20red%20peppers%2C%20Kalamata%20olives%2C%20tzatziki%20sauce.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Balsamic%20Glaze%22%2C%22value%22%3A%22%2415%22%2C%22text%22%3A%22Beef%20patty%2C%20fresh%20mozzarella%2C%20tomato%20slices%2C%20basil%20leaves%2C%20balsamic%20glaze.%22%2C%22media%22%3A%2280471%22%7D%5D" gutter_tab_h="2" tab_gap="2" media_break="mobile" media_width_percent="20" border_style="dashed" border_color="accent" heading_semantic="h6" text_size="'. uncode_wf_print_font_size( 'h4' ) .'" text_weight="600" uncode_shortcode_id="130146" border_color_type="uncode-palette" media_max_width="120"][/vc_column_inner][vc_column_inner column_width_percent="100" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/3" uncode_shortcode_id="128069"][uncode_pricing_list values="%5B%7B%22entry%22%3A%22Balsamic%20Glaze%22%2C%22value%22%3A%22%2415%22%2C%22text%22%3A%22Beef%20patty%2C%20fresh%20mozzarella%2C%20tomato%20slices%2C%20basil%20leaves%2C%20balsamic%20glaze.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Smokey%20Mountain%22%2C%22value%22%3A%22%2416%22%2C%22text%22%3A%22Beef%20patty%2C%20smoked%20Gouda%20cheese%2C%20caramelized%20onions%2C%20crispy%20bacon.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Texas%20Heatwave%22%2C%22value%22%3A%22%2418%22%2C%22text%22%3A%22Beef%20patty%2C%20pepper%20jack%20cheese%2C%20jalape%C3%B1os%2C%20grilled%20onions%2C%20chipotle%20mayo.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Mediterranean%20Bliss%22%2C%22value%22%3A%22%2412%22%2C%22text%22%3A%22Beef%20patty%2C%20feta%20cheese%2C%20roasted%20red%20peppers%2C%20Kalamata%20olives%2C%20tzatziki%20sauce.%22%2C%22media%22%3A%2280471%22%7D%2C%7B%22entry%22%3A%22Surf%20\'n\%20Turf%22%2C%22value%22%3A%22%2411%22%2C%22text%22%3A%22Beef%20patty%2C%20lobster%20meat%2C%20Swiss%20cheese%2C%20garlic%20butter%2C%20arugula.%22%2C%22media%22%3A%2280471%22%7D%5D" gutter_tab_h="2" tab_gap="2" media_break="mobile" media_width_percent="20" border_style="dashed" border_color="accent" heading_semantic="h6" text_size="'. uncode_wf_print_font_size( 'h4' ) .'" text_weight="600" uncode_shortcode_id="134440" border_color_type="uncode-palette" media_max_width="120"][/vc_column_inner][/vc_row_inner][/vc_tab][/vc_tabs][vc_row_inner limit_content=""][vc_column_inner column_width_percent="100" align_horizontal="align_center" gutter_size="0" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" align_medium="align_left_tablet" medium_width="0" align_mobile="align_left_mobile" mobile_width="0" width="1/1" uncode_shortcode_id="168782"][vc_column_text uncode_shortcode_id="509705"]* Change the color to match your brand or vision, add your logo.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
';

// Check if this wireframe is for a content block
if ( $data[ 'is_content_block' ] && ! $is_content_block ) {
	$data[ 'custom_class' ] .= ' for-content-blocks';
}

// Check if this wireframe requires a plugin
foreach ( $data[ 'dependency' ]  as $dependency ) {
	if ( ! UNCDWF_Dynamic::has_dependency( $dependency ) ) {
		$data[ 'custom_class' ] .= ' has-dependency needs-' . $dependency;
	}
}

vc_add_default_templates( $data );
