<?php
/**
 * name             - Wireframe title
 * cat_name         - Comma separated list for multiple categories (cat display name)
 * custom_class     - Space separated list for multiple categories (cat ID)
 * dependency       - Array of dependencies
 * is_content_block - (optional) Best in a content block
 *
 * @version  1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$wireframe_categories = UNCDWF_Dynamic::get_wireframe_categories();
$data                 = array();

// Wireframe properties

$data[ 'name' ]             = esc_html__( 'Tabs with Contents', 'uncode-wireframes' );
$data[ 'cat_name' ]         = $wireframe_categories[ 'tabs-accordions' ];
$data[ 'custom_class' ]     = 'tabs-accordions';
$data[ 'image_path' ]       = UNCDWF_THUMBS_URL . 'tabs-accordions/Tabs-with-Contents.jpg';
$data[ 'dependency' ]       = array();
$data[ 'is_content_block' ] = false;

// Wireframe content

$data[ 'content' ]      = '
[vc_row row_height_percent="0" override_padding="yes" h_padding="2" top_padding="5" bottom_padding="5" overlay_alpha="50" gutter_size="3" column_width_percent="100" shift_y="0" z_index="0" uncode_shortcode_id="223554"][vc_column column_width_percent="100" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/1" uncode_shortcode_id="978803"][vc_tabs history="yes" target="row" tab_no_fade="yes" tab_scrolling="yes" animation_active="yes" typography="advanced" border_100="yes" titles_size="h5" titles_weight="600" gutter_simple="0" uncode_shortcode_id="503141"][vc_tab gutter_size="2" column_padding="3" title="About Us" tab_id="1671548483061-0-516728314047851672833104030" slug="about"][vc_row_inner row_inner_height_percent="0" overlay_alpha="50" gutter_size="4" shift_y="0" z_index="0" uncode_shortcode_id="121123" limit_content=""][vc_column_inner width="5/12"][vc_single_image media="'. uncode_wf_print_single_image( '80471' ) .'" media_width_percent="100" media_ratio="four-five" shape="img-round" radius="xs" shadow="yes" shadow_weight="std" uncode_shortcode_id="557376"][/vc_column_inner][vc_column_inner column_width_percent="100" position_vertical="middle" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="7/12" uncode_shortcode_id="165671"][vc_custom_heading heading_semantic="h3" text_height="'. uncode_wf_print_font_height( 'fontheight-357766' ) .'" uncode_shortcode_id="106879"]Efficiently unleash cross-media information without cross-media value. Quickly maximize timely deliverables for real-time schemas. Spectacular maintain clicks-and-mortar solutions without functional solutions.[/vc_custom_heading][vc_column_text text_lead="yes" uncode_shortcode_id="282633"]Capitalize on low hanging fruit to identify a ballpark value added activity to beta test. Override the digital divide with additional clickthroughs from DevOps. Nanotechnology immersion along the information highway will close the loop on focusing solely on the bottom line. Podcasting operational change management inside of workflows to establish a framework. Taking seamless key performance indicators offline to maximise the long tail.[/vc_column_text][vc_column_text uncode_shortcode_id="266561"]<strong>⸻ Maxwell Watkins</strong>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_tab][vc_tab gutter_size="2" column_padding="3" title="Our Method" tab_id="1671548483489-0-916728314047851672833104030" slug="method"][vc_row_inner row_inner_height_percent="0" overlay_alpha="50" gutter_size="4" shift_y="0" z_index="0" limit_content="" uncode_shortcode_id="183214"][vc_column_inner column_width_percent="100" gutter_size="2" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/3" uncode_shortcode_id="106278"][vc_custom_heading text_color="color-uydo" text_size="'. uncode_wf_print_font_size( 'fontsize-160206' ) .'" text_height="'. uncode_wf_print_font_height( 'fontheight-161249' ) .'" uncode_shortcode_id="126487" text_color_type="uncode-palette"]01[/vc_custom_heading][vc_empty_space empty_h="1"][vc_custom_heading uncode_shortcode_id="207429"]Market Analysis[/vc_custom_heading][vc_separator sep_color=",Default"][vc_column_text text_lead="yes" uncode_shortcode_id="212795"]Efficiently unleash cross-media information without cross-media value. Quickly maximize timely deliverables for real-time schemas. Spectacular maintain clicks-and-mortar solutions without functional solutions.[/vc_column_text][vc_empty_space empty_h="1"][vc_button radius="btn-circle" custom_typo="yes" order_width="0" uncode_shortcode_id="173460" link="url:%23"]Learn More[/vc_button][/vc_column_inner][vc_column_inner column_width_percent="100" gutter_size="2" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/3" uncode_shortcode_id="662294"][vc_custom_heading text_color="color-uydo" text_size="'. uncode_wf_print_font_size( 'fontsize-160206' ) .'" text_height="'. uncode_wf_print_font_height( 'fontheight-161249' ) .'" uncode_shortcode_id="834327" text_color_type="uncode-palette"]02[/vc_custom_heading][vc_empty_space empty_h="1"][vc_custom_heading uncode_shortcode_id="620688"]Detailed Design[/vc_custom_heading][vc_separator sep_color=",Default"][vc_column_text text_lead="yes" uncode_shortcode_id="139101"]Completely synergize resource taxing relationships via premier niche markets. Professionally cultivate one-to-one customer service with robust ideas. Dynamically resource-leveling customer service for state of the art.[/vc_column_text][vc_empty_space empty_h="1"][vc_button radius="btn-circle" custom_typo="yes" order_width="0" uncode_shortcode_id="173460" link="url:%23"]Learn More[/vc_button][/vc_column_inner][vc_column_inner column_width_percent="100" gutter_size="2" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/3" uncode_shortcode_id="185620"][vc_custom_heading text_color="color-uydo" text_size="'. uncode_wf_print_font_size( 'fontsize-160206' ) .'" text_height="'. uncode_wf_print_font_height( 'fontheight-161249' ) .'" uncode_shortcode_id="260016" text_color_type="uncode-palette"]03[/vc_custom_heading][vc_empty_space empty_h="1"][vc_custom_heading uncode_shortcode_id="166953"]Product Development[/vc_custom_heading][vc_separator sep_color=",Default"][vc_column_text text_lead="yes" uncode_shortcode_id="684376"]Objectively innovate empowered manufactured products whereas parallel platforms. Holisticly extensible testing procedures for reliable supply chains. Spectacular engage top-line web services vis-a-vis cutting-edge.[/vc_column_text][vc_empty_space empty_h="1"][vc_button radius="btn-circle" custom_typo="yes" order_width="0" uncode_shortcode_id="173460" link="url:%23"]Learn More[/vc_button][/vc_column_inner][/vc_row_inner][/vc_tab][vc_tab gutter_size="3" column_padding="3" title="Services" tab_id="1671548483266-0-316728314047851672833104030" slug="services"][vc_row_inner limit_content=""][vc_column_inner column_width_percent="100" gutter_size="2" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/1" uncode_shortcode_id="175606"][vc_custom_heading text_size="'. uncode_wf_print_font_size( 'h3' ) .'" uncode_shortcode_id="610696"]Video &amp; Post Production[/vc_custom_heading][vc_column_text text_lead="yes" uncode_shortcode_id="127276"]Collaboratively administrate turnkey channels whereas virtual e-tailers. Objectively seize scalable metrics whereas proactive e-services. Seamlessly empower fully researched growth strategies and interoperable internal or "organic" sources. Objectively innovate empowered manufactured products whereas parallel platforms. Holisticly predominate extensible testing procedures for reliable supply chains. Spectacular engage top-line web services vis-a-vis cutting-edge deliverables.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner limit_content=""][vc_column_inner column_width_percent="100" position_vertical="middle" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/2" uncode_shortcode_id="558406"][vc_custom_heading text_size="'. uncode_wf_print_font_size( 'h4' ) .'" uncode_shortcode_id="199555"]$250 / Daily[/vc_custom_heading][/vc_column_inner][vc_column_inner column_width_percent="100" position_vertical="middle" align_horizontal="align_right" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" align_medium="align_left_tablet" medium_width="0" align_mobile="align_left_mobile" mobile_width="0" width="1/2" uncode_shortcode_id="208607"][vc_button size="link" btn_link_underline="btn-underline-out" custom_typo="yes" font_weight="500" icon_position="right" uncode_shortcode_id="622902" icon="fa fa-long-arrow-right"]RESERVE IT[/vc_button][/vc_column_inner][/vc_row_inner][vc_separator sep_color=",Default"][vc_row_inner limit_content=""][vc_column_inner column_width_percent="100" gutter_size="2" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/1" uncode_shortcode_id="175606"][vc_custom_heading text_size="'. uncode_wf_print_font_size( 'h3' ) .'" uncode_shortcode_id="225335"]Photography and Editing[/vc_custom_heading][vc_column_text text_lead="yes" uncode_shortcode_id="128711"]Collaboratively administrate empowered markets via plug-and-play networks. Dynamically procrastinate B2C users after installed base benefits. Spectacular visualize customer directed convergence without revolutionary ROI. Efficiently unleash cross-media information without cross-media value. Quickly maximize timely deliverables for real-time schemas. Spectacular maintain clicks-and-mortar solutions without functional solutions. Professionally cultivate one-to-one customer service with robust ideas.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner limit_content=""][vc_column_inner column_width_percent="100" position_vertical="middle" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/2" uncode_shortcode_id="558406"][vc_custom_heading text_size="'. uncode_wf_print_font_size( 'h4' ) .'" uncode_shortcode_id="784033"]$185 / Daily[/vc_custom_heading][/vc_column_inner][vc_column_inner column_width_percent="100" position_vertical="middle" align_horizontal="align_right" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" align_medium="align_left_tablet" medium_width="0" align_mobile="align_left_mobile" mobile_width="0" width="1/2" uncode_shortcode_id="142386"][vc_button size="link" btn_link_underline="btn-underline-out" custom_typo="yes" font_weight="500" icon_position="right" uncode_shortcode_id="622902" icon="fa fa-long-arrow-right"]RESERVE IT[/vc_button][/vc_column_inner][/vc_row_inner][/vc_tab][/vc_tabs][/vc_column][/vc_row]
';

// Check if this wireframe is for a content block
if ( $data[ 'is_content_block' ] && ! $is_content_block ) {
	$data[ 'custom_class' ] .= ' for-content-blocks';
}

// Check if this wireframe requires a plugin
foreach ( $data[ 'dependency' ]  as $dependency ) {
	if ( ! UNCDWF_Dynamic::has_dependency( $dependency ) ) {
		$data[ 'custom_class' ] .= ' has-dependency needs-' . $dependency;
	}
}

vc_add_default_templates( $data );
