<?php

declare (strict_types=1);
namespace Voxel\Vendor\Paddle\SDK\Resources\Transactions\Operations;

use Voxel\Vendor\Paddle\SDK\Entities\Shared\BillingDetails;
use Voxel\Vendor\Paddle\SDK\Entities\Shared\Checkout;
use Voxel\Vendor\Paddle\SDK\Entities\Shared\CollectionMode;
use Voxel\Vendor\Paddle\SDK\Entities\Shared\CurrencyCode;
use Voxel\Vendor\Paddle\SDK\Entities\Shared\CustomData;
use Voxel\Vendor\Paddle\SDK\Entities\Shared\TransactionStatus;
use Voxel\Vendor\Paddle\SDK\Entities\Transaction\TransactionCreateItem as EntityTransactionCreateItem;
use Voxel\Vendor\Paddle\SDK\Entities\Transaction\TransactionCreateItemWithPrice as EntityTransactionCreateItemWithPrice;
use Voxel\Vendor\Paddle\SDK\Entities\Transaction\TransactionTimePeriod;
use Voxel\Vendor\Paddle\SDK\FiltersUndefined;
use Voxel\Vendor\Paddle\SDK\Resources\Transactions\Operations\Create\TransactionCreateItem;
use Voxel\Vendor\Paddle\SDK\Resources\Transactions\Operations\Create\TransactionCreateItemWithPrice;
use Voxel\Vendor\Paddle\SDK\Resources\Transactions\Operations\Discount\TransactionNonCatalogDiscount;
use Voxel\Vendor\Paddle\SDK\Undefined;
class CreateTransaction implements \JsonSerializable
{
    use FiltersUndefined;
    /**
     * @param array<TransactionCreateItem|TransactionCreateItemWithPrice|EntityTransactionCreateItem|EntityTransactionCreateItemWithPrice> $items
     */
    public function __construct(public readonly array $items, public readonly TransactionStatus|Undefined $status = new Undefined(), public readonly string|Undefined|null $customerId = new Undefined(), public readonly string|Undefined|null $addressId = new Undefined(), public readonly string|Undefined|null $businessId = new Undefined(), public readonly CustomData|Undefined|null $customData = new Undefined(), public readonly CurrencyCode|Undefined $currencyCode = new Undefined(), public readonly CollectionMode|Undefined $collectionMode = new Undefined(), public readonly string|Undefined|null $discountId = new Undefined(), public readonly BillingDetails|Undefined|null $billingDetails = new Undefined(), public readonly TransactionTimePeriod|Undefined|null $billingPeriod = new Undefined(), public readonly Checkout|Undefined|null $checkout = new Undefined(), public readonly TransactionNonCatalogDiscount|Undefined|null $discount = new Undefined())
    {
    }
    public function jsonSerialize(): array
    {
        return $this->filterUndefined(['items' => $this->items, 'status' => $this->status, 'customer_id' => $this->customerId, 'address_id' => $this->addressId, 'business_id' => $this->businessId, 'custom_data' => $this->customData, 'currency_code' => $this->currencyCode, 'collection_mode' => $this->collectionMode, 'discount_id' => $this->discountId, 'billing_details' => $this->billingDetails, 'billing_period' => $this->billingPeriod, 'checkout' => $this->checkout, 'discount' => $this->discount]);
    }
}
