<?php

namespace Voxel\Modules\Stripe_Payments;

if ( ! defined('ABSPATH') ) {
	exit;
}

class Tax_Codes {

	private static $list = [
		'txcd_99999999' => 'txcd_99999999 - General - Tangible Goods',
		'txcd_20030000' => 'txcd_20030000 - General - Services',
		'txcd_10000000' => 'txcd_10000000 - General - Electronically Supplied Services',
		'txcd_00000000' => 'txcd_00000000 - Nontaxable',
		'txcd_10010001' => 'txcd_10010001 - Infrastructure as a service (IaaS) - personal use',
		'txcd_10101000' => 'txcd_10101000 - Infrastructure as a service (IaaS) - business use',
		'txcd_10102000' => 'txcd_10102000 - Platform as a service (PaaS) - business use',
		'txcd_10102001' => 'txcd_10102001 - Platform as a Service (PaaS) - personal use',
		'txcd_10103000' => 'txcd_10103000 - Software as a service (SaaS) - personal use',
		'txcd_10103001' => 'txcd_10103001 - Software as a service (SaaS) - business use',
		'txcd_10103100' => 'txcd_10103100 - Software as a service (SaaS) - electronic download - personal use',
		'txcd_10103101' => 'txcd_10103101 - Software as a service (SaaS) - electronic download - business use',
		'txcd_10104001' => 'txcd_10104001 - Cloud-based business process as a service',
		'txcd_10201000' => 'txcd_10201000 - Video Games - downloaded - non subscription - with permanent rights',
		'txcd_10201001' => 'txcd_10201001 - Video Games - downloaded - non subscription - with limited rights',
		'txcd_10201002' => 'txcd_10201002 - Video Games - downloaded - subscription - with conditional rights',
		'txcd_10201003' => 'txcd_10201003 - Video Games - streamed - non subscription - with limited rights',
		'txcd_10201004' => 'txcd_10201004 - Video Games - streamed - subscription - with conditional rights',
		'txcd_10202000' => 'txcd_10202000 - Downloadable Software - personal use',
		'txcd_10202001' => 'txcd_10202001 - Downloadable Software - non-recreational - personal use',
		'txcd_10202003' => 'txcd_10202003 - Downloadable Software - business use',
		'txcd_10203000' => 'txcd_10203000 - Downloadable Software - custom - personal use',
		'txcd_10203001' => 'txcd_10203001 - Downloadable Software - custom - business use',
		'txcd_10301000' => 'txcd_10301000 - Audiobook',
		'txcd_10302000' => 'txcd_10302000 - Digital Books - downloaded - non subscription - with permanent rights',
		'txcd_10302001' => 'txcd_10302001 - Digital Books - downloaded - non subscription - with limited rights',
		'txcd_10302002' => 'txcd_10302002 - Digital Books - downloaded - subscription - with conditional rights',
		'txcd_10302003' => 'txcd_10302003 - Digital Books - viewable only - subscription - with conditional rights',
		'txcd_10303000' => 'txcd_10303000 - Digital Magazines/Periodicals - downloadable - subscription - with conditional rights',
		'txcd_10303001' => 'txcd_10303001 - Digital Magazines/Periodicals - subscription tangible and digital',
		'txcd_10303002' => 'txcd_10303002 - Digital Magazines/Periodicals - viewable only - subscription - with conditional rights',
		'txcd_10303100' => 'txcd_10303100 - Digital Magazines/Periodicals - downloadable - non subscription - with permanent rights',
		'txcd_10303101' => 'txcd_10303101 - Digital Magazines/Periodicals - viewable only - non subscription - with limited rights',
		'txcd_10303102' => 'txcd_10303102 - Digital Magazines/Periodicals - viewable only - non subscription - with permanent rights',
		'txcd_10303104' => 'txcd_10303104 - Digital Magazines/Periodicals - downloadable - non subscription - with limited rights',
		'txcd_10304000' => 'txcd_10304000 - Digital Newspapers - downloadable - non subscription - with permanent rights',
		'txcd_10304001' => 'txcd_10304001 - Digital Newspapers - viewable only - non subscription - with limited rights',
		'txcd_10304002' => 'txcd_10304002 - Digital Newspapers - viewable only - non subscription - with permanent rights',
		'txcd_10304003' => 'txcd_10304003 - Digital Newspapers - downloadable - non subscription - with limited rights',
		'txcd_10304100' => 'txcd_10304100 - Digital Newspapers - downloadable - subscription - with conditional rights',
		'txcd_10304101' => 'txcd_10304101 - Digital Newspapers - subscription tangible and digital',
		'txcd_10304102' => 'txcd_10304102 - Digital Newspapers - viewable only - subscription - with conditional rights',
		'txcd_10305000' => 'txcd_10305000 - Digital School Textbooks - downloaded - non subscription - with limited rights',
		'txcd_10305001' => 'txcd_10305001 - Digital School Textbooks - downloaded - non subscription - with permanent rights',
		'txcd_10401000' => 'txcd_10401000 - Digital Audio Works - streamed - non subscription - with limited rights',
		'txcd_10401001' => 'txcd_10401001 - Digital Audio Works - downloaded - non subscription - with limited rights',
		'txcd_10401100' => 'txcd_10401100 - Digital Audio Works - downloaded - non subscription - with permanent rights',
		'txcd_10401200' => 'txcd_10401200 - Digital Audio Works - streamed - subscription - with conditional rights',
		'txcd_10402000' => 'txcd_10402000 - Digital Audio Visual Works - streamed - non subscription - with limited rights',
		'txcd_10402100' => 'txcd_10402100 - Digital Audio Visual Works - downloaded - non subscription - with permanent rights',
		'txcd_10402110' => 'txcd_10402110 - Digital Audio Visual Works - downloaded - non subscription - with limited rights',
		'txcd_10402200' => 'txcd_10402200 - Digital Audio Visual Works - streamed - subscription - with conditional rights',
		'txcd_10402300' => 'txcd_10402300 - Digital Video Streaming - live events - limited use',
		'txcd_10501000' => 'txcd_10501000 - Digital Photographs/Images - downloaded - non subscription - with permanent rights',
		'txcd_10502000' => 'txcd_10502000 - Gift Card',
		'txcd_10503000' => 'txcd_10503000 - Digital other news or documents - downloadable - non subscription - with permanent rights',
		'txcd_10503001' => 'txcd_10503001 - Digital other news or documents - downloadable - non subscription - with limited rights',
		'txcd_10503002' => 'txcd_10503002 - Digital other news or documents - downloadable - subscription - with conditional rights',
		'txcd_10503003' => 'txcd_10503003 - Digital other news or documents - viewable only - non subscription - with limited rights',
		'txcd_10503004' => 'txcd_10503004 - Digital other news or documents - viewable only - non subscription - with permanent rights',
		'txcd_10503005' => 'txcd_10503005 - Digital other news or documents - viewable only - subscription - with conditional rights',
		'txcd_10504000' => 'txcd_10504000 - Electronic software documentation or user manuals - Custom, electronic delivery',
		'txcd_10504003' => 'txcd_10504003 - Electronic software documentation or user manuals - Prewritten, electronic delivery',
		'txcd_10505000' => 'txcd_10505000 - Digital Finished Artwork - downloaded - non subscription - with limited rights',
		'txcd_10505001' => 'txcd_10505001 - Digital Finished Artwork - downloaded - non subscription - with permanent rights',
		'txcd_10505002' => 'txcd_10505002 - Digital Finished Artwork - downloaded - subscription - with conditional rights',
		'txcd_10506000' => 'txcd_10506000 - Digital Greeting Cards - Audio Only',
		'txcd_10506001' => 'txcd_10506001 - Digital Greeting Cards - Audio Visual',
		'txcd_10506002' => 'txcd_10506002 - Digital Greeting Cards - Static text and/or images only',
		'txcd_10701000' => 'txcd_10701000 - Website Advertising',
		'txcd_10701100' => 'txcd_10701100 - Website Hosting',
		'txcd_10701200' => 'txcd_10701200 - Website Design',
		'txcd_10701300' => 'txcd_10701300 - Website Data Processing',
		'txcd_10701400' => 'txcd_10701400 - Website Information Services',
		'txcd_10702000' => 'txcd_10702000 - Online Dating Services',
		'txcd_10804001' => 'txcd_10804001 - Digital Audio Visual Works - bundle - downloaded with permanent rights and streamed - subscription - with conditional rights',
		'txcd_10804002' => 'txcd_10804002 - Digital Audio Visual Works - bundle - downloaded with limited rights and streamed - non subscription',
		'txcd_10804003' => 'txcd_10804003 - Digital Audio Visual Works - bundle - downloaded with permanent rights and streamed - non subscription',
		'txcd_10804010' => 'txcd_10804010 - Digital Audio Works - bundle - downloaded with permanent rights and streamed - subscription - with conditional rights',
		'txcd_20010001' => 'txcd_20010001 - Car Washing',
		'txcd_20010003' => 'txcd_20010003 - Cleaning of Tangible Personal Property',
		'txcd_20010004' => 'txcd_20010004 - Commercial Cleaning Services',
		'txcd_20010006' => 'txcd_20010006 - Residential Cleaning Services',
		'txcd_20010007' => 'txcd_20010007 - Gutter Cleaning Services',
		'txcd_20020009' => 'txcd_20020009 - Installation of Hardware - Nonpermanent',
		'txcd_20020010' => 'txcd_20020010 - Installation of Hardware - Permanent',
		'txcd_20020018' => 'txcd_20020018 - Installation of Tangible Personal Property',
		'txcd_20030002' => 'txcd_20030002 - Pet Boarding',
		'txcd_20030003' => 'txcd_20030003 - Pet Grooming',
		'txcd_20030004' => 'txcd_20030004 - Parking Services',
		'txcd_20030005' => 'txcd_20030005 - Pet Services - Obedience Training',
		'txcd_20040001' => 'txcd_20040001 - Hairdressing Services',
		'txcd_20040002' => 'txcd_20040002 - Personal Care Services',
		'txcd_20040003' => 'txcd_20040003 - Body Piercing',
		'txcd_20040004' => 'txcd_20040004 - Childcare Services / Adultcare',
		'txcd_20040005' => 'txcd_20040005 - Dating Services',
		'txcd_20040006' => 'txcd_20040006 - Employment Services',
		'txcd_20040007' => 'txcd_20040007 - Manicure Services',
		'txcd_20040008' => 'txcd_20040008 - Massage Services',
		'txcd_20040009' => 'txcd_20040009 - Spa Services',
		'txcd_20040010' => 'txcd_20040010 - Tanning Services',
		'txcd_20040011' => 'txcd_20040011 - Tattooing Services',
		'txcd_20060000' => 'txcd_20060000 - Professional Services',
		'txcd_20060001' => 'txcd_20060001 - Accounting Services',
		'txcd_20060002' => 'txcd_20060002 - Advertising Services',
		'txcd_20060008' => 'txcd_20060008 - Credit Reporting Services',
		'txcd_20060009' => 'txcd_20060009 - Data Processing',
		'txcd_20060010' => 'txcd_20060010 - Debt Collection Services',
		'txcd_20060013' => 'txcd_20060013 - Engineering Services',
		'txcd_20060017' => 'txcd_20060017 - Technical Support Services',
		'txcd_20060021' => 'txcd_20060021 - Insurance Services',
		'txcd_20060022' => 'txcd_20060022 - Interior Decorating',
		'txcd_20060026' => 'txcd_20060026 - Lobbying Services',
		'txcd_20060027' => 'txcd_20060027 - Medical Professional Services',
		'txcd_20060029' => 'txcd_20060029 - Payroll Services',
		'txcd_20060030' => 'txcd_20060030 - Private Investigator Services',
		'txcd_20060035' => 'txcd_20060035 - Secretarial/Editing Services',
		'txcd_20060040' => 'txcd_20060040 - Electronic Filing Service',
		'txcd_20060042' => 'txcd_20060042 - Temporary Help Services',
		'txcd_20060044' => 'txcd_20060044 - Training',
		'txcd_20060045' => 'txcd_20060045 - Training Services - Live Virtual',
		'txcd_20060047' => 'txcd_20060047 - Architectural Services',
		'txcd_20060048' => 'txcd_20060048 - Consulting Services',
		'txcd_20060049' => 'txcd_20060049 - Cosmetic Medical Procedure',
		'txcd_20060050' => 'txcd_20060050 - Credit Monitoring Services',
		'txcd_20060051' => 'txcd_20060051 - Credit Card Processing Services',
		'txcd_20060052' => 'txcd_20060052 - Educational Services',
		'txcd_20060053' => 'txcd_20060053 - Home Inspection Services',
		'txcd_20060054' => 'txcd_20060054 - Legal Services',
		'txcd_20060055' => 'txcd_20060055 - Marketing Services',
		'txcd_20060056' => 'txcd_20060056 - Public Relations',
		'txcd_20060057' => 'txcd_20060057 - Stenographic Services',
		'txcd_20060058' => 'txcd_20060058 - Training Services - Self-study Web-based',
		'txcd_20060059' => 'txcd_20060059 - Tutoring',
		'txcd_20070001' => 'txcd_20070001 - Security - Alarm Services',
		'txcd_20070006' => 'txcd_20070006 - Extermination Services',
		'txcd_20070007' => 'txcd_20070007 - Landscaping',
		'txcd_20070008' => 'txcd_20070008 - Lawn Maintenance Services',
		'txcd_20070010' => 'txcd_20070010 - Painting & Wallpapering Services',
		'txcd_20070013' => 'txcd_20070013 - Security - Guard Services',
		'txcd_20070016' => 'txcd_20070016 - Property Surveying Services',
		'txcd_20080003' => 'txcd_20080003 - Motor Vehicle Repair',
		'txcd_20080004' => 'txcd_20080004 - Shoe Repair',
		'txcd_20080005' => 'txcd_20080005 - Repair of Tangible Personal Property',
		'txcd_20080007' => 'txcd_20080007 - Repairs to Real Property',
		'txcd_20080008' => 'txcd_20080008 - Aircraft Repair',
		'txcd_20080009' => 'txcd_20080009 - Appliance Repair',
		'txcd_20080010' => 'txcd_20080010 - Computer Repair',
		'txcd_20080011' => 'txcd_20080011 - Furniture Reupholstering',
		'txcd_20080012' => 'txcd_20080012 - Jewelry Repair',
		'txcd_20080013' => 'txcd_20080013 - Machine Repair',
		'txcd_20090001' => 'txcd_20090001 - Garment Alterations - in conjunction with purchase of garment',
		'txcd_20090002' => 'txcd_20090002 - Garment Alterations - separate from purchase of garment',
		'txcd_20090003' => 'txcd_20090003 - Shredding Service',
		'txcd_20090004' => 'txcd_20090004 - Dry Cleaning',
		'txcd_20090006' => 'txcd_20090006 - Fabrication',
		'txcd_20090010' => 'txcd_20090010 - Gift Wrapping - in conjunction with purchase of article',
		'txcd_20090012' => 'txcd_20090012 - Linen Services - Laundry only',
		'txcd_20090015' => 'txcd_20090015 - Warranty - Mandatory',
		'txcd_20090018' => 'txcd_20090018 - Warranty - Optional',
		'txcd_20090022' => 'txcd_20090022 - Assembly - in conjunction with final purchase of article',
		'txcd_20090023' => 'txcd_20090023 - Assembly - prior to final purchase of article',
		'txcd_20090024' => 'txcd_20090024 - Dry Cleaning - other than clothing',
		'txcd_20090025' => 'txcd_20090025 - Gift Wrapping - separate from purchase of article',
		'txcd_20090026' => 'txcd_20090026 - Linen Services - Laundry only - other than clothing',
		'txcd_20090027' => 'txcd_20090027 - Meat Processing',
		'txcd_20090028' => 'txcd_20090028 - Printing',
		'txcd_20090029' => 'txcd_20090029 - Printing - customer supplied articles',
		'txcd_20090030' => 'txcd_20090030 - Taxidermy Services',
		'txcd_20090031' => 'txcd_20090031 - Engraving Services -  separate from purchase of article',
		'txcd_20090032' => 'txcd_20090032 - Engraving Services - in conjunction with purchase of article',
		'txcd_20091000' => 'txcd_20091000 - Optional Extended Warranty Contract on Motor Vehicle',
		'txcd_20091001' => 'txcd_20091001 - Optional Maintenance Contract on Motor Vehicle',
		'txcd_20091002' => 'txcd_20091002 - Optional Extended Warranty Contract on Leased Motor Vehicle',
		'txcd_20091003' => 'txcd_20091003 - Optional Maintenance Contract on Leased Motor Vehicle',
		'txcd_20091004' => 'txcd_20091004 - Optional Extended Warranty Contract on Motor Vehicle - After Market',
		'txcd_20091005' => 'txcd_20091005 - Optional Maintenance Contract on Motor Vehicle - After Market',
		'txcd_20100001' => 'txcd_20100001 - Armored Car Services',
		'txcd_30011000' => 'txcd_30011000 - Clothing & Footwear',
		'txcd_30011002' => 'txcd_30011002 - Belt Buckle',
		'txcd_30011003' => 'txcd_30011003 - Belts or Suspenders',
		'txcd_30011015' => 'txcd_30011015 - Neck Gaiter',
		'txcd_30011020' => 'txcd_30011020 - School Uniforms',
		'txcd_30011028' => 'txcd_30011028 - Fur Clothing - Synthetic',
		'txcd_30011034' => 'txcd_30011034 - Scarves',
		'txcd_30011045' => 'txcd_30011045 - Neckties',
		'txcd_30011100' => 'txcd_30011100 - Formal or Special Occasion Wear',
		'txcd_30011200' => 'txcd_30011200 - Children\'s clothing and footwear',
		'txcd_30011201' => 'txcd_30011201 - Fur Clothing',
		'txcd_30021000' => 'txcd_30021000 - Athletic Activity Clothing',
		'txcd_30021001' => 'txcd_30021001 - Sweat Bands',
		'txcd_30021200' => 'txcd_30021200 - Swimsuits',
		'txcd_30030001' => 'txcd_30030001 - Occupational Uniforms',
		'txcd_30031004' => 'txcd_30031004 - Cleanroom Apparel',
		'txcd_30031041' => 'txcd_30031041 - Reflective Apparel',
		'txcd_30031404' => 'txcd_30031404 - Protective/Safety Clothing',
		'txcd_30031405' => 'txcd_30031405 - Protective/Safety Clothing - Occupational Use',
		'txcd_30031406' => 'txcd_30031406 - Protective/Safety Footwear',
		'txcd_30031407' => 'txcd_30031407 - Protective/Safety Footwear - Occupational Use',
		'txcd_30031408' => 'txcd_30031408 - Protective/Safety Equipment',
		'txcd_30031409' => 'txcd_30031409 - Protective/Safety Equipment - Occupational Use',
		'txcd_30040003' => 'txcd_30040003 - Cloth Face Masks',
		'txcd_30040005' => 'txcd_30040005 - Costume Masks and Accessories',
		'txcd_30040006' => 'txcd_30040006 - Costumes',
		'txcd_30051302' => 'txcd_30051302 - Gloves (general use)',
		'txcd_30060001' => 'txcd_30060001 - Purses and Handbags',
		'txcd_30060004' => 'txcd_30060004 - Handkerchiefs',
		'txcd_30060005' => 'txcd_30060005 - Hair Accessories',
		'txcd_30060006' => 'txcd_30060006 - Hats',
		'txcd_30060007' => 'txcd_30060007 - Jewelry',
		'txcd_30060010' => 'txcd_30060010 - Non-Clothing Accessories',
		'txcd_30060011' => 'txcd_30060011 - Shower Caps',
		'txcd_30060013' => 'txcd_30060013 - Umbrellas',
		'txcd_30060014' => 'txcd_30060014 - Wigs, Hairpieces, Hair extensions',
		'txcd_30060015' => 'txcd_30060015 - Luggage',
		'txcd_30060016' => 'txcd_30060016 - Watches',
		'txcd_30060017' => 'txcd_30060017 - Sunglasses - Non-prescription',
		'txcd_30060018' => 'txcd_30060018 - Watches - Smart',
		'txcd_30060019' => 'txcd_30060019 - Briefcases',
		'txcd_30060020' => 'txcd_30060020 - Aprons',
		'txcd_30060021' => 'txcd_30060021 - Bandannas',
		'txcd_30060101' => 'txcd_30060101 - Wallets',
		'txcd_30070001' => 'txcd_30070001 - Bicycle Helmets - Adult',
		'txcd_30070002' => 'txcd_30070002 - Bicycle Helmets - Youth',
		'txcd_30070003' => 'txcd_30070003 - Ballet or Tap Shoes',
		'txcd_30070004' => 'txcd_30070004 - Baseball Batting Gloves',
		'txcd_30070005' => 'txcd_30070005 - Bowling Gloves',
		'txcd_30070006' => 'txcd_30070006 - Bowling Shoes',
		'txcd_30070007' => 'txcd_30070007 - Boxing Gloves',
		'txcd_30070008' => 'txcd_30070008 - Cleated or Spiked Shoes',
		'txcd_30070009' => 'txcd_30070009 - Football Receiver Gloves',
		'txcd_30070010' => 'txcd_30070010 - Golf Gloves',
		'txcd_30070011' => 'txcd_30070011 - Golf Shoes',
		'txcd_30070012' => 'txcd_30070012 - Ice Skates',
		'txcd_30070013' => 'txcd_30070013 - Life Vests',
		'txcd_30070014' => 'txcd_30070014 - Martial Arts Attire',
		'txcd_30070015' => 'txcd_30070015 - Motorcycle Helmets',
		'txcd_30070017' => 'txcd_30070017 - Mouth Guards',
		'txcd_30070018' => 'txcd_30070018 - Roller Skates or Roller Blades',
		'txcd_30070019' => 'txcd_30070019 - Shin Guards',
		'txcd_30070020' => 'txcd_30070020 - Shoulder Pads for Sports',
		'txcd_30070021' => 'txcd_30070021 - Ski Boots',
		'txcd_30070022' => 'txcd_30070022 - Sport Uniforms',
		'txcd_30070023' => 'txcd_30070023 - Swim Fins',
		'txcd_30070024' => 'txcd_30070024 - Swim Goggles',
		'txcd_30070025' => 'txcd_30070025 - Wetsuit',
		'txcd_30070026' => 'txcd_30070026 - Athletic Supporter',
		'txcd_30070028' => 'txcd_30070028 - Hunting Vests',
		'txcd_30070029' => 'txcd_30070029 - Hunting Activity Clothing',
		'txcd_30071000' => 'txcd_30071000 - Sports Activities Equipment',
		'txcd_30080001' => 'txcd_30080001 - Button Covers',
		'txcd_30080002' => 'txcd_30080002 - Component Clothing Items',
		'txcd_30090005' => 'txcd_30090005 - Overshoes',
		'txcd_30090009' => 'txcd_30090009 - Shoe Inserts',
		'txcd_30090010' => 'txcd_30090010 - Shoelaces',
		'txcd_31020001' => 'txcd_31020001 - Bibs',
		'txcd_31020002' => 'txcd_31020002 - Infant Swaddles',
		'txcd_31020003' => 'txcd_31020003 - Infant Receiving Blankets',
		'txcd_31030001' => 'txcd_31030001 - Diaper Cream',
		'txcd_31030003' => 'txcd_31030003 - Baby Wipes',
		'txcd_31031202' => 'txcd_31031202 - Infant Diapers',
		'txcd_31031203' => 'txcd_31031203 - Disposable Toddler Training Pants',
		'txcd_31031204' => 'txcd_31031204 - Diaper Liners - Single Use',
		'txcd_31031205' => 'txcd_31031205 - Cloth Diapers',
		'txcd_31040001' => 'txcd_31040001 - Baby Feeding Bottles/Nipples',
		'txcd_31040002' => 'txcd_31040002 - Breast Pumps',
		'txcd_31070001' => 'txcd_31070001 - Infant/Child Car Seat',
		'txcd_32010001' => 'txcd_32010001 - Blood Glucose Monitoring Devices',
		'txcd_32010002' => 'txcd_32010002 - Diabetic Testing Supplies',
		'txcd_32010003' => 'txcd_32010003 - Blood Glucose Monitoring Devices with Prescription',
		'txcd_32010004' => 'txcd_32010004 - Diabetic Testing Supplies with Prescription',
		'txcd_32020001' => 'txcd_32020001 - Prescription Drugs',
		'txcd_32020002' => 'txcd_32020002 - Drugs - Over the Counter',
		'txcd_32020003' => 'txcd_32020003 - Over-the-Counter Drugs with Prescription',
		'txcd_32020004' => 'txcd_32020004 - Insulin with Prescription',
		'txcd_32020005' => 'txcd_32020005 - Insulin',
		'txcd_32020006' => 'txcd_32020006 - Medical Oxygen with Prescription',
		'txcd_32020011' => 'txcd_32020011 - Medical Oxygen',
		'txcd_32030001' => 'txcd_32030001 - Condoms',
		'txcd_32030002' => 'txcd_32030002 - Condoms with Prescription',
		'txcd_32030003' => 'txcd_32030003 - Condoms with Spermicide',
		'txcd_32030004' => 'txcd_32030004 - Condoms with Spermicide with Prescription',
		'txcd_32030005' => 'txcd_32030005 - Contraceptive Ointments',
		'txcd_32030006' => 'txcd_32030006 - Birth Control - Over-the-Counter Oral Contraceptives',
		'txcd_32030007' => 'txcd_32030007 - Birth Control - Over-the-Counter Oral Contraceptives with Prescription',
		'txcd_32030008' => 'txcd_32030008 - Birth Control - Prescription non-Oral Contraceptives - Barriers',
		'txcd_32030009' => 'txcd_32030009 - Birth Control - Prescription non-Oral Contraceptives - Hormonal',
		'txcd_32030010' => 'txcd_32030010 - Birth Control - Prescription Oral Contraceptives',
		'txcd_32040002' => 'txcd_32040002 - Feminine Cleansing Solutions',
		'txcd_32040003' => 'txcd_32040003 - Feminine Cleansing Solutions - Medicated',
		'txcd_32040004' => 'txcd_32040004 - Feminine Yeast Treatments',
		'txcd_32040005' => 'txcd_32040005 - Tampons/Pads/Sanitary Napkins/Liners',
		'txcd_32050001' => 'txcd_32050001 - Adult Disposable Diapers',
		'txcd_32050005' => 'txcd_32050005 - Disposable Face Masks',
		'txcd_32050006' => 'txcd_32050006 - Grooming and Hygiene Products',
		'txcd_32050007' => 'txcd_32050007 - Grooming and Hygiene Products - Medicated',
		'txcd_32050009' => 'txcd_32050009 - Hand Sanitizers',
		'txcd_32050012' => 'txcd_32050012 - Medicated Acne Treatments',
		'txcd_32050013' => 'txcd_32050013 - Skin Care Products',
		'txcd_32050014' => 'txcd_32050014 - Skin Care Products - Medicated',
		'txcd_32050015' => 'txcd_32050015 - Smoking Cessation Products',
		'txcd_32050017' => 'txcd_32050017 - Toilet Tissue',
		'txcd_32050018' => 'txcd_32050018 - Toothbrush',
		'txcd_32050019' => 'txcd_32050019 - Toothpaste',
		'txcd_32050020' => 'txcd_32050020 - Baby Oil',
		'txcd_32050021' => 'txcd_32050021 - Baby Powder',
		'txcd_32050022' => 'txcd_32050022 - Breath Spray/Dissolvable Strips',
		'txcd_32050023' => 'txcd_32050023 - Bubble Bath/Bath Salts,Oils,Crystals',
		'txcd_32050024' => 'txcd_32050024 - Conditioner - Hair',
		'txcd_32050025' => 'txcd_32050025 - Cosmetics - Beautifying',
		'txcd_32050026' => 'txcd_32050026 - Dental Floss/Picks',
		'txcd_32050027' => 'txcd_32050027 - Denture Creams/Adhesives',
		'txcd_32050028' => 'txcd_32050028 - Deodorant - Natural or No Active Ingredients',
		'txcd_32050029' => 'txcd_32050029 - Deodorant/Antiperspirant',
		'txcd_32050030' => 'txcd_32050030 - Hair Loss Products',
		'txcd_32050031' => 'txcd_32050031 - Hair Removal Products',
		'txcd_32050032' => 'txcd_32050032 - Lip Balm',
		'txcd_32050033' => 'txcd_32050033 - Lip Balm - Medicated',
		'txcd_32050034' => 'txcd_32050034 - Mouthwash - Cosmetic',
		'txcd_32050035' => 'txcd_32050035 - Mouthwash - Therapeutic',
		'txcd_32050036' => 'txcd_32050036 - Shampoo',
		'txcd_32050037' => 'txcd_32050037 - Shampoo - Medicated',
		'txcd_32050038' => 'txcd_32050038 - Shaving Creams',
		'txcd_32050039' => 'txcd_32050039 - Soaps - Antibacterial',
		'txcd_32050040' => 'txcd_32050040 - Sunscreen',
		'txcd_32050041' => 'txcd_32050041 - Teeth Whitening Kits',
		'txcd_32060001' => 'txcd_32060001 - Durable Medical Equipment for Home Use',
		'txcd_32060002' => 'txcd_32060002 - Durable Medical Equipment for Home Use with Prescription',
		'txcd_32060007' => 'txcd_32060007 - Enteral Feeding Equipment for Home Use with Prescription',
		'txcd_32060012' => 'txcd_32060012 - Kidney Dialysis Equipment for Home Use with Prescription',
		'txcd_32060017' => 'txcd_32060017 - Kidney Dialysis Equipment for Home Use',
		'txcd_32060018' => 'txcd_32060018 - Oxygen Delivery Equipment for Home Use with Prescription',
		'txcd_32060023' => 'txcd_32060023 - Oxygen Delivery Equipment for Home Use',
		'txcd_32060024' => 'txcd_32060024 - Heating Pads',
		'txcd_32060025' => 'txcd_32060025 - Cold or Hot Therapy Packs - Reusable',
		'txcd_32060026' => 'txcd_32060026 - Enteral Feeding Equipment for Home Use',
		'txcd_32070003' => 'txcd_32070003 - Wound Care Supplies - Bandages, Dressings, Gauze',
		'txcd_32070004' => 'txcd_32070004 - Wound Care Supplies - Bandages, Dressings, Gauze - Medicated',
		'txcd_32070018' => 'txcd_32070018 - First Aid Kits',
		'txcd_32070019' => 'txcd_32070019 - Gloves - Disposable (non medical use)',
		'txcd_32070020' => 'txcd_32070020 - Gloves - Disposable (medical use)',
		'txcd_32070028' => 'txcd_32070028 - Medical Supplies - Consumable',
		'txcd_32070029' => 'txcd_32070029 - First Aid Kits - 50% or Less Medicinal Items',
		'txcd_32070030' => 'txcd_32070030 - Contact Lens Disinfecting Solutions',
		'txcd_32070031' => 'txcd_32070031 - Contact Lens Lubricating Solutions',
		'txcd_32070032' => 'txcd_32070032 - Cotton Balls/Swabs - Sterile',
		'txcd_32070033' => 'txcd_32070033 - Cotton Balls/Swabs - Unsterile',
		'txcd_32070034' => 'txcd_32070034 - Cold or Hot Therapy Packs - Disposable',
		'txcd_32070035' => 'txcd_32070035 - Cold or Hot Therapy Packs - Disposable - Medicated',
		'txcd_32070036' => 'txcd_32070036 - Nasal Breathing Strips',
		'txcd_32070037' => 'txcd_32070037 - Hypodermic Needles/Syringes with Prescription - Insulin',
		'txcd_32070038' => 'txcd_32070038 - Hypodermic Needles/Syringes - Insulin',
		'txcd_32070039' => 'txcd_32070039 - Hydrogen Peroxide',
		'txcd_32070040' => 'txcd_32070040 - Petroleum Jelly',
		'txcd_32070041' => 'txcd_32070041 - Ear Drops - Medicated',
		'txcd_32070042' => 'txcd_32070042 - Isopropyl (Rubbing) Alcohol',
		'txcd_32080001' => 'txcd_32080001 - Bath Aids',
		'txcd_32080003' => 'txcd_32080003 - Mobility Enhancing Equipment',
		'txcd_32080004' => 'txcd_32080004 - Repair & Replacement Parts for Mobility Enhancing Equipment',
		'txcd_32080005' => 'txcd_32080005 - Mobility Enhancing Equipment with Prescription',
		'txcd_32090003' => 'txcd_32090003 - Corrective Lenses',
		'txcd_32090005' => 'txcd_32090005 - Hearing Aid Batteries',
		'txcd_32090006' => 'txcd_32090006 - Hearing Aids',
		'txcd_32090007' => 'txcd_32090007 - Prosthetic Device',
		'txcd_32090008' => 'txcd_32090008 - Prosthetic Devices with Prescription',
		'txcd_32090013' => 'txcd_32090013 - Corrective Lenses with Prescription',
		'txcd_32090014' => 'txcd_32090014 - Contact Lenses with Prescription',
		'txcd_32090015' => 'txcd_32090015 - Dental Prosthetics with Prescription',
		'txcd_32090016' => 'txcd_32090016 - Dental Prosthetics',
		'txcd_32090017' => 'txcd_32090017 - Hearing Aids with Prescription',
		'txcd_32090018' => 'txcd_32090018 - Hearing Aid Batteries with Prescription',
		'txcd_32100001' => 'txcd_32100001 - Pregenacy Testing Kits',
		'txcd_32100002' => 'txcd_32100002 - Ovulation Testing Kits',
		'txcd_32100003' => 'txcd_32100003 - Infectious Disease Test',
		'txcd_32100004' => 'txcd_32100004 - Infectious Disease Test - Prescription only',
		'txcd_32100005' => 'txcd_32100005 - DNA Testing Kits',
		'txcd_32100006' => 'txcd_32100006 - Medical Thermometers - Disposable',
		'txcd_32100007' => 'txcd_32100007 - Medical Thermometers - Reusable',
		'txcd_32100008' => 'txcd_32100008 - Energy Star Products',
		'txcd_32100010' => 'txcd_32100010 - Blood Pressure Testing Devices',
		'txcd_32100011' => 'txcd_32100011 - Pulse Oximeter',
		'txcd_32100012' => 'txcd_32100012 - Drug Testing Kits',
		'txcd_32100013' => 'txcd_32100013 - Cholesterol Testing Kits',
		'txcd_33020001' => 'txcd_33020001 - Ceiling Fans - Energy Star',
		'txcd_33020002' => 'txcd_33020002 - Air conditioners - Energy Star',
		'txcd_33020003' => 'txcd_33020003 - Furnaces - Energy Star',
		'txcd_33020004' => 'txcd_33020004 - Heat Pumps - Energy Star',
		'txcd_33020005' => 'txcd_33020005 - Water Heater - Energy Star',
		'txcd_33020006' => 'txcd_33020006 - Dehumidifier - Energy Star',
		'txcd_33020007' => 'txcd_33020007 - Boilers - Energy Star',
		'txcd_33020008' => 'txcd_33020008 - Programmable Wall Thermostat - Energy Star',
		'txcd_33020009' => 'txcd_33020009 - Refrigerators - Energy Star',
		'txcd_33020010' => 'txcd_33020010 - Dishwashers - Energy Star',
		'txcd_33020011' => 'txcd_33020011 - Freezers- Energy Star',
		'txcd_33020012' => 'txcd_33020012 - Clothes Washing Machine - Energy Star',
		'txcd_33020013' => 'txcd_33020013 - Clothes Drying Machine - Energy Star',
		'txcd_33020014' => 'txcd_33020014 - Can Opener - Manual',
		'txcd_33020200' => 'txcd_33020200 - Water conserving products',
		'txcd_33030001' => 'txcd_33030001 - Alkaline Batteries',
		'txcd_33031001' => 'txcd_33031001 - Mobile Phone Batteries',
		'txcd_33080201' => 'txcd_33080201 - Disinfectant Wipes',
		'txcd_33080202' => 'txcd_33080202 - Disposable Household Paper Products',
		'txcd_33080300' => 'txcd_33080300 - Household Linens/Bedding Towels Shower Curtains',
		'txcd_33080301' => 'txcd_33080301 - Bedding',
		'txcd_33080302' => 'txcd_33080302 - Bath Mats/Rugs',
		'txcd_33080303' => 'txcd_33080303 - Bath Towels',
		'txcd_33080304' => 'txcd_33080304 - Shower Curtain or Liner',
		'txcd_33080305' => 'txcd_33080305 - Crib Bumpers/Liners',
		'txcd_33080306' => 'txcd_33080306 - Dish Towels',
		'txcd_33080400' => 'txcd_33080400 - Yarn - Non-clothing',
		'txcd_33100001' => 'txcd_33100001 - Landscape Soil, Mulch, Compost - Residential',
		'txcd_33100101' => 'txcd_33100101 - Agricultural Chemicals - Non-commercial gardening',
		'txcd_33100200' => 'txcd_33100200 - Agricultural Fertilizer - Non-commercial gardening',
		'txcd_33110001' => 'txcd_33110001 - Incandescent Light Bulbs - Energy Star',
		'txcd_33110002' => 'txcd_33110002 - Compact Fluorescent Light Bulbs - Energy Star',
		'txcd_33110003' => 'txcd_33110003 - LED Bulbs - Energy Star',
		'txcd_33110004' => 'txcd_33110004 - Portable Light Sources',
		'txcd_33110005' => 'txcd_33110005 - Candles',
		'txcd_33120000' => 'txcd_33120000 - Storm Preparedness Items',
		'txcd_33120001' => 'txcd_33120001 - Portable Radios',
		'txcd_33120002' => 'txcd_33120002 - Food Storage Cooler',
		'txcd_33120003' => 'txcd_33120003 - Smoke Detectors',
		'txcd_33120004' => 'txcd_33120004 - Carbon Monoxide Detectors',
		'txcd_33120005' => 'txcd_33120005 - Fire Extinguishers',
		'txcd_33120006' => 'txcd_33120006 - Portable Fuel Container',
		'txcd_33120007' => 'txcd_33120007 - Water Storage Container',
		'txcd_33120008' => 'txcd_33120008 - Artificial Ice',
		'txcd_33120009' => 'txcd_33120009 - Tarpaulins and Weatherproof Sheeting',
		'txcd_33120010' => 'txcd_33120010 - Portable Generator',
		'txcd_33120011' => 'txcd_33120011 - Power Cords',
		'txcd_33120012' => 'txcd_33120012 - Axes/Hatchets',
		'txcd_33120013' => 'txcd_33120013 - Garden Chainsaw',
		'txcd_33120014' => 'txcd_33120014 - Chainsaw Accessories',
		'txcd_33120015' => 'txcd_33120015 - Storm Shutters/Window Protection Devices',
		'txcd_33120016' => 'txcd_33120016 - Emergency/Rescue Ladder',
		'txcd_33120017' => 'txcd_33120017 - Ropes and Cords',
		'txcd_33120018' => 'txcd_33120018 - Ground Anchor Systems and Tie-down Kits',
		'txcd_33120019' => 'txcd_33120019 - Duct Tape',
		'txcd_33150001' => 'txcd_33150001 - Toilets - WaterSense',
		'txcd_33150002' => 'txcd_33150002 - Urinals - WaterSense',
		'txcd_33150003' => 'txcd_33150003 - Bathroom Faucets - WaterSense',
		'txcd_33150004' => 'txcd_33150004 - Spray Water Sprinkler Bodies - WaterSense',
		'txcd_33150005' => 'txcd_33150005 - Irrigation Controls - WaterSense',
		'txcd_33150006' => 'txcd_33150006 - Showerheads - WaterSense',
		'txcd_34010001' => 'txcd_34010001 - Audio Turntables',
		'txcd_34010002' => 'txcd_34010002 - Digital Music Players',
		'txcd_34010003' => 'txcd_34010003 - Video Cameras',
		'txcd_34020001' => 'txcd_34020001 - Digital Cameras',
		'txcd_34020002' => 'txcd_34020002 - Digital Picture Frames',
		'txcd_34020003' => 'txcd_34020003 - E-Book Readers',
		'txcd_34020004' => 'txcd_34020004 - Headphones/Earbuds',
		'txcd_34020005' => 'txcd_34020005 - Consumer Electronics Peripherals/Accessories',
		'txcd_34020006' => 'txcd_34020006 - Televisions',
		'txcd_34020027' => 'txcd_34020027 - Consumer Electronics',
		'txcd_34021000' => 'txcd_34021000 - Mobile Phones',
		'txcd_34021001' => 'txcd_34021001 - Mobile Phone Charging Device/cord',
		'txcd_34022000' => 'txcd_34022000 - Video Gaming Console - Fixed',
		'txcd_34022001' => 'txcd_34022001 - Video Gaming Console - Portable',
		'txcd_34040001' => 'txcd_34040001 - Computer Batteries',
		'txcd_34040002' => 'txcd_34040002 - Computer Cables',
		'txcd_34040003' => 'txcd_34040003 - Computer Drives',
		'txcd_34040004' => 'txcd_34040004 - Computer Keyboards',
		'txcd_34040005' => 'txcd_34040005 - Computer Microphones',
		'txcd_34040006' => 'txcd_34040006 - Computer Monitor/Displays',
		'txcd_34040007' => 'txcd_34040007 - Computer Mouse/Pointing Devices',
		'txcd_34040008' => 'txcd_34040008 - Computer Printer',
		'txcd_34040009' => 'txcd_34040009 - Computer Speakers',
		'txcd_34040010' => 'txcd_34040010 - Docking Stations',
		'txcd_34040011' => 'txcd_34040011 - Modems',
		'txcd_34040012' => 'txcd_34040012 - Motherboards',
		'txcd_34040013' => 'txcd_34040013 - Port Replicators',
		'txcd_34040014' => 'txcd_34040014 - Routers',
		'txcd_34040015' => 'txcd_34040015 - Scanners',
		'txcd_34040016' => 'txcd_34040016 - Sound Cards',
		'txcd_34040017' => 'txcd_34040017 - Video/Graphics Card',
		'txcd_34040018' => 'txcd_34040018 - Web Camera',
		'txcd_35010000' => 'txcd_35010000 - Books',
		'txcd_35010001' => 'txcd_35010001 - Books for Children',
		'txcd_35010400' => 'txcd_35010400 - Religious Books',
		'txcd_35010410' => 'txcd_35010410 - Bibles',
		'txcd_35010500' => 'txcd_35010500 - Audiobook (Physical Copy)',
		'txcd_35020100' => 'txcd_35020100 - Newspapers',
		'txcd_35020200' => 'txcd_35020200 - Periodicals',
		'txcd_35020220' => 'txcd_35020220 - Magazine by Subscription',
		'txcd_36010001' => 'txcd_36010001 - Flea & Tick Products',
		'txcd_36010002' => 'txcd_36010002 - Over-the-Counter Drugs for Animal Use Without a Prescription',
		'txcd_36010003' => 'txcd_36010003 - Over-the-Counter Medical Supplies for Pets',
		'txcd_36010004' => 'txcd_36010004 - Pet Food',
		'txcd_36010005' => 'txcd_36010005 - Pet Vitamins',
		'txcd_37010000' => 'txcd_37010000 - Personal Computers',
		'txcd_37010003' => 'txcd_37010003 - Computer Storage Media',
		'txcd_37010036' => 'txcd_37010036 - Printer Ink',
		'txcd_37030002' => 'txcd_37030002 - Globes - Student',
		'txcd_37030003' => 'txcd_37030003 - Maps - Student',
		'txcd_37040001' => 'txcd_37040001 - Printer Paper',
		'txcd_37050001' => 'txcd_37050001 - School Textbooks',
		'txcd_37060001' => 'txcd_37060001 - Bookbags/Backpacks - Student',
		'txcd_37060002' => 'txcd_37060002 - Calculators',
		'txcd_37060003' => 'txcd_37060003 - Daily Planners',
		'txcd_37060008' => 'txcd_37060008 - Padlocks - Student',
		'txcd_37060009' => 'txcd_37060009 - School Art Supplies',
		'txcd_37060010' => 'txcd_37060010 - Dictionaries/Thesauruses',
		'txcd_37060011' => 'txcd_37060011 - Sheet music - Student',
		'txcd_37060012' => 'txcd_37060012 - School Supplies',
		'txcd_37060013' => 'txcd_37060013 - Staplers/Staples',
		'txcd_37060035' => 'txcd_37060035 - Push pins/tacks',
		'txcd_37060045' => 'txcd_37060045 - Graphing Calculators',
		'txcd_37060046' => 'txcd_37060046 - Musical instruments - Student',
		'txcd_37070001' => 'txcd_37070001 - Canned Software - Tangible Medium',
		'txcd_37070002' => 'txcd_37070002 - Canned Software - Tangible Medium - Non-recreational',
		'txcd_37071001' => 'txcd_37071001 - Software Maintenance Agreement - Optional, Prewritten, Electronic Delivery, Updates Only',
		'txcd_37071002' => 'txcd_37071002 - Software Maintenance Agreement - Optional, Prewritten, Electronic Delivery, Updates and Services',
		'txcd_37071003' => 'txcd_37071003 - Software Maintenance Agreement - Optional, Prewritten, Services Only',
		'txcd_37071006' => 'txcd_37071006 - Software Maintenance Agreement - Optional, Prewritten, Tangible Delivery, Updates Only',
		'txcd_37071007' => 'txcd_37071007 - Software Maintenance Agreement - Optional, Prewritten, Tangible Delivery, Updates and Services',
		'txcd_37071009' => 'txcd_37071009 - Software Maintenance Agreement - Optional, Custom, Electronic Delivery, Updates Only',
		'txcd_37071010' => 'txcd_37071010 - Software Maintenance Agreement - Optional, Custom, Electronic Delivery, Updates and Services',
		'txcd_37071011' => 'txcd_37071011 - Software Maintenance Agreement - Optional, Custom, Services Only',
		'txcd_37071014' => 'txcd_37071014 - Software Maintenance Agreement - Optional, Custom, Tangible Delivery, Updates Only',
		'txcd_37071015' => 'txcd_37071015 - Software Maintenance Agreement - Optional, Custom, Tangible Delivery, Updates and Services',
		'txcd_37071101' => 'txcd_37071101 - Software Maintenance Agreement - Mandatory, Prewritten, Electronic Delivery',
		'txcd_37071103' => 'txcd_37071103 - Software Maintenance Agreement - Mandatory, Prewritten, Tangible Delivery',
		'txcd_37071104' => 'txcd_37071104 - Software Maintenance Agreement - Mandatory, Custom, Electronic Delivery',
		'txcd_37071106' => 'txcd_37071106 - Software Maintenance Agreement - Mandatory, Custom, Tangible Delivery',
		'txcd_40010000' => 'txcd_40010000 - Cereal Grains',
		'txcd_40010001' => 'txcd_40010001 - Pasta',
		'txcd_40010002' => 'txcd_40010002 - Rice',
		'txcd_40020002' => 'txcd_40020002 - Edible Oils',
		'txcd_40020004' => 'txcd_40020004 - Sugar and Sugar Substitutes',
		'txcd_40020005' => 'txcd_40020005 - Flour',
		'txcd_40020006' => 'txcd_40020006 - Herbs',
		'txcd_40020007' => 'txcd_40020007 - Seasonings',
		'txcd_40020008' => 'txcd_40020008 - Food Coloring',
		'txcd_40040000' => 'txcd_40040000 - Food for Non-Immediate Consumption',
		'txcd_40040003' => 'txcd_40040003 - Cocoa Mix',
		'txcd_40040004' => 'txcd_40040004 - Baby Food',
		'txcd_40040009' => 'txcd_40040009 - Baking Cocoa',
		'txcd_40040010' => 'txcd_40040010 - Ice Cubes',
		'txcd_40040013' => 'txcd_40040013 - Meat and Meat Products',
		'txcd_40040016' => 'txcd_40040016 - Nuts and Seeds',
		'txcd_40040017' => 'txcd_40040017 - Nuts and Seeds, Processed',
		'txcd_40040019' => 'txcd_40040019 - Vegetables',
		'txcd_40040020' => 'txcd_40040020 - Cracker Bread',
		'txcd_40040021' => 'txcd_40040021 - Plain Breads',
		'txcd_40040022' => 'txcd_40040022 - Speciality Breads',
		'txcd_40050003' => 'txcd_40050003 - Food/TPP Bundle - with Food between 50% and 75%',
		'txcd_40050004' => 'txcd_40050004 - Food/TPP Bundle with Food 50% to 90%',
		'txcd_40050005' => 'txcd_40050005 - Food/TPP Bundle with Food 90% or more',
		'txcd_40050006' => 'txcd_40050006 - Food/TPP Bundle with Food less than 50%',
		'txcd_40050007' => 'txcd_40050007 - Food/TPP Bundle - with Food 90% or more - Food is all Candy',
		'txcd_40050008' => 'txcd_40050008 - Food/TPP Bundle - with Food between 50% and 75% - Food is all Candy',
		'txcd_40050009' => 'txcd_40050009 - Food/TPP Bundle - with Food between 76% and 89%',
		'txcd_40050010' => 'txcd_40050010 - Food/TPP Bundle - with Food between 76% and 89% - Food is all Candy',
		'txcd_40051001' => 'txcd_40051001 - Food/Candy Bundle - with Candy 10% or less',
		'txcd_40051002' => 'txcd_40051002 - Food/Candy Bundle - with Candy 11% to 24%',
		'txcd_40051003' => 'txcd_40051003 - Food/Candy Bundle - with Candy 25% to 49%',
		'txcd_40051004' => 'txcd_40051004 - Food/Candy Bundle - with Candy 50% or more',
		'txcd_40060003' => 'txcd_40060003 - Food for Immediate Consumption',
		'txcd_40070001' => 'txcd_40070001 - Granola Bars, Cereal Bars, Energy Bars, Protein Bars Containing Flour',
		'txcd_40070002' => 'txcd_40070002 - Granola Bars, Cereal Bars, Energy Bars, Protein Bars Containing No Flour',
		'txcd_40070005' => 'txcd_40070005 - Snack Foods',
		'txcd_40070006' => 'txcd_40070006 - Biscuits/Cookies - Plain',
		'txcd_40070007' => 'txcd_40070007 - Biscuits/Cookies - Chocolate Coated',
		'txcd_40090001' => 'txcd_40090001 - Dietary Supplements',
		'txcd_40090002' => 'txcd_40090002 - Protein Powder',
		'txcd_40090005' => 'txcd_40090005 - Infant Formula',
		'txcd_40090008' => 'txcd_40090008 - Nutritional Supplements',
		'txcd_40100001' => 'txcd_40100001 - Candy',
		'txcd_40100002' => 'txcd_40100002 - Candy (Contains Flour)',
		'txcd_40100003' => 'txcd_40100003 - Ice Cream, Packaged - One Pint or Greater',
		'txcd_40100004' => 'txcd_40100004 - Ice Cream, Packaged - Less Than One Pint Container',
		'txcd_40100010' => 'txcd_40100010 - Chewing Gum',
		'txcd_40100011' => 'txcd_40100011 - Breath Mints',
		'txcd_40400005' => 'txcd_40400005 - Dried Fruit - Unsweetened',
		'txcd_41020001' => 'txcd_41020001 - Alcoholic Beverages - Beer/Malt Beverage',
		'txcd_41020002' => 'txcd_41020002 - Alcoholic Beverages - Spirits',
		'txcd_41020003' => 'txcd_41020003 - Alcoholic Beverages - Wine',
		'txcd_41030001' => 'txcd_41030001 - Bottled Water',
		'txcd_41030002' => 'txcd_41030002 - Bottled Water - Carbonated Artificially',
		'txcd_41030003' => 'txcd_41030003 - Bottled Water - Carbonated Naturally',
		'txcd_41040002' => 'txcd_41040002 - Carbonated Soft Drinks - 0% Fruit or Vegetable juice',
		'txcd_41040003' => 'txcd_41040003 - Bottled Tea - Non-Carbonated - Sweetened',
		'txcd_41040004' => 'txcd_41040004 - Bottled water - Sweetened',
		'txcd_41040005' => 'txcd_41040005 - Bottled water - Carbonated - Sweetened',
		'txcd_41040008' => 'txcd_41040008 - Non-Carbonated Soft Drinks - 0% Fruit or Vegetable juice',
		'txcd_41040009' => 'txcd_41040009 - Soft Drinks - Carbonated - 1 -9% Vegetable juice',
		'txcd_41040010' => 'txcd_41040010 - Soft Drinks - Carbonated - 1-9% Fruit juice',
		'txcd_41040011' => 'txcd_41040011 - Soft Drinks - Carbonated - 10-24% Fruit juice',
		'txcd_41040012' => 'txcd_41040012 - Soft Drinks - Carbonated - 10-24% Vegetable juice',
		'txcd_41040013' => 'txcd_41040013 - Soft Drinks - Carbonated - 100% Fruit or Vegetable juice',
		'txcd_41040014' => 'txcd_41040014 - Soft Drinks - Carbonated - 25-50% Fruit juice',
		'txcd_41040015' => 'txcd_41040015 - Soft Drinks - Carbonated - 25-50% Vegetable juice',
		'txcd_41040016' => 'txcd_41040016 - Soft Drinks - Carbonated - 51-69% Fruit juice',
		'txcd_41040017' => 'txcd_41040017 - Soft Drinks - Carbonated - 51-69% Vegetable juice',
		'txcd_41040018' => 'txcd_41040018 - Soft Drinks - Carbonated - 70-99% Fruit juice',
		'txcd_41040019' => 'txcd_41040019 - Soft Drinks - Carbonated - 70-99% Vegetable juice',
		'txcd_41040020' => 'txcd_41040020 - Soft Drinks - Non-Carbonated - 1 -9% Vegetable juice',
		'txcd_41040021' => 'txcd_41040021 - Soft Drinks - Non-Carbonated - 1-9% Fruit juice',
		'txcd_41040022' => 'txcd_41040022 - Soft Drinks - Non-Carbonated - 10-24% Fruit juice',
		'txcd_41040023' => 'txcd_41040023 - Soft Drinks - Non-Carbonated - 10-24% Vegetable juice',
		'txcd_41040024' => 'txcd_41040024 - Soft Drinks - Non-Carbonated - 100% Fruit or Vegetable juice',
		'txcd_41040025' => 'txcd_41040025 - Soft Drinks - Non-Carbonated - 25-50% Fruit juice',
		'txcd_41040026' => 'txcd_41040026 - Soft Drinks - Non-Carbonated - 25-50% Vegetable juice',
		'txcd_41040027' => 'txcd_41040027 - Soft Drinks - Non-Carbonated - 51-69% Fruit juice',
		'txcd_41040028' => 'txcd_41040028 - Soft Drinks - Non-Carbonated - 51-69% Vegetable juice',
		'txcd_41040029' => 'txcd_41040029 - Soft Drinks - Non-Carbonated - 70-99% Fruit juice',
		'txcd_41040030' => 'txcd_41040030 - Soft Drinks - Non-Carbonated - 70-99% Vegetable juice',
		'txcd_41050001' => 'txcd_41050001 - Bottled coffee - Containing Milk or Milk Substitute',
		'txcd_41050002' => 'txcd_41050002 - Bottled Coffee - No Milk - Sweetened',
		'txcd_41050003' => 'txcd_41050003 - Bottled Coffee - No Milk - Unsweetened',
		'txcd_41050004' => 'txcd_41050004 - Bottled Tea - Carbonated - Unsweetened',
		'txcd_41050005' => 'txcd_41050005 - Bottled Tea - Non-Carbonated - Unsweetened',
		'txcd_41050006' => 'txcd_41050006 - Coffee Beans or Ground Coffee',
		'txcd_41050007' => 'txcd_41050007 - Bottled Tea - Carbonated - Sweetened',
		'txcd_41050008' => 'txcd_41050008 - Tea Leaves or Tea Bags',
		'txcd_41051001' => 'txcd_41051001 - Energy Beverages - Carbonated - with Supplement Facts Label',
		'txcd_41051002' => 'txcd_41051002 - Energy Beverages - Non-Carbonated - with Supplement Facts Label',
		'txcd_41052001' => 'txcd_41052001 - Food and Beverage - Non-Alcoholic Beer/ Wine',
		'txcd_41053001' => 'txcd_41053001 - Nutritional Supplement, Protein Drinks, Shakes - Contains Milk',
		'txcd_41053002' => 'txcd_41053002 - Nutritional Supplement, Protein Drink, Shakes - Contains No Milk',
		'txcd_41054001' => 'txcd_41054001 - Powdered Drink Mixes - To Be Mixed with Milk',
		'txcd_41054002' => 'txcd_41054002 - Powdered Drink Mixes - To Be Mixed with Water',
		'txcd_41060003' => 'txcd_41060003 - Milk Substitutes',
		'txcd_41060006' => 'txcd_41060006 - Milk Coffee Tea Cocoa Beverages',
		'txcd_50021001' => 'txcd_50021001 - Fitness Centers - Dues and Membership Fees',
		'txcd_50021002' => 'txcd_50021002 - Fitness Centers - Initiation Fees',
		'txcd_50021003' => 'txcd_50021003 - Fee for Personal Training/Fitness Classes',
		'txcd_50021101' => 'txcd_50021101 - Fitness Centers - Single Use Access Fees',
		'txcd_50021103' => 'txcd_50021103 - Fee For Sport Instruction Classes',
		'txcd_90000001' => 'txcd_90000001 - Cash Donation',
		'txcd_90020001' => 'txcd_90020001 - Optional Gratuity',
		'txcd_92010001' => 'txcd_92010001 - Shipping',
	];

	public static function all() {
		return static::$list;
	}
}
