<?php
get_header();

$album_colums = noo_get_option('noo_album_columns', '3');
$class = 'col-md-' . absint((12 / $album_colums));
?>

<div id="content" class="container-wrap noo-archive-album">
	<div class="main-content container">
		<div class="row">
			<div class="noo-main">
				<div class="noo_albums-wrap clearfix">
					<ul class="noo_albums">
						<?php while ( have_posts() ) : the_post(); ?>
							<li <?php post_class(  $class . ' col-sm-6'); ?>>
								<div class="noo_album-container">
									<figure>
										<div class="noo_album-wrap">
											<div class="noo_album-images">
												<a href="<?php the_permalink(); ?>">
													<?php 
													if ( has_post_thumbnail() ) {
														echo get_the_post_thumbnail( get_the_ID(), 'noo-loop-album' );
													}
													?>
												</a>
											</div>
										</div>
										<figcaption>
											<div class="noo_album-info">
												<h3 class="noo_album_title"><a href="<?php the_permalink()?>"><?php the_title(); ?></a></h3>
												<div class="noo_album-category"><?php echo get_the_term_list(get_the_ID(),'album_genre', '', ', ', '')?></div>
											</div>
											<div class="noo_album-loop-actions">
                                                <a href="<?php the_permalink(); ?>"><i class="fa fa-link"></i> <?php _e('Detail','noo') ; ?></a>
                                                <?php
                                                $source_songs = noo_get_post_meta( get_the_ID(), '_source_songs', 'upload_file' );
                                                ?>
                                                <?php if ( 'upload_file' == $source_songs ) :  ?>
	                                                <?php if( noo_get_option('enable_footer_player', 'enabled') == 'enabled' ) : ?>
														<a href="#" data-songs='<?php echo esc_attr(Noo_Album::songs_to_playlist_data(get_the_ID()))?>' class="add-to-playlist-btn"><i class="fa fa-plus"></i> <?php _e('Add to Playlist','noo')?></a>
													<?php endif; ?>
												<?php elseif ( 'soundcloud' == $source_songs ) :  ?>
													<a href="<?php the_permalink(); ?>"><i class="fa fa-soundcloud"></i> <?php _e('Soundcloud','noo')?></a>
												<?php elseif ( 'link' == $source_songs ) :  $wlink = noo_get_post_meta( get_the_ID(), '_open_link', '' );  ?>
													<a href="<?php echo esc_url( $wlink ); ?>" target="_blank"><i class="fa fa-external-link"></i> <?php _e('View link','noo')?></a>
												<?php endif; ?>
											</div>
										</figcaption>
									</figure>
								</div>
							</li>
						<?php endwhile; // end of the loop. ?>
					</ul>
				</div>
				<?php noo_pagination(); ?>
			</div>
		</div>
	</div>
</div>
<?php
get_footer();
?>