<?php


/* =============================================================================
 *
 * Function for specific theme, remember to keep all the functions
 * specified for this theme inside this file.
 *
 * ============================================================================*/

// function to display number of posts.
function getPostViews($postID){
    $count_key = 'post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
        return "0";
    }
    return $count;
}

// function to count views.
function setPostViews($postID) {
    $count_key    = 'post_views_count';
    $count        = get_post_meta($postID, $count_key, true);
    if($count==''){
        $count = 0;
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
    }else{
        $count++;
        update_post_meta($postID, $count_key, $count);
    }
}

// Define theme specific constant
if (!defined('NOO_THEME_NAME'))
{
  define('NOO_THEME_NAME', 'noo-');
}

if (!defined('NOO_THEME_VERSION'))
{
  define('NOO_THEME_VERSION', '0.0.1');
}

function noo_relative_time($a=''){
   return human_time_diff($a, current_time( 'timestamp' ));
}
//get time for event countdown
function noo_countdown_time($a=''){

    //get current timestampt
    $b = strtotime("now");
    //get difference
    $d = $a - $b;
    if($d > 0) {
        return $d;
    } else {
        return 0;
    }
}

function noo_social_share( $post_id = null,$echo = true ) {
    $post_id = (null === $post_id) ? get_the_id() : $post_id;
    $post_type =  get_post_type($post_id);
    $prefix = 'noo_blog';

    if($post_type == 'portfolio_project' ) {
        $prefix = 'noo_portfolio';
    }

    if(noo_get_option("{$prefix}_social", true ) === false) {
        return '';
    }

    $share_url     = urlencode( get_permalink() );
    //$share_title   = urlencode( get_the_title() );
    $share_source  = urlencode( get_bloginfo( 'name' ) );
    // $share_content = urlencode( get_the_content() );
    $share_media   = wp_get_attachment_thumb_url( get_post_thumbnail_id($post_id) );
    $popup_attr    = 'resizable=0, toolbar=0, menubar=0, status=0, location=0, scrollbars=0';

    $facebook     = noo_get_option( "{$prefix}_social_facebook", true );
    $twitter      = noo_get_option( "{$prefix}_social_twitter", true );
    $google       = noo_get_option( "{$prefix}_social_google", true );
    $pinterest    = noo_get_option( "{$prefix}_social_pinterest", true );
    $linkedin     = noo_get_option( "{$prefix}_social_linkedin", true );
    $share_title     = noo_get_option( "{$prefix}_social_title", '' );

    $html = array();

    if ( $facebook || $twitter || $google || $pinterest || $linkedin ) {
        if( $share_title !== '' ) {
                $html[] = '<p class="social-title">';
                $html[] = '  ' . $share_title;
                $html[] = '</p>';
            }
        if($facebook) {

            $html[] = '<a href="#share" class="noo-share noo-facebook"'
                    . ' title="' . __( 'Share on Facebook', 'noo' ) . '"'
                            . ' onclick="window.open('
                                    . "'http://www.facebook.com/sharer.php?u={$share_url}&amp;t={$share_title}','popupFacebook','width=650,height=270,{$popup_attr}');"
                                    . ' return false;">';
            $html[] = '<span class="title-shared">'.__( 'Share on Facebook', 'noo' ).'</span>';
            $html[] = '<i class="fa fa-facebook"></i>';
            $html[] = '</a>';
        }

        if($twitter) {
            $html[] = '<a href="#share" class="noo-share noo-twitter"'
                    . ' title="' . __( 'Share on Twitter', 'noo' ) . '"'
                            . ' onclick="window.open('
                                    . "'https://twitter.com/intent/tweet?text={$share_title}&amp;url={$share_url}','popupTwitter','width=500,height=370,{$popup_attr}');"
                                    . ' return false;">';
            $html[] = '<span class="title-shared">'.__( 'Share on Twitter', 'noo' ).'</span>';
            $html[] = '<i class="fa fa-twitter"></i></a>';
        }

        if($google) {
            $html[] = '<a href="#share" class="noo-share noo-google-plus"'
                    . ' title="' . __( 'Share on Google+', 'noo' ) . '"'
                            . ' onclick="window.open('
                            . "'https://plus.google.com/share?url={$share_url}','popupGooglePlus','width=650,height=226,{$popup_attr}');"
                            . ' return false;">';
                            $html[] = '<span class="title-shared">'.__( 'Share on Google+', 'noo' ).'</span>';
                            $html[] = '<i class="fa fa-google-plus"></i></a>';
        }

        if($pinterest) {
            $html[] = '<a href="#share" class="noo-share noo-pinterest"'
                    . ' title="' . __( 'Share on Pinterest', 'noo' ) . '"'
                            . ' onclick="window.open('
                                    . "'http://pinterest.com/pin/create/button/?url={$share_url}&amp;media={$share_media}&amp;description={$share_title}','popupPinterest','width=750,height=265,{$popup_attr}');"
                                    . ' return false;">';
            $html[] = '<span class="title-shared">'.__( 'Share on Pinterest', 'noo' ).'</span>';
            $html[] = '<i class="fa fa-pinterest"></i></a>';
        }

        if($linkedin) {
            $html[] = '<a href="#share" class="noo-share noo-linkedin"'
                    . ' title="' . __( 'Share on LinkedIn', 'noo' ) . '"'
                            . ' onclick="window.open('
                                    . "'http://www.linkedin.com/shareArticle?mini=true&amp;url={$share_url}&amp;title={$share_title}&amp;source={$share_source}','popupLinkedIn','width=610,height=480,{$popup_attr}');"
                                    . ' return false;">';
            $html[] = '<span class="title-shared">'.__( 'Share on LinkedIn', 'noo' ).'</span>';
            $html[] = '<i class="fa fa-linkedin"></i></a>';
        }
    }
    if($echo)
        echo implode("\n", $html);
    else 
        return implode("\n", $html);
}

function noo_social_count($post_id = null,$cache_minutes = 15) {
    $count_social =  0;
    $post_id = (null === $post_id) ? get_the_id() : $post_id;
    $post_type =  get_post_type($post_id);
    $prefix = 'noo_blog';
    $share_url     = urlencode( get_permalink() );
    $share_title   = urlencode( get_the_title() );
    $share_source  = urlencode( get_bloginfo( 'name' ) );
    $share_content = urlencode( get_the_content() );
    $share_media   = wp_get_attachment_thumb_url( get_post_thumbnail_id() );
    $popup_attr    = 'resizable=0, toolbar=0, menubar=0, status=0, location=0, scrollbars=0';


    $facebook     = noo_get_option( "{$prefix}_social_facebook", true );
    $twitter      = noo_get_option( "{$prefix}_social_twitter", true );
    $google       = noo_get_option( "{$prefix}_social_google", true );

    $pinterest    = noo_get_option( "{$prefix}_social_pinterest", true );
    $linkedin     = noo_get_option( "{$prefix}_social_linkedin", true );

    //$share_url     = 'http://mashable.com/2015/04/07/husky-howl/';
    $html = array();
    $shared_count_network_flag = false;
    if(apply_filters('noo_get_shared_count_network', true)){
    	$shared_count_network_flag = true;
    	$shared_count_network_total = noo_get_shared_count_network_data($post_id,'sum');
    	$shared_count_network_data = noo_get_shared_count_network_data($post_id,'',false);
    }
    if ( $facebook || $twitter || $google || $pinterest || $linkedin ) {
        $html[] = '<div class="social-shared-wrap">';
        $html[] .= '<a class="button-social" title="' . __( 'Share This Post', 'noo' ) . '">';
        $html[] .= '<i class="fa fa-share-alt"></i>';
        $html[] .= '{$count}';
        $html[] .= '</a>';
        $html[] = '<div class="social-shared">';
        if($facebook) {
        	if($shared_count_network_flag){
        		$facebook_count = $shared_count_network_data['shares']['fb'];
        	}else{
	            $facebook_count = get_transient('noo_facebook_share_count_'.$post_id);
	            if( empty( $facebook_count ) ) {
	                $facebook_count = noo_fb_count($share_url);
	                set_transient( 'noo_facebook_share_count_'.$post_id , $facebook_count , $cache_minutes * 60);
	            }
	            $count_social += $facebook_count;
        	}
            
            $html[] = '<div><a href="#share" class="noo-share"'
                . ' title="' . __( 'Share on Facebook', 'noo' ) . '"'
                . ' onclick="window.open('
                . "'http://www.facebook.com/sharer.php?u={$share_url}&amp;t={$share_title}','popupFacebook','width=650,height=270,{$popup_attr}');"
                . ' return false;">';
            $html[] = '<i class="fa fa-facebook"></i>';
            $html[] = '</a><span>'.$facebook_count.'</span></div>';
        }
        if($twitter) {
        	if($shared_count_network_flag){
        		$twitter_count = $shared_count_network_data['shares']['tw'];
        	}else{
	            $twitter_count = get_transient('noo_twitter_share_count_'.$post_id);
	            if( empty( $twitter_count ) ) {
	                $twitter_count = noo_twitter_count($share_url);
	                set_transient( 'noo_twitter_share_count_'.$post_id , $twitter_count , $cache_minutes * 60);
	            }
	            $count_social += $twitter_count;
        	}
            $html[] = '<div><a href="#share" class="noo-share"'
                . ' title="' . __( 'Share on Twitter', 'noo' ) . '"'
                . ' onclick="window.open('
                . "'https://twitter.com/intent/tweet?text={$share_title}&amp;url={$share_url}','popupTwitter','width=500,height=370,{$popup_attr}');"
                . ' return false;">';
            $html[] = '<i class="fa fa-twitter"></i></a><span>'.$twitter_count.'</span></div>';
        }
        if($google) {
        	if($shared_count_network_flag){
        		$gplus_count = $shared_count_network_data['shares']['gp'];
        	}else{
	            $gplus_count = get_transient('noo_gplus_share_count_'.$post_id);
	            if( empty( $gplus_count ) ) {
	                $gplus_count = noo_gplus_count($share_url);
	                set_transient( 'noo_gplus_share_count_'.$post_id , $gplus_count , $cache_minutes * 60);
	            }
	            $count_social += $gplus_count;
        	}
            $html[] = '<div><a href="#share" class="noo-share"'
                . ' title="' . __( 'Share on Google+', 'noo' ) . '"'
                . ' onclick="window.open('
                . "'https://plus.google.com/share?url={$share_url}','popupGooglePlus','width=650,height=226,{$popup_attr}');"
                . ' return false;">';
            $html[] = '<i class="fa fa-google-plus"></i></a><span>'.$gplus_count.'</span></div>';
        }
        if($pinterest) {
        	if($shared_count_network_flag){
        		$pinterest_count = $shared_count_network_data['shares']['pin'];
        	}else{
	            $pinterest_count = get_transient('noo_pinterest_share_count_'.$post_id);
	            if( empty( $pinterest_count ) ) {
	                $pinterest_count = noo_pinterest_count($share_url);
	                set_transient( 'noo_pinterest_share_count_'.$post_id , $pinterest_count , $cache_minutes * 60);
	            }
	            $count_social += $pinterest_count;
        	}
            $html[] = '<div><a href="#share" class="noo-share"'
                . ' title="' . __( 'Share on Pinterest', 'noo' ) . '"'
                . ' onclick="window.open('
                . "'http://pinterest.com/pin/create/button/?url={$share_url}&amp;media={$share_media}&amp;description={$share_title}','popupPinterest','width=750,height=265,{$popup_attr}');"
                . ' return false;">';
            $html[] = '<i class="fa fa-pinterest"></i></a><span>'.$pinterest_count.'</span></div>';

        }
        if($linkedin) {
        	if($shared_count_network_flag){
        		$linkedin_count = $shared_count_network_data['shares']['li'];
        	}else{
	            $linkedin_count = get_transient('noo_linkedin_share_count_'.$post_id);
	            if( empty( $linkedin_count ) ) {
	                $linkedin_count = noo_linkedin_count($share_url);
	                set_transient( 'noo_linkedin_share_count_'.$post_id , $linkedin_count , $cache_minutes * 60);
	            }
	            $count_social+= noo_linkedin_count($share_url);
        	}
            $html[] = '<div><a href="#share" class="noo-share"'
                 . ' title="' . __( 'Share on LinkedIn', 'noo' ) . '"'
                 . ' onclick="window.open('
                 . "'http://www.linkedin.com/shareArticle?mini=true&amp;url={$share_url}&amp;title={$share_title}&amp;summary={$share_content}&amp;source={$share_source}','popupLinkedIn','width=610,height=480,{$popup_attr}');"
                 . ' return false;">';
            $html[] = '<i class="fa fa-linkedin"></i></a><span>'.$linkedin_count.'</span></div>';
        }
        $html[] .= '</div>';
        
        $html[] .= '</div>';
        ob_start();
        ?>
        <script>
            jQuery(document).ready(function($) {
               $('.button-social').on('click',function(){
                    $(".social-shared").toggleClass("active");
               });
               jQuery('body').on('mousedown', jQuery.proxy( function(e){
                    var element = jQuery(e.target);
                    if(!element.is('.social-shared') && element.parents('.social-shared').length === 0 )
                    {
                        jQuery('.social-shared').removeClass('active');
                    }
                }, this) );
            });
        </script>
        <?php
        $html[] .= ob_get_clean();
    }
    $html = implode("\n", $html);
    
    if($shared_count_network_flag){
    	if(empty($shared_count_network_total)){
    		$shared_count_network_total = (int)$shared_count_network_total;
    		foreach ($shared_count_network_data['shares'] as $totalcount) $shared_count_network_total += (int)$totalcount;
    	}
    	$shared_count_network_count = get_transient('noo_post_share_count_network_'.$post_id);
    	if($shared_count_network_count != $shared_count_network_total){
    		set_transient( 'noo_post_share_count_network_'.$post_id ,$shared_count_network_total , $cache_minutes * 60);
    	}
    	$count_social = $shared_count_network_total;
    }
    return str_replace('{$count}', $count_social, $html);
}

function noo_get_shared_count_network_data( $post_id, $data_type='sum' ,$cache_minutes = 15 ) {
	global $noo_post_shared_data;
	$prefix = 'noo_blog';
	$facebook     = noo_get_option( "{$prefix}_social_facebook", true );
	$twitter      = noo_get_option( "{$prefix}_social_twitter", true );
	$google       = noo_get_option( "{$prefix}_social_google", true );
	$pinterest    = noo_get_option( "{$prefix}_social_pinterest", true );
	$linkedin     = noo_get_option( "{$prefix}_social_linkedin", true );
	if(empty($noo_post_shared_data))
		$noo_post_shared_data = array();
	$global_key = $post_id.'_'.$data_type;

	if(!empty($noo_post_shared_data) && isset($noo_post_shared_data[$global_key]))
		return $noo_post_shared_data[$global_key];
	
	$noo_get_shared_count_network_url = 'http://'.apply_filters('noo_get_shared_count_network_domain', 'free.sharedcount.com') . "/?url=" . rawurlencode(get_permalink($post_id)) . "&apikey=" . apply_filters('noo_get_shared_count_network_api', 'f7ba52d06445354e5ec13f844305e9074aa24922');
	$noo_get_shared_count_network_url = apply_filters('noo_get_shared_count_network_url', $noo_get_shared_count_network_url);
	
	$shared_count_network_count = false;
	if($cache_minutes !== false)
		$shared_count_network_count = get_transient('noo_post_share_count_network_'.$post_id);

	if($shared_count_network_count === false){
		try {
			$args = array(
				'httpversion' => '1.1',
				'blocking' => true,
				'decompress'=>false,
				'headers' => array(
					'Authorization' => "Bearer {$twitter['token']}"
				)
			);
			$response = wp_remote_get($noo_get_shared_count_network_url,$args);
			if (!is_wp_error($response)) {
				$curl_results = wp_remote_retrieve_body($response);
				$sharecounts = json_decode($curl_results, true);
				$counts = array('shares'=>array(),'total'=>0);
				$facebook && isset($sharecounts['Facebook']['share_count']) ? $counts['shares']['fb'] = $sharecounts['Facebook']['share_count'] : $counts['shares']['fb'] = 0;
				$twitter && isset($sharecounts['Twitter']) ? $counts['shares']['tw'] = $sharecounts['Twitter'] : $sharecounts['Twitter'] = 0;
				$google && isset($sharecounts['GooglePlusOne']) ? $counts['shares']['gp'] = $sharecounts['GooglePlusOne'] : $counts['shares']['gp'] = 0 ;
				$linkedin && isset($sharecounts['LinkedIn']) ? $counts['shares']['li'] = $sharecounts['LinkedIn'] : $counts['shares']['li'] = 0;
				$pinterest && isset($sharecounts['Pinterest']) ? $counts['shares']['pin'] = $sharecounts['Pinterest'] : $counts['shares']['pin'] = 0;
				
				$total = 0;
				foreach ($counts['shares'] as $totalcount) $total += (int)$totalcount;
				$totalArr = array ('total' => $total);
				$objMerged = (object)array_merge((array)$sharecounts, (array)$totalArr);
				
				$data = $counts;
				
				if($data_type=='sum'){
					$data = $total;
				}
				$data = apply_filters('noo_get_shared_count_network_data', $data,$post_id,$data_type,$sharecounts,$curl_results);
				//save to global
				
				//save to data
				if($cache_minutes !== false){
					$noo_post_shared_data[$global_key] = $data;
					set_transient( 'noo_post_share_count_network_'.$post_id ,$data , $cache_minutes * 60);
				}
			
				return $data;
			}
			return 0;
		}catch (Exception $e){
			return 0;
		}
	}
	return $shared_count_network_count;
}

function noo_share_count($post_id = null,$cache_minutes = 15, $class_input='') {
    if(!apply_filters('noo_share_count_meta', true)){
    	return;
    }
    if(!noo_get_option('noo_count_share',true)){
        return;
    }
    $count_social =  0;
    $post_id = (null === $post_id) ? get_the_ID() : $post_id;
    
    if(apply_filters('noo_get_shared_count_network', true)){
    	$html = array();
    	$html[] .= '<span class="button-social '.$class_input.'">';
    	$html[] .= '<i class="fa fa-share-alt"></i>';
    	$html[] .= (int) noo_get_shared_count_network_data($post_id,'sum');
    	$html[] .= '</span>';
    	return implode("\n", $html);
    }
    
    $post_type =  get_post_type($post_id);
    $prefix = 'noo_blog';
    $share_url     = ( get_permalink() );


    $facebook     = noo_get_option( "{$prefix}_social_facebook", true );
    $twitter      = noo_get_option( "{$prefix}_social_twitter", true );
    $google       = noo_get_option( "{$prefix}_social_google", true );

    $pinterest    = noo_get_option( "{$prefix}_social_pinterest", true );
    $linkedin     = noo_get_option( "{$prefix}_social_linkedin", true );
    //$share_url     = 'http://mashable.com/2015/04/07/husky-howl/';
    $html = array();
    $post_share_cout = get_transient('noo_post_share_count_'.$post_id);
    
    if ( $post_share_cout === false && ($facebook || $twitter || $google || $pinterest || $linkedin ) ) {
       
        if($facebook) {
           // delete_transient('noo_facebook_share_count_'.$post_id);
            $facebook_count = get_transient('noo_facebook_share_count_'.$post_id);
            if( $facebook_count  === false) {
                $facebook_count = noo_fb_count($share_url);
                set_transient( 'noo_facebook_share_count_'.$post_id , $facebook_count , $cache_minutes * 60);
            }
            $count_social += $facebook_count;
        }
        if($twitter) {
            $twitter_count = get_transient('noo_twitter_share_count_'.$post_id);
            if( $twitter_count  === false ) {
                $twitter_count = noo_twitter_count($share_url);
                set_transient( 'noo_twitter_share_count_'.$post_id , $twitter_count , $cache_minutes * 60);
            }
            $count_social += $twitter_count;
        }
        if($google) {

            $gplus_count = get_transient('noo_gplus_share_count_'.$post_id);
            if($gplus_count === false ) {
                $gplus_count = noo_gplus_count($share_url);
                set_transient( 'noo_gplus_share_count_'.$post_id , $gplus_count , $cache_minutes * 60);
            }
            $count_social += $gplus_count;
        }
        if($pinterest) {

            $pinterest_count =  get_transient('noo_pinterest_share_count_'.$post_id);
            if( empty($pinterest_count) ) {
                $pinterest_count = noo_pinterest_count($share_url);
                set_transient( 'noo_pinterest_share_count_'.$post_id , $pinterest_count , $cache_minutes * 60);
            }
            $count_social += $pinterest_count;

        }
        if($linkedin) {
            $linkedin_count = get_transient('noo_linkedin_share_count_'.$post_id);
            if( $linkedin_count  === false ) {
                $linkedin_count = noo_linkedin_count($share_url);
                set_transient( 'noo_linkedin_share_count_'.$post_id , $linkedin_count , $cache_minutes * 60);
            }
            $count_social+= noo_linkedin_count($share_url);
        }
        //save to transient	
        set_transient( 'noo_post_share_count_'.$post_id ,$count_social , $cache_minutes * 60);
        
    }
    $html[] .= '<span class="button-social '.$class_input.'">';
    $html[] .= '<i class="fa fa-share-alt"></i>';
    $html[] .= (int) $post_share_cout;
    $html[] .= '</span>';
    return implode("\n", $html);
}


function noo_list_comments($comment, $args, $depth) {
    $GLOBALS['comment'] = $comment;
    GLOBAL $post;
    $avatar_size = isset($args['avatar_size']) ? $args['avatar_size'] : 60;
    ?>
        <li id="li-comment-<?php comment_ID(); ?>" <?php comment_class(); ?>>
            <div class="comment-wrap">
                <div class="comment-img">
                    <?php echo get_avatar($comment, $avatar_size); ?>
                </div>
                <div id="comment-<?php comment_ID(); ?>" class="comment-block">
                    <header class="comment-header">
                        <cite class="comment-author"><?php echo get_comment_author_link(); ?> 
                            <?php if ($comment->user_id === $post->post_author): ?>
                            <span class="ispostauthor">
                                <?php _e('Author', 'noo'); ?>
                            </span>
                            <?php endif; ?>
                        </cite>
                        <div class="comment-meta">
                            <span class="time">
                                <?php echo sprintf(__('%1$s ago', 'noo') , esc_html(noo_relative_time(get_comment_date('U')))); ?>
                            </span>
                            <span class="comment-edit">
                                <?php edit_comment_link('' . __('Edit', 'noo')); ?>
                            </span>
                        </div>
                        <?php if ('0' == $comment->comment_approved): ?>
                            <p class="comment-pending"><?php _e('Your comment is awaiting moderation.', 'noo'); ?></p>
                        <?php endif; ?>
                    </header>
                    <div class="comment-content">
                        <?php comment_text(); ?>
                        <span class="comment-reply">
                            <?php comment_reply_link(array_merge($args, array(
                                'reply_text' => (__('Reply', 'noo') . '') ,
                                'depth' => $depth,
                                'max_depth' => $args['max_depth']
                            ))); ?>
                        </span>
                    </div>

                </div>
            </div>
        <?php
}

function noo_content_meta($is_shortcode=false,$hide_author = true,$hide_date = false,$hide_category = false,$hide_comment = false,$show_bookmark=false) {
	global $member_manage_id;
	$post_type = get_post_type();
    if ( $post_type == 'post' ) {
        if ((!is_single() && noo_get_option( 'noo_blog_show_post_meta' ) === false)
                || (is_single() && noo_get_option( 'noo_blog_post_show_post_meta' ) === false)) {
                    return;
                }
    } elseif ($post_type == 'portfolio_project') {
        if (noo_get_option( 'noo_portfolio_show_post_meta' ) === false) {
            return;
        }
    }

    $html = array();
    $html[] = '<p class="content-meta">';
    // Author
    if(!$hide_author ):
        $html[] = '<span class="noo-author">';
        $html[] = '<i class="fa fa-pencil-square-o"></i>';
        ob_start();
        the_author_posts_link();
        $html[] = ob_get_clean();
        $html[] = '</span>';
    endif;
    // Date
    // Date
    if(!$hide_date):
        $html[] = '<span>';
        $html[] = '<i class="fa fa-calendar"></i>';
        $html[] = '<time class="entry-date" datetime="' . esc_attr(get_the_date('c')) . '">';
        $html[] = esc_html(get_the_date());
        $html[] = '</time>';
        $html[] = '</span>';
    endif;
    // Categories
    $categories_html = '';
    $separator = ', ';

    if (get_post_type() == 'portfolio_project') {
        if (has_term('', 'portfolio_category', NULL)) {
            $categories = get_the_terms(get_the_id() , 'portfolio_category');
            foreach ($categories as $category) {
                $categories_html .= '<a' . ' href="' . get_term_link($category->slug, 'portfolio_category') . '"' . ' title="' . esc_attr(sprintf(__("View all Portfolio Items in: &ldquo;%s&rdquo;", 'noo') , $category->name)) . '">' . ' ' . $category->name . '</a>' . $separator;
            }
        }
    } else {
        $categories = get_the_category();
        foreach ($categories as $category) {
            $categories_html.= '<a' . ' href="' . get_category_link($category->term_id) . '"' . ' title="' . esc_attr(sprintf(__("View all posts in: &ldquo;%s&rdquo;", 'noo') , $category->name)) . '">' . ' ' . $category->name . '</a>' . $separator;
        }
    }

    $comments_html = '';

    if (comments_open()) {
        $comment_title = '';
        $comment_number = '';
        $comment_title = sprintf(__('View all comments on: &ldquo;%s&rdquo;', 'noo') , get_the_title());
        $comment_number =  ' ' . get_comments_number(); 
        $comments_html.= '<span><i class="fa fa-comments-o"></i><a' . ' href="' . esc_url(get_comments_link()) . '"' . ' title="' . esc_attr($comment_title) . '"' . ' class="meta-comments">';
        $comments_html.=  $comment_number . '</a></span>';
    }
    if(!$hide_comment)
        $html[] = $comments_html;
    if(is_user_logged_in() && apply_filters('noo_show_bookmark_butotn', $show_bookmark)){
    	$user_bookmarks		= (array) get_user_meta(get_current_user_id(),'_post_bookmark',true);
    	if( !in_array(get_the_ID(), $user_bookmarks) ) {
    		$html [] = '<span><a class="bookmark-action" data-action="noo_bookmark_post" data-security="'.wp_create_nonce('member-bookmark').'" data-post-id="'.get_the_ID().'" href="#" title="'.esc_attr__('Bookmark this post','noo').'"><i class="fa fa-bookmark-o"></i></a></span>';
    	}else{
    		if($member_manage_id == Noo_Member::get_setting('manage_page'))
    			$html [] = '<span><a class="bookmark-action" data-action="noo_remove_bookmark_post" data-security="'.wp_create_nonce('member-bookmark').'" data-post-id="'.get_the_ID().'"  href="#" title="'.esc_attr__('Unbookmark this post','noo').'"><i class="text-danger fa fa-times"></i></a></span>';
    		else
    			$html [] = '<span><a class="bookmark-action bookmarked" data-action="noo_remove_bookmark_post" data-security="'.wp_create_nonce('member-bookmark').'" data-post-id="'.get_the_ID().'" href="#" title="'.esc_attr__('Bookmarked','noo').'"><i class="text-primary fa fa-bookmark"></i></a></span>';
    	}
    }
    $html[] = '<span><i class="fa fa-eye"></i>'.getPostViews(get_the_ID()).'</span>';

    $html[] = '</p>';
    echo implode("\n", $html);
}

function noo_comment_form( $args = array(), $post_id = null ) {
    global $id;
    $user = wp_get_current_user();
    $user_identity = $user->exists() ? $user->display_name : '';

    if ( null === $post_id ) {
        $post_id = $id;
    }
    else {
        $id = $post_id;
    }

    if ( comments_open( $post_id ) ) :
    ?>
    <div id="respond-wrap">
        <?php 
            $commenter = wp_get_current_commenter();
            $req = get_option( 'require_name_email' );
            $aria_req = ( $req ? " aria-required='true'" : '' );
            $fields =  array(
                'author' => '<div class="row"><p class="comment-form-author  col-sm-12"><input id="author" name="author" type="text" placeholder="' . __( 'Name*', 'noo' ) . '" class="form-control" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' . $aria_req . ' /></p>',
                'email' => '<p class="comment-form-email col-sm-12"><input id="email" name="email" type="text" placeholder="' . __( 'Email*', 'noo' ) . '" class="form-control" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30"' . $aria_req . ' /></p>',
                'comment_field'        => '<div class="col-sm-12"><p class="comment-form-comment"><textarea class="form-control" placeholder="' . __( 'Comment', 'noo' ) . '" id="comment" name="comment" cols="40" rows="6" aria-required="true"></textarea></p></div></div>'
            );
            $comments_args = array(
                    'fields'               => apply_filters( 'comment_form_default_fields', $fields ),
                    'logged_in_as'         => '<p class="logged-in-as">' . sprintf( __( 'Logged in as <a href="%1$s">%2$s</a>. <a href="%3$s" title="Log out of this account">Log out?</a>', 'noo' ), admin_url( 'profile.php' ), $user_identity, wp_logout_url( apply_filters( 'the_permalink', get_permalink( ) ) ) ) . '</p>',
                    'title_reply'          => sprintf('<span>%s</span>',__( 'Leave your thought', 'noo' )),
                    'title_reply_to'       => sprintf('<span>%s</span>',__( 'Leave a reply to %s', 'noo' )),
                    'cancel_reply_link'    => __( 'Click here to cancel the reply', 'noo' ),
                    'comment_notes_before' => '',
                    'comment_notes_after'  => '',
                    'label_submit'         => __( 'Submit', 'noo' ),
                    'comment_field'        =>'',
                    'must_log_in'          => ''
            );
            if(is_user_logged_in()){
                $comments_args['comment_field'] = '<p class="comment-form-comment"><textarea class="form-control" placeholder="' . __( 'Comment', 'noo' ) . '" id="comment" name="comment" cols="40" rows="6" aria-required="true"></textarea></p>';
            }
        comment_form($comments_args); 
        ?>
    </div>

    <?php
    endif;
}
function noo_post_nav() {
    global $post;

    // Don't print empty markup if there's nowhere to navigate.
    $previous = ( is_attachment() ) ? get_post( $post->post_parent ) : get_adjacent_post( false, '', true );
    $next     = get_adjacent_post( false, '', false );

    if ( ! $next && ! $previous )
        return;
    ?>
    <?php $prev_link = get_previous_post_link( '%link', _x( '%title', 'Previous post link', 'noo' ) ); ?>
    <?php $next_link = get_next_post_link( '%link', _x( '%title', 'Next post link', 'noo' ) ); ?>
    <nav class="post-navigation<?php echo( (!empty($prev_link) || !empty($next_link) ) ? ' post-navigation-line':'' )?>">
        <?php if($prev_link):?>
            <div class="prev-post col-md-6 col-sm-6">
                <?php echo ($prev_link);?>

            </div>
        <?php endif;?>
                
        <?php if(!empty($next_link)):?>
            <div class="next-post col-md-6 col-sm-6">
                <?php echo ($next_link);?>
            </div>
        <?php endif;?>
    </nav>
    <?php
}
function noo_excerpt_read_more( $more ) {
    return '';
}
add_filter( 'excerpt_more', 'noo_excerpt_read_more' );

function noo_content_read_more( $more ) {
    return '';
}

add_filter( 'the_content_more_link', 'noo_content_read_more' );

if( !function_exists('noo_get_instagram_data') ) :
    // using standard_resolution / thumbnail / low_resolution
    function noo_get_instagram_data($username = 'nootheme', $cache_hours = '5', $nr_images = '4', $resolution = 'thumbnail', $randomise = false) {
        $opt_name    = 'noo_insta_'.md5( $username );
        $instaData   = get_transient( $opt_name );
        $user_opt    = get_option( $opt_name );

        if( !in_array($resolution, array( 'low_resolution', 'thumbnail', 'standard_resolution' ) ) ) $resolution = 'thumbnail';
        if ( false === $instaData
            || $user_opt['username']    != $username
            || $user_opt['cache_hours'] != $cache_hours
            || $user_opt['nr_images']   != $nr_images
            || $user_opt['resolution']  != $resolution
        ) {
            $instaData    = array();
            $insta_url    = 'http://instagram.com/';
            $user_profile = $insta_url.$username;
            $json         = wp_remote_get( $user_profile, array( 'sslverify' => false, 'timeout'=> 60 ) );
            $user_options = compact('username', 'cache_hours', 'nr_images', 'resolution');

            update_option( $opt_name, $user_options );
            if ( !is_wp_error( $json ) && $json['response']['code'] == 200 ) {
                $json     = $json['body'];
                $json     = strstr( $json, 'window._sharedData = ' );
                $json     = str_replace('window._sharedData = ', '', $json);
                
                // Compatibility for version of php where strstr() doesnt accept third parameter
                if ( version_compare( phpversion(), '5.3.10', '<' ) ) {
                    $json = substr( $json, 0, strpos($json, '</script>' ) );
                } else {
                    $json = strstr( $json, '</script>', true );
                }
                
                $json     = rtrim( $json, ';' );
                
                // Function json_last_error() is not available before PHP * 5.3.0 version
                if ( function_exists( 'json_last_error' ) ) {
                
                    ( $results = json_decode( $json, true ) ) && json_last_error() == JSON_ERROR_NONE;
                
                } else {
                        
                    $results = json_decode( $json, true );
                }
                
                if ( ( $results ) && is_array( $results ) && isset( $results['entry_data']['UserProfile'] ) && is_array( $results['entry_data']['UserProfile'] ) ) {
                    foreach( $results['entry_data']['UserProfile'][0]['userMedia'] as $current => $result ) {
                            
                        if( $current >= $nr_images ) break;
                        $caption      = $result['caption'];
                        $image        = isset( $result['images'][$resolution] ) ? $result['images'][$resolution] : '';
                        $id           = $result['id'];
                        $image        = $image['url'];
                        $link         = $result['link'];
                        $created_time = $caption['created_time'];
                        $text         = _utf8_4byte_to_3byte($caption['text']);
                        $upload_dir   = wp_upload_dir();
                        $filename_data= explode( '.', $image );
                
                        if ( is_array( $filename_data ) ) {
                
                            $fileformat   = end( $filename_data );
                
                            if ( $fileformat !== false ){
                
                                array_push( $instaData, array(
                                    'id'           => $id,
                                    'user_name'    => $username,
                                    'user_url'     => $user_profile,
                                    'created_time' => $created_time,
                                    'text'         => $text,
                                    'image'        => $image,
                                    'image_path'   => $upload_dir['path'] . '/' . md5( $id ) . '.' . $fileformat,
                                    'link'         => $link
                                ));
                
                            } // end -> if $fileformat !== false
                
                        } // end -> is_array( $filename_data )
                
                    } // end -> foreach
                
                } // end -> ( $results ) && is_array( $results ) )
                if ( $instaData ) {
                    set_transient( $opt_name, $instaData, $cache_hours * 60 * 60 );
                } // end -> true $instaData
            }
        }
        
        return ( $randomise ? shuffle( $instaData ) : $instaData );
    }
endif;

function _utf8_4byte_to_3byte( $input ) {
         
    if (!empty($input)) {
        $utf8_2byte = 0xC0 /*1100 0000*/; $utf8_2byte_bmask = 0xE0 /*1110 0000*/;
        $utf8_3byte = 0xE0 /*1110 0000*/; $utf8_3byte_bmask = 0XF0 /*1111 0000*/;
        $utf8_4byte = 0xF0 /*1111 0000*/; $utf8_4byte_bmask = 0xF8 /*1111 1000*/;

        $sanitized = "";
        $len = strlen($input);
        for ($i = 0; $i < $len; ++$i) {
            $mb_char = $input[$i]; // Potentially a multibyte sequence
            $byte = ord($mb_char);
            if (($byte & $utf8_2byte_bmask) == $utf8_2byte) {
                $mb_char .= $input[++$i];
            }
            else if (($byte & $utf8_3byte_bmask) == $utf8_3byte) {
                $mb_char .= $input[++$i];
                $mb_char .= $input[++$i];
            }
            else if (($byte & $utf8_4byte_bmask) == $utf8_4byte) {
                // Replace with ? to avoid MySQL exception
                $mb_char = '?';
                $i += 3;
            }

            $sanitized .=  $mb_char;
        }

        $input= $sanitized;
    }

    return $input;
}

// Related post function

function noo_related_post(){
    global $post;
    $categories = get_the_category($post->ID);
    
    if (!$categories) {
        return;
    }
    $args = array(
        'posts_per_page' => 4,
        'post__not_in' => array($post->ID),
        "meta_key" => "_thumbnail_id",
        'category__in' => wp_get_post_categories($post->ID)
    );
    
    
    $r = new WP_Query($args);
    if($r->have_posts()):
    ?>
    <div class="related-post">
        <div class="related-posts noo_editor_picks noo-horizontal">
            <ul>
            <?php while ( $r->have_posts() ) : $r->the_post(); global $post; ?>
                    <?php 
                        
                        $avatar_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'agent-thumb' );
                        if( empty($avatar_src) ) {
                            $avatar_src     = NOO_ASSETS_URI . '/images/default-avatar.png';
                        } else {
                            $avatar_src     = $avatar_src[0];
                        }
                    ?>
                    <li style="background-image: url(<?php echo esc_url($avatar_src); ?>)">
       
                       <div class="noo-picks-excerpt">
                           <h3><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h3>
                            <?php
                            $excerpt = $post->post_excerpt;
                            if(empty($excerpt))
                                $excerpt = $post->post_content;

                            $excerpt = strip_shortcodes($excerpt);
                            echo '<p>' . wp_trim_words($excerpt,20,'...') . '</p>';
                            ?>
                       </div>
                   </li>
                <?php endwhile; ?>
            </ul>
        </div>
    </div>
    <?php
    endif;
    wp_reset_postdata();
}

// count fan page for social
function noo_remote_get( $url ) {
    $request = wp_remote_retrieve_body( wp_remote_get( $url , array( 'timeout' => 18,'decompress'=>false , 'sslverify' => false ) ) );
    return $request;
}
function noo_followers_count( $twitter = array() ) {
    
    $twitter['followers_count'] = 0;
    $twitter['page_url'] = '';
    if( !isset($twitter['username']) || empty( $twitter['username'] ) 
        || !isset($twitter['consumer_key']) || empty( $twitter['consumer_key'] ) 
        || !isset($twitter['consumer_secret']) || empty( $twitter['consumer_secret'] ) 
        ) {
        return $twitter;
    }

    $twitter['page_url'] = 'http://www.twitter.com/'.$twitter['username'];
    $twitter['followers_count'] = 0;//get_transient('twitter_count');
    if( empty( $twitter['followers_count']) || $twitter['followers_count'] <= 0 ){
        try {
            
            $twitter['token'] = get_option( 'twitter_token', '' );
         
            // getting new auth bearer only if we don't have one
            if(!isset($twitter['token']) || empty( $twitter['token'] )) {
                // preparing credentials
                $credentials = $twitter['consumer_key'] . ':' . $twitter['consumer_secret'];
                $toSend = base64_encode($credentials);
         
                // http post arguments
                $args = array(
                    'method' => 'POST',
                    'httpversion' => '1.1',
                    'blocking' => true,
                	'decompress'=>false,
                    'headers' => array(
                        'Authorization' => 'Basic ' . $toSend,
                        'Content-Type' => 'application/x-www-form-urlencoded;charset=UTF-8'
                    ),
                    'body' => array( 'grant_type' => 'client_credentials' )
                );
         
                add_filter('https_ssl_verify', '__return_false');
                $response = wp_remote_post('https://api.twitter.com/oauth2/token', $args);
         
                $keys = json_decode(wp_remote_retrieve_body($response));
         
                if($keys) {
                    // saving token to wp_options table
                    update_option('twitter_token', $keys->access_token);
                    $twitter['token'] = $keys->access_token;
                }
            }
            if( empty( $twitter['token'] ) ) return $twitter;
            
            // we have bearer token wether we obtained it from API or from options
            $args = array(
                'httpversion' => '1.1',
                'blocking' => true,
                'decompress'=>false,
                'headers' => array(
                    'Authorization' => "Bearer {$twitter['token']}"
                )
            );
            
            add_filter('https_ssl_verify', '__return_false');

            $api_url = "https://api.twitter.com/1.1/users/show.json?screen_name={$twitter['username']}";
            $response = wp_remote_get($api_url,$args);
            if (!is_wp_error($response)) {
                $followers = json_decode(wp_remote_retrieve_body($response));
                $twitter['followers_count'] = isset($followers->followers_count) ? $followers->followers_count : 0;
            }
            
        } catch (Exception $e) {
            $twitter['followers_count'] = 0;
        }

        if( !empty( $twitter['followers_count'] ) ){
            set_transient( 'twitter_count' , $twitter['followers_count'] , 1200);
            if( get_option( 'followers_count') != $twitter['followers_count'] ) 
                update_option( 'followers_count' , $twitter['followers_count'] );
        }
            
        if( $twitter['followers_count'] == 0 && get_option( 'followers_count') )
            $twitter['followers_count'] = get_option( 'followers_count');
    }
    return $twitter;
}

/** Function Count number fans of Facebook Page
 * $page_link
 * */

function noo_facebook_fans( $page_link ){

    $face_link = @parse_url($page_link);

    if( $face_link['host'] == 'www.facebook.com' || $face_link['host']  == 'facebook.com' ){
        $fans = get_transient('fans_count');
        if( empty( $fans ) ){
            try {
//              $data = json_decode(wp_remote_retrieve_body(wp_remote_get("http://graph.facebook.com".$face_link['path']),array( 'timeout' => 18 , 'sslverify' => false ) ));
                $data = @json_decode(noo_remote_get("http://graph.facebook.com/".$page_link));
                $fans = isset( $data->likes ) ? $data->likes : 0;

            } catch (Exception $e) {
                $fans = 0;
            }

            if( !empty($fans) ){

                set_transient( 'fans_count' , $fans , 1200);

                if ( get_option( 'fans_count') != $fans )
                    update_option( 'fans_count' , $fans );

            }

            if( $fans == 0 && get_option( 'fans_count') )
                $fans = get_option( 'fans_count');

            elseif( $fans == 0 && !get_option( 'fans_count') )
                $fans = 0;
        }

        return $fans;
    }
}

/** Function Count number subcriber of Youtube Chanel
 * $page_link
 * */

function noo_youtube_subs( $channel_link ){
    $youtube_link = @parse_url($channel_link);
    if( $youtube_link['host'] == 'www.youtube.com' || $youtube_link['host']  == 'youtube.com' ){
        $subs = get_transient('youtube_count');
        if( empty( $subs ) ){
            try {
                if (strpos( strtolower($channel_link) , "channel") === false)
                    $youtube_name = substr(@parse_url($channel_link, PHP_URL_PATH), 6);
                else
                    $youtube_name = substr(@parse_url($channel_link, PHP_URL_PATH), 9);
                $json = @noo_remote_get("http://gdata.youtube.com/feeds/api/users".$youtube_link['path']."?alt=json");
                $data = json_decode($json, true); 
                //$data = @json_decode(noo_remote_get("http://graph.facebook.com/".$youtube_link));
                $subs = $data['entry']['yt$statistics']['subscriberCount']; 
            } catch (Exception $e) {
                $subs = 0;
            }
            
            if( !empty($subs) ){
                set_transient( 'youtube_count' , $subs , 1200);
                if( get_option( 'youtube_count') != $subs )
                    update_option( 'youtube_count' , $subs );
            }
                
            if( $subs == 0 && get_option( 'youtube_count') )
                $subs = get_option( 'youtube_count');
                    
            elseif( $subs == 0 && !get_option( 'youtube_count') )
                $subs = 0;
        }
        return $subs;
    }
}


function noo_vimeo_count( $page_link ) {
	$vimeo_link = @parse_url($page_link);
	if( $vimeo_link['host'] == 'www.vimeo.com' || $vimeo_link['host']  == 'vimeo.com' ){
        // echo( $vimeo_link);return;
		$vimeo = get_transient('vimeo_count');
		if( empty( $vimeo ) ){
			try {
				$page_name = substr(@parse_url($page_link, PHP_URL_PATH), 10);
                $json = @noo_remote_get( 'http://vimeo.com/api/v2/channel/' . $page_name  .'/info.json');
				$data = json_decode($json, true); 
			
				$vimeo = isset($data->total_subscribers) ? $data->total_subscribers : 0;
			} catch (Exception $e) {
				$vimeo = 0;
			}

			if( !empty($vimeo) ){
				set_transient( 'vimeo_count' , $vimeo , 1200);
				if( get_option( 'vimeo_count') != $vimeo )
					update_option( 'vimeo_count' , $vimeo );
			}
				
			if( $vimeo == 0 && get_option( 'vimeo_count') )
				$vimeo = get_option( 'vimeo_count');
			elseif( $vimeo == 0 && !get_option( 'vimeo_count') )
				$vimeo = 0;
		}
		return $vimeo;
	}
}

function noo_dribbble_count( $page_link ) {
	$dribbble_link = @parse_url($page_link);

	if( $dribbble_link['host'] == 'www.dribbble.com' || $dribbble_link['host']  == 'dribbble.com' ){
		$dribbble = get_transient('dribbble_count');
		if( empty( $dribbble ) ){
			try {
				$page_name = substr(@parse_url($page_link, PHP_URL_PATH), 1);
				@$data = @json_decode(noo_remote_get( 'http://api.dribbble.com/' . $page_name));
					
				$dribbble = isset($data->followers_count) ? $data->followers_count : 0;
			} catch (Exception $e) {
				$dribbble = 0;
			}

			if( !empty($dribbble) ){
				set_transient( 'dribbble_count' , $dribbble , 1200);
				if( get_option( 'dribbble_count') != $dribbble )
					update_option( 'dribbble_count' , $dribbble );
			}

			if( $dribbble == 0 && get_option( 'dribbble_count') )
				$dribbble = get_option( 'dribbble_count');
			elseif( $dribbble == 0 && !get_option( 'dribbble_count') )
			$dribbble = 0;
		}
		return $dribbble;
	}
}

function noo_soundcloud_count( $page_link , $api ) {
	$soundcloud_link = @parse_url($page_link);
	if( $soundcloud_link['host'] == 'www.soundcloud.com' || $soundcloud_link['host']  == 'soundcloud.com' ){
		$soundcloud = get_transient('soundcloud_count');
		if( empty( $soundcloud ) ){
			try {
				$username = substr( $soundcloud_link['path'] , 1);
				$data = @json_decode(noo_remote_get("http://api.soundcloud.com/users/$username.json?consumer_key=$api") , true );
				$soundcloud = (int) $data['followers_count'];
					
			} catch (Exception $e) {
				$soundcloud = 0;
			}

			if( !empty($soundcloud) ){
				set_transient( 'soundcloud_count' , $soundcloud , 1200);
				if( get_option( 'soundcloud_count') != $soundcloud )
					update_option( 'soundcloud_count' , $soundcloud );
			}
				
			if( $soundcloud == 0 && get_option( 'soundcloud_count') )
				$soundcloud = get_option( 'soundcloud_count');
			elseif( $soundcloud == 0 && !get_option( 'soundcloud_count') )
			$soundcloud = 0;
		}
		return $soundcloud;
	}
}

//Behance Counter

function noo_behance_count( $page_link , $api ) {
	$behance_link = @parse_url($page_link);
	if( $behance_link['host'] == 'www.behance.net' || $behance_link['host']  == 'behance.net' ){
		$behance = get_transient('behance_count');
		if( empty( $behance ) ){
			try {
				$username = substr( $behance_link['path'] , 1);
				$data = @json_decode( noo_remote_get("http://www.behance.net/v2/users/$username?api_key=$api") , true );
				@$behance = (int) $data['user']['stats']['followers'];
			} catch (Exception $e) {
				$behance = 0;
			}

			if( !empty($behance) ){
				set_transient( 'behance_count' , $behance , 1200);
				if( get_option( 'behance_count') != $behance )
					update_option( 'behance_count' , $behance );
			}
				
			if( $behance == 0 && get_option( 'behance_count') )
				$behance = get_option( 'behance_count');
			elseif( $behance == 0 && !get_option( 'behance_count') )
			$behance = 0;
		}
		return $behance;
	}
}

// Instagram Counter

function noo_instagram_count( $page_link , $api='' ) {
	$instagram_link = @parse_url($page_link);
	if( $instagram_link['host'] == 'www.instagram.com' || $instagram_link['host']  == 'instagram.com' ){
		$instagram = get_transient('instagram_count');
		if( empty( $instagram ) ){
			try {
				$username = explode(".", $api);
				$data = @json_decode( noo_remote_get("https://api.instagram.com/v1/users/$username[0]/?access_token=$api") , true );
				$instagram = (int) $data['data']['counts']['followed_by'];
					
			} catch (Exception $e) {
				$instagram = 0;
			}

			if( !empty($instagram) ){
				set_transient( 'instagram_count' , $instagram , 1200);
				if( get_option( 'instagram_count') != $instagram )
					update_option( 'instagram_count' , $instagram );
			}
				
			if( $instagram == 0 && get_option( 'instagram_count') )
				$instagram = get_option( 'instagram_count');
			elseif( $instagram == 0 && !get_option( 'instagram_count') )
			$instagram = 0;
		}
		return $instagram;
	}
}

// Count number of like on face

function noo_fb_count( $url_or_id ) {
    /* url or id (for optional validation) */
    if( is_int( $url_or_id ) ) $url = 'http://graph.facebook.com/' . $url_or_id;
    else $url = 'http://graph.facebook.com/' .  $url_or_id;
 
    /* get json */
    $json = json_decode( file_get_contents( $url ), false );
 
    /* has likes or shares? */
    if( isset( $json->likes ) ) return (int) $json->likes;
    elseif( isset( $json->shares ) ) return (int) $json->shares;
 
    return 0; // otherwise zed
}
// Twitter Count URL in Tweets
function noo_twitter_count( $url ) {
    /* build the pull URL */
    $url = 'http://cdn.api.twitter.com/1/urls/count.json?url=' . urlencode( $url );
  
    /* get json */
    $json = json_decode( file_get_contents( $url ), false );
    if( isset( $json->count ) ) return (int) $json->count;
  
    return 0; // else zed
}

//Google Plus +1′s Count
function noo_gplus_count( $url ) {
    /* get source for custom +1 button */
    $contents = file_get_contents( 'https://plusone.google.com/_/+1/fastbutton?url=' .  $url );
 
    /* pull out count variable with regex */
    preg_match( '/window\.__SSR = {c: ([\d]+)/', $contents, $matches );
 
    /* if matched, return count, else zed */
    if( isset( $matches[0] ) ) 
        return (int) str_replace( 'window.__SSR = {c: ', '', $matches[0] );
    return 0;
}

//LinkedIn Counter

function noo_linkedin_count( $url ) {
    /* get source for custom +1 button */
    $contents = file_get_contents( 'http://www.linkedin.com/countserv/count/share?url==' .  $url );
 
    /* pull out count variable with regex */
    preg_match( '/window\.__SSR = {c: ([\d]+)/', $contents, $matches );
 
    /* if matched, return count, else zed */
    if( isset( $matches[0] ) ) 
        return (int) str_replace( 'window.__SSR = {c: ', '', $matches[0] );
    return 0;
}

//Pinterest Counter function

function noo_pinterest_count( $url ) {
    /* get source for custom +1 button */
    $contents = file_get_contents( 'http://api.pinterest.com/v1/urls/count.json?callback=&url==' .  $url );

    /* pull out count variable with regex */
    preg_match( '/window\.__SSR = {c: ([\d]+)/', $contents, $matches );

    /* if matched, return count, else zed */
    if( isset( $matches[0] ) )
        return (int) str_replace( 'window.__SSR = {c: ', '', $matches[0] );
    return 0;
}

// Get featured post on list blog

function noo_post_featured_slider(){
    wp_enqueue_script('nooCarouFredSel');
    $args = array(
        'meta_key' => '_noo_feature',
        'meta_value' => '1',
        'posts_per_page' => noo_get_option('noo_blog_number_featured',4),
        'post_type'=>'post',
        'ignore_sticky_posts' => 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );
    $r = new WP_Query($args);
    if($r->have_posts()):
    ?>
    <div class="row">
        <div class="featured-slider bottom-indicators" id="noo-featured-slider">
            <div class="featured-slider-wrap">
                <ul class="featured-slides">
                    <?php while ($r->have_posts()):$r->the_post();?>
                        <li class="col-md-12 featured-slide-item">
                            <div class="featured-slide-item-wrap">
                                <?php if(has_post_thumbnail()):?>
                                <div class="featured-slide-thumbnail">
                                    <?php the_post_thumbnail('large')?>
                                </div>
                                <?php endif;?>
                                <div class="featured-slide-item-info">
                                    <h3><a href="<?php the_permalink()?>"><?php the_title()?></a></h3>
                                    <?php noo_content_meta()?>
                                    
                                </div>
                            </div>
                        </li>
                    <?php endwhile;?>
                </ul>
            </div>
            <div id="noo-featured-slider-pagination" class="slider-indicators"></div>
            
        </div>
    </div>
    <script type="text/javascript">
        jQuery(document).ready(function() {
            jQuery('.featured-slider').each(function(){
                var $this = jQuery(this);
                var recentCarouselOptions = {
                    responsive: true,
                    circular: true,
                    infinite:true,
            //              width: '100%',
            //              height: 'auto',
                    auto: {
                        play : false,
                        pauseOnHover: true
                    },
                    prev: $this.find('.caroufredsel-prev'),
                    next: $this.find('.caroufredsel-next'),
                    mousewheel: true,
                    swipe: {
                        onMouse: true,
                        onTouch: true
                    },
                    scroll: {
                        items: null,
                        duration: 600,
                        fx: 'scroll',
                        timeoutDuration: 2000,
                        easing: 'swing'
                    },
                    items: {
                        height:'variable',
                        //  height: '30%',  //  optionally resize item-height
                        visible: {
                            min: 1,
                            max: 1
                        }
                    },
                    pagination: {
                      container: "#noo-featured-slider-pagination"
                    },
                };
                $this.find('ul').carouFredSel(recentCarouselOptions);
                imagesLoaded($this,function(){
                    $this.find('ul').trigger('updateSizes');
                });
                jQuery(window).resize(function(){
                    $this.find('ul').trigger("destroy").carouFredSel(recentCarouselOptions);
                });
            });
        });
    </script>
    <?php
    endif;
    wp_reset_postdata();
}

function noo_top_news_tabs(){
    wp_enqueue_script('noo-carousel');
    $limit = noo_get_option('noo_top_bar_dropdown_limit_items',12);
    ?>
    <div class="noo-top-news-tab widget">
        <div class="widget-tabs-header">
            <h6 data-option-value='noo_topview'>
               <span>
                    <?php _e('Trending', 'noo') ?>
                </span>
            </h6>
            <h6 data-option-value='noo_recent' class="noo_widgetab">
                <span>
                    <?php _e('Recent', 'noo') ?>
                </span>
            </h6>
            <h6 data-option-value='noo_comment' class="noo_widgetab">
                <span>
                    <?php _e('Featured', 'noo') ?>
                </span>
            </h6>
        </div>
    <div class="widget_tabs_content">
        <div class="noo-tabcat-content1">
            <div class="noo_topview noo_widget_content">
            <div class="featured-sliders">
                <ul class="featured-top-sliders">
                    <?php
                        $args = array(
                            'posts_per_page' => $limit,
                            'meta_key'       => 'post_count_indate',
                            'orderby'        => 'meta_value_num',
                            'order'          => 'DESC',
                            'tax_query'      => array(
                                array(
                                    'taxonomy' => 'post_format',
                                    'field'    => 'slug',
                                    'terms' => array(
                                        'post-format-aside',
                                        'post-format-chat',
                                        'post-format-audio',
                                        'post-format-link',
                                        'post-format-quote',
                                        'post-format-status'
                                    ),
                                    'operator' => 'NOT IN'
                                )
                            )
                        );
                        $top_query = new WP_Query( $args );
                        if ( $top_query -> have_posts() ):
                            while( $top_query -> have_posts() ): $top_query -> the_post();
                                $category = get_the_category();
                    ?>
                    <li>
                        <?php the_post_thumbnail('medium') ?>
                        <div class="noo_tb">
                            <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                        </div>
                    </li>

                    <?php
                            endwhile;
                        endif;
                        wp_reset_postdata();
                    ?>
                </ul>
                </div>
            </div>
            <div class="noo_recent noo_widget_content ">
            <div class="featured-sliders">
                <ul class="featured-top-sliders">
                    <?php
                        $args = array(
                            'posts_per_page' => $limit,
                            'orderby'        => 'date',
                            'order'          => 'DESC',
                            'tax_query'      => array(
                                array(
                                    'taxonomy' => 'post_format',
                                    'field'    => 'slug',
                                    'terms' => array(
                                        'post-format-aside',
                                        'post-format-chat',
                                        'post-format-audio',
                                        'post-format-link',
                                        'post-format-quote',
                                        'post-format-status'
                                    ),
                                    'operator' => 'NOT IN'
                                )
                            )
                        );
                        $top_query = new WP_Query( $args );
                        if ( $top_query -> have_posts() ):
                            while( $top_query -> have_posts() ): $top_query -> the_post();
                                $category = get_the_category();
                    ?>
                    <li>
                        <?php the_post_thumbnail('') ?>
                        <div class="noo_tb">
                            <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                        </div>
                    </li>

                    <?php
                            endwhile;
                        endif;
                        wp_reset_postdata();
                    ?>
                </ul> 
                </div>
            </div>
            <div class="noo_comment noo_widget_content">
            <div class="featured-sliders">
                <ul class="featured-top-sliders">
                    <?php
                        $args = array(
                            'posts_per_page' => $limit,
                            'meta_key' => '_noo_feature',
                            'meta_value'        => '1',
                            'orderby'        => 'date',
                            'order'          => 'DESC',
                            'tax_query'      => array(
                                array(
                                    'taxonomy' => 'post_format',
                                    'field'    => 'slug',
                                    'terms' => array(
                                        'post-format-aside',
                                        'post-format-chat',
                                        'post-format-audio',
                                        'post-format-link',
                                        'post-format-quote',
                                        'post-format-status'
                                    ),
                                    'operator' => 'NOT IN'
                                )
                            )
                        );
                        $top_query = new WP_Query( $args );
                        if ( $top_query -> have_posts() ):
                            while( $top_query -> have_posts() ): $top_query -> the_post();
                                $category = get_the_category();
                    ?>
                    <li>
                        <?php the_post_thumbnail('medium') ?>
                        <div class="noo_tb">
                            <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                        </div>
                    </li>

                    <?php
                            endwhile;
                        endif;
                        wp_reset_postdata();
                    ?>
                </ul>   
                </div>
            </div>
        </div>
    </div>
    <script>

        jQuery(document).ready(function(){
            "use strict";
            jQuery('.noo-top-news-tab ').each(function(){
                jQuery(this).find('.noo_widget_content:first').show();
                jQuery(this).find('.widget-tabs-header h6:first').addClass('tab-active');
            });

            jQuery('.widget-tabs-header h6').click(function(){
                jQuery(this).parent().find('h6').removeClass('tab-active');
                jQuery(this).addClass('tab-active');
                var $id = jQuery(this).attr('data-option-value');
                jQuery(this).parent().parent().find('.noo_widget_content').fadeOut(0);
                jQuery('.'+$id).fadeIn(0);


            }) ;

            jQuery('.featured-top-sliders').each(function(){
                jQuery(this).owlCarousel({
                    items : <?php echo noo_get_option('noo_top_bar_dropdown_columns', 6);?>,
                    itemsDesktop : [1199,4],
                    itemsDesktopSmall : [991,3],
                    itemsTablet: [768, 2],
                    slideSpeed:500,
                    paginationSpeed:800,
                    rewindSpeed:1000,
                    autoHeight: false,
                    loop:true,
                    pagination:false
                });

            }) ;
        });
        jQuery(window).load(function(){
            var $height_slider = jQuery('.noo-top-news-tab').innerHeight();
            var $top_control = true;
            jQuery('.noo_top_news').click(function(){
                if($top_control==true){
                    jQuery('.noo-top-featured').css({
                        height: $height_slider+'px'
                    });
                    jQuery('.noo_top_news').addClass('up');
                    $top_control = false;
                }else{
                    jQuery('.noo-top-featured').css('height',0);
                    jQuery('.noo_top_news').removeClass('up');
                    $top_control = true;
                }

            });
        });
    </script>
</div>
<?php
}

function is_locked_post( $post_id = null, $strictly = false ) {
    if( !class_exists('Noo_Subscribe') ) return false;

    if( empty( $post_id ) ) $post_id = get_the_ID();

    $locked = Noo_Subscribe::is_locked_post( $post_id );

    if( $strictly ) return $locked;

    return $locked && !Noo_Subscribe::can_read_locked_post();
}

function locked_post_content( $post_id = '' ) {
    if( !class_exists('Noo_Subscribe') ) return '';
    return Noo_Subscribe::locked_post_content( $post_id );
}

function locked_post_excerpt( $text = '', $excerpt = '' ) {
    if( !class_exists('Noo_Subscribe') ) return '';
    return Noo_Subscribe::locked_post_excerpt( $text, $excerpt );
}

function is_subscribed( $user_id = '' ) {
    if( !class_exists('Noo_Subscribe') ) return false;
    return Noo_Subscribe::is_subscribed( $user_id );
}

function is_trial( $user_id = '' ) {
    if( !class_exists('Noo_Subscribe') ) return false;
    return Noo_Subscribe::is_trial( $user_id );
}