// File inputs
jQuery( function ( $ ) {
	$('.noo-song-meta-box').on('click','a.insert',function(){
		$(this).closest('.noo-song-meta-box').find('tbody').append( $(this).data( 'row' ) );
		return false;
	});
	$('.noo-song-meta-box').on('click','a.delete',function(){
		$(this).closest('tr').remove();
		return false;
	});
	$('.noo-song-meta-box tbody').sortable({
		items:'tr',
		cursor:'move',
		axis:'y',
		handle: 'td.sort',
		scrollSensitivity:40,
		forcePlaceholderSize: true,
		helper: 'clone',
		opacity: 0.65,
	});
	
	// Uploading files
	var noo_song_file_frame;
	var song_path_field;

	jQuery(document).on( 'click', '.upload_song_button', function( event ){

		var $el = $(this);

		song_path_field = $el.closest('tr').find('td.file_url input');

		event.preventDefault();

		// If the media frame already exists, reopen it.
		if ( noo_song_file_frame ) {
			noo_song_file_frame.open();
			return;
		}

		var song_file_states = [
			// Main states.
			new wp.media.controller.Library({
				library:   wp.media.query(),
				multiple:  false,
				title:     $el.data('choose'),
				priority:  20,
				filterable: 'uploaded',
			})
		];

		// Create the media frame.
		noo_song_file_frame = wp.media.frames.song_file = wp.media({
			// Set the title of the modal.
			title: $el.data('choose'),
			library: { type: 'audio' },
			button: {
				text: $el.data('update'),
			},
			multiple: false
		});

		// When an image is selected, run a callback.
		noo_song_file_frame.on( 'select', function() {

			var file_path = '';
			var selection = noo_song_file_frame.state().get('selection');

			selection.map( function( attachment ) {

				attachment = attachment.toJSON();

				if ( attachment.url )
					file_path = attachment.url

			} );

			song_path_field.val( file_path );
		});

		// Finally, open the modal.
		noo_song_file_frame.open();
	});

	
});