(function ($) {
    'use strict';

    if (typeof wp === 'undefined' || !wp.customize || typeof nooCustomizer === 'undefined') {
        return;
    }

    /* ------------------------------------
     * Post type refresh helpers
     * ------------------------------------ */
    if (Array.isArray(nooCustomizer.postTypes)) {
        nooCustomizer.postTypes.forEach(function (postType) {

            window['noo_refresh_preview_' + postType + '_archive'] = function () {
                if (nooCustomizer.l10n['is_' + postType + '_archive'] === "true") {
                    window.noo_refresh_preview();
                } else {
                    window.noo_redirect_preview(postType + '_archive');
                }
            };

            window['noo_refresh_preview_' + postType + '_single'] = function () {
                if (nooCustomizer.l10n['is_' + postType + '_single'] === "true") {
                    window.noo_refresh_preview();
                } else {
                    window.noo_redirect_preview(postType + '_single');
                }
            };

        });
    }

    /* ------------------------------------
     * Customizer bindings
     * ------------------------------------ */
    Object.keys(nooCustomizer.settings || {}).forEach(function (settingId) {

        var config = nooCustomizer.settings[settingId];

        wp.customize(settingId, function (value) {
            value.bind(function () {

                switch (config.preview_type) {

                    case 'none':
                        if (typeof window.showCannotPreviewMsg === 'function') {
                            window.showCannotPreviewMsg();
                        }
                        break;

                    case 'update_css':
                        if (config.preview_params && config.preview_params.css) {
                            window.noo_update_customizer_css(
                                config.preview_params.css
                            );
                        }
                        break;

                    default:
                        window.noo_refresh_preview();
                }
            });
        });

    });

})(jQuery);
