<?php
if(noo_get_option( 'noo_site_link_hover_color') != '#d91f26'  && noo_get_option( 'noo_site_link_hover_color') != ''):
// Variables
$default_link_color = noo_get_theme_default( 'text_color' );

$noo_site_link_color = $default_link_color;
$noo_site_link_hover_color = noo_get_option( 'noo_site_link_hover_color', noo_get_theme_default( 'primary_color' ) );
$noo_site_link_color_lighten_10 = lighten( $noo_site_link_hover_color, '10%' );
$noo_site_link_color_darken_5   = darken( $noo_site_link_hover_color, '5%' );
$noo_site_link_color_darken_15   = darken( $noo_site_link_hover_color, '15%' );
$noo_site_link_color_darken_10   = darken( $noo_site_link_hover_color, '10%' );
$noo_site_link_color_fade_50   = fade( $noo_site_link_hover_color, '50%' );
$noo_site_link_color_fade_10   = fade( $noo_site_link_hover_color, '10%' );
$noo_site_link_color_fade_80   = fade( $noo_site_link_hover_color, '80%' );

$default_font_color = noo_get_theme_default( 'text_color' );
$default_headings_color = noo_get_theme_default( 'headings_color' );

$noo_typo_use_custom_fonts_color = noo_get_option( 'noo_typo_use_custom_fonts_color', false );
$noo_typo_body_font_color = $noo_typo_use_custom_fonts_color ? noo_get_option( 'noo_typo_body_font_color', $default_font_color ) : $default_font_color;
$noo_typo_headings_font_color = $noo_typo_use_custom_fonts_color ? noo_get_option( 'noo_typo_headings_font_color', $default_headings_color ) : $default_headings_color; 

$noo_header_custom_nav_font = noo_get_option( 'noo_header_custom_nav_font', false );
$noo_header_nav_link_color = $noo_header_custom_nav_font ? noo_get_option( 'noo_header_nav_link_color', $noo_site_link_color ) : $noo_site_link_color;
$noo_header_nav_link_color_light = $noo_header_custom_nav_font ? noo_get_option( 'noo_header_nav_link_color', $noo_site_link_color ) : '#000';
$noo_header_nav_link_hover_color = $noo_header_custom_nav_font ? noo_get_option( 'noo_header_nav_link_hover_color', $noo_site_link_hover_color ) : $noo_site_link_hover_color;

?>

body {
	color: <?php echo esc_html($noo_typo_body_font_color); ?>;
}


h1:hover a, h2:hover a, h3:hover a, h4:hover a, h5:hover a, h6:hover a,
body.theme-light h1:hover a,
body.theme-light h2:hover a,
body.theme-light h3:hover a,
body.theme-light h4:hover a,
body.theme-light h5:hover a,
body.theme-light h6:hover a,
body.theme-light .h1:hover a,
body.theme-light .h2:hover a,
body.theme-light .h3:hover a,
body.theme-light .h4:hover a,
body.theme-light .h5:hover a,
body.theme-light .h6:hover a,
body.theme-light .navbar-nav .sub-menu li.current-menu-item > a,
.footer-player .album-player-embed .mejs-container .mejs-controls .mejs-navigation-controls .mejs-button i:hover,
.footer-player .album-player-embed .mejs-container .mejs-controls .mejs-left-controls .mejs-queue .fa:hover,
.footer-player .album-player-embed .mejs-container .mejs-controls .mejs-left-controls .mejs-queue.queue-active .fa,
.footer-player .album-player-embed .mejs-container .mejs-controls .mejs-button button:hover:before,
body.theme-light #tribe-events-content ul.tribe-events-sub-nav a:hover,
.noo-featured-albums .sh-featured-albumns-item .shop-info .product-category:hover a,
.noo-featured-albums .sh-featured-albumns-item .sh-top .product-category:hover a,
.single-tribe_events #tribe-events-content form.cart .woo-ticket-list:hover .tickets_name span
{
color: <?php echo esc_html($noo_site_link_hover_color); ?> !important;
}

h1 a:hover, h2 a:hover, h3 a:hover, h4 a:hover, h5 a:hover, h6 a:hover,
.h1 a:hover, .h2 a:hover, .h3 a:hover, .h4 a:hover, .h5 a:hover, .h6 a:hover,
.tribe-events-photo-event .entry-title a:hover,
.sidebar-event .widget_calendar #wp-calendar > tbody > tr > td#today,
.sidebar-event .widget_calendar #wp-calendar > thead > tr > th{
	color: <?php echo esc_html($noo_site_link_hover_color); ?>;
}

/* Global Link */
/* ====================== */

a:hover,
a:focus,
.text-primary,
a.text-primary:hover,
ol,
.noo-page-heading .noo-page-breadcrumb ul li a:hover,
.similar_title span{
	color: <?php echo esc_html($noo_site_link_hover_color); ?>;
}

.bg-primary,
.btn-default:hover,
.btn:hover,
.btn:focus{
	background-color: <?php echo esc_html($noo_site_link_hover_color); ?>;
	border-color: <?php echo esc_html($noo_site_link_hover_color); ?>;
}
a.bg-primary:hover {
	background-color: <?php echo esc_html($noo_site_link_color_darken_15); ?>;
}
.bg-primary-overlay {
  background: <?php echo fade($noo_site_link_hover_color, '90%'); ?>;
}

/* Navigation Color */
/* ====================== */

/* Default menu style */
.noo-menu li > a {
	color: <?php echo esc_html($noo_header_nav_link_color); ?>;
}
.noo-menu li > a:hover,
.noo-menu li > a:active,
.noo-menu li.current-menu-item > a {
	color: <?php echo esc_html($noo_header_nav_link_hover_color); ?>;
}

/* NavBar: Link */
body .navbar-nav li > a {
	color: <?php echo esc_html($noo_header_nav_link_color); ?>;
}
body.theme-light .navbar-nav li > a {
	color: <?php echo esc_html($noo_header_nav_link_color_light); ?>;
}

body.page-menu-transparent .navbar:not(.navbar-fixed-top) .navbar-nav > li > a:hover,
.navbar-nav li > a:hover,
.navbar-nav li > a:focus,
.navbar-nav li:hover > a,
.navbar-nav li.sfHover > a,
body .navbar-nav li.current-menu-item > a,
body .navbar-nav > li > a:hover:before,
body .navbar-nav > li > a:focus:before{
	background-color: <?php echo esc_html($noo_header_nav_link_hover_color); ?>;
    border-color: <?php echo esc_html($noo_header_nav_link_hover_color); ?>;
}

/* Border color */
@media (min-width: 992px) {
	.navbar-default .navbar-nav.sf-menu > li > ul.sub-menu {
		border-top-color: <?php echo esc_html($noo_site_link_hover_color); ?>;
	}
	.navbar-default .navbar-nav.sf-menu > li > ul.sub-menu:before,
	.navbar-nav.sf-menu > li.align-center > ul.sub-menu:before,
	.navbar-nav.sf-menu > li.align-right > ul.sub-menu:before,
	.navbar-nav.sf-menu > li.align-left > ul.sub-menu:before,
	.navbar-nav.sf-menu > li.full-width.sfHover > a:before {
		border-bottom-color: <?php echo esc_html($noo_site_link_hover_color); ?>;
	}
}

/* Dropdown Color */
.navbar-nav ul.sub-menu li > a:hover,
.navbar-nav ul.sub-menu li > a:focus,
.navbar-nav ul.sub-menu li:hover > a,
.navbar-nav ul.sub-menu li.sfHover > a,
.navbar-nav ul.sub-menu li.current-menu-item > a
{
	color: <?php echo esc_html($noo_header_nav_link_hover_color); ?>;
}



/* Other Text/Link Color */
/* ====================== */


.loadmore-loading span,
{
    background: <?php echo esc_html($noo_site_link_hover_color); ?>;
}

/* WordPress Element */
/* ====================== */

/* Comment */
h2.comments-title span,
.comment-author a:hover {
	color: <?php echo esc_html($noo_site_link_hover_color); ?>;
}

/*List Posts*/
.noo-slider .slider-control {
	background: <?php echo esc_html($noo_site_link_hover_color); ?>;
}
.standard-blog .rated_count {
	background: <?php echo esc_html($noo_site_link_color_fade_50); ?>;
}

/* Post */


/*Button Loadmore*/

#loader:before, #loader:after {
	background: <?php echo esc_html($noo_site_link_hover_color); ?>;
}

@keyframes preload_audio_wave {
	0% {height:5px;transform:translateY(0px);background:<?php echo esc_html($noo_site_link_hover_color); ?>;}
	25% {height:30px;transform:translateY(15px);background:<?php echo esc_html($noo_site_link_hover_color); ?>;}
	50% {height:5px;transform:translateY(0px);background:<?php echo esc_html($noo_site_link_hover_color); ?>;}
	100% {height:5px;transform:translateY(0px);background:<?php echo esc_html($noo_site_link_hover_color); ?>;}
}
@-webkit-keyframes preload_audio_wave {
    0% {height:5px;-webkit-transform:translateY(0px);background:<?php echo esc_html($noo_site_link_hover_color); ?>;}
    25% {height:30px;-webkit-transform:translateY(15px);background:<?php echo esc_html($noo_site_link_hover_color); ?>;}
    50% {height:5px;-webkit-transform:translateY(0px);background:<?php echo esc_html($noo_site_link_hover_color); ?>;}
    100% {height:5px;-webkit-transform:translateY(0px);background:<?php echo esc_html($noo_site_link_hover_color); ?>;}
}

@-moz-keyframes preload_audio_wave {
    0% {height:5px;-moz-transform:translateY(0px);background:<?php echo esc_html($noo_site_link_hover_color); ?>;}
    25% {height:30px;-moz-transform:translateY(15px);background:<?php echo esc_html($noo_site_link_hover_color); ?>;}
    50% {height:5px;-moz-transform:translateY(0px);background:<?php echo esc_html($noo_site_link_hover_color); ?>;}
    100% {height:5px;-moz-transform:translateY(0px);background:<?php echo esc_html($noo_site_link_hover_color); ?>;}
}

@keyframes preload_audio_wave {
    0% {height:5px;transform:translateY(0px);background:<?php echo esc_html($noo_site_link_hover_color); ?>;}
    25% {height:30px;transform:translateY(15px);background:<?php echo esc_html($noo_site_link_hover_color); ?>;}
    50% {height:5px;transform:translateY(0px);background:<?php echo esc_html($noo_site_link_hover_color); ?>;}
    100% {height:5px;transform:translateY(0px);background:<?php echo esc_html($noo_site_link_hover_color); ?>;}
}


.btn-primary, 
.widget_newsletterwidget .newsletter-submit,
.button:hover, .button:focus,
body.theme-light .noo-tribe-fullname .add-to-cart button:hover,
.noo-tribe-fullname .add-to-cart button:hover
{
background: <?php echo esc_html($noo_site_link_hover_color); ?>;
border-bottom-color: <?php echo esc_html($noo_site_link_color_darken_10); ?>;
}

/*Link color*/
.noo-menu-item-cart .noo-minicart .minicart-body .cart-product .cart-product-details .cart-product-title a:hover,
.sh-event-title span,
.noo-sh-grid-event .noo-shevent-content .sh-date i,
.noo-sh-grid-event .noo-shevent-content .sh-time-event i,
.wigetized .widget ul li a:hover,
.wigetized .widget ol li a:hover,
.wigetized .noo-footer-bottom .widget ul.noo-infomation li span.fa,
.wigetized .widget a:hover,
.woocommerce .star-rating span,
.noo-sh-grid-event .noo-shevent-content .sh-address i,
.woocommerce .star-rating span:before,
ul.contact-info li span,
.sidebar-event .noo_request_information .icon-request,
.standard-blog .content-meta a:hover,
#author-bio .author-info h5 a,
.noo-sh-list-event .noo-shevent-content .sh-date i,
.noo-smart-content div.product .album-intro .album-intro-wrap .album-media-player .album-playlist ul li.current-playing a i,
.noo-smart-content div.product .meta-summary > div,
.noo-smart-content div.product .related h2 span,
.noo_team_item .team_thumbnail .team-info .team_position,
.noo-sh-list-event .noo-shevent-content .sh-address i,
.content-meta > span > a:hover,
.widget ul li a:hover, .widget ol li a:hover,
.masonry-blog .masonry-item .item-content-meta a:hover,
.widget_recent_news ul li span.post-comment a:hover,
.widget_categories ul li:hover a,
#tribe-events-content .tribe-events-tooltip h4,
#tribe-events-content ul.tribe-events-sub-nav a:hover,
h2.tribe-events-page-title a:hover,
.noo-single-event-content .tribe-events-schedule .sh-time-event i,
.noo-single-event-content .tribe-events-schedule .sh-address i,
.comment-author,
.single .noo_album .album-intro .album-intro-wrap .album-media-player .single-album-playlist ul li a:hover .fa,
.single .noo_album .album-summary .meta-summary > div,
.woocommerce div.product .entry-summary div[itemprop='offers'] .price span,
.woocommerce table.cart a.remove,
.woocommerce .cart-collaterals .cart_totals table tr td .shipping-calculator-button,
.woocommerce-page .cart-collaterals .cart_totals table tr td .shipping-calculator-button,
.woocommerce form .form-row .required,
.order_review_wrap #order_review table.shop_table tfoot td strong,
.tribe-events-list .tribe-events-loop .noo-tribe-events-image .tribe-events-event-meta.vcard .time-details .fa,
.woocommerce ul.products li.product figcaption h3.product_title a:hover,
.breadcrumb-wrap i,
.single .noo_album .album-intro .album-intro-wrap .album-media-player .single-album-playlist ul li.current-playing a .fa,
body.theme-light .navbar .navbar-nav.sf-menu > li ul.sub-menu li a:hover,
.footer-player .album-player-embed .mejs-container .mejs-controls .mejs-playpause-button i.fa,
.tribe-events-day .tribe-events-day-time-slot h5,
#tribe-events-content ul.tribe-events-sub-nav a,
body.theme-light .widget .entry-title a:hover,
body.theme-light #tribe-events-content form.cart .woo-ticket-list:hover .tickets_name span,
body.theme-light .myaccount_user a,
body.theme-light .noo-category a:hover
{
color: <?php echo esc_html($noo_site_link_hover_color); ?>;
}

/*Background color*/

.noo-countdown .noo-countdown-footer span a,
.noo-view-event a:hover,
.noo_news_blog li .noo-sh-blog-content .read-more:hover,
.wpcf7-form .wpcf7-submit,
.read-more:hover, .read-more:focus,
.read-more:active,
.read-more.active,
.open > .dropdown-toggle.read-more,
.entry-tags a:hover,
.noo_news_blog li:hover .noo-sh-blog-content .read-more,
.noo-smart-content div.product .entry-summary .cart .button,
.noo-smart-content div.product .product-tag a:hover,
.noo-grid-header-events .icon,
.noo-sh-list-event .noo-thumbnail .entry-date,
.events-list .tribe-events-loop .type-tribe_events .tribe-events-read-more:hover,
.tribe-events-day .tribe-events-loop .type-tribe_events .tribe-events-read-more:hover,
.widget.widget-counter.col3 .counter-social-widget ul li a:hover, 
.widget.widget-counter.col3 .counter-social-widget ul li a:focus,
.widget_tag_cloud .tagcloud a:hover, 
.widget_product_tag_cloud .tagcloud a:hover,
.woocommerce div#payment input#place_order,
.sidebar-event .noo_request_information .request:hover,
.noo-single-event-content .entry-date,
.comment-reply-link:hover,
.noo_albums li .noo_album-container figure figcaption .noo_album-loop-actions a:hover,
.single .noo_album .album-intro .album-intro-wrap .album-purchase a:hover,
.single .noo_album .album-summary .entry-summary .album-tag a:hover,
.woocommerce ul.products li.product figure figcaption .shop-loop-actions .button:hover,
.woocommerce ul.products li.product figure figcaption .shop-loop-actions .button:focus,
.wpcf7-form .wpcf7-submit:focus,
.wpcf7-form .wpcf7-submit:active:focus,
.wpcf7-form .wpcf7-submit.active:focus,
.tribe-events-list .tribe-events-loop .type-tribe_events .tribe-events-read-more:hover,
.widget.widget-counter.col3 .counter-social-widget ul li a:focus,
.widget.widget-counter.col3 .counter-social-widget ul li a:active:focus,
.widget.widget-counter.col3 .counter-social-widget ul li a.active:focus,
.noo-sh-list-event .entry-date,
.noo-featured-albums figure figcaption .shop-loop-actions .button:hover,
.noo-featured-albums .sh-featured-albumns-item .shop-loop-actions .button:hover,
body.theme-light #commentform .form-submit input[type="submit"]:hover,
.single-tribe_events #tribe-events-content form.cart .woo-ticket-button .button:hover,
.tp-caption a.button-revolution,
body.theme-light.woocommerce-account input[name='save_account_details']:hover,
body.theme-light .order_review_wrap #payment #place_order,
body.theme-light .order_review_wrap #payment #place_order:hover,
body.theme-light .woocommerce .login .form-row .button:hover,
body.theme-light .woocommerce .checkout_coupon .form-row .button:hover,
body.theme-light .woocommerce #customer_login .form-row .button:hover,
.albums-masonry .loadmore-action .btn-loadmore:hover,
body.theme-light .albums-masonry .loadmore-action .btn-loadmore:hover,
.woocommerce-checkout .woocommerce .login .form-row .button:hover,
body.theme-light .woocommerce-checkout .woocommerce .login .form-row .button:hover
{
background: <?php echo esc_html($noo_site_link_hover_color); ?>;
border-color: <?php echo esc_html($noo_site_link_color_darken_10); ?>;
}
.noo-menu-item-cart .noo-minicart .minicart-footer .minicart-actions .button.checkout-button,
.single-product div.product form.cart .button:hover,
.woocommerce table.cart a.remove:hover,
.woocommerce-cart table.shop_table .actions input.button:hover,
.woocommerce-cart table.shop_table .actions input.button:hover,
.woocommerce .woocommerce-error .button:hover,
.woocommerce .woocommerce-info .button:hover,
.woocommerce .woocommerce-message .button:hover,
.woocommerce .cart-collaterals .cart_totals table tr td .shipping-calculator-form button:hover,
.woocommerce-page .cart-collaterals .cart_totals table tr td .shipping-calculator-form button:hover,
.single-product .woocommerce-tabs .panel #review_form #respond form #submit:hover,
.tribe-events-grid .tribe-grid-header .tribe-week-today,
.footer-player .album-player-embed .contro-album-player:hover,
.wrap .owl-theme .owl-controls .owl-page.active span,
.wrap .owl-theme .owl-controls .owl-page:hover span,
body.theme-light #tribe-events-content form.cart .woo-ticket-list:hover .quantity input,
body.theme-light .widget_tag_cloud .tagcloud a:hover,
.noo-attr-style,
body.theme-light .tribe-events-tickets-rsvp .tribe-ticket-quantity:hover,
.tribe-events-tickets-rsvp .tribe-ticket-quantity:hover,
.single-tribe_events #tribe-events-content form.cart .woo-ticket-list li .quantity input:hover
{
background: <?php echo esc_html($noo_site_link_hover_color); ?> !important;
}

/*Background color*/
.scrollbar .handle,
.noo-line .fa,
.breadcrumb > li:before,
body #tribe-events .tribe-events-button,
.post-navigation .next-post a:hover,
.woocommerce ul.products li.product figure figcaption .shop-loop-actions a:hover,
.woocommerce ul.products li.product figure figcaption .shop-loop-actions a:focus,
.noo-smart-content div.product .album-intro .album-intro-wrap .album-media-player .mejs-controls .mejs-horizontal-volume-slider .mejs-horizontal-volume-current,
.post-navigation .prev-post a:hover,
.navbar-nav li.current_page_item > a,
.is-countdown .countdown-section .countdown-period,
.mailchimp-widget .mc-subscribe-form button:hover,
.noo-smart-content div.product .album-intro .album-intro-wrap .album-media-player .mejs-controls .mejs-time-rail .mejs-time-total .mejs-time-current,
.woocommerce .cart-collaterals .cart_totals .shipping-calculator-form .button:hover,
#tribe-events-bar #tribe-bar-form .tribe-bar-submit input[type=submit],
.mailchimp-widget .mc-subscribe-form button:hover,
.woocommerce .quantity input.qty,
.single-product .woocommerce-tabs .panel #review_form #respond form #submit:hover,
.woocommerce .cart-collaterals .cart_totals .wc-proceed-to-checkout a,
.woocommerce-page .cart-collaterals .cart_totals .wc-proceed-to-checkout a,
.woocommerce-account .login .form-row .button,
.woocommerce-account .register .form-row .button,
.woocommerce .return-to-shop .wc-backward,
.breadcrumb > li:before,
.scrollbar .handle,
.noo-line .fa,
.woocommerce-account .woocommerce form .form-row .button,
body.theme-light .pagination .page-numbers.current,
body.theme-light .pagination .page-numbers:hover
{
background: <?php echo esc_html($noo_site_link_hover_color); ?>;
}

/*Border color*/
.noo-line,
.noo-smart-content div.product .entry-summary .cart .quantity .input-text,
.single-post .noo-main .hentry blockquote,
.noo-tabs-header li span.tab-active,
.albums-masonry .masonry-filters li a.selected,
.form-submit input[type="submit"]:focus,
.form-submit input[type="submit"]:active:focus,
a.read-more:focus,
a.read-more:active:focus,
a.read-more.active:focus,
body .btn:focus,
body .btn:active:focus,
.btn-primary:focus,
.btn-primary:active:focus,
.btn-primary.active:focus,
.widget_newsletterwidget .newsletter-submit:focus,
.widget_newsletterwidget .newsletter-submit:active:focus,
.widget_newsletterwidget .newsletter-submit.active:focus,
.button:focus,
.button:active:focus,
.button.active:focus,
.single .noo_album .album-intro .album-intro-wrap .album-media-player .single-album-playlist ul li a .current-active-play,
.footer-player .album-player-embed .mejs-container .mejs-controls .mejs-playpause-button
{
border-color: <?php echo esc_html($noo_site_link_hover_color); ?>;
}

.form-submit input[type="submit"]:hover,
.form-submit input[type="submit"]:focus,
.form-submit input[type="submit"]:active,
.form-submit input[type="submit"].active,
.open > .dropdown-toggle.form-submit input[type="submit"],
.noo-countdown .noo-countdown-footer a,
.events-list .tribe-events-loop .type-tribe_events .tribe-events-read-more:hover,
.pagination .page-numbers.current,
.pagination a.page-numbers:hover,
#tribe-events-content .tribe-events-photo-event-wrap .tribe-events-read-more:hover,
.btn:hover,
.btn-primary:hover,
.btn-primary:focus,
body.theme-light .loadmore-action a:hover,
body.theme-light .masonry-blog .masonry-item .read-more:hover,
body.theme-light .hentry.type-post .read-more:hover,
body.theme-light .comment-reply-link
{
background: <?php echo esc_html($noo_site_link_hover_color); ?>;
border-color: <?php echo esc_html($noo_site_link_color_darken_10); ?>;
}

.woocommerce span.onsale{
background: <?php echo esc_html($noo_site_link_color_fade_80); ?>;
}

.noo-smart-content div.product .album-intro .album-intro-wrap .album-media-player .mejs-controls .mejs-player-control .mejs-button:hover,
.widget_categories ul li:hover,
.product-masonry .masonry-filters ul li a.selected
{
border-color: <?php echo esc_html($noo_site_link_hover_color); ?>;
color: <?php echo esc_html($noo_site_link_hover_color); ?>;
}
#tribe-events .tribe-events-button,
.countdown-period{
background: <?php echo esc_html($noo_site_link_hover_color).'!important'; ?>;
}
#tribe-events .tribe-events-button:hover{
background: <?php echo esc_html($noo_site_link_color_fade_80).'!important'; ?>;
}

.navbar-nav li > a:hover:before, .navbar-nav li > a:focus:before {
border-color: <?php echo esc_html($noo_site_link_color_darken_10); ?>;
}
.navbar-nav li.current_page_item > a:before,
.navbar-nav li > a:hover:before, 
.navbar-nav li > a:focus:before
{
	background: <?php echo esc_html($noo_site_link_color_darken_10); ?>;
}

/*Orther link*/

.noo-smart-content div.product .album-intro .album-intro-wrap .album-media-player .album-playlist ul li.current-playing a i,
.wigetized .widget_top_rated_products ul.product_list_widget li:hover .product-title, 
.wigetized .widget_top_rated_products ul.product_list_widget li:hover a,
.noo-smart-content div.product .album-intro .album-intro-wrap .album-media-player .album-playlist ul li:hover a i,
.events-list .tribe-events-loop .noo-tribe-events-image .tribe-events-event-meta.vcard .time-details .fa,
.events-list .tribe-events-loop .noo-tribe-events-image .tribe-events-event-meta.vcard .tribe-events-venue-details .fa,
.tribe-events-day .tribe-events-loop .noo-tribe-events-image .tribe-events-event-meta.vcard .time-details .fa,
.tribe-events-day .tribe-events-loop .noo-tribe-events-image .tribe-events-event-meta.vcard .tribe-events-venue-details .fa,
.noo-single-event-content .noo-tribe-money i,
.noo_news_blog li .noo-sh-blog-content h3:hover a

{
	color: <?php echo esc_html($noo_site_link_hover_color); ?>;
}
<?php
endif;
?>