<?php
// Variables
$noo_typo_use_custom_fonts = noo_get_option( 'noo_typo_use_custom_fonts', false );
$noo_typo_headings_uppercase = noo_get_option( 'noo_typo_headings_uppercase', false );
$noo_typo_body_font_size = noo_get_option( 'noo_typo_body_font_size', noo_get_theme_default( 'font_size' ) );

if( $noo_typo_use_custom_fonts ) :
	$noo_typo_headings_font = noo_get_option( 'noo_typo_headings_font', noo_get_theme_default( 'headings_font' ) );
	$noo_typo_headings_font_weight = noo_get_option( 'noo_typo_headings_font_weight', 'bold' );
	$noo_typo_headings_uppercase = noo_get_option( 'noo_typo_headings_uppercase', false );

	$noo_typo_body_font = noo_get_option( 'noo_typo_body_font', noo_get_theme_default( 'font_family' ) );
	$noo_typo_body_font_style = noo_get_option( 'noo_typo_body_font_style', 'normal' );
	$noo_typo_body_font_weight = noo_get_option( 'noo_typo_body_font_weight', noo_get_theme_default( 'font_weight' ) );

?>

/* Body style */
/* ===================== */
body {
	font-family: "<?php echo esc_html( $noo_typo_body_font ); ?>", sans-serif;
	font-size: <?php echo esc_html( $noo_typo_body_font_size ) . 'px'; ?>;
	font-style: <?php echo esc_html( $noo_typo_body_font_style ); ?>;
	font-weight: <?php echo esc_html( $noo_typo_body_font_weight ); ?>;
}

/* Headings */
/* ====================== */
h1, h2, h3, h4, h5, h6,
.h1, .h2, .h3, .h4, .h5, .h6 {
	font-family: "<?php echo esc_html( $noo_typo_headings_font ); ?>", sans-serif;
	font-weight: <?php echo esc_html( $noo_typo_headings_font_weight ); ?>;	
	<?php if ( !empty( $noo_typo_headings_uppercase ) ) : ?>
		text-transform: uppercase;
	<?php else : ?>
		text-transform: none;
	<?php endif; ?>
}
.noo_slider_tab .more-post,
.noo-tabcat-wrap .noo-tabcat-header span,
.noo-tabcat-wrap .noo-items .noo-post-meta,
.btn-primary, 
.widget_newsletterwidget .newsletter-submit,
.noo-popular-video .noo-popular-video-inner .count-view,
.widget_latest_ratting .widget-latest_ratting-content .latest_ratting-featured .noo_rating_point,
.widget_noo_categories ul li,
.slider-item .slider-content .slider-meta,
.list-blog-thumbnail .item-category,
.nav-tabs > li > a,
.item-content-meta,
.noo_rating_point,
.noo-tncat,
.noo_latest_ratting ul li .noo-ratting-meta,
.slider-item .slider-content .slider-meta,
.noo-timeline-news .noo-rn-item .loop-item-wrap .loop-item-date time,
.noo-timeline-news .noo-rn-item .loop-item-wrap .loop-item-content .item-category,
.noo-audio-post .noo-audio-post-item .count-view,
.noo-recent-comment .comment-count,
.noo-recent-quote .noo-recent-quote-item .recent-quote-content .content-sub-title,
.noo-recent-news .item-category,
.masonry-filters ul li a,
.content-meta,
.content-header .entry-date,
.widget_latest_ratting .widget-latest_ratting-content .noo-ratting-meta,
.widget-counter.col3 ul li a,
.noo_reader_now,
.noo_total_rating .noo_front_totalcount,
.noo_total_rating strong,
.noo_editor_ratting,
.form-submit input[type="submit"],
.noo-topbar,
.video_introduction h2,
.button-social{
	font-family: "<?php echo esc_html( $noo_typo_headings_font ); ?>", sans-serif;
}
/* Other style */
/* ====================== */
.comment-author,
.comment-reply-title,
.footer-top .noo-menu li a,
.pagination .page-numbers,
.entry-tags span,
ol,
.widget.widget_recent_entries li a,
.default_list_products .woocommerce ul.products.grid li.product figcaption h3.product_title,
.default_list_products .woocommerce ul.products li.product figure figcaption .product_title,
.woocommerce div.product .wpn_buttons,
.woocommerce div.product .product-navigation .next-product a > span,
.woocommerce div.product .product-navigation .next-product a .next-product-info .next-desc .amount,
.woocommerce div.product .product-navigation .prev-product a > span,
.woocommerce div.product div.summary .variations_form label,
.woocommerce div.product div.summary .product_meta > span,
.woocommerce .list_products_toolbar .products-toolbar span,
.woocommerce ul.products li.product .price,
.woocommerce ul.products.list li.product h3.product_title,
.woocommerce div.product span.price,
.woocommerce div.product p.price,
.woocommerce div.product .woocommerce-tabs .nav-tabs > li > a,
.woocommerce .quantity .plus,
.woocommerce .quantity .minus,
.woocommerce #reviews #comments ol.commentlist li .comment-text p.meta strong,
.woocommerce table.shop_attributes th,
.woocommerce table.cart .product-price,
.woocommerce table.cart .product-subtotal,
.woocommerce .checkout #order_review td.product-total,
.woocommerce .checkout #order_review .cart-subtotal td,
.woocommerce .checkout #order_review .order-total td,
.woocommerce .view_order .wrap_order_details table tr .amount,
.woocommerce .checkout_complete ul.order_details.general li.total strong,
.woocommerce table.my_account_orders tr td.order-total .amount,
.woocommerce .widget_price_filter .price_slider_amount,
.home-lookbook-detai .lookbook-detail-content ol li b {
	font-family: "<?php echo esc_html( $noo_typo_headings_font ); ?>", sans-serif;
}
<?php else : ?>
/* Body style */
/* ===================== */
body {
	font-size: <?php echo esc_html( $noo_typo_body_font_size ) . 'px'; ?>;
}

/* Headings */
/* ====================== */
h1, h2, h3, h4, h5, h6,
.h1, .h2, .h3, .h4, .h5, .h6 {
	<?php if ( !empty( $noo_typo_headings_uppercase ) ) : ?>
		text-transform: uppercase;
	<?php else : ?>
		text-transform: none;
	<?php endif; ?>
}
<?php endif; ?>