<?php
/**
 * NOO Customizer Package.
 *
 * Register Options
 * This file register options used in NOO-Customizer
 *
 * @package    NOO Framework
 * @version    1.0.0
 * @author     Kan Nguyen <khanhnq@nootheme.com>
 * @copyright  Copyright (c) 2014, NooTheme
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       http://nootheme.com
 */
// =============================================================================


// 0. Remove Unused WP Customizer Sections
if ( ! function_exists( 'noo_customizer_remove_wp_native_sections' ) ) :
	function noo_customizer_remove_wp_native_sections( $wp_customize ) {
		$wp_customize->remove_section( 'title_tagline' );
		// $wp_customize->remove_section( 'colors' );
		// $wp_customize->remove_section( 'background_image' );
		// $wp_customize->remove_section( 'nav' );
		// $wp_customize->remove_section( 'static_front_page' );
	}

add_action( 'customize_register', 'noo_customizer_remove_wp_native_sections' );
endif;


//
// Register NOO Customizer Sections and Options
//

// 1. Site Enhancement options.
if ( ! function_exists( 'noo_customizer_register_options_general' ) ) :
	function noo_customizer_register_options_general( $wp_customize ) {

		// declare helper object.
		$helper = new NOO_Customizer_Helper( $wp_customize );

		// Section: Site Enhancement
		$helper->add_section(
			'noo_customizer_section_site_enhancement',
			__( 'Site Enhancement', 'noo' ),
			__( 'Enable/Disable some features for your site.', 'noo' )
		);

		noo_customizer_add_controls(
			$wp_customize,
			array(
				'noo_custom_favicon' => array(
					'type'		=> 'noo_image',
					'label'		=> __( 'Custom Favicon', 'noo' ),
					'default'	=> '',
					'preview_type' => 'none'// or 'control' => array( 'preview_type' => 'none' )
				),
				'noo_page_heading' => array(
					'type'		=> 'noo_switch',
					'label'		=> __( 'Enable Page Heading', 'noo' ),
					'default'	=> 1
				),
				'noo_mailchimp' => array(
					'type'		=> 'noo_switch',
					'label'		=> __( 'Enable MailChimp Subscribe', 'noo' ),
					'default'	=> 1,
					'control'	=> array( 'json' => array( 'on_child_options' => 'noo_mailchimp_api_key' ), 'preview_type' => 'none' ),
				),
				'noo_mailchimp_api_key' => array(
					'type'		=> 'mailchimp',
					'label'		=> __( 'MailChimp Settings', 'noo' ),
					'default'		=> '',
					'preview_type' => 'none'
				)
			)
		);
	}
add_action( 'customize_register', 'noo_customizer_register_options_general' );
endif;

// 2. Design and Layout options.
if ( ! function_exists( 'noo_customizer_register_options_layout' ) ) :
	function noo_customizer_register_options_layout( $wp_customize ) {

		// declare helper object.
		$helper = new NOO_Customizer_Helper( $wp_customize );

		// Section: Layout
		$helper->add_section(
			'noo_customizer_section_layout',
			__( 'Design and Layout', 'noo' ),
			__( 'Set Style and Layout for your site. Boxed Layout will come with additional setting options for background color and image.', 'noo' )
		);

		noo_customizer_add_controls(
			$wp_customize,
			array(
				'noo_site_layout' => array(
					'type' => 'noo_radio',
					'label' => __( 'Site Layout', 'noo' ),
					'default' => 'fullwidth',
					'control' => array(
						'choices' => array( 'fullwidth' => __( 'Fullwidth', 'noo' ), 'boxed' => __( 'Boxed', 'noo' ) ),
						'json'  => array(
							'child_options' => array(
								'boxed' => 'noo_layout_site_width
											,noo_layout_site_max_width
											,noo_layout_bg_color
		                                    ,noo_layout_bg_image_sub_section
		                                    ,noo_layout_bg_image
		                                    ,noo_layout_bg_repeat
		                                    ,noo_layout_bg_align
		                                    ,noo_layout_bg_attachment
		                                    ,noo_layout_bg_cover'
							)
						),
						'preview_type' => 'custom'
					)
				),
                'noo_theme_style' => array(
					'type' => 'noo_radio',
					'label' => __( 'Theme Style', 'noo' ),
					'default' => 'dark',
					'control' => array(
						'choices' => array( 'dark' => __( 'Dark', 'noo' ), 'light' => __( 'Light', 'noo' ) )
					)
				),
				'noo_layout_site_width' => array(
					'type' => 'ui_slider',
					'label' => __( 'Site Width (%)', 'noo' ),
					'default' => '90',
					'control' => array(
						'json' => array(
							'data_min' => 60,
							'data_max' => 100,
						),
						'preview_type' => 'custom'
					)
				),
				'noo_layout_site_max_width' => array(
					'type' => 'ui_slider',
					'label' => __( 'Site Max Width (px)', 'noo' ),
					'default' => '1200',
					'control' => array(
						'json' => array(
							'data_min'  => 980,
							'data_max'  => 1600,
							'data_step' => 10,
						),
						'preview_type' => 'custom'
					)
				),
				'noo_layout_bg_color' => array(
					'type' => 'color_control',
					'label' => __( 'Background Color', 'noo' ),
					'default' => '#ffffff',
					'preview_type' => 'custom'
				)
			)
		);

		// Sub-section: Background Image
		$helper->add_sub_section(
			'noo_layout_bg_image_sub_section',
			__( 'Background Image', 'noo' ),
			__( 'Upload your background image here, you have various settings for your image:<br/><strong>Repeat Image</strong>: enable repeating your image, you will need it when using patterned background.<br/><strong>Alignment</strong>: Set the position to align your background image.<br/><strong>Attachment</strong>: Make your image scroll with your site or fixed.<br/><strong>Auto resize</strong>: Enable it to ensure your background image always fit the windows.', 'noo' )
		);

		// Control: Background Image
		$helper->add_control(
			'noo_layout_bg_image',
			'noo_image',
			__( 'Background Image', 'noo' ),
			'',
			array( 'preview_type' => 'custom' )
		);

		// Control: Repeat Image
		$helper->add_control(
			'noo_layout_bg_repeat',
			'radio',
			__( 'Background Repeat', 'noo' ),
			'no-repeat',
			array(
				'choices' => array(
					'repeat' => __( 'Repeat', 'noo' ),
					'no-repeat' => __( 'No Repeat', 'noo' ),
				),
				'preview_type' => 'custom'
			)
		);

		// Control: Align Image
		$helper->add_control(
			'noo_layout_bg_align',
			'select',
			__( 'BG Image Alignment', 'noo' ),
			'left top',
			array(
				'choices' => array(
					'left top'       => __( 'Left Top', 'noo' ),
					'left center'     => __( 'Left Center', 'noo' ),
					'left bottom'     => __( 'Left Bottom', 'noo' ),
					'center top'     => __( 'Center Top', 'noo' ),
					'center center'     => __( 'Center Center', 'noo' ),
					'center bottom'     => __( 'Center Bottom', 'noo' ),
					'right top'     => __( 'Right Top', 'noo' ),
					'right center'     => __( 'Right Center', 'noo' ),
					'right bottom'     => __( 'Right Bottom', 'noo' ),
				),
				'preview_type' => 'custom'
			)
		);

		// Control: Enable Scrolling Image
		$helper->add_control(
			'noo_layout_bg_attachment',
			'radio',
			__( 'BG Image Attachment', 'noo' ),
			'fixed',
			array(
				'choices' => array(
					'fixed' => __( 'Fixed Image', 'noo' ),
					'scroll' => __( 'Scroll with Site', 'noo' ),
				),
				'preview_type' => 'custom'
			)
		);

		// Control: Auto Resize
		$helper->add_control(
			'noo_layout_bg_cover',
			'noo_switch',
			__( 'Auto Resize', 'noo' ),
			0,
			array( 'preview_type' => 'custom' )
		);

		// Sub-Section: Links Color
		$helper->add_sub_section(
			'noo_general_sub_section_links_color',
			__( 'Color', 'noo' ),
			__( 'Here you can set the color for links and various elements on your site.', 'noo' )
		);

		// Control: Site Links Hover Color
		$helper->add_control(
			'noo_site_link_hover_color',
			'color_control',
			__( 'Primary Color', 'noo' ),
			noo_get_theme_default( 'primary_color' ),
			array( 'preview_type' => 'update_css', 'preview_params' => array( 'css' => 'design' ) )
		);
	}
add_action( 'customize_register', 'noo_customizer_register_options_layout' );
endif;

// 3. Typography options.
if ( ! function_exists( 'noo_customizer_register_options_typo' ) ) :
	function noo_customizer_register_options_typo( $wp_customize ) {

		// declare helper object.
		$helper = new NOO_Customizer_Helper( $wp_customize );

		// Section: Typography
		$helper->add_section(
			'noo_customizer_section_typo',
			__( 'Typography', 'noo' ),
			__( 'Customize your Typography settings. Merito integrated all Google Fonts. See font preview at <a target="_blank" href="http://www.google.com/fonts/">Google Fonts</a>.', 'noo' )
		);

		// Control: Use Custom Fonts
		$helper->add_control(
			'noo_typo_use_custom_fonts',
			'noo_switch',
			__( 'Use Custom Fonts?', 'noo' ),
			0,
			array( 'json' => array( 
				'on_child_options'  => 'noo_typo_headings_font,noo_typo_body_font' 
				),
				'preview_type' => 'update_css',
				'preview_params' => array( 'css' => 'typography' )
			)
		);

		// Control: Use Custom Font Color
		$helper->add_control(
			'noo_typo_use_custom_fonts_color',
			'noo_switch',
			__( 'Custom Font Color?', 'noo' ),
			0,
			array( 'json' => array(
				'on_child_options'  => 'noo_typo_headings_font_color,noo_typo_body_font_color'
				),
				'preview_type' => 'update_css',
				'preview_params' => array( 'css' => 'design' )
			)
		);

		// Sub-Section: Headings
		$helper->add_sub_section(
			'noo_typo_sub_section_headings',
			__( 'Headings', 'noo' )
		);

		// Control: Headings font
		$helper->add_control(
			'noo_typo_headings_font',
			'google_fonts',
			__( 'Headings Font', 'noo' ),
			noo_get_theme_default( 'headings_font_family' ),
			array(
				'weight' => '700',
				'style'	=> 'italic',
				'preview_type' => 'custom'
			)
		);

		// Control: Headings Font Color
		$helper->add_control(
			'noo_typo_headings_font_color',
			'color_control',
			__( 'Font Color', 'noo' ),
			noo_get_theme_default( 'headings_color' ),
			array( 'preview_type' => 'custom' )
		);

		// Control: Headings Font Uppercase
		$helper->add_control(
			'noo_typo_headings_uppercase',
			'checkbox',
			__( 'Transform to Uppercase', 'noo' ),
			0,
			array( 'preview_type' => 'custom' )
		);

		// Sub-Section: Body
		$helper->add_sub_section(
			'noo_typo_sub_section_body',
			__( 'Body', 'noo' )
		);

		// Control: Body font
		$helper->add_control(
			'noo_typo_body_font',
			'google_fonts',
			__( 'Body Font', 'noo' ),
			noo_get_theme_default( 'font_family' ),
			array( 'preview_type' => 'custom' )
		);

		// Control: Body Font Size
		$helper->add_control(
			'noo_typo_body_font_size',
			'font_size',
			__( 'Font Size (px)', 'noo' ),
			noo_get_theme_default( 'font_size' ),
			array( 'preview_type' => 'custom' )
		);

		// Control: Body Font Color
		$helper->add_control(
			'noo_typo_body_font_color',
			'color_control',
			__( 'Font Color', 'noo' ),
			noo_get_theme_default( 'text_color' ),
			array(
				'preview_type' => 'update_css',
				'preview_params' => array( 'css' => 'design' )
			)
		);
	}
add_action( 'customize_register', 'noo_customizer_register_options_typo' );
endif;


// 6. Header options.
if ( ! function_exists( 'noo_customizer_register_options_header' ) ) :
	function noo_customizer_register_options_header( $wp_customize ) {

		// declare helper object.
		$helper = new NOO_Customizer_Helper( $wp_customize );

		// Section: Header
		$helper->add_section(
			'noo_customizer_section_header',
			__( 'Header', 'noo' ),
			__( 'Customize settings for your Header, including Navigation Bar (Logo and Navigation) and an optional Top Bar.', 'noo' ),
			true
		);

		// Sub-section: General Options
		$helper->add_sub_section(
			'noo_header_sub_section_general',
			__( 'General Options', 'noo' ),
			''
		);

		// Sub-Section: Navigation Bar
		$helper->add_sub_section(
			'noo_header_sub_section_nav',
			__( 'Navigation Bar', 'noo' ),
			__( 'Adjust settings for Navigation Bar. You also can customize some settings for the Toggle Button on Mobile in this section.', 'noo' )
		);

		// Control: NavBar Position
		$helper->add_control(
			'noo_header_nav_position',
			'noo_radio',
			__( 'NavBar Position', 'noo' ),
			'fixed_top', 
			array(
				'choices' => array(
					'static_top'       => __( 'Static Top', 'noo' ),
					'fixed_top'     => __( 'Fixed Top', 'noo' ),
					// 'fixed_left'     => __( 'Fixed Left', 'noo' ),
					// 'fixed_right'     => __( 'Fixed Right', 'noo' ),
				),
				'json' => array(
					'child_options' => array(
						'fixed_top'   => 'noo_header_nav_shrinkable,noo_header_nav_smart_scroll,noo_header_sub_section_nav_floating,noo_header_nav_floating',
						// 'fixed_left'  => 'noo_header_side_nav_width,noo_header_side_nav_alignment,noo_header_side_logo_margin_top,noo_header_side_nav_link_height',
						// 'fixed_right' => 'noo_header_side_nav_width,noo_header_side_nav_alignment,noo_header_side_logo_margin_top,noo_header_side_nav_link_height',
					)
				)
			)
		);

		if( NOO_WOOCOMMERCE_EXIST ) {

			// Control: Show Cart Icon
			$helper->add_control(
				'noo_header_nav_icon_cart',
				'noo_switch',
				__( 'Show Shopping Cart', 'noo' ),
				1
			);

			if( defined( 'YITH_WCWL' ) ) {
				// Control: Show Wishlist Icon
				$helper->add_control(
					'noo_header_nav_icon_wishlist',
					'noo_switch',
					__( 'Show Wistlist', 'noo' ),
					1
				);
			}
		}

				// Control: Divider 2
		$helper->add_control( 'noo_header_nav_divider_2', 'divider', '' );

		// Control: Custom NavBar Font
		$helper->add_control(
			'noo_header_custom_nav_font',
			'noo_switch',
			__( 'Use Custom NavBar Font and Color?', 'noo' ),
			0,
			array( 'json' => array( 
					'on_child_options'  => 'noo_header_nav_font,noo_header_nav_link_color,noo_header_nav_link_hover_color' 
				),
				'preview_type' => 'update_css',
				'preview_params' => array( 'css' => 'header' )
			)
		);

		// Control: NavBar font
		$helper->add_control(
			'noo_header_nav_font',
			'google_fonts',
			__( 'NavBar Font', 'noo' ),
			noo_get_theme_default( 'headings_font_family' ),
			array(
				'weight' => '700',
				'style'	=> 'normal',
				'preview_type' => 'custom',
			)
		);

		// Control: NavBar Font Size
		$helper->add_control(
			'noo_header_nav_font_size',
			'ui_slider',
			__( 'Font Size (px)', 'noo' ),
			'14',
			array(
				'json' => array(
					'data_min' => 9,
					'data_max' => 30,
				),
				'preview_type' => 'custom'
			)
		);

		// Control: NavBar Link Color
		$helper->add_control(
			'noo_header_nav_link_color',
			'color_control',
			__( 'Link Color', 'noo' ),
			'',
			array(
				'preview_type' => 'custom'
			)
		);

		// Control: NavBar Link Hover Color
		$helper->add_control(
			'noo_header_nav_link_hover_color',
			'color_control',
			__( 'Link Hover Color', 'noo' ),
			''
		);

		// Control: NavBar Font Uppercase
		$helper->add_control(
			'noo_header_nav_uppercase',
			'checkbox',
			__( 'Transform to Uppercase', 'noo' ),
			1,
			array(
				'preview_type' => 'custom'
			)
		);

		// Sub-Section: Logo
		$helper->add_sub_section(
			'noo_header_sub_section_logo',
			__( 'Logo', 'noo' ),
			__( 'All the settings for Logo go here. If you do not use Image for Logo, plain text will be used.', 'noo' )
		);

		// Control: Use Image for Logo
		$helper->add_control(
			'noo_header_use_image_logo',
			'noo_switch',
			__( 'Use Image for Logo?', 'noo' ),
			0,
			array(
				'json' => array(
					'on_child_options'   => 'noo_header_logo_image,noo_header_logo_image_height',
					'off_child_options'  => 'blogname
										,noo_header_logo_font
                                        ,noo_header_logo_font_size
                                        ,noo_header_logo_font_color
                                        ,noo_header_logo_uppercase'
				)
			)
		);

		// Control: Blog Name
		$helper->add_control(
			'blogname',
			'text',
			__( 'Blog Name', 'noo' ),
			get_bloginfo( 'name' ),
			array(
				'preview_type' => 'custom',
				'type' => 'option'
			)
		);

		// Control: Logo font
		$helper->add_control(
			'noo_header_logo_font',
			'google_fonts',
			__( 'Logo Font', 'noo' ),
			noo_get_theme_default( 'logo_font_family' ),
			array(
				'weight' => '700',
				'style'	=> 'normal',
				'preview_type' => 'custom'
			)
		);

		// Control: Logo Font Size
		$helper->add_control(
			'noo_header_logo_font_size',
			'ui_slider',
			__( 'Font Size (px)', 'noo' ),
			'50',
			array(
				'json' => array(
					'data_min' => 15,
					'data_max' => 80,
				),
				'preview_type' => 'custom'
			)
		);

		// Control: Logo Font Color
		$helper->add_control(
			'noo_header_logo_font_color',
			'color_control',
			__( 'Font Color', 'noo' ),
			noo_get_theme_default( 'logo_color' ),
			array(
				'preview_type' => 'custom'
			)
		);

		// Control: Logo Font Uppercase
		$helper->add_control(
			'noo_header_logo_uppercase',
			'checkbox',
			__( 'Transform to Uppercase', 'noo' ),
			0,
			array(
				'preview_type' => 'custom'
			)
		);

		// Control: Logo Image
		$helper->add_control(
			'noo_header_logo_image',
			'noo_image',
			__( 'Upload Your Logo', 'noo' ),
			'',
			array(
				'preview_type' => 'custom'
			)
		);

		// Control: Logo Image Height
		$helper->add_control(
			'noo_header_logo_image_height',
			'ui_slider',
			__( 'Image Height (px)', 'noo' ),
			'70',
			array(
				'json' => array(
					'data_min' => 15,
					'data_max' => 120,
				),
				'preview_type' => 'custom'
			)
		);

		// Sub-Section: NavBar Alignment
		$helper->add_sub_section(
			'noo_header_sub_section_alignment',
			__( 'NavBar Alignment', 'noo' ),
			''
		);

		// Control: NavBar Height (px)
		$helper->add_control(
			'noo_header_nav_height',
			'ui_slider',
			__( 'NavBar Height (px)', 'noo' ),
			'100',
			array(
				'json' => array(
					'data_min' => 100,
					'data_max' => 150,
				),
				'preview_type' => 'custom'
			)
		);

		// Control: NavBar Link Spacing (px)
		$helper->add_control(
			'noo_header_nav_link_spacing',
			'ui_slider',
			__( 'NavBar Link Spacing (px)', 'noo' ),
			'30',
			array(
				'json' => array(
					'data_min' => 10,
					'data_max' => 50,
				),
				'preview_type' => 'custom'
			)
		);

		// Control: Mobile Icon Size (px)
		$helper->add_control(
			'noo_header_nav_toggle_size',
			'ui_slider',
			__( 'Mobile Icon Size (px)', 'noo' ),
			'25',
			array(
				'json' => array(
					'data_min' => 15,
					'data_max' => 100,
				),
				'preview_type' => 'custom'
			)
		);

	}
add_action( 'customize_register', 'noo_customizer_register_options_header' );
endif;

// 7. Footer options.
if ( ! function_exists( 'noo_customizer_register_options_footer' ) ) :
	function noo_customizer_register_options_footer( $wp_customize ) {

		// declare helper object.
		$helper = new NOO_Customizer_Helper( $wp_customize );

		// Section: Footer
		$helper->add_section(
			'noo_customizer_section_footer',
			__( 'Footer', 'noo' ),
			__( 'Footer contains Widgetized area and Footer Bottom. You can change any parts.', 'noo' )
		);

        $helper->add_control(
            'noo_background_footer',
            'noo_image',
            __( 'Upload Your Footer', 'noo' ),
            ''
        );

		// Control: Footer Columns (Widgetized)
		$helper->add_control(
			'noo_footer_widgets',
			'select',
			__( 'Footer Columns (Widgetized)', 'noo' ),
			'4',
			array(
				'choices' => array(
					0       => __( 'None (No Footer Main Content)', 'noo' ),
					1     => __( 'One', 'noo' ),
					2     => __( 'Two', 'noo' ),
					3     => __( 'Three', 'noo' ),
					4     => __( 'Four', 'noo' )
				)
			)
		);

		// Control: Divider 2
		$helper->add_control( 'noo_footer_divider_2', 'divider', '' );

        // Control: Footer Columns (Widgetized)
        $helper->add_control(
            'noo_footer_bottom',
            'select',
            __( 'Footer bottom', 'noo' ),
            '0',
            array(
                'choices' => array(
                    0       => __( 'Hide', 'noo' ),
                    1     => __( 'Show', 'noo' ),
                )
            )
        );

		// Control: Bottom Bar Content
		$helper->add_control(
			'noo_bottom_bar_content',
			'textarea',
			__( 'Footer Content (HTML)', 'noo' ),
			'&copy; 2015 WeMusic. Designed with <i class="fa fa-heart text-primary" ></i> by NooTheme',
			array(
				'preview_type' => 'custom'
			)
		);

	}
add_action( 'customize_register', 'noo_customizer_register_options_footer' );
endif;

// 8. WP Sidebar options.
if ( ! function_exists( 'noo_customizer_register_options_sidebar' ) ) :
	function noo_customizer_register_options_sidebar( $wp_customize ) {

		global $wp_version;
		if ( $wp_version >= 4.0 ) {
			// declare helper object.
			$helper = new NOO_Customizer_Helper( $wp_customize );

			// Change the sidebar panel priority
			$widget_panel = $wp_customize->get_panel('widgets');
			if(!empty($widget_panel)) {
				$widget_panel->priority = $helper->get_new_section_priority();
			}
		}
	}
add_action( 'customize_register', 'noo_customizer_register_options_sidebar' );
endif;

// 9. Blog options.
if ( ! function_exists( 'noo_customizer_register_options_blog' ) ) :
	function noo_customizer_register_options_blog( $wp_customize ) {

		// declare helper object.
		$helper = new NOO_Customizer_Helper( $wp_customize );

		// Section: Blog
		$helper->add_section(
			'noo_customizer_section_blog',
			__( 'Blog', 'noo' ),
			__( 'In this section you have settings for your Blog page, Archive page and Single Post page.', 'noo' ),
			true
		);

		// Sub-section: Blog Page (Index Page)
		$helper->add_sub_section(
			'noo_blog_sub_section_blog_page',
			__( 'Post List', 'noo' ),
			__( 'Choose Layout settings for your Post List', 'noo' )
		);

		// Control: Blog Layout
		$helper->add_control(
			'noo_blog_layout',
			'noo_radio',
			__( 'Blog Layout', 'noo' ),
			'sidebar',
			array(
				'choices' => array(
					'fullwidth'   => __( 'Full-Width', 'noo' ),
					'sidebar'   => __( 'With Right Sidebar', 'noo' ),
					'left_sidebar'   => __( 'With Left Sidebar', 'noo' )
				),
				'json' => array(
					'child_options' => array(
						'fullwidth'   => '',
						'sidebar'   => 'noo_blog_sidebar',
						'left_sidebar'   => 'noo_blog_sidebar'
					)
				)
			)
		);

		// Control: Blog Sidebar
		$helper->add_control(
			'noo_blog_sidebar',
			'widgets_select',
			__( 'Blog Sidebar', 'noo' ),
			'sidebar-main'
		);

		// Control: Divider 1
		$helper->add_control( 'noo_blog_divider_1', 'divider', '' );

		// Control: Heading Image
		$helper->add_control(
			'noo_blog_heading_image',
			'noo_image',
			__( 'Heading Background Image', 'noo' ),
			''
		);

		// Control: Divider 2
		$helper->add_control( 'noo_blog_divider_2', 'divider', '' );

		// Control: Show Post Meta
		$helper->add_control(
			'noo_blog_show_post_meta',
			'checkbox',
			__( 'Show Post Meta', 'noo' ),
			1
		);
		// Control: Show Readmore link
		$helper->add_control(
			'noo_blog_show_readmore',
			'checkbox',
			__( 'Show Readmore link', 'noo' ),
			1
		);

		// Control: Excerpt Length
		$helper->add_control(
			'noo_blog_excerpt_length',
			'text',
			__( 'Excerpt Length', 'noo' ),
			'60'
		);

		// Sub-section: Single Post
		$helper->add_sub_section(
			'noo_blog_sub_section_post',
			__( 'Single Post', 'noo' )
		);

		// Control: Post Layout
		$helper->add_control(
			'noo_blog_post_layout',
			'noo_same_as_radio',
			__( 'Post Layout', 'noo' ),
			'same_as_blog',
			array(
				'choices' => array(
					'same_as_blog'   => __( 'Same as Blog Layout', 'noo' ),
					'fullwidth'   => __( 'Full-Width', 'noo' ),
					'sidebar'   => __( 'With Right Sidebar', 'noo' ),
					'left_sidebar'   => __( 'With Left Sidebar', 'noo' ),
				),
				'json' => array(
					'child_options' => array(
						'fullwidth'   => '',
						'sidebar'   => 'noo_blog_post_sidebar',
						'left_sidebar'   => 'noo_blog_post_sidebar',
					)
				)
			)
		);

		// Control: Post Sidebar
		$helper->add_control(
			'noo_blog_post_sidebar',
			'widgets_select',
			__( 'Post Sidebar', 'noo' ),
			'sidebar-main'
		);
		
		// Control: Divider 1
		$helper->add_control( 'noo_blog_post_divider_1', 'divider', '' );


		// Control: Divider 1
		$helper->add_control( 'noo_blog_post_divider_1', 'divider', '' );
		
		// Control: Show Post Meta
		$helper->add_control(
			'noo_blog_post_show_post_meta',
			'checkbox',
			__( 'Show Post Meta', 'noo' ),
			1
		);

		// Control: Show Post Tags
		$helper->add_control(
			'noo_blog_post_show_post_tag',
			'checkbox',
			__( 'Show Post Tags', 'noo' ),
			1
		);

		// Control: Show Author Bio
		$helper->add_control(
			'noo_blog_post_author_bio',
			'checkbox',
			__( 'Show Author\'s Bio', 'noo' ),
			1
		);

		// Control: Divider 2
		$helper->add_control( 'noo_blog_post_divider_2', 'divider', '' );

		// Control: Enable Social Sharing
		$helper->add_control(
			'noo_blog_social',
			'noo_switch',
			__( 'Enable Social Sharing', 'noo' ),
			1,
			array(
				'json' => array( 'on_child_options' => 'noo_blog_social_facebook,
		                                                noo_blog_social_twitter,
		                                                noo_blog_social_google,
		                                                noo_blog_social_pinterest,
		                                                noo_blog_social_linkedin'
				)
			)
		);

		// Control: Sharing Title
		$helper->add_control(
			'noo_blog_social_title',
			'text',
			__( 'Sharing Title', 'noo' ),
			__( 'Share This Post', 'noo' )
		);

		// Control: Facebook Share
		$helper->add_control(
			'noo_blog_social_facebook',
			'checkbox',
			__( 'Facebook Share', 'noo' ),
			1
		);

		// Control: Twitter Share
		$helper->add_control(
			'noo_blog_social_twitter',
			'checkbox',
			__( 'Twitter Share', 'noo' ),
			1
		);

		// Control: Google+ Share
		$helper->add_control(
			'noo_blog_social_google',
			'checkbox',
			__( 'Google+ Share', 'noo' ),
			1
		);

		// Control: Pinterest Share
		$helper->add_control(
			'noo_blog_social_pinterest',
			'checkbox',
			__( 'Pinterest Share', 'noo' ),
			0
		);

		// Control: LinkedIn Share
		$helper->add_control(
			'noo_blog_social_linkedin',
			'checkbox',
			__( 'LinkedIn Share', 'noo' ),
			0
		);
	}
add_action( 'customize_register', 'noo_customizer_register_options_blog' );
endif;

// Event
if( !function_exists('noo_customizer_register_options_event') ):

    function noo_customizer_register_options_event( $wp_customize ){
        $helper = new NOO_Customizer_Helper( $wp_customize );

        $helper->add_section(
            'noo_customizer_section_event',
            __('Event', 'noo'),
            __('Setting for Event', 'noo')
        );
        // Control: Logo Image
        $helper->add_control(
            'noo_heading_event_image',
            'noo_image',
            __( 'Upload image heading', 'noo' ),
            '',
            array( 'preview_type' => 'custom' )
        );
        // Control: Footer Columns (Widgetized)
        $helper->add_control(
            'noo_position_event_sidebar',
            'select',
            __( 'Event Layout', 'noo' ),
            '0',
            array(
                'choices' => array(
                    0       => __( 'Right sidebar', 'noo' ),
                    1     => __( 'Left sidebar', 'noo' )
                ),
                'preview_type' => 'custom'
            )
        );
    }
    add_action('customize_register','noo_customizer_register_options_event');
endif;

// Album
if( !function_exists('noo_customizer_register_options_album') ):

    function noo_customizer_register_options_album( $wp_customize ){
        $helper = new NOO_Customizer_Helper( $wp_customize );

        $helper->add_section(
            'noo_customizer_section_album',
            __('Album', 'noo'),
            __('Setting for Album', 'noo')
        );
        // Control: Logo Image
        $helper->add_control(
            'noo_heading_album_image',
            'noo_image',
            __( 'Upload image heading', 'noo' ),
            '',
            array( 'preview_type' => 'custom' )
        );

        // Control: Footer Columns (Widgetized)
		$helper->add_control(
			'noo_album_columns',
			'select',
			__( 'Album Columns', 'noo' ),
			'3',
			array(
				'choices' => array(
					1     => __( 'One', 'noo' ),
					2     => __( 'Two', 'noo' ),
					3     => __( 'Three', 'noo' ),
					4     => __( 'Four', 'noo' )
				)
			)
		);

        // Control: Divider 1
 		$helper->add_control( 'noo_album_divider_1', 'divider', '' );
        
        $helper->add_control(
            'enable_footer_player',
            'noo_radio',
            __( 'Enable Footer Player', 'noo' ),
            'enabled',
            array(
				'choices' => array(
					'enabled'   => __( 'Enable on all pages', 'noo' ),
					'album_only'   => __( 'Only Enable on Single Album', 'noo' ),
					'none'   => __( 'No Player', 'noo' )
				),
				'json' => array(
					'child_options' => array(
						'enabled'   => 'album_id',
					)
				)
			)
        );

        // Control: Headings Font Uppercase
		$helper->add_control(
			'noo_album_auto_play',
			'noo_switch',
			__( 'Auto Play?', 'noo' ),
			1,
			array(
				'json' => array(
					'child_options' => array(
						'enabled'   => 'album_id',
					)
				)
			)
		);

        $helper->add_control(
            'album_id',
            'posts_album',
            __( 'Album Default for Player', 'noo' ),
            '',
            array( 'preview_type' => 'custom' )

        );

    }
    add_action('customize_register','noo_customizer_register_options_album');
endif;


// 10. Custom Post Type options
if ( ! function_exists( 'noo_customizer_register_options_post_type' ) ) :
	function noo_customizer_register_options_post_type( $wp_customize ) {
		global $noo_post_types;
		if( empty( $noo_post_types ) ) return;

		// declare helper object.
		$helper = new NOO_Customizer_Helper( $wp_customize );

		foreach ($noo_post_types as $post_type => $args) {
			if( !isset( $args['customizer'] ) || empty( $args['customizer'] ) )
				continue;

			$pt_customizer = $args['customizer'];

			$pt_customizer['panel'] = isset( $pt_customizer['panel'] ) ? $pt_customizer['panel'] : array( 'single' );

			$helper->add_section(
				array(
					'id' => "noo_customizer_section_{$post_type}",
					'label' => $args['name'],
					'description' => sprintf( __( 'Firstly assign a page as your %s page from dropdown list. %s page can be any page. Once you chose a page as %s Page, its slug will be your %s\'s main slug.', 'noo' ), $args['name'], $args['name'], $args['name'], $args['name'] ),
					'is_panel' => count( $pt_customizer['panel'] ) > 1
				)
			);

			if( in_array('list', $pt_customizer['panel'] ) ) {
				// Sub-section: List
				$helper->add_sub_section(
					"{$post_type}_archive_sub_section",
					sprintf( __( 'List %s', 'noo' ), $args['name'] )
				);
			}

			if( in_array('page', $pt_customizer) ) {
				// Control: Post type Page
				$helper->add_control(
					array(
						'id' => "{$post_type}_archive_page",
						'type' => 'pages_select',
						'label' => sprintf( __( '%s Page', 'noo' ), $args['name'] ),
						'default' => '',
					)
				);
			}

			if( in_array('heading-title', $pt_customizer) ) {
				$default = isset( $args['heading-title'] ) ? $args['heading-title'] : sprintf( __( '%s List', 'noo' ), $args['name'] );

				// Control: Heading Title
				$helper->add_control(
					array(
						'id' => "{$post_type}_heading_title",
						'type' => 'text',
						'label' => sprintf( __( '%s Heading Title', 'noo' ), $args['name'] ),
						'default' => $default,
					)
				);
			}

			if( in_array('heading-image', $pt_customizer) ) {
				// Control: Heading Title
				$helper->add_control(
					array(
						'id' => "{$post_type}_heading_image",
						'type' => 'noo_image',
						'label' => sprintf( __( '%s Heading Background Image', 'noo' ), $args['name'] ),
						'default' => '',
					)
				);
			}

			if( in_array('list-layout', $pt_customizer) ) {
				// Control: List Layout
				$helper->add_control(
					array(
						'id' => "{$post_type}_archive_layout",
						'type' => 'noo_radio',
						'label' => sprintf( __( '%s List Layout', 'noo' ), $args['name'] ),
						'default' => 'sidebar',
						'control' => array(
								'choices' => array(
									'fullwidth'   => __( 'Full-Width', 'noo' ),
									'sidebar'   => __( 'With Right Sidebar', 'noo' ),
									'left_sidebar'   => __( 'With Left Sidebar', 'noo' )
								),
								'json' => array(
									'child_options' => array(
										'fullwidth'   => '',
										'sidebar'   => "{$post_type}_archive_sidebar",
										'left_sidebar'   => "{$post_type}_archive_sidebar"
									)
								)
							),
					)
				);

				// Control: Event List Sidebar
				$helper->add_control(
					array(
						'id' => "{$post_type}_archive_sidebar",
						'type' => 'widgets_select',
						'label' => sprintf( __( '%s List Sidebar', 'noo' ), $args['name'] ),
						'default' => 'sidebar-main',
					)
				);
			}

			if( in_array('layout', $pt_customizer) ) {
				// Control: List Layout
				$helper->add_control(
					array(
						'id' => "{$post_type}_archive_layout",
						'type' => 'noo_radio',
						'label' => sprintf( __( '%s Layout', 'noo' ), $args['name'] ),
						'default' => 'sidebar',
						'control' => array(
								'choices' => array(
									'fullwidth'   => __( 'Full-Width', 'noo' ),
									'sidebar'   => __( 'With Right Sidebar', 'noo' ),
									'left_sidebar'   => __( 'With Left Sidebar', 'noo' )
								),
								'json' => array(
									'child_options' => array(
										'fullwidth'   => '',
										'sidebar'   => "{$post_type}_archive_sidebar",
										'left_sidebar'   => "{$post_type}_archive_sidebar"
									)
								)
							),
					)
				);

				// Control: Event List Sidebar
				$helper->add_control(
					array(
						'id' => "{$post_type}_archive_sidebar",
						'type' => 'widgets_select',
						'label' => sprintf( __( '%s Sidebar', 'noo' ), $args['name'] ),
						'default' => 'sidebar-main',
					)
				);
			}

			do_action( "{$post_type}_archive_customizer", $wp_customize );

			if( in_array('list_num', $pt_customizer) ) {
				// Control: Number of Item per Page
				$helper->add_control(
					array(
						'id' => "{$post_type}_num",
						'type' => 'ui_slider',
						'label' => __( 'Items Per Page', 'noo' ),
						'8',
		 				'control' => array(
		 					'json' => array(
		 						'data_min'  => '4',
		 						'data_max'  => '50',
		 						'data_step' => '2'
		 					)
		 				),
					)
				);
			}

			if( in_array('single', $pt_customizer['panel'] ) ) {
				// Sub-section: Single
				$helper->add_sub_section(
					"{$post_type}_single_sub_section",
					sprintf( __( 'Single %s', 'noo' ), $args['singular_name'] )
				);
			}

			if( in_array('single-layout', $pt_customizer) ) {
				// Control: Single Layout
				$helper->add_control(
					array(
						'id' => "{$post_type}_single_layout",
						'type' => 'noo_same_as_radio',
						'label' => sprintf( __( 'Single %s Layout', 'noo' ), $args['singular_name'] ),
						'default' => "same_as_archive",
						'control' => array(
								'choices' => array(
									"same_as_archive"   => sprintf( __( 'Same as %s List Layout', 'noo' ), $args['name'] ),
									'fullwidth'   => __( 'Full-Width', 'noo' ),
									'sidebar'   => __( 'With Right Sidebar', 'noo' ),
									'left_sidebar'   => __( 'With Left Sidebar', 'noo' ),
								),
								'json' => array(
									'child_options' => array(
										'fullwidth'   => '',
										'sidebar'   => "{$post_type}_single_sidebar",
										'left_sidebar'   => "{$post_type}_single_sidebar",
									)
								)
							),
					)
				);

				// Control: Single Sidebar
				$helper->add_control(
					array(
						'id' => "{$post_type}_single_sidebar",
						'type' => 'widgets_select',
						'label' => sprintf( __( '%s Sidebar', 'noo' ), $args['singular_name'] ),
						'default' => 'sidebar-main',
					)
				);
			}



			do_action( "{$post_type}_single_customizer", $wp_customize );

			if( in_array('single-social', $pt_customizer) ) {
				$helper->add_control(
				 	array(
						'id' => "{$post_type}_single_divider_1",
						'type' => 'divider'
					)
				);

				// Control: Enable Social Sharing
		        $helper->add_control(
		        	array(
						'id' => "{$post_type}_single_social",
						'type' => 'noo_switch',
						'label' => __( 'Enable Social Sharing', 'noo' ),
						'default' => 1,
						'control' => array(
			                'json' => array( 'on_child_options' => "{$post_type}_single_social_facebook,
					                                                {$post_type}_single_social_twitter,
					                                                {$post_type}_single_social_google,
					                                                {$post_type}_single_social_pinterest,
					                                                {$post_type}_single_social_linkedin"
			                )
			            )
					)
		        );

				// Control: Facebook Share
				$helper->add_control(
					array(
						'id' => "{$post_type}_single_social_facebook",
						'type' => 'noo_switch',
						'label' => __( 'Facebook Share', 'noo' ),
						'default' => 1,
					)
				);

				// Control: Twitter Share
				$helper->add_control(
					array(
						'id' => "{$post_type}_single_social_twitter",
						'type' => 'noo_switch',
						'label' => __( 'Twitter Share', 'noo' ),
						'default' => 1,
					)
				);

				// Control: Google+ Share
				$helper->add_control(
					array(
						'id' => "{$post_type}_single_social_google",
						'type' => 'noo_switch',
						'label' => __( 'Google+ Share', 'noo' ),
						'default' => 1,
					)
				);

				// Control: Pinterest Share
				$helper->add_control(
					array(
						'id' => "{$post_type}_single_social_pinterest",
						'type' => 'noo_switch',
						'label' => __( 'Pinterest Share', 'noo' ),
						'default' => 1,
					)
				);

				// Control: LinkedIn Share
				$helper->add_control(
					array(
						'id' => "{$post_type}_single_social_linkedin",
						'type' => 'noo_switch',
						'label' => __( 'LinkedIn Share', 'noo' ),
						'default' => 1,
					)
				);
			}
		}
        
	}
	add_action( 'customize_register', 'noo_customizer_register_options_post_type' );
endif;

 //12. WooCommerce options.
 if( NOO_WOOCOMMERCE_EXIST ) :
 	if ( ! function_exists( 'noo_customizer_register_options_woocommerce' ) ) :
 		function noo_customizer_register_options_woocommerce( $wp_customize ) {

 			// declare helper object.
 			$helper = new NOO_Customizer_Helper( $wp_customize );

 			// Section: Revolution Slider
 			$helper->add_section(
 				'noo_customizer_section_shop',
 				__( 'WooCommerce', 'noo' ),
 				'',
 				true
 			);

 			// Sub-section: Shop Page
 			$helper->add_sub_section(
 				'noo_woocommerce_sub_section_shop_page',
 				__( 'Shop Page', 'noo' ),
 				__( 'Choose Layout and Headline Settings for your Shop Page.', 'noo' )
 			);

 			// Control: Shop Layout
 			$helper->add_control(
 				'noo_shop_layout',
 				'noo_radio',
 				__( 'Shop Layout', 'noo' ),
 				'fullwidth',
 				array(
 					'choices' => array(
 						'fullwidth'   => __( 'Full-Width', 'noo' ),
 						'sidebar'   => __( 'With Right Sidebar', 'noo' ),
 						'left_sidebar'   => __( 'With Left Sidebar', 'noo' )
 					),
 					'json' => array(
 						'child_options' => array(
 							'fullwidth'   => '',
 							'sidebar'   => 'noo_shop_sidebar',
 							'left_sidebar'   => 'noo_shop_sidebar',
 						)
 					)
 				)
 			);

 			// Control: Shop Sidebar
 			$helper->add_control(
 				'noo_shop_sidebar',
 				'widgets_select',
 				__( 'Shop Sidebar', 'noo' ),
 				''
 			);

 			// Control: Divider 1
 			$helper->add_control( 'noo_shop_divider_1', 'divider', '' );

 			// Control: Heading Image
 			$helper->add_control(
 				'noo_shop_heading_image',
 				'noo_image',
 				__( 'Heading Background Image', 'noo' ),
 				''
 			);


 			// Control: Number of Product per Page
 			$helper->add_control(
 				'noo_shop_num',
 				'ui_slider',
 				__( 'Products Per Page', 'noo' ),
 				'12',
 				array(
 					'json' => array(
 						'data_min'  => 4,
 						'data_max'  => 50,
 						'data_step' => 2
 					)
 				)
 			);

 			// Sub-section: Single Product
 			$helper->add_sub_section(
 				'noo_woocommerce_sub_section_product',
 				__( 'Single Product', 'noo' )
 			);

 			// Control: Product Layout
 			$helper->add_control(
 				'noo_woocommerce_product_layout',
 				'noo_same_as_radio',
 				__( 'Product Layout', 'noo' ),
 				'same_as_shop',
 				array(
 					'choices' => array(
 						'same_as_shop'   => __( 'Same as Shop Layout', 'noo' ),
 						'fullwidth'   => __( 'Full-Width', 'noo' ),
 						'sidebar'   => __( 'With Right Sidebar', 'noo' ),
 						'left_sidebar'   => __( 'With Left Sidebar', 'noo' ),
 					),
 					'json' => array(
 						'child_options' => array(
 							'fullwidth'   => '',
 							'sidebar'   => 'noo_woocommerce_product_sidebar',
 							'left_sidebar'   => 'noo_woocommerce_product_sidebar',
 						)
 					)
 				)
 			);

 			// Control: Product Sidebar
 			$helper->add_control(
 				'noo_woocommerce_product_sidebar',
 				'widgets_select',
 				__( 'Product Sidebar', 'noo' ),
 				''
 			);

 			// Control: Products related
 		    $helper->add_control(
 			    'noo_woocommerce_product_related',
 			    'text',
 			    __( 'Related Products Count', 'noo' ),
 			    ''
 		    );

 		}
 	add_action( 'customize_register', 'noo_customizer_register_options_woocommerce' );
 	endif;
 endif;

 // 13. Revolution Slider options.
 if ( ! function_exists( 'noo_customizer_register_options_rev_slider' ) ) :
 	function noo_customizer_register_options_rev_slider( $wp_customize ) {

 		// declare helper object.
 		$helper = new NOO_Customizer_Helper( $wp_customize );

 		// Section: Revolution Slider
 		$helper->add_section(
 			'noo_customizer_section_rev_slider',
 			__( 'Revolution Slider', 'noo' )
 		);

 	}
 add_action( 'customize_register', 'noo_customizer_register_options_rev_slider' );
 endif;


// 15. Custom Code
if ( ! function_exists( 'noo_customizer_register_options_custom_code' ) ) :
	function noo_customizer_register_options_custom_code( $wp_customize ) {

		// declare helper object.
		$helper = new NOO_Customizer_Helper( $wp_customize );

		// Section: Custom Code
		$helper->add_section(
			'noo_customizer_section_custom_code',
			__( 'Custom Code', 'noo' ),
			__( 'In this section you can add custom JavaScript and CSS to your site.<br/>Your Google analytics tracking code should be added to Custom JavaScript field.', 'noo' )
		);

		// Control: Custom JS (Google Analytics)
		$helper->add_control(
			'noo_custom_javascript',
			'textarea',
			__( 'Custom JavaScript', 'noo' ),
			'',
			array( 'preview_type' => 'custom' )
		);

		// Control: Custom CSS
		$helper->add_control(
			'noo_custom_css',
			'textarea',
			__( 'Custom CSS', 'noo' ),
			'',
			array( 'preview_type' => 'custom' )
		);
	}
add_action( 'customize_register', 'noo_customizer_register_options_custom_code' );
endif;