<?php
/**
 * Helper functions for NOO Framework.
 * Function for getting view files. There's two kind of view files,
 * one is default view from framework, the other is view from specific theme.
 * File from specific theme will override that from framework.
 *
 * @package    NOO Framework
 * @version    1.0.0
 * @author     Kan Nguyen <khanhnq@nootheme.com>
 * @copyright  Copyright (c) 2014, NooTheme
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       http://nootheme.com
 */


if( !function_exists( 'noo_get_post_meta' ) ) {
	// Normal get option
	function noo_get_post_meta( $post_ID, $meta_key, $default = null ) {
		$post_ID = (null === $post_ID) ? get_the_ID() : $post_ID;

		$value = get_post_meta( $post_ID, $meta_key, true );

		// Sanitize for on/off checkbox
		$value = ( $value == 'off' ? false : $value );
		$value = ( $value == 'on' ? true : $value );
		if( ( $value === null || $value === '' ) && ( $default != null && $default != '' ) ) {
			$value = $default;
		}

		return apply_filters( 'noo_post_meta', $value, $post_ID, $meta_key, $default );
	}
}

if( !function_exists( 'noo_is_archive' ) ) {
	function noo_is_archive( $post_type = '' ) {
		if( empty( $post_type ) ) return false;
		if( is_post_type_archive( $post_type ) ) 
			return true;

		global $noo_post_types;
		if( empty( $noo_post_types ) || !isset($noo_post_types[$post_type]) || !isset($noo_post_types[$post_type]['taxonomy']) ) {
			return false;
		}

		foreach ($noo_post_types[$post_type]['taxonomy'] as $taxonomy) {
			if( is_tax($taxonomy) ) return true;
		}
	}
}

if( !function_exists('noo_get_term_meta') ) :
	function noo_get_term_meta( $term_id = null, $meta_key = '', $default = null ) {
		if( empty( $term_id ) || empty( $meta_key) ) {
			return null;
		}

		$term_meta = get_option( 'taxonomy_' . $term_id );
		$value = isset( $term_meta[$meta_key] ) ? $term_meta[$meta_key] : null;

		if( ( $value === null || $value === '' ) && ( $default != null && $default != '' ) ) {
			$value = $default;
		}

		return apply_filters( 'noo_term_meta', $value, $term_id, $meta_key, $default );
	}
endif;