<?php
/**
 * NOO Framework Site Package.
 *
 * Register Style
 * This file register & enqueue style used in NOO Themes.
 *
 * @package    NOO Framework
 * @version    1.0.0
 * @author     Kan Nguyen <khanhnq@nootheme.com>
 * @copyright  Copyright (c) 2014, NooTheme
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       http://nootheme.com
 */
// =============================================================================

if ( ! function_exists( 'noo_enqueue_site_style' ) ) :
	function noo_enqueue_site_style() {

		if ( ! is_admin() ) {

			// URI variables.
			$get_stylesheet_directory_uri = get_stylesheet_directory_uri();
			$get_template_directory_uri   = get_template_directory_uri();

			// Main style
			wp_register_style( 'noo-style', $get_stylesheet_directory_uri . '/style.css', NULL, NULL, 'all' );

			wp_register_style( 'noo-main-style', NOO_ASSETS_URI . '/css/noo.css', NULL, NULL, 'all' );
			if( is_file( noo_upload_dir() . '/custom.css' ) ) {
				wp_register_style( 'noo-custom-style', noo_upload_url() . '/custom.css', NULL, NULL, 'all' );
			}
			wp_enqueue_style( 'noo-main-style' );

			if(noo_get_option('noo_theme_style', 'dark') == 'light'){
				wp_enqueue_style( 'noo-theme-light', NOO_ASSETS_URI . '/css/theme-light.css', NULL, NULL, 'all' );
			}
			
			// //woocommerce
			if(NOO_WOOCOMMERCE_EXIST)
				wp_enqueue_style('noo-woocommerce',NOO_ASSETS_URI."/css/woocommerce.css",null,null,'all');

			if( ! noo_get_option('noo_use_inline_css', false) && wp_style_is( 'noo-custom-style', 'registered' ) ) {
				global $wp_customize;
				if ( !isset( $wp_customize ) ) {
					 wp_enqueue_style( 'noo-custom-style' );
				}
			}

			wp_enqueue_style( 'noo-style' ); // place style.css here so that child theme can use custom css inside it.
			
			// Vendors
			// Font Awesome
			wp_register_style( 'vendor-font-awesome-css', NOO_VENDOR_URI . '/fontawesome/css/font-awesome.min.css',array(),'4.2.0');
			wp_enqueue_style( 'vendor-font-awesome-css' );
			wp_register_style( 'vendor-nivo-lightbox-css', NOO_VENDOR_URI . '/nivo-lightbox/nivo-lightbox.css', array( ), null );
			wp_register_style( 'vendor-nivo-lightbox-default-css', NOO_VENDOR_URI . '/nivo-lightbox/themes/default/default.css', array( 'vendor-nivo-lightbox-css' ), null );
			wp_register_style( 'vendor-fancybox-lightbox-default-css', NOO_VENDOR_URI . '/fancybox-lightbox/source/jquery.fancybox.css', '', null );


            wp_register_style( 'YTPlayer-css', NOO_ASSETS_URI . '/css/jquery.mb.YTPlayer.min.css',array(),'4.2.0');
            wp_enqueue_style('YTPlayer-css');

            wp_register_style( 'owl_carousel',  NOO_ASSETS_URI . '/css/owl.carousel.css', NULL, NULL, 'all');
            wp_register_style( 'owl_theme',  NOO_ASSETS_URI . '/css/owl.theme.css', NULL, NULL, 'all');
            wp_enqueue_style('owl_carousel');
            wp_enqueue_style('owl_theme');
			// Enqueue Fonts.
			$default_font         = noo_get_theme_default( 'font_family' );

			$protocol             = is_ssl() ? 'https' : 'http';

			$body_font_family     = noo_get_theme_default( 'font_family' );
			$headings_font_family = noo_get_theme_default( 'headings_font_family' );
			$nav_font_family      = noo_get_theme_default( 'nav_font_family' );
			$logo_font_family     = noo_get_theme_default( 'logo_font_family' );

			$body_font_subset     = '';
			$headings_font_subset = '';
			$nav_font_subset      = '';
			$logo_font_subset     = '';

			$font_in_used		  = array();

			$typo_use_custom_font = noo_get_option( 'noo_typo_use_custom_fonts', false );
			if( $typo_use_custom_font ) {
				$body_font_family		= noo_get_option( 'noo_typo_body_font', '' );
				$body_font_subset		= noo_get_option( 'noo_typo_body_font_subset', 'latin' );

				$headings_font_family   = noo_get_option( 'noo_typo_headings_font', '' );
				$headings_font_subset   = noo_get_option( 'noo_typo_headings_font_subset', 'latin' );
			}
			
			$nav_custom_font        = noo_get_option( 'noo_header_custom_nav_font', false );
			if( $nav_custom_font ) {
				$nav_font_family    = noo_get_option( 'noo_header_nav_font', '' );
				$nav_font_subset    = noo_get_option( 'noo_header_nav_font_subset', 'latin' );
			}

			$use_image_logo         = noo_get_option( 'noo_header_use_image_logo', false );
			if( ! $use_image_logo ) {
				$logo_font_family   = noo_get_option( 'noo_header_logo_font', '' );
				$logo_font_subset   = noo_get_option( 'noo_header_logo_font_subset', 'latin' );
			}

			if ( ! empty( $body_font_family ) ) {
				$font_in_used[]	 = $body_font_family;

				$font      = str_replace( ' ', '+', $body_font_family ) . ':' . '100,300,400,700,900,300italic,400italic,700italic,900italic';
				$subset    = !empty( $body_font_subset ) ? '&subset=' . $body_font_subset : '';

				wp_enqueue_style( 'noo-google-fonts-body', "{$protocol}://fonts.googleapis.com/css?family={$font}{$subset}", false, null, 'all' );
			}

			if ( ! empty( $headings_font_family ) && !in_array($headings_font_family, $font_in_used) ) {
				$font_in_used[]	 = $headings_font_family;

				$font      = str_replace( ' ', '+', $headings_font_family ) . ':' . '100,300,400,700,900,300italic,400italic,700italic,900italic';
				$subset    = !empty( $headings_font_subset ) ? '&subset=' . $headings_font_subset : '';

				wp_enqueue_style( 'noo-google-fonts-headings', "{$protocol}://fonts.googleapis.com/css?family={$font}{$subset}", false, null, 'all' );
			}

			if ( ! empty( $nav_font_family ) && !in_array($nav_font_family, $font_in_used) ) {
				// $font_in_used[]	 = $nav_font_family;
				$nav_font_weight  = noo_get_option( 'noo_header_nav_font_weight', '700' );
				$nav_font_style   = noo_get_option( 'noo_header_nav_font_style', 'italic' );

				$font      = str_replace( ' ', '+', $nav_font_family ) . ':' . $nav_font_weight . $nav_font_style;
				$subset    = !empty( $nav_font_subset ) ? '&subset=' . $nav_font_subset : '';

				wp_enqueue_style( 'noo-google-fonts-nav', "{$protocol}://fonts.googleapis.com/css?family={$font}{$subset}", false, null, 'all' );
			}

			if ( !empty( $logo_font_family ) && !in_array($logo_font_family, $font_in_used) ) {
				// $font_in_used[]	 = $logo_font_family;
				$logo_font_weight     = noo_get_option( 'noo_header_logo_font_weight', '700' );
				$logo_font_style      = noo_get_option( 'noo_header_logo_font_style', 'italic' );

				$font      = str_replace( ' ', '+', $logo_font_family ) . ':' . $logo_font_weight . $logo_font_style;
				$subset    = !empty( $logo_font_subset ) ? '&subset=' . $logo_font_subset : '';

				wp_enqueue_style( 'noo-google-fonts-logo', "{$protocol}://fonts.googleapis.com/css?family={$font}{$subset}", false, null, 'all' );
			}
			wp_enqueue_style('vendor-nivo-lightbox-default-css');

			
			// // Default font
			// $default_font_family = !empty( $default_font ) ? str_replace( ' ', '+', $default_font ) . ':' . '100,300,400,700,900,300italic,400italic,700italic,900italic' : '';
			// wp_enqueue_style( 'noo-google-fonts-default', "{$protocol}://fonts.googleapis.com/css?family={$default_font_family}", false, null, 'all' );
			
			//
			// Unused style
			//
			// De-register Contact Form 7 Styles
			if ( class_exists( 'WPCF7_ContactForm' ) ) :
			    wp_deregister_style( 'contact-form-7' );
			endif;

			/*
			 * RTL Support
			 */

			if ( is_rtl() ) :

			   	wp_enqueue_style( 'noo-style-rtl', get_stylesheet_directory_uri() .'/rtl.css' );

			endif;
		
		}
	}
add_action( 'wp_enqueue_scripts', 'noo_enqueue_site_style' );
endif;
