<?php
/**
 * NOO Framework Site Package.
 *
 * Register Script
 * This file register & enqueue scripts used in NOO Themes.
 *
 * @package    NOO Framework
 * @version    1.0.0
 * @author     Kan Nguyen <khanhnq@nootheme.com>
 * @copyright  Copyright (c) 2014, NooTheme
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       http://nootheme.com
 */
// =============================================================================

//
// Site scripts
//
if ( ! function_exists( 'noo_enqueue_site_scripts' ) ) :
	function noo_enqueue_site_scripts() {

		// Main script

		// vendor script
		wp_register_script( 'vendor-modernizr', NOO_VENDOR_URI . '/modernizr-2.7.1.min.js', null, null, false );
		wp_register_script( 'vendor-touchSwipe', NOO_VENDOR_URI . '/jquery.touchSwipe.js', array( 'jquery' ), null, true );
		wp_register_script( 'vendor-bootstrap', NOO_VENDOR_URI . '/bootstrap.min.js', array( 'vendor-touchSwipe' ), null, true );
		
		wp_register_script( 'vendor-hoverIntent', NOO_VENDOR_URI . '/hoverIntent-r7.min.js', array( 'jquery' ), null, true );
		wp_register_script( 'vendor-superfish', NOO_VENDOR_URI . '/superfish-1.7.4.min.js', array( 'jquery', 'vendor-hoverIntent' ), null, true );
    	wp_register_script( 'vendor-jplayer', NOO_VENDOR_URI . '/jplayer/jplayer-2.5.0.min.js', array( 'jquery' ), null, true );
		
		wp_register_script( 'vendor-imagesloaded', NOO_VENDOR_URI . '/imagesloaded.pkgd.min.js', null, null, true );
		wp_register_script( 'vendor-isotope', NOO_VENDOR_URI . '/jquery.isotope.min.js', array('vendor-imagesloaded'), null, true );
		wp_register_script( 'vendor-masonry', NOO_VENDOR_URI . '/masonry.pkgd.min.js', array('vendor-imagesloaded'), null, true );
		wp_register_script( 'vendor-infinitescroll', NOO_VENDOR_URI . '/infinitescroll-2.0.2.min.js', null, null, true );
		wp_register_script( 'vendor-carouFredSel-touchSwipe', NOO_VENDOR_URI . '/carouFredSel/helper-plugins/jquery.touchSwipe.min.js', array( 'jquery' ), null, true );
		wp_register_script( 'vendor-carouFredSel', NOO_VENDOR_URI . '/carouFredSel/jquery.carouFredSel-6.2.1-packed.js', array( 'jquery', 'vendor-carouFredSel-touchSwipe','vendor-imagesloaded' ), null, true );
		
		wp_register_script( 'vendor-easing', NOO_VENDOR_URI . '/easing-1.3.0.min.js', array( 'jquery' ), null, true );
		wp_register_script( 'vendor-appear', NOO_VENDOR_URI . '/jquery.appear.js', array( 'jquery','vendor-easing' ), null, true );
		wp_register_script( 'vendor-countTo', NOO_VENDOR_URI . '/jquery.countTo.js', array( 'jquery', 'vendor-appear' ), null, true );
		wp_register_script( 'vc_pie_custom', NOO_ASSETS_URI . '/js/jquery.vc_chart.custom.js',array('jquery','progressCircle','vendor-appear'), null, true);
		
		wp_register_script( 'vendor-nivo-lightbox-js', NOO_VENDOR_URI . '/nivo-lightbox/nivo-lightbox.min.js', array( 'jquery' ), null, true );
		wp_register_script( 'vendor-fancybox-lightbox-js', NOO_VENDOR_URI . '/fancybox-lightbox/source/jquery.fancybox.pack.js', array( 'jquery' ), null, true );
		
		wp_register_script( 'vendor-parallax', NOO_VENDOR_URI . '/jquery.parallax-1.1.3.js', array( 'jquery'), null, true );

        wp_register_script( 'vendor-countdown-plugin', NOO_VENDOR_URI . '/countdown/jquery.plugin.min.js', array( 'jquery' ), null, true );
        wp_register_script( 'vendor-countdown-js', NOO_VENDOR_URI . '/countdown/jquery.countdown.min.js', array( 'jquery' ), null, true );
        wp_register_script( 'vendor-YTPlayer-js', NOO_VENDOR_URI . '/ytplayer/jquery.mb.YTPlayer.min.js', array( 'jquery' ), null, true );

		//wp_register_script( 'vendor-nicescroll', NOO_VENDOR_URI . '/nicescroll-3.5.4.min.js', array( 'jquery' ), null, true );

        wp_register_script( 'noo-category', NOO_ASSETS_URI . '/js/noo_category.js', array( 'jquery'), null, true );
        wp_register_script( 'noo-carousel', NOO_VENDOR_URI . '/owl.carousel.min.js', array( 'jquery'), null, true );

        wp_register_script( 'noo-tweenLite', NOO_VENDOR_URI . '/canvas_effect/TweenLite.min.js', array( 'jquery'), null, true );
        wp_register_script( 'noo-EasePack', NOO_VENDOR_URI . '/canvas_effect/EasePack.min.js', array( 'jquery'), null, true );
        wp_register_script( 'noo-rAF', NOO_VENDOR_URI . '/canvas_effect/rAF.js', array( 'jquery'), null, true );
        wp_register_script( 'noo-effect', NOO_VENDOR_URI . '/canvas_effect/effect.js', array( 'jquery'), null, true );

		wp_enqueue_script('vendor-carouFredSel');



        if( is_single() ){
            wp_enqueue_script( 'vendor-nivo-lightbox-js' );
        }
		
		// BigVideo scripts.
		wp_register_script( 'vendor-bigvideo-video',        NOO_VENDOR_URI . '/bigvideo/video-4.1.0.min.js',        array( 'jquery', 'jquery-ui-slider', 'vendor-imagesloaded' ), NULL, true );
		wp_register_script( 'vendor-bigvideo-bigvideo',     NOO_VENDOR_URI . '/bigvideo/bigvideo-1.0.0.min.js',     array( 'jquery', 'jquery-ui-slider', 'vendor-imagesloaded', 'vendor-bigvideo-video' ), NULL, true );
		// wp_register_script( 'noo-countdown',     NOO_VENDOR_URI . '/noo_countdown.js',, null, null, false );



		wp_register_script( 'noo-script', NOO_ASSETS_URI . '/js/noo_uncompressed.js', array( 'jquery','vendor-bootstrap', 'vendor-superfish', ), null, true );

		if ( ! is_admin() ) {
			wp_enqueue_script( 'vendor-modernizr' );
			
			// if( noo_get_option( 'noo_smooth_scrolling', true ) ) {
			// 	wp_enqueue_script('vendor-nicescroll');
			// }	

			// Required for nested reply function that moves reply inline with JS
			if ( is_singular() ) wp_enqueue_script( 'comment-reply' );

			// if ( is_post_type_archive( 'portfolio_project' ) || is_tax( 'portfolio_category') ) {
			// 	wp_enqueue_script('vendor-isotope');
			// }

			$is_shop				= NOO_WOOCOMMERCE_EXIST && is_shop();
			$is_project             = is_singular( 'portfolio_project' ) ? 'true' : 'false';
			$is_portfolio_attribute = is_tax( 'portfolio_tag' ) ? 'true' : 'false';
			$nooL10n = array(
				'ajax_url'        => admin_url( 'admin-ajax.php', 'relative' ),
				'ajax_finishedMsg'=>__('All posts displayed','noo'),
				'home_url'        => home_url( '/' ),
				'is_blog'         => is_home() ? 'true' : 'false',
				'is_archive'      => is_post_type_archive('post') ? 'true' : 'false',
				'is_single'       => is_single() ? 'true' : 'false',
                'is_event'        => is_singular( 'tribe_events' ) ? 'true' : 'false',
                'is_album'        => is_tax( 'album_genre' ) ? 'true' : 'false',
				// 'is_portfolio'    => is_post_type_archive( 'portfolio_project' ) || is_tax( 'portfolio_category') ? 'true' : 'false',
				// 'is_project'      => is_singular( 'portfolio_project' ) ? 'true' : 'false',
				'is_shop'         => NOO_WOOCOMMERCE_EXIST && is_shop() ? 'true' : 'false',
				'is_product'      => NOO_WOOCOMMERCE_EXIST && is_product() ? 'true' : 'false',
				'infinite_scroll_end_msg' => __('All posts displayed', 'noo')
			);

			global $noo_post_types;
			if( !empty( $noo_post_types ) ) {
				foreach ($noo_post_types as $post_type => $args) {
					$nooL10n['is_' . $post_type . '_archive'] = is_post_type_archive( $post_type ) ? 'true' : 'false';
					$nooL10n['is_' . $post_type . '_single'] = is_singular( $post_type ) ? 'true' : 'false';
				}
			}
			
			
			wp_localize_script('noo-script', 'nooL10n', $nooL10n);
			wp_enqueue_script( 'vendor-infinitescroll' );
			wp_enqueue_script( 'noo-script' );


            wp_enqueue_style( 'mediaelement' );
            wp_enqueue_script('mediaelement');
            wp_register_script( 'noo-player', NOO_ASSETS_URI . '/js/player.js', array(), null, true );

			$album_id     = noo_get_option('album_id');
			$default_list = '';
			$object       = '';
			$auto_play    = '';

            if( isset($album_id) && $album_id != '' ){
				$default_list = Noo_Album::default_song_to_playlist_data($album_id);
				$object       = Noo_Album::songs_to_playlist_data($album_id);
				$auto_play    = noo_get_option( 'noo_album_auto_play', true );
            }
            $nooPlayerL10n = array(
                'ajax_url'        => admin_url( 'admin-ajax.php', 'relative' ),
                'home_url'        => home_url( '/' ),
                'theme_dir'		  => get_template_directory(),
                'theme_uri'		  => get_template_directory_uri(),
                'default_list'    => $default_list,
                'object_noo'      => $object,
                'auto_play'		  => $auto_play
            );
            wp_enqueue_script('noo-player');
            wp_localize_script('noo-player', 'nooPlayerL10n', $nooPlayerL10n);
		}
	}
add_action( 'wp_enqueue_scripts', 'noo_enqueue_site_scripts' );
endif;
