<?php
/**
 * Function process social
 *
 * @package 	WeMusic
 * @author 		KENT <tuanlv@vietbrain.com>
 * @version 	1.0
 */

/**
 * Create class Noo_Data_Social
 * 
 * @author KENT <this>
 * @since this
 *
 */

if ( !class_exists( 'Noo_Data_Social' ) ) :

	class Noo_Data_Social{

		/**
         * A reference to an instance of this class.
         */
        private static $instance;

        public $social;

		/**
         * Returns an instance of this class. 
         */
        public static function get_instance() {

            if( null == self::$instance ) {
                    self::$instance = new Noo_Data_Social();
            } 
            return self::$instance;

        } 

        /**
         * Initializes the plugin by setting filters and administration functions.
         */
        private function __construct() {}

		/**
		 * Get Data From API's
		 *
		 * @author 		KENT <tuanlv@vietbrain.com>
		 * @version 	1.0
		 */
		public static function remove_get_data( $url , $json = true ) {

			$get_request 	= wp_remote_get( $url , array( 'timeout' => 18 , 'sslverify' => false ) );
			$request 		= wp_remote_retrieve_body( $get_request );
			if( $json ) $request = @json_decode( $request , true );
			return $request;

		}


		public static  function getList(&$params)
		{	
			$facebook = Noo_Data_Social::get_facebook();
			$twitter = Noo_Data_Social::get_twitter();
			$google = Noo_Data_Social::get_google();
			$youtube = Noo_Data_Social::get_youtube();
			$pinterest = Noo_Data_Social::get_pinterest();
			$vimeo = Noo_Data_Social::get_vimeo();
			$instagram = Noo_Data_Social::get_instagram();
			$soundcloud = Noo_Data_Social::get_soundcloud();

			$return = array();
				$return[] 	= $facebook;
				$return[] 	= $twitter;
				$return[]  	= $youtube;
				$return[] 	= $pinterest;
				$return[]   = $vimeo;
				$return[]   = $instagram;
				$return[]   = $soundcloud;
			return $return;
		}

		public static function time_count(&$params,$module_id){
			$cache_time_out = 5;
			$cache_time_out = $cache_time_out*3600;
			if(!isset($_SESSION['time_count_'.$module_id])){
			$_SESSION['time_count_'.$module_id] = time();
				if(!isset($_SESSION['social_count_'.$module_id])){
				$_SESSION['social_count_'.$module_id] = self::getList($params);
				}
			}
			elseif(time() - $_SESSION['time_count_'.$module_id] > $cache_time_out){
				$_SESSION['social_count_'.$module_id] = self::getList($params);
				// unset($_SESSION['time_count_'.$module_id]);
			}
			return $_SESSION['social_count_'.$module_id];
		}


		/**
		 * Get data facebook
		 *
		 * @author 		KENT <tuanlv@vietbrain.com>
		 * @version 	1.0
		 */
		public static function get_facebook() {

			$fb_id = Noo_Social_Counter::getSetting('facebook_id');
			$app_id = Noo_Social_Counter::getSetting('app_id');
			$app_secret=Noo_Social_Counter::getSetting('app_secret');
			$urls = 'https://graph.facebook.com/v2.7/'. $fb_id . '?fields=fan_count&access_token='. $app_id . '|' . $app_secret;

			$string = @file_get_contents( $urls );

			if($string) {

			$fan_count = json_decode( $string );

			$get_fan_count = $fan_count->fan_count;

			return $get_fan_count;
		}

		}
		/**
		 * Get data google
		 *
		 * @author 		KENT <tuanlv@vietbrain.com>
		 * @version 	1.0
		 */
		public static function get_google() {

			// $google_url = Noo_Social_Counter::getSetting( 'google_url' );
			$gplus_id =Noo_Social_Counter::getSetting( 'gplus_id' );
			$gplus_key = Noo_Social_Counter::getSetting( 'gplus_key' );
			
			$json_string = @file_get_contents('https://www.googleapis.com/plus/v1/people/'.$gplus_id.'?key='.$gplus_key);
	
			$json = json_decode($json_string, true);
			$followers_count = isset($json['circledByCount'])?$json['circledByCount']:0;
			return $followers_count;

		}


		/**
		 * Get data youtube
		 *
		 * @author 		KENT <tuanlv@vietbrain.com>
		 * @version 	1.0
		 */
		public static function get_youtube( $show = 'subscriber' ) {

			$youtube_url = Noo_Social_Counter::getSetting( 'youtube_url' );
			$youtube_api = Noo_Social_Counter::getSetting( 'youtube_api' );
			if ( !empty( $youtube_url ) || !empty( $youtube_api ) ) :

				$youtube_url  = @parse_url( $youtube_url );
				$youtube_user = str_replace( '/', '', $youtube_url['path'] );
				$data         = @self::remove_get_data( "https://www.googleapis.com/youtube/v3/channels?part=statistics&forUsername=$youtube_user&key=$youtube_api");
								
				if ( $show === 'subscriber' ) :

					return (int) $data['items'][0]['statistics']['subscriberCount'];

				elseif ( $show === 'views' ) :

					return (int) $data['items'][0]['statistics']['viewCount'];

				elseif ( $show === 'comment' ) :

					return (int) $data['items'][0]['statistics']['commentCount'];

				elseif ( $show === 'video' ) :

					return (int) $data['items'][0]['statistics']['videoCount'];

				endif;

			else :

				return 0;

			endif;

		}

		/**
		 * Get data twitter
		 *
		 * @author 		KENT <tuanlv@vietbrain.com>
		 * @version 	1.0
		 */
		public static function get_twitter( $show = 'count' ) {

			$twitter_user            = Noo_Social_Counter::getSetting( 'twitter_user' );
			$twitter_consumer_key    = Noo_Social_Counter::getSetting( 'twitter_consumer_key' );
			$twitter_consumer_secret = Noo_Social_Counter::getSetting( 'twitter_consumer_secret' );


			if ( !empty( $twitter_user ) || !empty( $twitter_consumer_key ) || !empty( $twitter_consumer_secret ) ) :

				$twitter_token = get_option( 'twitter_token' );

				if( empty( $twitter_token ) ) {
					// preparing credentials
					$credentials 	= $twitter_consumer_key . ':' . $twitter_consumer_secret;
					$toSend 		= base64_encode($credentials);

					// http post arguments
					$args = array(
						'method' 		=> 'POST',
						'httpversion' 	=> '1.1',
						'blocking' 		=> true,
						'headers'		=> array(
							'Authorization'	=> 'Basic ' . $toSend,
							'Content-Type' 	=> 'application/x-www-form-urlencoded;charset=UTF-8'
						),
						'body' 			=> array( 'grant_type' => 'client_credentials' )
					);

					add_filter('https_ssl_verify', '__return_false');
					$response = wp_remote_post('https://api.twitter.com/oauth2/token', $args);

					$keys = json_decode(wp_remote_retrieve_body($response));

					if( $keys ) {
						// saving token to wp_options table
						update_option( 'twitter_token', $keys->access_token );
						$twitter_token = $keys->access_token;
					}
				}

				$args = array(
					'httpversion' 	=> '1.1',
					'blocking' 		=> true,
					'headers' 		=> array(
						'Authorization' => "Bearer $twitter_token"
					)
				);

				add_filter('https_ssl_verify', '__return_false');
				$api_url 	= "https://api.twitter.com/1.1/users/show.json?screen_name=$twitter_user";
				$response 	= wp_remote_get($api_url, $args);

				if ( ! is_wp_error( $response ) ) {
					$followers 	= json_decode(wp_remote_retrieve_body($response));
					return isset($followers->followers_count) ? $followers->followers_count : 0;
				} else {
					return 0;
				}

			else :

				return 0;

			endif;

		}

		/**
		 * Get data behance
		 *
		 * @author 		KENT <tuanlv@vietbrain.com>
		 * @version 	1.0
		 */
		public static function get_behance( $show = 'followers' ) {

			$behance_url = Noo_Social_Counter::getSetting( 'behance_url' );
			$behance_api = Noo_Social_Counter::getSetting( 'behance_api' );
			
			if ( !empty( $behance_url ) || !empty( $behance_api ) ) :

		  //   	$behance_url  = @parse_url( $behance_url );
				// $behance_user = str_replace( '/', '', $behance_url['path'] );

			    if ( $show === 'followers' ) :
			    	
			    	// $data = @self::remove_get_data("http://www.behance.net/v2/users/$behance_user?api_key=$behance_api");

			    	// return (int) $data['user']['stats']['followers'];
			    	$data = file_get_contents( $behance_url );
				    if (is_wp_error($data)) {
				        return 0;
				    } else {
				        if (preg_match( '/class=\"js\-followers\-count\">(.*?)<\/a>/is', $data, $follow)) {
				            return wp_strip_all_tags( $follow[1] );
				        }
				        return 0;
				    }


			    else :

			    	return 0;

			    endif;

			else :

				return 0;

			endif;

		}

		/**
		 * Get data linkedin
		 *
		 * @author 		KENT <tuanlv@vietbrain.com>
		 * @version 	1.0
		 */
		// public static function get_linkedin( $show = 'count' ) {

		// 	$linkedin_url = Noo_Social_Counter::getSetting( 'linkedin_url' );			
		// 	if ( !empty( $url ) ) :

		//   		$url = urlencode($linkedin_url);
		// 		$json_string = @file_get_contents("http://www.linkedin.com/countserv/count/share?url=$url&format=json");
		// 		$json = json_decode($json_string, true);
		// 		$followers_count = $json['count'];
		// 		return $followers_count;

		// 	endif;

		// }

		/**
		 * Get data pinterest
		 *
		 * @author 		KENT <tuanlv@vietbrain.com>
		 * @version 	1.0
		 */
		public static function get_pinterest( $show = 'count' ) {

			$pinterest_url = Noo_Social_Counter::getSetting( 'pinterest_url' );
			
			if ( !empty( $pinterest_url ) ) :

		  		/* get source for custom +1 button */
			    $data = file_get_contents( 'http://api.pinterest.com/v1/urls/count.json?callback=&url==' .  $pinterest_url );

			    /* pull out count variable with regex */
			    preg_match( '/window\.__SSR = {c: ([\d]+)/', $data, $matches );

			    /* if matched, return count, else zed */
			    if( isset( $matches[0] ) )
			        return (int) str_replace( 'window.__SSR = {c: ', '', $matches[0] );
			    return 0;

			else :

				return 0;

			endif;

		}

		/**
		 * Get data vimeo
		 *
		 * @author 		KENT <tuanlv@vietbrain.com>
		 * @version 	1.0
		 */
		public static function get_vimeo( $show = 'subscribers' ) {

			$vimeo_url = Noo_Social_Counter::getSetting( 'vimeo_url' );
			
			if ( !empty( $vimeo_url ) ) :

				$vimeo_url  = @parse_url( $vimeo_url );
				$vimeo_user = str_replace( '/channels/', '', $vimeo_url['path'] );
				
				$data       = @self::remove_get_data( "http://vimeo.com/api/v2/channel/{$vimeo_user}/info.json" );

		  		if ( $show === 'id' ) :
					
					return (int) $data['id'];

				elseif ( $show === 'name' ) :

					return $data['name'];

				elseif ( $show === 'description' ) :

					return $data['description'];

				elseif ( $show === 'logo' ) :

					return $data['logo'];

				elseif ( $show === 'badge' ) :

					return $data['badge'];

				elseif ( $show === 'url' ) :

					return $data['url'];

				elseif ( $show === 'rss' ) :

					return $data['rss'];

				elseif ( $show === 'videos' ) :

					return (int) $data['total_videos'];

				elseif ( $show === 'subscribers' ) :

					return (int) $data['total_subscribers'];

				endif;

			else :

				return 0;

			endif;

		}

		/**
		 * Get data instagram
		 *
		 * @author 		KENT <tuanlv@vietbrain.com>
		 * @version 	1.0
		 */
		public static function get_instagram() {

			$userID = Noo_Social_Counter::getSetting( 'userID' );
			$access_token = Noo_Social_Counter::getSetting( 'access_token' );
			// $userID = $params->get('inst_userid');
			// $access_token = $params->get('inst_access_token');
			$ch = curl_init('https://api.instagram.com/v1/users/'.$userID.'?access_token='.$access_token);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
			$json_string = curl_exec($ch);
			curl_close($ch);
			// $json_string = @file_get_contents('https://api.instagram.com/v1/users/'.$userID.'?access_token='.$access_token);
			$json = json_decode($json_string, true);
			$followers_count = isset($json['data']['counts']['followed_by'])?$json['data']['counts']['followed_by']:0;
			return $followers_count;
		}

		/**
		 * Get data soundcloud
		 *
		 * @author 		KENT <tuanlv@vietbrain.com>
		 * @version 	1.0
		 */
		public static function get_soundcloud( $show = 'follows' ) {

			$soundcloud_url = Noo_Social_Counter::getSetting( 'soundcloud_url' );
			$soundcloud_api = Noo_Social_Counter::getSetting( 'soundcloud_api' );
			
			if ( !empty( $soundcloud_url ) && !empty( $soundcloud_api ) ) :

				$soundcloud_url  = @parse_url( $soundcloud_url );
				$soundcloud_user = str_replace( '/', '', $soundcloud_url['path'] );
				
				$data          = @self::remove_get_data( "http://api.soundcloud.com/users/$soundcloud_user.json?consumer_key=$soundcloud_api" );

		  		if ( $show === 'name' ) :

					return $data['username'];

				elseif ( $show === 'username' ) :

					return $data['permalink'];

				elseif ( $show === 'website' ) :

					return $data['website'];

				elseif ( $show === 'avatar' ) :

					return $data['avatar_url'];

				elseif ( $show === 'url' ) :

					return $data['permalink_url'];

				elseif ( $show === 'followed' ) :

					return (int) $data['followings_count'];

				elseif ( $show === 'follows' ) :

					return (int) $data['followers_count'];

				elseif ( $show === 'like' ) :

					return (int) $data['likes_count'];

				elseif ( $show === 'playlist' ) :

					return (int) $data['playlist_count'];

				elseif ( $show === 'track' ) :

					return (int) $data['track_count'];

				elseif ( $show === 'id' ) :

					return (int) $data['id'];

				else :

					return 0;

				endif;

			else :

				return 0;

			endif;

		}

		/**
		 * Get data dribbble
		 *
		 * @author 		KENT <tuanlv@vietbrain.com>
		 * @version 	1.0
		 */
		public static function get_dribbble() {

			$drbl_un = Noo_Social_Counter::getSetting( 'drbl_un' );
			$access_tokend = Noo_Social_Counter::getSetting( 'access_tokend' );
			
			// $drbl_un = $params->get('drbl_un', 'Facebook');
			// $access_tokend = $params->get('access_tokend', 'access_tokend');

			$json_string = @file_get_contents('https://api.dribbble.com/v1/users/'.$drbl_un.'?access_token='.$access_tokend.'');
			$json = json_decode($json_string, true);
			$followers_count = isset($json['followers_count'])?$json['followers_count']:0;
			return $followers_count;

		}

	}

	add_action( 'after_setup_theme', array( 'Noo_Data_Social', 'get_instance' ) );

endif;