<?php
if(!class_exists('Noo_Social_Counter')):
	class Noo_Social_Counter {

		public $settings_screen = null;
		public static $option_key = 'noo_social_counter';
		
		public function __construct(){
			// Adds admin menu.
			add_action( 'admin_menu', array( $this, 'settings_menu' ) );

			// Init plugin options form.
			add_action( 'admin_init', array( $this, 'plugin_settings' ) );

		}

		public static function getSetting( $id, $default = null ){
			$options = get_option(self::$option_key);
			if (isset($options[$id])) {
				return $options[$id];
			}
			return $default;
		}

		public function settings_menu() {
			$this->settings_screen = add_options_page(
				__( 'Social Counter', 'noo' ),
				__( 'Social Counter', 'noo' ),
				'manage_options',
				'noo-social-counter',
				array( $this, 'settings_page' )
			);
		}

		public function settings_page() {
			$screen = get_current_screen();

			if ( ! $this->settings_screen || $screen->id !== $this->settings_screen ) {
				return;
			}

			// Load the plugin options.
			$settings = get_option( self::$option_key );

			?>
			<div class="wrap">
				<h2 class="nav-tab-wrapper"><?php _e( 'Social Counter Settings', 'noo' ); ?></h2>

				<?php
					// if ( isset( $settings['twitter_active'] ) && (
					// 	empty( $settings['twitter_user'] )
					// 	|| empty( $settings['twitter_consumer_key'] )
					// 	|| empty( $settings['twitter_consumer_secret'] )
					// 	|| empty( $settings['twitter_access_token'] )
					// 	|| empty( $settings['twitter_access_token_secret'] )
					// ) ) :
				 ?>
					<!-- <div class="error">
						<p><?php _e( 'To use the counter of Twitter you need to fill the fields:', 'noo' ); ?></p>
						<ul style="list-style: disc; margin-left: 20px;">
							<li><strong><?php _e( 'Twitter username', 'noo' ); ?></strong></li>
							<li><strong><?php _e( 'Twitter Consumer key', 'noo' ); ?></strong></li>
							<li><strong><?php _e( 'Twitter Consumer secret', 'noo' ); ?></strong></li>
							<li><strong><?php _e( 'Twitter Access token', 'noo' ); ?></strong></li>
							<li><strong><?php _e( 'Twitter Access token secret', 'noo' ); ?></strong></li>
						</ul>
					</div> -->
				<?php //endif; ?>

				<form method="post" action="options.php">
					<?php
						settings_fields( self::$option_key );
						do_settings_sections( self::$option_key );
						submit_button();
					?>
				</form>
			</div>
			<?php
		}

		public function plugin_settings() {

			// Process the settings.
			foreach ( self::options_list() as $settings_id => $sections ) {

				// Create the sections.
				foreach ( $sections as $section_id => $section ) {
					add_settings_section(
						$section_id,
						$section['title'],
						'__return_false',
						$settings_id
					);

					// Create the fields.
					foreach ( $section['fields'] as $field_id => $field ) {
						switch ( $field['type'] ) {
							case 'text':
								add_settings_field(
									$field_id,
									$field['title'],
									array( $this, 'text_element_callback' ),
									$settings_id,
									$section_id,
									array(
										'tab'         => $settings_id,
										'id'          => $field_id,
										'class'       => 'regular-text',
										'description' => isset( $field['description'] ) ? $field['description'] : ''
									)
								);
								break;
							case 'checkbox':
								add_settings_field(
									$field_id,
									$field['title'],
									array( $this, 'checkbox_element_callback' ),
									$settings_id,
									$section_id,
									array(
										'tab'         => $settings_id,
										'id'          => $field_id,
										'description' => isset( $field['description'] ) ? $field['description'] : ''
									)
								);
								break;

							default:
								break;
						}
					}
				}

				// Register the setting.
				register_setting( $settings_id, $settings_id );
			}
		}

		public function text_element_callback( $args ) {
			$tab     = $args['tab'];
			$id      = $args['id'];
			$class   = isset( $args['class'] ) ? $args['class'] : 'small-text';
			$default = isset( $args['default'] ) ? $args['default'] : '';
			$current = $this->getSetting( $id, $default );
			$html    = sprintf( '<input type="text" id="%1$s" name="%2$s[%1$s]" value="%3$s" class="%4$s" />', $id, $tab, $current, $class );

			// Displays option description.
			if ( isset( $args['description'] ) ) {
				$html .= sprintf( '<p class="description">%s</p>', $args['description'] );
			}

			echo $html;
		}

		public function checkbox_element_callback( $args ) {
			$tab     = $args['tab'];
			$id      = $args['id'];
			$default = isset( $args['default'] ) ? $args['default'] : '';
			$current = $this->getSetting( $id, $default );
			$html    = sprintf( '<input type="checkbox" id="%1$s" name="%2$s[%1$s]" value="1"%3$s />', $id, $tab, checked( 1, $current, false ) );
			$html   .= sprintf( '<label for="%s"> %s</label></br>', $id, __( 'Activate/Deactivate', 'noo' ) );

			// Displays option description.
			if ( isset( $args['description'] ) ) {
				$html .= sprintf( '<p class="description">%s</p>', $args['description'] );
			}

			echo $html;
		}

		/**
		 *  Options list.
		 *
		 * @return array
		 */
		protected static function options_list() {
			$twitter_oauth_description = sprintf( __( 'Create an APP on Twitter in <a href="%s" target="_blank">https://dev.twitter.com/apps</a> and get this information', 'noo' ), 'https://dev.twitter.com/apps' );

			$settings = array(
				self::$option_key => array(
					'twitter' => array(
						'title'  => __( 'Twitter', 'noo' ),
						'fields' => array(
							'twitter_user' => array(
								'title'       => __( 'Twitter username', 'noo' ),
								'type'        => 'text',
								'description' => __( 'Insert the Twitter username. Example: nootheme', 'noo' )
							),
							'twitter_consumer_key' => array(
								'title'       => __( 'Twitter Consumer key', 'noo' ),
								'type'        => 'text',
								'description' => $twitter_oauth_description
							),
							'twitter_consumer_secret' => array(
								'title'       => __( 'Twitter Consumer secret', 'noo' ),
								'type'        => 'text',
								'description' => $twitter_oauth_description
							),
							// 'twitter_access_token' => array(
							// 	'title'       => __( 'Twitter Access token', 'noo' ),
							// 	'type'        => 'text',
							// 	'description' => $twitter_oauth_description
							// ),
							// 'twitter_access_token_secret' => array(
							// 	'title'       => __( 'Twitter Access token secret', 'noo' ),
							// 	'type'        => 'text',
							// 	'description' => $twitter_oauth_description
							// )
						)
					),
					'facebook' => array(
						'title'  => __( 'Facebook', 'noo' ),
						'fields' => array(
							'facebook_page' => array(
								'title'   => __( 'URL Fanpage', 'noo' ),
								'type'    => 'text',
								'description' => __( 'URL of Facebook page. The URL will be similar to this:</br><strong>https://www.facebook.com/NooTheme/</strong>', 'noo' )
							),
							'facebook_id' => array(
								'title'   => __( 'Fanpage ID', 'noo' ),
								'type'    => 'text',
								'description' => __( 'The URL will be similar to this:</br><strong>https://findmyfbid.com/</strong>', 'noo' )
							),
							'app_id' => array(
								'title'   => __( 'Facebook App Id', 'noo' ),
								'type'    => 'text',
								'description' => __( 'The URL will be similar to this:</br><strong>https://developers.facebook.com/</strong>', 'noo' )
							),
							'app_secret' => array(
								'title'   => __( 'Facebook App Secret', 'noo' ),
								'type'    => 'text',
								'description' => __( 'The URL will be similar to this:</br><strong>https://developers.facebook.com/</strong>', 'noo' )
							)
						)
					),
					'youtube' => array(
						'title'  => __( 'YouTube', 'noo' ),
						'fields' => array(
							'youtube_url' => array(
								'title'       => __( 'YouTube URl', 'noo' ),
								'type'        => 'text',
								'description' => __( 'Insert the YouTube URL. he URL will be similar to this:</br><strong>https://www.youtube.com/nootheme</strong>', 'noo' )
							),
							'youtube_api' => array(
								'title'       => __( 'Youtube API Key', 'noo' ),
								'type'        => 'text',
								'description' => __( 'Check this tutorial on how to get your youtube api key: http://valvepress.com/how-to-get-a-youtube-api-key-to-post-from-youtube-to-wordpress/', 'noo' )
							)
						)
					),
					'pinterest' => array(
						'title'  => __( 'Pinterest', 'noo' ),
						'fields' => array(
							'pinterest_url' => array(
								'title'       => __( 'Pinterest URl', 'noo' ),
								'type'        => 'text',
								'description' => __( 'Insert the Pinterest URl. he URL will be similar to this:</br><strong>https://www.pinterest.com/NOOTheme</strong>', 'noo' )
							)
						)
					),
					// 'linkedin' => array(
					// 	'title'  => __( 'LinkedIn', 'noo' ),
					// 	'fields' => array(
					// 		'linkedin_url' => array(
					// 			'title'       => __( 'LinkedIn URl', 'noo' ),
					// 			'type'        => 'text',
					// 			'description' => __( 'Insert the LinkedIn URl. he URL will be similar to this:</br><strong>https://www.linkedin.com/NOOTheme</strong>', 'noo' )
					// 		)
					// 	)
					// ),
					'googleplus' => array(
						'title'  => __( 'Google+', 'noo' ),
						'fields' => array(
							'google_url' => array(
								'title'       => __( 'Google+ URL', 'noo' ),
								'type'        => 'text',
								'description' => __( 'Google+ page URL. </br>Example:</br><strong>https://plus.google.com/100697928077686140656</strong>', 'noo' )
							),
							'gplus_id' => array(
								'title'       => __( 'Google+ ID', 'noo' ),
								'type'        => 'text',
								'description' => __( 'Example:</br>https://plus.google.com/<strong>100697928077686140656</strong>', 'noo' )
							),
							'gplus_key' => array(
								'title'       => __( 'Google+ Key Api', 'noo' ),
								'type'        => 'text',
								'description' => __( 'Get Google+ key Api:</br>https://console.developers.google.com/apis/library</strong>', 'noo' )
							)
						)
					),
					'instagram' => array(
						'title'  => __( 'Instagram', 'noo' ),
						'fields' => array(
							'instagram_url' => array(
								'title'       => __( 'Instagram Page', 'noo' ),
								'type'        => 'text',
								'description' => __( 'Insert the Instagram Page.', 'noo' )
							),'userID' => array(
								'title'       => __( 'User ID', 'noo' ),
								'type'        => 'text',
								'description' => __( 'Insert the user ID.', 'noo' )
							),
							'access_token' => array(
								'title'       => __( 'Access Token Instagram', 'noo' ),
								'type'        => 'text',
								'description' => __( 'Get Access Token Instagram:</br>https://instagram.pixelunion.net/</strong>', 'noo' )
							),
						)
					),
					'vimeo' => array(
						'title'  => __( 'Vimeo', 'noo' ),
						'fields' => array(
							'vimeo_url' => array(
								'title'       => __( 'Vimeo URL', 'noo' ),
								'type'        => 'text',
								'description' => __( 'Vimeo page URL.', 'noo' )
							)
						)
					),
					'dribbble' => array(
						'title'  => __( 'Dribbble', 'noo' ),
						'fields' => array(
							'dribbble_url' => array(
								'title'       => __( 'Dribbble URL', 'noo' ),
								'type'        => 'text',
								'description' => __( 'Dribbble page URL.', 'noo' )
							),'drbl_un' => array(
								'title'       => __( 'Dribbble Page', 'noo' ),
								'type'        => 'text',
								'description' => __( 'Dribbble Page.', 'noo' )
							),
							'access_tokend' => array(
								'title'       => __( 'Dribbble Access Token', 'noo' ),
								'type'        => 'text',
								'description' => __( 'Dribbble Access Token.', 'noo' )
							)
						)
					),
					'behance' => array(
						'title'  => __( 'Behance', 'noo' ),
						'fields' => array(
							'behance_url' => array(
								'title'       => __( 'Behance URL', 'noo' ),
								'type'        => 'text',
								'description' => __( 'Behance page URL.', 'noo' )
							),
							// 'behance_api' => array(
							// 	'title'       => __( 'Behance API', 'noo' ),
							// 	'type'        => 'text',
							// 	'description' => __( 'Insert the Behance API.', 'noo' )
							// )
						)
					),
					'soundcloud' => array(
						'title'  => __( 'SoundCloud', 'noo' ),
						'fields' => array(
							'soundcloud_url' => array(
								'title'       => __( 'SoundCloud URL', 'noo' ),
								'type'        => 'text',
								'description' => __( 'Insert the SoundCloud URL.', 'noo' )
							),
							'soundcloud_api' => array(
								'title'       => __( 'SoundCloud API Key', 'noo' ),
								'type'        => 'text',
								'description' => __( 'Insert the SoundCloud API Key', 'noo' )
							)
						)
					),
				),
			);

			return $settings;
		}
	}
	new Noo_Social_Counter();
endif;