<?php
/**
 * Register NOO Team.
 * This file register Item and Category for NOO Portfolio.
 *
 * @package    NOO Framework
 * @subpackage NOO Portfolio
 * @version    1.0.0
 * @author     Kan Nguyen <khanhnq@nootheme.com>
 * @copyright  Copyright (c) 2014, NooTheme
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       http://nootheme.com
 */

if ( ! function_exists('noo_init_team')) :
	function noo_init_team() {

		// Text for NOO team.
		$team_labels = array(
			'name' => __('Team Member', 'noo') ,
			'singular_name' => __('Team Member', 'noo') ,
			'menu_name' => __('Team Member', 'noo') ,
			'add_new' => __('Add New', 'noo') ,
			'add_new_item' => __('Add New Team Member Item', 'noo') ,
			'edit_item' => __('Edit Team Member Item', 'noo') ,
			'new_item' => __('Add New Team Member Item', 'noo') ,
			'view_item' => __('View Team Member', 'noo') ,
			'search_items' => __('Search Team Member', 'noo') ,
			'not_found' => __('No Team Member items found', 'noo') ,
			'not_found_in_trash' => __('No Team Member items found in trash', 'noo') ,
			'parent_item_colon' => ''
		);


		$team_slug = 'noo-team';

		// Options
		$team_args = array(
			'labels' => $team_labels,
			'public' => false,
			'publicly_queryable' => true,
            'show_in_nav_menus' => false,
			'show_ui' => true,
			'show_in_menu' => true,
			 'menu_position' => 5,
			'capability_type' => 'post',
			'hierarchical' => false,
			'supports' => array(
				'title',
				// 'editor',
				// 'excerpt',
				//'thumbnail',
				// 'comments',
				// 'custom-fields',
				'revisions'
			) ,
			'has_archive' => true,
			'rewrite' => array(
				'slug' => $team_slug,
				'with_front' => false
			)
		);
		
		register_post_type('team_member', $team_args);

		// Register a taxonomy for Project Categories.
		$category_labels = array(
			'name' => __('Team Categories', 'noo') ,
			'singular_name' => __('Team Category', 'noo') ,
			'menu_name' => __('Team Categories', 'noo') ,
			'all_items' => __('All Team Categories', 'noo') ,
			'edit_item' => __('Edit Team Category', 'noo') ,
			'view_item' => __('View Team Category', 'noo') ,
			'update_item' => __('Update Team Category', 'noo') ,
			'add_new_item' => __('Add New Team Category', 'noo') ,
			'new_item_name' => __('New Team Category Name', 'noo') ,
			'parent_item' => __('Parent Team Category', 'noo') ,
			'parent_item_colon' => __('Parent Team Category:', 'noo') ,
			'search_items' => __('Search Team Categories', 'noo') ,
			'popular_items' => __('Popular Team Categories', 'noo') ,
			'separate_items_with_commas' => __('Separate Team Categories with commas', 'noo') ,
			'add_or_remove_items' => __('Add or remove Team Categories', 'noo') ,
			'choose_from_most_used' => __('Choose from the most used Team Categories', 'noo') ,
			'not_found' => __('No Team Categories found', 'noo') ,
		);
		
		$category_args = array(
			'labels' => $category_labels,
			'public' => false,
			'show_ui' => true,
			'show_in_nav_menus' => false,
			'show_tagcloud' => false,
			'show_admin_column' => false,
			'hierarchical' => true,
			'query_var' => true,
			'rewrite' => array(
				'slug' => 'team_category',
				'with_front' => false
			) ,
		);
		
		register_taxonomy('team_category', array(
			'team_member'
		) , $category_args);


	}
endif;

add_action('init', 'noo_init_team');




