<?php

if ( ! class_exists( 'Noo_Album' ) ) :

	class Noo_Album {

		public function __construct() {
			add_filter( 'template_include', array( $this, 'template_loader' ) );
            add_shortcode('noo_album_masonry', array($this,'noo_album_masonry_shortcode'));

            add_action( 'init', array( &$this, 'album_reorder_by_month' ), 0 );
			if(!is_admin())
				add_action('wp_footer', array( &$this,'footer_player'));

		}

		public function album_reorder_by_month(){
			$month = date('m');
			$args = array(
				'post_type'				=> 'noo_album',
				'post_status' 			=> 'publish',
				'ignore_sticky_posts'	=> 1,
				'posts_per_page' 		=> -1,
			);
			$query = new WP_Query($args);
            if( $query->have_posts() ):
                while( $query->have_posts() ):
                    $query->the_post();
                	$postID = get_the_ID();

                	$album_month = get_post_meta($postID, 'album_month', true);

                	if ($month != $album_month || $album_month == '') {
                		delete_post_meta($postID, 'album_month');
        				add_post_meta($postID, 'album_month', $month);
        				delete_post_meta($postID, 'post_views_count');
        				add_post_meta($postID, 'post_views_count', '0');
                	}
                endwhile;
            endif;
		}

		public function template_loader( $template ) {
			if ( is_post_type_archive( 'noo_album' ) || is_tax( 'album_artist' ) || is_tax( 'album_genre' ) || is_tax( 'album_produced' ) || is_tax( 'album_tag' ) ) {
				$template = locate_template( 'archive-noo_album.php' );
			}
			return $template;
		}
		public static function songs_to_playlist_data($post_id){
			$songs = get_post_meta( $post_id, '_noo_songs', true );
			$song_arr = array();
			if($songs):
				if(has_post_thumbnail($post_id)){
					$thumb       = get_the_post_thumbnail( $post_id, 'thumbnail', array(
						'title' => esc_attr( get_the_title( get_post_thumbnail_id($post_id) ) )
						) );
				}else{
					$thumb = '<img src="'.get_template_directory_uri().'/assets/images/no-track-image.png">';
				}
				$soundcloud_id = get_option('soundcloud_client_id');
				$soundcloud_api = 'api.soundcloud.com';
				foreach ($songs as $k=>$song){
					
					$song_obj = new stdClass();
					$song_obj->id = $k;
					$song_obj->album_id = $post_id;
					$song_obj->artist = get_the_term_list($post_id,'album_artist', '', ', ', '');
					if( isset($song['author']) && !empty($song['author']) ) {
						$song_obj->artist = '<a href="javascript:void(0)">' . esc_html( $song['author'] ) . '</a>';
					}
					$song_obj->genre = get_the_term_list($post_id,'album_genre', '', ', ', '');

					// Check file from api soundcloud
					if ( strpos($song['file'], $soundcloud_api) !== false && !empty( $soundcloud_id ) ) {
						$soundcloud_track_id = 0;
						// Remove '/'
						$song['file'] = untrailingslashit($song['file']);
						$song_expl = explode('/', $song['file']);
						$soundcloud_track_id = end($song_expl);

						$song['file'] = 'https://api.soundcloud.com/tracks/' . $soundcloud_track_id . '/stream?client_id=' . esc_attr( $soundcloud_id );
					}

					$song_obj->file = $song['file'];
					$song_obj->thumb = $thumb;
					$song_obj->name = esc_html( $song['name'] );
					$song_obj->url = get_permalink($post_id);
					$song_obj->album = get_the_title($post_id);
					$song_arr[] = $song_obj;
				}
			endif;
			return json_encode($song_arr);
		}
        public static function default_song_to_playlist_data($post_id){
            $songs = get_post_meta( $post_id, '_noo_songs', true );
            $song_arr = array();
            if( isset($songs) && !empty($songs)){
                foreach ($songs as $k=>$song){

                    $song_arr[] = $k;
                }
            }
            return json_encode($song_arr);
        }
		public function footer_player(){
			$enable_player = noo_get_option('enable_footer_player', 'enabled');
			if( !is_singular( 'noo_album' ) && $enable_player != 'enabled' ) {
				return;
			}

			$player_style = ( $enable_player == 'none' ) ? 'style="display: none !important;"' : '';

			echo '
<div class="footer-player" ' . $player_style . '>
	<div class="album-playlist">
		<ul>
			<li class="album-playlist-title">
				<span class="playlist-play">
				'.__('Play','noo').'
				</span>
				<span class="playlist-release">
				'.__('Play','noo').'
					<small>'.__('(Label)','noo').'</small>
				</span>
				<span class="playlist-tract">
				'.__('Track title','noo').'
					<small>'.__('(Track author)','noo').'</small>
				</span>
				<span class="playlist-page">
				'.__('Page','noo').'
				</span>
				<span class="playlist-delete">
				'.__('Delete','noo').'
				</span>
			</li>';
			$s_songs = isset($_COOKIE['noo-playlist']) ? $_COOKIE['noo-playlist'] : '';
			$s_songs = json_decode(stripslashes($s_songs));
			if(!empty($s_songs)){
				$soundcloud_id = get_option('soundcloud_client_id');
				$soundcloud_api = 'api.soundcloud.com';
				foreach ($s_songs as $song){

					$s_r = explode('_', $song);
					$post_id = absint(@$s_r[0]);
					$song_id = @$s_r[1];
					$m_songs = get_post_meta( $post_id, '_noo_songs', true );
					if($post_id && $m_songs){
						if(has_post_thumbnail($post_id)){
							$thumb       = get_the_post_thumbnail( $post_id, 'thumbnail', array(
								'title' => esc_attr( get_the_title( get_post_thumbnail_id($post_id) ) )
							) );
						}else{
							$thumb = '<img src="'.get_template_directory_uri().'/assets/images/no-track-image.png">';
						}
						$artist = get_the_term_list($post_id,'album_artist', '', ', ', '');
						foreach ($m_songs as $key=>$m_song){
							$k_r = explode('_', $key);
							
							if(!empty($song_id) && @$k_r[1] == $song_id){
								$author = isset( $m_song['author'] ) && !empty( $m_song['author'] ) ? $m_song['author'] : $artist;

								// Check file from api soundcloud
								if ( strpos($m_song['file'], $soundcloud_api) !== false && !empty( $soundcloud_id ) ) {
									$soundcloud_track_id = 0;
									// Remove '/'
									$m_song['file'] = untrailingslashit($m_song['file']);
									$song_expl = explode('/', $m_song['file']);
									$soundcloud_track_id = end($song_expl);

									$m_song['file'] = 'https://api.soundcloud.com/tracks/' . $soundcloud_track_id . '/stream?client_id=' . esc_attr( $soundcloud_id );
								}
								
								echo '<li id="'.esc_attr($key).'" class="album-playlist-item" data-thumb="'.esc_attr($thumb).'" data-id="'.esc_attr($key).'" data-name="'.esc_attr($m_song['name']).'" data-artist="'.esc_attr($author).'">
									<span class="playlist-play">
										<a href="'.esc_url($m_song['file']).'"><i class="fa fa-play"></i></a>
									</span>
									<span class="playlist-release">
										<a href="'.esc_url(get_permalink($post_id)).'">'.get_the_title($post_id).'</a>
									</span>
									<span class="playlist-tract">
										<a href="'.esc_url(get_permalink($post_id)).'">'.$m_song['name'].'</a>
										<small><a href="javascript:void(0)">'.esc_html($author).'</a></small>
									</span>
									<span class="playlist-page">
									  <a href="'.esc_url(get_permalink($post_id)).'"><i class="fa fa-share"></i></a>
									</span>
									<span class="playlist-delete">
									  <a href="#"><i class="fa fa-times"></i></a>
									</span>
								</li>';
							}
						}
					}
				}
			}
	echo '</ul>
	</div>
	<div class="album-player">
		<div class="album-player-embed">
		    <span class="contro-album-player contro-down-player"><i class="fa fa-angle-down"></i></span>
		    <span class="contro-album-player contro-up-player"><i class="fa fa-angle-up"></i></span>
			<audio class="album-audio-embed">
				<source src="#" type="audio/mpeg" />
			</audio>
		</div>
	</div>
</div>
';
			return;
		}
		
		
		public function noo_album_masonry_shortcode($atts, $content = null){
			wp_enqueue_script('vendor-isotope');
			if( is_front_page() || is_home()) {
				$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : ( ( get_query_var( 'page' ) ) ? get_query_var( 'page' ) : 1 );
			} else {
				$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
			}
			extract( shortcode_atts( array(
				'per_page'        => '12',
				'orderby'         =>  'latest',
				'visibility'      => '',
				'class'           => '',
				'custom_style'    => ''
			), $atts));
            ob_start();
            $order = 'DESC';
	        switch ($orderby) {
	            case 'latest':
	                $orderby = 'date';
	                break;

	            case 'oldest':
	                $orderby = 'date';
	                $order = 'ASC';
	                break;

	            case 'alphabet':
	                $orderby = 'title';
	                $order = 'ASC';
	                break;

	            case 'ralphabet':
	                $orderby = 'title';
	                break;

	            case 'default':
	                $orderby = 'default';
	                break;

	            default:
	                $orderby = 'date';
	                break;
	        }

			?>
			<div class="albums-masonry masonry <?php echo noo_visibility_class( $visibility )?> <?php echo esc_attr( $class )?>">
					<?php 
					$args = array(
						'post_type'				=> 'noo_album',
						'post_status' 			=> 'publish',
						'ignore_sticky_posts'	=> 1,
						'posts_per_page' 		=> $per_page,
						'paged'			  		=> $paged,
					);

					if ( 'default' != $orderby ) {
						$args['orderby'] = $orderby;
						$args['order'] = $order;
					}

					$albums = new WP_Query($args );
					

					if ( $albums->have_posts() ) : ?>
						<div class="masonry-filters">
							<ul data-option-key="filter" >
								<li>
									<a class="selected" href="#" data-option-value= "*"><?php echo __('All','noo') ?></a>
								</li>
								<?php
									if($album_genres = get_terms('album_genre')){
										
										foreach ((array) $album_genres  as $album_genre){
								?>
										<li>
											<a href="#" data-option-value= ".<?php echo 'mansonry-filter-'.esc_attr($album_genre->slug)  ; ?>"><?php echo esc_html($album_genre->name); ?></a>
										</li>
								<?php 
										}
									}
								?>
							</ul>
						</div>
						<div class="noo_albums-wrap clearfix">
						<ul class="noo_albums masonry-container">
			
							<?php while ( $albums->have_posts() ) : $albums->the_post(); global $post;?>
								<?php 
								$classes = array();
								$classes[] = 'loadmore-item masonry-item noo-al-item';
								$cat_class = array();
								if ( is_object_in_taxonomy( $post->post_type, 'album_genre' ) ) {
									foreach ( (array) get_the_terms($post->ID,'album_genre') as $cat ) {
										if ( empty($cat->slug ) )
											continue;
										$cat_class[] =  'mansonry-filter-'.$cat->slug;
									}
								}
								$cat_class = implode(' ', $cat_class);
								$classes[] = $cat_class;
								?>
								<li <?php post_class($classes); ?>>
								<div class="noo_album-container">
									<figure>
										<div class="noo_album-wrap">
											<div class="noo_album-images">
												<a href="<?php the_permalink(); ?>">
													<?php 
													if ( has_post_thumbnail() ) {
														echo get_the_post_thumbnail( get_the_ID(), 'noo-loop-album' );
													}
													?>
												</a>
											</div>
										</div>
										<figcaption>
											<div class="noo_album-info">
												<h3 class="noo_album_title"><a href="<?php the_permalink()?>"><?php the_title(); ?></a></h3>
												<div class="noo_album-category"><?php echo get_the_term_list(get_the_ID(),'album_genre', '', ', ', '')?></div>
											</div>
											<div class="noo_album-loop-actions">
                                                <a href="<?php the_permalink(); ?>"><i class="fa fa-link"></i> <?php _e('Detail','noo') ; ?></a>
												<?php
                                                $source_songs = noo_get_post_meta( get_the_ID(), '_source_songs', 'upload_file' );
                                                ?>
                                                <?php if ( 'upload_file' == $source_songs ) :  ?>
	                                                <?php if( noo_get_option('enable_footer_player', 'enabled') == 'enabled' ) : ?>
														<a href="#" data-songs='<?php echo esc_attr(Noo_Album::songs_to_playlist_data(get_the_ID()))?>' class="add-to-playlist-btn"><i class="fa fa-plus"></i> <?php _e('Add to Playlist','noo')?></a>
													<?php endif; ?>
												<?php elseif ( 'soundcloud' == $source_songs ) :  ?>
													<a href="<?php the_permalink(); ?>"><i class="fa fa-soundcloud"></i> <?php _e('Soundcloud','noo')?></a>
												<?php elseif ( 'link' == $source_songs ) :  $wlink = noo_get_post_meta( get_the_ID(), '_open_link', '' );  ?>
													<a href="<?php echo esc_url( $wlink ); ?>" target="_blank"><i class="fa fa-external-link"></i> <?php _e('View link','noo')?></a>
												<?php endif; ?>
											</div>
										</figcaption>
									</figure>
								</div>
							</li>
							<?php endwhile; // end of the loop. ?>
						</ul>
					</div>
					<?php if(1 < $albums->max_num_pages):?>
					<div class="loadmore-action">
						<a href="#" class="btn-loadmore btn-primary" title="<?php _e('Load More','noo')?>"><?php _e('Load More','noo')?></a>
						<div class="noo-loader loadmore-loading"><span></span><span></span><span></span><span></span><span></span></div>
					</div>
					<?php noo_pagination_normal(array(),$albums)?>
					<?php endif;?>
					<?php endif;
                    wp_reset_postdata();
					?>
					
				</div>
			<?php
            $album_get = ob_get_contents();
            ob_end_clean();
            return $album_get;
		}
		

	}
	new Noo_Album();

endif;