<?php
// [slider] Responsive Slider
// ============================
if( !function_exists( 'noo_shortcode_slider' ) ) {
    function noo_shortcode_slider ( $atts, $content = null ) {
        extract( shortcode_atts( array(
            'visibility'         => '',
            'class'              => '',
            'id'                 => '',
            'custom_style'       => '',
            'animation'          => 'slide',
            'visible_items'      => '1',
            'slider_time'        => '3000',
            'slider_speed'       => '600',
            'auto_play'          => '',
            'pause_on_hover'     => '',
            'random'             => '',
            'indicator'          => '',
            'indicator_position' => '',
            'prev_next_control'  => '',
            'timer'              => '',
            'swipe'              => '',
        ), $atts ) );

        wp_enqueue_script( 'vendor-carouFredSel' );
        $indicator_class  = ( $indicator_position != '' ) ? $indicator_position . '-indicators' : 'top-indicators';

        $class            = ( $class              != '' ) ? 'noo-slider ' . $indicator_class . '' . esc_attr( $class ) : 'noo-slider ' . $indicator_class ;
        $visibility       = ( $visibility         != '' ) && ( $visibility != 'all' ) ? esc_attr( $visibility ) : '';
        $class           .= noo_visibility_class( $visibility );

        $html  = array();

        $id    = ( $id    != '' ) ? esc_attr( $id ) : 'noo-slider-' . noo_vc_elements_id_increment();
        $class = ( $class != '' ) ? 'class="' . $class . '"' : '';
        $custom_style   = ( $custom_style  != '' ) ? 'style="' . $custom_style . '"' : '';

        $indicator_html = array();
        $indicator_js   = array();
        if( $indicator == 'true') {
            $indicator_js[] = '    pagination: {';
            $indicator_js[] = '      container: "#' . $id . '-pagination"';
            $indicator_js[] = '    },';

            $indicator_html[] = '  <div id="' . $id . '-pagination" class="slider-indicators"></div>';
        }

        $prev_next_control_html = array();
        $prev_next_control_js   = array();
        if( $prev_next_control == 'true') {
            $prev_next_control_js[]   = '    prev: {';
            $prev_next_control_js[]   = '      button: "#' . $id . '-prev"';
            $prev_next_control_js[]   = '    },';
            $prev_next_control_js[]   = '    next: {';
            $prev_next_control_js[]   = '      button: "#' . $id . '-next"';
            $prev_next_control_js[]   = '    },';

            $prev_next_control_html[] = '  <a id="' . $id . '-prev" class="slider-control prev-btn" role="button" href="#"><span class="slider-icon-prev"></span></a>';
            $prev_next_control_html[] = '  <a id="' . $id . '-next" class="slider-control next-btn" role="button" href="#"><span class="slider-icon-next"></span></a>';
        }

        $timer_html = array();
        $timer_js   = array();
        if( $timer == 'true' ) {
            $timer_js[]  = '      progress: {';
            $timer_js[]  = '        bar: "#' . $id . '-timer"';
            $timer_js[]  = '      },';

            $timer_html[] = '  <div id="' . $id . '-timer" class="slider-timer"></div>';
        }

        $swipe  = ( $swipe == 'true' ) ? 'true' : 'false';
        $animation = ( $animation == 'slide' ) ? 'scroll' : $animation; // Not allow fading with carousel

        $html[] = "<div id=\"{$id}\" {$class} {$custom_style}>";
        $html[] = '  <ul class="sliders">';
        $html[] = do_shortcode( $content );
        $html[] = '  </ul>';
        $html[] = '  <div class="clearfix"></div>';
        $html[] = implode( "\n", $timer_html );
        $html[] = implode( "\n", $indicator_html );
        $html[] = implode( "\n", $prev_next_control_html );
        $html[] = '</div>';

        // slider script
        $html[] = '<script>';
        $html[] = "jQuery('document').ready(function ($) {";
        $html[] = "var nooSliderOptions = {";
        $html[] = "    infinite: true,";
        $html[] = "    circular: true,";
        $html[] = "    responsive: true,";
        $html[] = "    debug : false,";
        $html[] = '    items: {';
        // $html[] = ( $random == 'true'     ) ? '      start: "random"' : '      start: 0,';
        // $html[] = "      height: 'variable',";
        $html[] = "      visible: {min:1, max: $visible_items}";
        $html[] = '    },';
        $html[] = '    scroll: {';
        $html[] = '      items: 1,';
        $html[] = ( $slider_speed   != ''         ) ? '      duration: ' . $slider_speed . ',' : '';
        $html[] = ( $pause_on_hover == 'true'     ) ? '      pauseOnHover: "resume",' : '';
        $html[] = '      fx: "' . $animation . '"';
        $html[] = '    },';
        $html[] = '    auto: {';
        $html[] = ( $slider_time    != ''     ) ? '      timeoutDuration: ' . $slider_time . ',' : '';
        $html[] = implode( "\n", $timer_js );
        $html[] = ( $auto_play      == 'true' ) ? '      play: true' : '      play: false';
        $html[] = '    },';
        $html[] = implode( "\n", $prev_next_control_js );
        $html[] = implode( "\n", $indicator_js );
        $html[] = '    swipe: {';
        $html[] = "      onTouch: {$swipe},";
        $html[] = "      onMouse: {$swipe}";
        $html[] = '    }';
        $html[] = '  }';
        $html[] = "$('#{$id} .sliders').carouFredSel(nooSliderOptions)";
        $html[] = "$(window).on('resize',function(){";
        $html[] = "$('#{$id} .sliders').trigger('destroy').carouFredSel(nooSliderOptions)";
        $html[] = "})";
        $html[] = "imagesLoaded('#{$id} .sliders',function(){";
        $html[] = "$('#{$id} .sliders').trigger('updateSizes')";
        $html[] = '});';
        $html[] = '});';
        $html[] = '</script>';

        return implode( "\n", $html );
    }
}
add_shortcode( 'slider', 'noo_shortcode_slider' );

// [slide]
// ============================
if( !function_exists( 'noo_shortcode_slide' ) ) {
    function noo_shortcode_slide ( $atts, $content = null ) {
        extract( shortcode_atts( array(
            'class'             => '',
            'id'                => '',
            'custom_style'      => '',
            'type'              => 'image',
            'image'             => '',
            'caption'           => '',
            'video_url'         => '',
            'video_poster'      => ''
        ), $atts ) );

        $id    = ( $id    != '' ) ? esc_attr( $id ) : 'noo-slider-item-' . noo_vc_elements_id_increment();
        $slide_content = array();
        if( $type == 'image' ) {
            $image = wp_get_attachment_image_src( $image, 'fullwidth-fullwidth' );

            $alt          = get_post_meta($image, '_wp_attachment_image_alt', true);
            $alt          = ( $alt != '' ) ? $alt : get_the_title( $image );
            $slide_content[] = '<img class="slide-image" alt="'. $alt .'" src="' . $image[0] . '">';
            $slide_content[] = ( $caption != '' ) ? '<p class="slide-caption">' . $caption . '</p>' : '';
        } elseif( $type == 'video' && $video_url != '') {
            wp_enqueue_script( 'vendor-jplayer' );
            ob_start();
            ?>
            <script>
                jQuery(document).ready(function($){
                    if($().jPlayer) {
                        $('#jplayer_<?php echo esc_attr($id); ?>').jPlayer({
                            ready: function () {
                                $(this).jPlayer('setMedia', {
                                    m4v: '<?php echo esc_url($video_url); ?>',
                                    poster: '<?php $poster = wp_get_attachment_image_src( $video_poster ); echo esc_url($poster[0]); ?>'
                                });
                            },
                            size: {
                                width: '100%',
                                height: '100%'
                            },
                            swfPath: '<?php echo get_template_directory_uri(); ?>/framework/vendor/jplayer',
                            cssSelectorAncestor: '#jp_interface_<?php echo esc_attr($id); ?>',
                            supplied: 'm4v'
                        });
                    }
                });
            </script>
            <div class="noo-video-container">
                <div class="video-inner">
                    <div id="jplayer_<?php echo esc_attr($id); ?>" class="jp-jplayer jp-jplayer-video"></div>
                    <div class="jp-controls-container jp-video">
                        <div id="jp_interface_<?php echo esc_attr($id); ?>" class="jp-interface">
                            <ul class="jp-controls">
                                <li><a href="#" class="jp-play" tabindex="1"><span><?php echo __('Play','noo') ?></span></a></li>
                                <li><a href="#" class="jp-pause" tabindex="1"><span><?php echo __('Pause','noo') ?></span></a></li>
                                <li><a href="#" class="jp-mute" tabindex="1"><span><?php echo __('Mute','noo') ?></span></a></li>
                                <li><a href="#" class="jp-unmute" tabindex="1"><span><?php echo __('UnMute','noo') ?></span></a></li>
                            </ul>
                            <div class="jp-progress-container">
                                <div class="jp-progress">
                                    <div class="jp-seek-bar">
                                        <div class="jp-play-bar"></div>
                                    </div>
                                </div>
                                <div class="jp-volume-bar">
                                    <div class="jp-volume-bar-value"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
            $slide_content[] = ob_get_contents();
            ob_end_clean();
        } elseif ($type == 'content' ) {
            $slide_content[] = '<div class="slide-content">';
            $slide_content[] = noo_handler_shortcode_content( $content, true );
            $slide_content[] = '</div>';
        }

        if( empty( $slide_content ) ) {
            return '';
        }

        $class = ( $class != ''     ) ? 'slide-item ' . esc_attr( $class ) : 'slide-item';

        $html  = array();

        $class = ( $class != '' ) ? 'class="' . $class . '"' : '';
        $custom_style   = ( $custom_style  != '' ) ? 'style="' . $custom_style . '"' : '';

        $html[] = "<li {$class} {$custom_style}>";

        $html[] = implode( "\n", $slide_content );
        $html[] = '</li>';

        return implode( "\n", $html );
    }
}

add_shortcode( 'slide', 'noo_shortcode_slide' );
?>