<?php
// Short Code Blog Masonry
// ============================
if(!function_exists('noo_blog_masonry_shortcode')){
    function noo_blog_masonry_shortcode($atts, $content = null){
        wp_enqueue_script('vendor-isotope');
        extract( shortcode_atts( array(
            'categories'        => 'all',
            'title'				=> '',
            'orderby'           => 'latest',
            'posts_per_page'	=> '8',
            'columns'  			=> '',
            'excerpt_length'	=> '20',
            'class'             => '',
            'custom_style'      => ''
        ), $atts ) );


        $class            = ( $class           != ''     ) ? 'masonry-blog masonry' . esc_attr( $class ) : 'masonry-blog masonry';
        $class = ( $class != '' ) ? ' class="' . esc_attr( $class ) . '"' : '';
        $custom_style = ( $custom_style != '' ) ? ' style="' . $custom_style . '"' : '';

        if( is_front_page() || is_home()) {
            $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : ( ( get_query_var( 'page' ) ) ? get_query_var( 'page' ) : 1 );
        } else {
            $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
        }
        $order = 'DESC';
        switch ($orderby) {
            case 'latest':
                $orderby = 'date';
                break;

            case 'oldest':
                $orderby = 'date';
                $order = 'ASC';
                break;

            case 'alphabet':
                $orderby = 'title';
                $order = 'ASC';
                break;

            case 'ralphabet':
                $orderby = 'title';
                break;

            default:
                $orderby = 'date';
                break;
        }

        $html = '';
        $args = array(
            'posts_per_page'      	=> $posts_per_page,
            'paged'			      	=> $paged,
            'post_status'         	=> 'publish',
            'orderby'         => "{$orderby}",
            'order'           => "{$order}",
        );

        if(!empty($categories) && $categories != 'all'){
            $args['category__in'] = explode(',', $categories);
        }
        $list_blog = new WP_Query($args);
        ob_start();
        if($list_blog->have_posts()):
            ?>
            <div <?php echo ( $class . ' ' . $custom_style ); ?> >

                <?php if(!empty($title)): ?>
                    <h3>
                        <?php echo (esc_html( $title ));?>
                    </h3>
                <?php endif;?>
                <div class="masonry-container columns-<?php echo esc_attr($columns)?>">
                    <?php while ($list_blog->have_posts()): $list_blog->the_post(); global $post;?>
                        <div class="loadmore-item masonry-item">
                            <div class="item-wrap">
                                <div class="content-social">
                                    <?php echo noo_social_share(get_the_ID(),false); ?>
                                </div>
                                <?php
                                $categories = get_the_category();
                                $categories_html = '';
                                if($categories) :?>
                                    <div class="noo-category">
                                        <?php
                                        foreach ($categories as $category) {
                                            $categories_html.= '<a' . ' href="' . get_category_link($category->term_id) . '"' . ' title="' . esc_attr(sprintf(__("View all posts in: &ldquo;%s&rdquo;", 'noo') , $category->name)) . '">' . ' ' . $category->name . '</a>';
                                        }
                                        echo ($categories_html);
                                        ?>

                                    </div>
                                <?php endif; ?>
                                <h3 class="item-title">
                                    <a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( sprintf( __( 'Permanent link to: "%s"','noo' ), the_title_attribute( 'echo=0' ) ) ); ?>"><?php the_title(); ?></a>
                                </h3>
                                <div class="item-thumbnail" >

                                    <?php if ( has_post_format( 'quote' )) : ?>
                                        <div class="quote-content">
                                            <i class="fa fa-quote-right">&nbsp;</i>
                                            <a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( sprintf( __( 'Permanent link to: "%s"','noo' ), the_title_attribute( 'echo=0' ) ) ); ?>">
                                                <em>
                                                    <?php
                                                    $quote = noo_get_post_meta(get_the_id() , '_noo_wp_post_quote', '');
                                                    if($quote == '') {
                                                        $quote = get_the_title( get_the_id() );
                                                    }
                                                    echo esc_html($quote);
                                                    ?>
                                                </em>
                                            </a>
                                        </div>
                                    <?php else: ?>
                                        <?php noo_featured_content(); ?>
                                    <?php endif;?>
                                    <?php if(get_post_format( get_the_id() ) !== 'video') :?>
                                        <?php if(noo_get_option('noo_blog_post_author_bio', true)):?>
                                            <div class="author-avatar">
                                                <?php echo get_avatar( get_the_author_meta( 'user_email' ),70); ?>
                                            </div>
                                        <?php endif;?>
                                    <?php endif; ?>
                                </div>
                                <div class="item-content-meta">
								<span class="author">
									<i class="fa fa-user">&nbsp;</i>
                                    <?php echo the_author_posts_link();?>
								</span>
								<span class="category">
									<i class="fa fa-folder-open"></i>
                                    <?php
                                    $cate = array();
                                    $categories_html = '';
                                    $categories = get_the_category();
                                    foreach ($categories as $category) {
                                        $categories_html.= '<a' . ' href="' . get_category_link($category->term_id) . '"' . ' title="' . esc_attr(sprintf(__("View all posts in: &ldquo;%s&rdquo;", 'noo') , $category->name)) . '">' . ' ' . $category->name . '</a>';
                                    }
                                    $cate[] = trim($categories_html) ;
                                    echo implode($cate);
                                    ?>
								</span>
								<span class="comment">
									<i class="fa fa-comments-o">&nbsp;</i>
                                    <?php
                                    $comment_title = sprintf(__('Leave a comment on: &ldquo;%s&rdquo;', 'noo') , get_the_title());
                                    ?>
                                    <a href=" <?php echo esc_url(get_comments_link()); ?> " title=" <?php echo esc_attr($comment_title) ?> " class="meta-comments"><?php comments_number( '0', '1', '%' ); ?></a>
								</span>
                                </div>
                                <?php if ( !has_post_format( 'quote' )) : ?>
                                    <div class="item-content">

                                        <div class="item-excerpt">
                                            <?php
                                            $excerpt = $post->post_excerpt;
                                            if(empty($excerpt))
                                                $excerpt = $post->post_content;
                                            $excerpt = strip_shortcodes($excerpt);
                                            echo '<p>' . wp_trim_words($excerpt,$excerpt_length,'...') . '</p>';
                                            ?>
                                        </div>
                                        <?php noo_readmore_link(); ?>
                                    </div>
                                <?php endif;?>

                            </div>
                        </div><!--masonry-item-->

                    <?php endwhile;?>

                </div>

                <?php if( 1 < $list_blog->max_num_pages ):?>
                    <div class="loadmore-action">
                        <a href="#" class="btn-loadmore btn" title="<?php _e('Load More','noo')?>"><?php _e('LOAD MORE','noo')?></a>
                        <div class="noo-loader loadmore-loading"><span></span><span></span><span></span><span></span><span></span></div>
                    </div>
                    <?php noo_pagination_normal(array(),$list_blog)?>
                <?php endif;?>
            </div>
        <?php
        endif;
        $html .= ob_get_clean();
        wp_reset_postdata();
        return $html;
    }
    add_shortcode('noo_blog_masonry', 'noo_blog_masonry_shortcode');
}