
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="row">
		
		<div class="<?php if( has_featured_content() && !is_singular() ) : echo 'col-md-6'; endif; ?>">
			<header class="content-header">
				
				<?php if ( !is_singular() ) : ?>
					<span class="entry-date">
						<time datetime="<?php echo get_the_date('c') ;?>">
							<?php echo get_the_date('M jS, Y'); ?>
						</time>
					</span>
				<?php endif; ?>

				<?php if ( is_singular() ) : ?>
					<h1 class="content-title">
						<?php the_title(); ?>
					</h1>
					<?php noo_content_meta(); ?>
					<?php echo noo_social_count(); ?>
				<?php else : ?>
				<h3 class="content-title">
					<a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( sprintf( __( 'Permanent link to: "%s"','noo' ), the_title_attribute( 'echo=0' ) ) ); ?>"><?php the_title(); ?></a>
				</h3>
				<?php endif; ?>
			</header>
			
			<div class="content-wrap">			
				<?php if ( is_singular() ) : ?>
					
					<div class="content">
						
						<?php if( is_locked_post( get_the_ID() ) ) : ?>
							<?php echo locked_post_content( get_the_ID() ); ?>
						<?php else: ?>
							<?php the_content(); ?>
						<?php endif;?>
						<?php wp_link_pages(); ?>

						<?php if(is_singular()): ?>
							<?php if((noo_get_option('noo_blog_post_show_post_tag', true)) && has_tag()):?>
								<div class="entry-tags">
								<?php the_tags(sprintf('<span>%s</span>',__('Tags ','noo')),'')?>
								</div>
							<?php endif;?>
						<?php endif;?>
					</div>
				<?php else : ?>
					<div class="content-excerpt">
						<?php if(get_the_excerpt()):?>
							<?php the_excerpt(); ?>
						<?php endif;?>
					</div>
				<?php endif; ?>


				<?php if(!is_singular()): ?>
					<?php noo_content_meta(); ?>
				<?php endif; ?>


			</div>
		</div>

		<?php if( has_featured_content()) : ?>
			<?php if(!is_singular()): ?>
				<div class="content-featured col-md-6">
					<?php noo_featured_audio(); ?>
					<?php if(esc_html(noo_get_post_meta(get_the_ID(),'noo_reader_count_rating',0) )) {?>
					<div class="noo_rating_point">
						<?php echo esc_html(noo_get_post_meta(get_the_ID(),'noo_reader_count_rating',0) );?>
					</div>
				<?php } ?>
				</div>				
			<?php endif; ?>
		<?php endif; ?>

	</div>
	<?php noo_get_layout('post', 'footer'); ?>
</article> <!-- /#post- -->