<?php
/**
 * The Template for displaying all single classes
 *
 * This template can be overridden by copying it to yourtheme/noo-timetable/single-noo_class.php.
 *
 * @author 		NooTheme
 * @package 	NooTimetable/Templates
 * @version     1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header();

?>
<?php noo_timetable_before_main_content(); ?>

		<div class="<?php noo_main_class(); ?> <?php noo_blog_class(); ?>" role="main">

		<?php
		// Start the loop.
		while ( have_posts() ) : the_post();
		?>
			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

				
				<?php noo_timetable_post_thumbnail(); ?>

				<header class="entry-header">
					<div class="loop-item-category"><?php echo get_the_term_list(get_the_ID(), 'class_category',' ',', ')?></div>
					<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
				</header>

				<?php noo_timetable_excerpt(); ?>

				<div class="entry-content">
					<?php
						the_content();
						wp_link_pages();
					?>
					
					<?php
						Noo__Timetable__Class::get_timetable();
					?>
				</div>
				
				<footer class="entry-footer"></footer>

			</article>

		<?php
		// End of the loop.
		endwhile;
		?>

		<?php
			// If comments are open or we have at least one comment, load up the comment template.
			if ( comments_open() || get_comments_number() ) {
				comments_template();
			}
		?>
		</div>
	<?php noo_timetable_get_sidebar( 'noo-class-sidebar' ); ?>

<?php noo_timetable_after_main_content(); ?>


<?php get_footer(); ?>
