<?php
/**
 * Default Events Template
 * This file is the basic wrapper template for all the views if 'Default Events Template'
 * is selected in Events -> Settings -> Template -> Events Template.
 *
 * Override this template in your own theme by creating a file at [your-theme]/tribe-events/default-template.php
 *
 * @package TribeEventsCalendar
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

get_header(); ?>
<?php
    $event_sidebar = noo_get_option('noo_position_event_sidebar','0');
    $class = 'col-md-9';
if( $event_sidebar == 1 ){
    $class = 'col-md-9 pull-right';
}
    if( function_exists('tribe_is_week') ){
        if(tribe_is_month() || tribe_is_week() || is_single()):
            $class = 'col-md-12';
        endif;
    }else{
        if(tribe_is_month() || is_single()):
            $class = 'col-md-12';
        endif;
    }

?>
<div class="noo-tribe-events">
	<div class="container">
        <div class="row">
            <div class="<?php echo esc_attr($class); ?>">
                <?php  tribe_events_before_html(); ?>
                <?php  tribe_get_view(); ?>
                <?php tribe_events_after_html(); ?>
            </div>
            <?php if($class != 'col-md-12' ): ?>
            <div class="col-md-3 sidebar-event">
                <?php if( function_exists('dynamic_sidebar') && dynamic_sidebar('noo-widget-event') ): endif; ?>
            </div>
            <?php endif; ?>
        </div>
	</div> <!-- #tribe-events-pg-template -->
</div>
<?php get_footer(); ?>