<?php
/**
 * List View Single Event
 * This file contains one event in the list view
 *
 * Override this template in your own theme by creating a file at [your-theme]/tribe-events/list/single-event.php
 *
 * @package TribeEventsCalendar
 *
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}
// Setup an array of venue details for use later in the template
$venue_details = tribe_get_venue_details();

// Venue
$has_venue_address = ( ! empty( $venue_details['address'] ) ) ? ' location' : '';

// Organizer
$organizer = tribe_get_organizer();
$noo_cost = tribe_get_event_meta( get_the_ID(), '_EventCost', true );
?>

<!-- Event Title -->
<?php do_action( 'tribe_events_before_the_event_title' ) ?>
<h2 class="tribe-events-list-event-title entry-title summary">
    <a class="url" href="<?php echo esc_url( tribe_get_event_link() ); ?>" title="<?php the_title() ?>" rel="bookmark">
        <?php the_title() ?>
    </a>
</h2>
<?php do_action( 'tribe_events_after_the_event_title' ) ?>
<div class="noo-tribe-events-image">
    <?php if( isset($noo_cost) && $noo_cost == '' ): ?>
        <span class="noo-attr-style"><?php echo __('Free', 'noo'); ?></span>
        <?php echo tribe_get_cost( null, true ) ?>

    <?php elseif( tribe_get_cost() ) : ?>

        <span class="noo-attr-style has-cost"><?php echo tribe_get_cost( null, true ) ?></span>
        
    <?php endif; ?>
    <!-- Event Meta -->
    <?php do_action( 'tribe_events_before_the_meta' ) ?>
    <div class="tribe-events-event-meta vcard">
        <div class="author <?php echo $has_venue_address; ?>">

            <!-- Schedule & Recurrence Details -->
            <div class="updated published time-details">
                <i class="fa fa-calendar"></i><?php echo tribe_events_event_schedule_details() ?>
            </div>

            <?php if ( isset($venue_details) && !empty($venue_details) ) : ?>
                <!-- Venue Display Info -->
                <div class="tribe-events-venue-details">
                    <i class="fa  fa-map-marker"></i><?php echo implode( ', ', $venue_details ); ?>
                </div> <!-- .tribe-events-venue-details -->
            <?php endif; ?>

        </div>
    </div><!-- .tribe-events-event-meta -->
    <?php do_action( 'tribe_events_after_the_meta' ) ?>

    <!-- Event Image -->
    <?php echo tribe_event_featured_image( null, 'full' ) ?>
</div>

<!-- Event Content -->
<?php do_action( 'tribe_events_before_the_content' ) ?>
<div class="tribe-events-list-event-description tribe-events-content description entry-summary">
    <?php the_excerpt() ?>
    <a href="<?php echo esc_url( tribe_get_event_link() ); ?>" class="tribe-events-read-more" rel="bookmark"><?php _e( 'READ MORE', 'noo' ) ?></a>
</div><!-- .tribe-events-list-event-description -->
<?php do_action( 'tribe_events_after_the_content' ) ?>
