<?php
/**
 * Map View Single Event
 * This file contains one event in the map
 *
 * Override this template in your own theme by creating a file at [your-theme]/tribe-events/map/single-event.php
 *
 * @package TribeEventsCalendar
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
} ?>

<?php

global $post;

$venue_details = tribe_get_venue_details();

// Venue microformats
$has_venue = ( $venue_details ) ? ' vcard' : '';
$has_venue_address = ( ! empty( $venue_details['address'] ) ) ? ' location' : '';

$noo_cost = tribe_get_event_meta( get_the_ID(), '_EventCost', true );
?>

<!-- Event Title -->
<?php do_action( 'tribe_events_before_the_event_title' ) ?>

<!-- Event Distance -->
<?php echo tribe_event_distance(); ?>

<h2 class="tribe-events-map-event-title summary">
    <a class="url" href="<?php echo esc_url( tribe_get_event_link() ); ?>" title="<?php the_title() ?>" rel="bookmark">
        <?php the_title() ?>
    </a>
</h2>
<?php do_action( 'tribe_events_after_the_event_title' ) ?>

<div class="noo-tribe-events-image">
    <?php if( isset($noo_cost) && $noo_cost == '' ): ?>
        <span class="noo-attr-style"><?php echo __('Free', 'noo'); ?></span>
        <?php echo tribe_get_cost( null, true ) ?>

    <?php elseif( tribe_get_cost() ) : ?>

        <span class="noo-attr-style has-cost"><?php echo tribe_get_cost( null, true ) ?></span>
        
    <?php endif; ?>
    <?php echo tribe_event_featured_image( null, 'noo-thumbnail-square' ); ?>
    <!-- Event Meta -->
    <?php do_action( 'tribe_events_before_the_meta' ) ?>
    <div class="tribe-events-event-meta <?php echo $has_venue . $has_venue_address; ?>">
        <div class="author location">
        <!-- Schedule & Recurrence Details -->
        <div class="updated published time-details">
            <?php echo tribe_events_event_schedule_details() ?>
        </div>

        <?php if ( $venue_details ) : ?>
            <!-- Venue Display Info -->
            <div class="tribe-events-venue-details">
                <?php echo implode( ', ', $venue_details ); ?>
            </div> <!-- .tribe-events-venue-details -->
        <?php endif; ?>
        </div>
    </div><!-- .tribe-events-event-meta -->
    <?php do_action( 'tribe_events_after_the_meta' ) ?>
</div>



<!-- Event Content -->
<?php do_action( 'tribe_events_before_the_content' ) ?>
<div class="tribe-events-event-details tribe-clearfix">
    <!-- Event Content -->
    <div class="tribe-events-list-photo-description tribe-events-content entry-summary description">
        <?php echo tribe_events_get_the_excerpt() ?>
    </div>

    <a href="<?php echo esc_url( tribe_get_event_link() ); ?>" class="tribe-events-read-more" rel="bookmark"><?php _e( 'READ MORE', 'noo' ) ?></a>

</div><!-- /.tribe-events-event-details -->
<?php do_action( 'tribe_events_after_the_content' ) ?>
