<?php

class Noo_Wiget extends WP_Widget {

	public $widget_cssclass;

	public $widget_description;

	public $widget_id;

	public $widget_name;

	public $settings;

	public $cached = true;

	/**
	 * Constructor
	 */
	public function __construct() {
		$widget_ops = array( 'classname' => $this->widget_cssclass, 'description' => $this->widget_description );
		
		parent::__construct( $this->widget_id, $this->widget_name, $widget_ops );
		if ( $this->cached ) {
			add_action( 'save_post', array( $this, 'flush_widget_cache' ) );
			add_action( 'deleted_post', array( $this, 'flush_widget_cache' ) );
			add_action( 'switch_theme', array( $this, 'flush_widget_cache' ) );
		}
	}

	/**
	 * get_cached_widget function.
	 */
	function get_cached_widget( $args ) {
		$cache = wp_cache_get( apply_filters( 'dh_cached_widget_id', $this->widget_id ), 'widget' );
		
		if ( ! is_array( $cache ) ) {
			$cache = array();
		}
		
		if ( isset( $cache[$args['widget_id']] ) ) {
			echo $cache[$args['widget_id']];
			return true;
		}
		
		return false;
	}

	/**
	 * Cache the widget
	 * @param string $content
	 */
	public function cache_widget( $args, $content ) {
		$cache[$args['widget_id']] = $content;
		
		wp_cache_set( apply_filters( 'dh_cached_widget_id', $this->widget_id ), $cache, 'widget' );
	}

	/**
	 * Flush the cache
	 *
	 * @return void
	 */
	public function flush_widget_cache() {
		wp_cache_delete( apply_filters( 'dh_cached_widget_id', $this->widget_id ), 'widget' );
	}

	/**
	 * update function.
	 *
	 * @see WP_Widget->update
	 * @param array $new_instance
	 * @param array $old_instance
	 * @return array
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		
		if ( ! $this->settings ) {
			return $instance;
		}
		
		foreach ( $this->settings as $key => $setting ) {
			
			if ( isset( $setting['multiple'] ) ) :
				$instance[$key] = implode( ',', $new_instance[$key] );
			 else :
				if ( isset( $new_instance[$key] ) ) {
					$instance[$key] = sanitize_text_field( $new_instance[$key] );
				} elseif ( 'checkbox' === $setting['type'] ) {
					$instance[$key] = 0;
				}
			endif;
		}
		if ( $this->cached ) {
			$this->flush_widget_cache();
		}
		
		return $instance;
	}

	/**
	 * form function.
	 *
	 * @see WP_Widget->form
	 * @param array $instance
	 */
	public function form( $instance ) {
		if ( ! $this->settings ) {
			return;
		}
		foreach ( $this->settings as $key => $setting ) {
			$value = isset( $instance[$key] ) ? $instance[$key] : $setting['std'];
			switch ( $setting['type'] ) {
				case "text" :
					?>
					<p>
						<label for="<?php echo $this->get_field_id( $key ); ?>"><?php echo esc_html( $setting['label'] ); ?></label>
						<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( $key ) ); ?>" name="<?php echo $this->get_field_name( $key ); ?>" type="text" value="<?php echo esc_attr( $value ); ?>" />
					</p>
					<?php
					break;
				
				case "number" :
					?>
					<p>
						<label for="<?php echo $this->get_field_id( $key ); ?>"><?php echo esc_html($setting['label']); ?></label>
						<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( $key ) ); ?>" name="<?php echo $this->get_field_name( $key ); ?>" type="number" step="<?php echo esc_attr( $setting['step'] ); ?>" min="<?php echo esc_attr( $setting['min'] ); ?>" max="<?php echo esc_attr( $setting['max'] ); ?>" value="<?php echo esc_attr( $value ); ?>" />
					</p>
					<?php
					break;
				case "select" :
					if ( isset( $setting['multiple'] ) ) :
						$value = explode( ',', $value );					
					endif;
					?>
					<p>
						<label for="<?php echo $this->get_field_id( $key ); ?>"><?php echo esc_html($setting['label']); ?></label>
						<select class="widefat" id="<?php echo esc_attr( $this->get_field_id( $key ) ); ?>" <?php if(isset($setting['multiple'])):?> multiple="multiple" <?php endif;?> name="<?php echo $this->get_field_name( $key ); ?><?php if(isset($setting['multiple'])):?>[]<?php endif;?>">
							<?php foreach ( $setting['options'] as $option_key => $option_value ) : ?>
								<option value="<?php echo esc_attr( $option_key ); ?>"
								<?php if(isset($setting['multiple'])): selected( in_array ( $option_key, $value ) , true ); else: selected( $option_key, $value ); endif; ?>><?php echo esc_html( $option_value ); ?></option>
							<?php endforeach; ?>
						</select>
					</p>
					<?php
					break;
				
				case "checkbox" :
					?>
					<p>
						<input id="<?php echo esc_attr( $this->get_field_id( $key ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( $key ) ); ?>" type="checkbox" value="1" <?php checked( $value, 1 ); ?> /> <label for="<?php echo $this->get_field_id( $key ); ?>"><?php echo esc_html($setting['label']); ?></label>
					</p>
					<?php
					break;
			}
		}
	}
}

// Request information
if( !class_exists('Noo_Request_Information') ):
class Noo_Request_Information extends  WP_Widget{

    function __construct(){
        parent::__construct(
            'noo_request_information',
            __('Noo Request Information', 'noo'),
            array('description', __('Request Information', 'noo'))
        );
    }
    public function widget( $args, $instance ){
        extract($args);
        extract( $instance );
        $title = apply_filters('widget_title', $instance['title']);
        echo $before_widget ;
        if ( $title ) :
            echo $before_title.$title.$after_title ;
        endif;

        if ( !empty( $instance['target'] ) ) {
            $target =' target="_blank"';
        } else {
            $target ='';
        }

        ?>
        <div class="noo_request_information">
            <i class="fa fa-envelope-o icon-request"></i>
            <p><?php if(isset($instance['description'])){ echo esc_html($description) ; } ?></p>
            <span class="attach"><?php if(isset($instance['attach'])){ echo esc_html($attach) ; } ?></span>
            <?php if( isset($instance['button_name']) && !empty($instance['button_name']) ): ?>
                <a class="request" href="<?php echo esc_url($button_link) ?>"<?php echo esc_attr( $target ); ?>>
                    <?php echo esc_html($button_name) ?>
                    <i class="fa fa-long-arrow-right"></i>
                </a>
            <?php endif; ?>
        </div>
        <?php
        echo $after_widget ;
    }
    public function form( $instance ){

        $instance = wp_parse_args( $instance, array(
            'title'         => __('Request Information', 'noo'),
            'description'   => '',
            'attach'        => '',
            'button_name'   => '',
            'button_link'   => '#',
            'target'        => ''
        ) );
        extract($instance);
    ?>
        <p>
            <label for="<?php echo $this ->  get_field_id('title'); ?>">
                <?php _e('Title','noo') ; ?>
            </label>
            <input type="text" name="<?php echo $this -> get_field_name('title') ; ?>" id="<?php echo $this -> get_field_id('title'); ?>" class="widefat" value="<?php echo esc_attr($title); ?>">
        </p>
        <p>
            <label for="<?php echo $this ->  get_field_id('attach'); ?>">
                <?php _e('Attach','noo') ; ?>
            </label>
            <input type="text" name="<?php echo $this -> get_field_name('attach') ; ?>" id="<?php echo $this -> get_field_id('attach'); ?>" class="widefat" value="<?php echo esc_attr($attach); ?>">
        </p>
        <p>
            <label for="<?php echo $this ->  get_field_id('button_name'); ?>">
                <?php _e('Button Name','noo') ; ?>
            </label>
            <input type="text" name="<?php echo $this -> get_field_name('button_name') ; ?>" id="<?php echo $this -> get_field_id('button_name'); ?>" class="widefat" value="<?php echo esc_attr($button_name); ?>">
        </p>
        <p>
            <label for="<?php echo $this ->  get_field_id('button_link'); ?>">
                <?php _e('Button Link','noo') ; ?>
            </label>
            <input type="text" name="<?php echo $this -> get_field_name('button_link') ; ?>" id="<?php echo $this -> get_field_id('button_link'); ?>" class="widefat" value="<?php echo esc_attr($button_link); ?>">
        </p>
        <p>
            <input id="<?php echo $this->get_field_id( 'target' ); ?>" name="<?php echo $this->get_field_name( 'target' ); ?>" value="_blank" type="checkbox" <?php checked( $target, '_blank', true ); ?>/>
            <label for="<?php echo $this->get_field_id( 'target' ); ?>"><?php _e( 'Open links in a new window', 'noo' )?></label>
        </p>
        <p>
            <label for="<?php echo $this ->  get_field_id('description'); ?>">
                <?php _e('Description','noo') ; ?>
            </label>
            <textarea name="<?php echo $this -> get_field_name('description') ; ?>" id="<?php echo $this -> get_field_id('description'); ?>" class="widefat" ><?php echo esc_html($description); ?></textarea>
        </p>
    <?php
    }

    public function update($new_instance, $old_instance){
        $instance = array();
        $instance['title']           = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['description']     = ( ! empty( $new_instance['description'] ) ) ? strip_tags( $new_instance['description'] ) : '';
        $instance['attach']          = ( ! empty( $new_instance['attach'] ) ) ? strip_tags( $new_instance['attach'] ) : '';
        $instance['button_name']     = ( ! empty( $new_instance['button_name'] ) ) ? strip_tags( $new_instance['button_name'] ) : '';
        $instance['button_link']     = ( ! empty( $new_instance['button_link'] ) ) ? strip_tags( $new_instance['button_link'] ) : '';
        $instance['target']          = ( ! empty( $new_instance['target'] ) ) ? strip_tags( $new_instance['target'] ) : '';
        return $instance ;
    }

}
register_widget('Noo_Request_Information');
endif;

/*widget social*/

class Noo_Social  extends WP_Widget {

    /* *
    * Register widget with WordPress.
    * parent user function class father
    */
    function  __construct() {
        parent::__construct(
            'noo_social', // Base Id
            __('Noo Social', 'noo'), // NAME
            array('description' => __('Display soical', 'noo')) // args
        ) ;
    }

    /**
     * Front-end display of widget
     */
    public function widget( $args, $instance ) {
        extract($args);
        $title = apply_filters('widget_title', $instance['title']);
        echo $before_widget ;
        if ( $title ) :
            echo $before_title.$title.$after_title ;
        endif;
        $arg_social = array(
            array('id'       =>  'facebook'),
            array('id'       =>  'google-plus'),
            array('id'       =>  'twitter'),
            array('id'       =>  'youtube'),
            array('id'       =>  'skype'),
            array('id'       =>  'linkedin'),
            array('id'       =>  'dribbble'),
            array('id'       =>  'pinterest'),
            array('id'       =>  'flickr'),
            array('id'       =>  'instagram'),

        ) ;
        if ( isset($instance['target']) ) {
            $target =' target="_blank"';
        } else {
            $target ='';
        }
        ?>
        <div class="noo_social">
            <div class="social-all">
                <?php
                foreach($arg_social as $social):
                    if (!empty($instance[$social['id']])):
                        ?>
                        <span class="footer-social">
                            <span class="social-name">
                                <?php printf(__('Follow on %s', 'noo'), esc_attr($social['id'])) ?>
                            </span>
                            <a href="<?php echo esc_url($instance[$social['id']]); ?>" class="fa fa-<?php echo esc_attr($social['id']); ?>"<?php echo esc_attr( $target ); ?>></a>
                        </span>
                    <?php
                    endif;
                endforeach;
                ?>
            </div>
        </div>
        <?php
        echo $after_widget ;


    }

    /**
     * Back-end widget form
     */
    public function  form($instrance) {
        // wp_parse_args : set default values
        $instrance = wp_parse_args( $instrance, array(
            'title'       =>  '',
            'target'      =>  '',
            'facebook'    =>  '',
            'google-plus' =>  '',
            'twitter'     =>  '',
            'youtube'     =>  '',
            'skype'       =>  '',
            'linkedin'    =>  '',
            'dribbble'    =>  '',
            'pinterest'   =>  '',
            'flickr'      =>  '',
            'instagram'   =>  ''

        ) );
        ?>
        <p>
            <label for="<?php echo $this ->  get_field_id('title'); ?>">
                <?php _e('Title','noo') ; ?>
            </label>
            <input type="text" name="<?php echo $this -> get_field_name('title') ; ?>" id="<?php echo $this -> get_field_id('title'); ?>" class="widefat" value="<?php echo esc_html($instrance['title']); ?>">
        </p>
        <p>
            <input id="<?php echo $this->get_field_id( 'target' ); ?>" name="<?php echo $this->get_field_name( 'target' ); ?>" value="_blank" type="checkbox" <?php checked( $instrance['target'], '_blank', true ); ?>/>
            <label for="<?php echo $this->get_field_id( 'target' ); ?>"><?php _e( 'Open links in a new window', 'noo' )?></label>
        </p>
        <p>
            <label for="<?php echo $this -> get_field_id('facebook') ?>" >
                <?php _e('Facebook','noo') ; ?>
            </label>
            <br>
            <input type="text" name="<?php echo $this -> get_field_name('facebook') ; ?>" id="<?php echo $this -> get_field_id('facebook'); ?>" class="widefat" value="<?php echo esc_attr($instrance['facebook']); ?>">
        </p>
        <p>
            <label for="<?php echo $this -> get_field_id('google-plus') ?>">
                <?php _e('Google','noo') ; ?>
            </label>
            <br>
            <input type="text" name="<?php echo $this -> get_field_name('google-plus') ; ?>" id="<?php echo $this -> get_field_id('google-plus'); ?>" class="widefat" value="<?php echo esc_attr($instrance['google-plus']); ?>">
        </p>
        <p>
            <label for="<?php echo $this -> get_field_id('twitter') ?>">
                <?php _e('Twitter','noo') ; ?>
            </label>
            <br>
            <input type="text" name="<?php echo $this -> get_field_name('twitter') ; ?>" id="<?php echo $this -> get_field_id('twitter'); ?>" class="widefat" value="<?php echo esc_attr($instrance['twitter']); ?>">
        </p>
        <p>
            <label for="<?php echo $this -> get_field_id('youtube') ?>">
                <?php _e('Youtube','noo') ; ?>
            </label>
            <br>
            <input type="text" name="<?php echo $this -> get_field_name('youtube') ; ?>" id="<?php echo $this -> get_field_id('youtube'); ?>" class="widefat" value="<?php echo esc_attr($instrance['youtube']); ?>">
        </p>
        <p>
            <label for="<?php echo $this -> get_field_id('skype'); ?>">
                <?php  _e('Skype','noo') ; ?>
            </label>
            <br>
            <input type="text" name="<?php echo $this -> get_field_name('skype') ; ?>" id="<?php echo $this -> get_field_id('skype'); ?>" class="widefat" value="<?php echo esc_attr($instrance['skype']); ?>">
        </p>
        <p>
            <label for="<?php echo $this -> get_field_id('linkedin') ?>">
                <?php _e('linkedin','noo') ; ?>
            </label>
            <br>
            <input type="text" name="<?php echo $this -> get_field_name('linkedin') ; ?>" id="<?php echo $this -> get_field_id('linkedin'); ?>" class="widefat" value="<?php echo esc_attr($instrance['linkedin']); ?>">
        </p>
        <p>
            <label for="<?php echo $this -> get_field_id('dribbble') ?>">
                <?php _e('Dribbble','noo') ; ?>
            </label>
            <br>
            <input type="text" name="<?php echo $this -> get_field_name('dribbble') ; ?>" id="<?php echo $this -> get_field_id('dribbble'); ?>" class="widefat" value="<?php echo esc_attr($instrance['dribbble']); ?>">
        </p>
        <p>
            <label for="<?php echo $this -> get_field_id('pinterest') ?>">
                <?php _e('Pinterest','noo') ; ?>
            </label>
            <br>
            <input type="text" name="<?php echo $this -> get_field_name('pinterest') ; ?>" id="<?php echo $this -> get_field_id('pinterest'); ?>" class="widefat" value="<?php echo esc_attr($instrance['pinterest']); ?>">
        </p>
        <p>
            <label for="<?php echo $this -> get_field_id('flickr') ?>">
                <?php _e('Flickr','noo') ; ?>
            </label>
            <br>
            <input type="text" name="<?php echo $this -> get_field_name('flickr') ; ?>" id="<?php echo $this -> get_field_id('flickr'); ?>" class="widefat" value="<?php echo esc_attr($instrance['flickr']); ?>">
        </p>
        <p>
            <label for="<?php echo $this -> get_field_id('instagram') ?>">
                <?php _e('Instagram','noo') ; ?>
            </label>
            <br>
            <input type="text" name="<?php echo $this -> get_field_name('instagram') ; ?>" id="<?php echo $this -> get_field_id('instagram'); ?>" class="widefat" value="<?php echo esc_attr($instrance['instagram']); ?>">
        </p>
    <?php
    }

    /* *
     * Method update
     */
    function update( $new_instance, $old_instance ) {
        $instance = array() ;
        $instance['title']       = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['target']      = ( ! empty( $new_instance['target'] ) ) ? strip_tags( $new_instance['target'] ) : '';
        $instance['facebook']    = ( ! empty( $new_instance['facebook'] ) ) ? strip_tags( $new_instance['facebook'] ) : ''  ;
        $instance['google-plus'] = ( ! empty( $new_instance['google-plus'] ) ) ? strip_tags( $new_instance['google-plus'] ) : ''  ;
        $instance['twitter']     = ( ! empty( $new_instance['twitter'] ) ) ? strip_tags( $new_instance['twitter'] ) : ''  ;
        $instance['youtube']     = ( ! empty( $new_instance['youtube'] ) ) ? strip_tags( $new_instance['youtube'] ) : ''  ;
        $instance['skype']       = ( ! empty( $new_instance['skype'] ) ) ? strip_tags( $new_instance['skype'] ) : ''  ;
        $instance['linkedin']    = ( ! empty( $new_instance['linkedin'] ) ) ? strip_tags( $new_instance['linkedin'] ) : ''  ;
        $instance['dribbble']    = ( ! empty( $new_instance['dribbble'] ) ) ? strip_tags( $new_instance['dribbble'] ) : ''  ;
        $instance['pinterest']   = ( ! empty( $new_instance['pinterest'] ) ) ? strip_tags( $new_instance['pinterest'] ) : ''  ;
        $instance['flickr']      = ( ! empty( $new_instance['flickr'] ) ) ? strip_tags( $new_instance['flickr'] ) : ''  ;
        $instance['instagram']   = ( ! empty( $new_instance['instagram'] ) ) ? strip_tags( $new_instance['instagram'] ) : ''  ;
        return $instance ;
    }

}
register_widget('Noo_Social');

if( !class_exists('Noo_Infomation') ):
    class Noo_Infomation extends  WP_Widget{

        public function __construct(){
            parent::__construct(
                'noo_infomation',
                'Noo Infomation',
                array('description', __('Noo Infomation', 'noo'))
            );

        }

        public function widget($args, $instance){
            extract( $args );
            extract( $instance );
            if ( ! empty( $instance['title'] ) ) {
                $title = apply_filters( 'widget_title', $instance['title'] );
            }
            echo $before_widget;
            if ( ! empty( $title ) ) {
                echo $before_title . $title . $after_title;
            }
            ?>
            <ul class="noo-infomation">
                <li>
                    <span class="fa fa-map-marker infomation-left"></span>
                    <address>
                        <?php echo esc_html($address); ?>
                    </address>
                </li>
                <li class="info-phone">
                    <span class="fa fa-phone infomation-left"></span>
                    <span><?php echo esc_html($phone); ?></span>
                </li>
                <li class="info-mail">
                    <span class="fa fa-envelope-o infomation-left"></span>
                    <span><?php echo esc_html($mail); ?></span>
                </li>
            </ul>
            <?php
            echo $after_widget;
        }

        public function form( $instance ){
            $instance = wp_parse_args( $instance, array(
                'title'     =>  'Noo Infomation',
                'address'   =>  '',
                'phone'     =>  '',
                'mail'      =>  ''
            ) );
            extract($instance);
            ?>
            <p>
                <label for="<?php echo $this -> get_field_id('title'); ?>"><?php echo _e('Title:', 'noo'); ?></label>
                <input type="text" id="<?php echo $this -> get_field_id('title'); ?>" name="<?php echo $this -> get_field_name('title') ?>" class="widefat" value="<?php echo esc_attr($title); ?>">
            </p>
            <p>
                <label for="<?php echo $this -> get_field_id('address'); ?>"><?php echo _e('Address', 'noo') ; ?></label>
                <textarea name="<?php echo $this -> get_field_name('address'); ?>" id="<?php echo $this -> get_field_id('address') ; ?>" cols="10" rows="5" class="widefat"><?php echo esc_attr($address); ?></textarea>
            </p>
            <p>
                <label for="<?php echo $this -> get_field_id('phone'); ?>"><?php echo _e('Phone:', 'noo'); ?></label>
                <input type="text" id="<?php echo $this -> get_field_id('phone'); ?>" name="<?php echo $this -> get_field_name('phone') ?>" class="widefat" value="<?php echo esc_attr($phone); ?>">
            </p>
            <p>
                <label for="<?php echo $this -> get_field_id('mail'); ?>"><?php echo _e('Mail', 'noo') ; ?></label>
                <input class="widefat" type="text" name="<?php echo $this -> get_field_name('mail'); ?>" id="<?php echo $this -> get_field_id('mail') ; ?>" value="<?php echo esc_attr($mail); ?>">
            </p>

        <?php
        }
        // method update
        public function update( $new_instance, $old_instance ){
            $instance                 =   $old_instance;
            $instance['title']        =   $new_instance['title'];
            $instance['address']      =   $new_instance['address'];
            $instance['phone']        =   $new_instance['phone'];
            $instance['mail']         =   $new_instance['mail'];
            return $instance;
        }
    }
    register_widget('Noo_Infomation');
endif;

class Noo_Widget_Categories extends WP_Widget {

	public function __construct() {
		$widget_ops = array( 'classname' => 'widget_noo_categories', 'description' => __( "A list or dropdown of categories.",'noo' ) );
		parent::__construct('noo_categories', __('Noo Categories','noo'), $widget_ops);
	}

	public function widget( $args, $instance ) {

		/** This filter is documented in wp-includes/default-widgets.php */
		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? __( 'Categories','noo' ) : $instance['title'], $instance, $this->id_base );
		$c = ! empty( $instance['count'] ) ? '1' : '0';
		$h = ! empty( $instance['hierarchical'] ) ? '1' : '0';
		$p = ! empty( $instance['parent'] ) ? 0 : '';
		echo $args['before_widget'];
		if ( $title ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}

		$cat_args = array('orderby' => 'name', 'show_count' => $c, 'parent' => $p, 'hierarchical' => $h);
?>
		<ul>
<?php
		$cat_args['title_li'] = '';

		/**
		 * Filter the arguments for the Categories widget.
		 *
		 * @since 2.8.0
		 *
		 * @param array $cat_args An array of Categories widget options.
		 */
		wp_list_categories( apply_filters( 'widget_noo_categories_args', $cat_args ) );
?>
		</ul>
<?php

		echo $args['after_widget'];
	}

	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['count'] = !empty($new_instance['count']) ? 1 : 0;
		$instance['hierarchical'] = !empty($new_instance['hierarchical']) ? 1 : 0;
		$instance['parent'] = !empty($new_instance['parent']) ? 1 : 0;

		return $instance;
	}

	public function form( $instance ) {
		//Defaults
		$instance = wp_parse_args( (array) $instance, array( 'title' => '') );
		$title = esc_attr( $instance['title'] );
		$count = isset($instance['count']) ? (bool) $instance['count'] :false;
		$hierarchical = isset( $instance['hierarchical'] ) ? (bool) $instance['hierarchical'] : false;
		$parent = isset( $instance['parent'] ) ? (bool) $instance['parent'] : false;
?>
		<p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e( 'Title:','noo' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></p>

		<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('count'); ?>" name="<?php echo $this->get_field_name('count'); ?>"<?php checked( $count ); ?> />
		<label for="<?php echo $this->get_field_id('count'); ?>"><?php _e( 'Show post counts','noo' ); ?></label><br />

		<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('hierarchical'); ?>" name="<?php echo $this->get_field_name('hierarchical'); ?>"<?php checked( $hierarchical ); ?> />
		<label for="<?php echo $this->get_field_id('hierarchical'); ?>"><?php _e( 'Show hierarchy','noo' ); ?></label></p>

		<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('parent'); ?>" name="<?php echo $this->get_field_name('parent'); ?>"<?php checked( $parent ); ?> />
		<label for="<?php echo $this->get_field_id('parent'); ?>"><?php _e( 'Only Show Parent','noo' ); ?></label></p>
<?php
	}
}

register_widget('Noo_Widget_Categories');

class Noo_Widget_Recent_News extends WP_Widget {

	public function __construct() {
		$widget_ops = array('classname' => 'widget_recent_news', 'description' => __( "Your site&#8217;s most recent Posts.",'noo') );
		parent::__construct('recent-news', __('Noo Recent News','noo'), $widget_ops);
		$this->alt_option_name = 'widget_recent_news';

		add_action( 'save_post', array($this, 'flush_widget_cache') );
		add_action( 'deleted_post', array($this, 'flush_widget_cache') );
		add_action( 'switch_theme', array($this, 'flush_widget_cache') );
	}

	public function widget($args, $instance) {
		
		$cache = array();
		if ( ! $this->is_preview() ) {
			$cache = wp_cache_get( 'widget_recent_news', 'widget' );
		}

		if ( ! is_array( $cache ) ) {
			$cache = array();
		}

		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		if ( isset( $cache[ $args['widget_id'] ] ) ) {
			echo $cache[ $args['widget_id'] ];
			return;
		}

		ob_start();

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'Recent News','noo' );

		/** This filter is documented in wp-includes/default-widgets.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

		$number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 5;
		if ( ! $number )
			$number = 5;
		$show_date = isset( $instance['show_date'] ) ? $instance['show_date'] : false;
		$show_comment = isset( $instance['show_comment'] ) ? $instance['show_comment'] : false;

		$r = new WP_Query( apply_filters( 'widget_news_args', array(
			'posts_per_page'      	=> $number,
			'no_found_rows'       	=> true,
			'post_status'         	=> 'publish',
			'ignore_sticky_posts' 	=> true,
		) ) );
		if ($r->have_posts()) :
		?>
		<?php echo $args['before_widget']; ?>
		<?php if ( $title ) {
			echo $args['before_title'] . $title . $args['after_title'];
		} ?>
		<ul>
		<?php while ( $r->have_posts() ) : $r->the_post(); ?>
			<li>
			 <?php if ( has_post_thumbnail() ):
	            the_post_thumbnail(array(60, 60));
	        else: ?>
	            <img width="60" height="60" src="<?php echo NOO_ASSETS_URI.'/images/no-image.jpg' ; ?>" alt="<?php the_title_attribute(); ?>" />
	        <?php endif;  ?>
				<h5><a href="<?php the_permalink(); ?>"><?php get_the_title() ? the_title() : the_ID(); ?></a></h5>
			<?php if ( $show_date ) : ?>
				<span class="post-date"><i class="fa fa-calendar"></i>&nbsp;<?php echo get_the_date(); ?></span>
			<?php endif; ?>
            <?php if ( $show_comment ) : ?>
                <?php
                $comment_title = '';
                $comment_number = '';
                $comment_title = sprintf(__('View all comments on: &ldquo;%s&rdquo;', 'noo') , get_the_title());
                $comment_number =  ' ' . get_comments_number();
                ?>
                <span class="post-comment"><i class="fa fa-comments-o"></i>&nbsp;<a href="<?php echo esc_url(get_comments_link()) ?>" title="<?php echo esc_attr($comment_title)?>"><?php echo $comment_number;?></a></span>
            <?php endif; ?>
			</li>
		<?php endwhile; ?>
		</ul>
		<?php echo $args['after_widget']; ?>
		<?php
		// Reset the global $the_post as this query will have stomped on it
		wp_reset_postdata();

		endif;
	
		if ( ! $this->is_preview() ) {
			$cache[ $args['widget_id'] ] = ob_get_flush();
			wp_cache_set( 'widget_recent_news', $cache, 'widget' );
		} else {
			ob_end_flush();
		}
	}

	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = (int) $new_instance['number'];
		$instance['show_date'] = isset( $new_instance['show_date'] ) ? (bool) $new_instance['show_date'] : false;
		$instance['show_comment'] = isset( $new_instance['show_comment'] ) ? (bool) $new_instance['show_comment'] : false;
		$this->flush_widget_cache();

		$alloptions = wp_cache_get( 'alloptions', 'options' );
		if ( isset($alloptions['widget_recent_entries']) )
			delete_option('widget_recent_entries');

		return $instance;
	}

	public function flush_widget_cache() {
		wp_cache_delete('widget_recent_news', 'widget');
	}

	public function form( $instance ) {
		$title          = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$number         = isset( $instance['number'] ) ? absint( $instance['number'] ) : 5;
		$show_date      = isset( $instance['show_date'] ) ? (bool) $instance['show_date'] : false;
		$show_comment   = isset( $instance['show_comment'] ) ? (bool) $instance['show_comment'] : false;
		?>
		<p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:','noo' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" /></p>

		<p><label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'Number of posts to show:','noo' ); ?></label>
		<input id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="text" value="<?php echo $number; ?>" size="3" /></p>

		<p><input class="checkbox" type="checkbox" <?php checked( $show_date ); ?> id="<?php echo $this->get_field_id( 'show_date' ); ?>" name="<?php echo $this->get_field_name( 'show_date' ); ?>" />
		<label for="<?php echo $this->get_field_id( 'show_date' ); ?>"><?php _e( 'Display post date?','noo' ); ?></label></p>
        <p><input class="checkbox" type="checkbox" <?php checked( $show_comment ); ?> id="<?php echo $this->get_field_id( 'show_comment' ); ?>" name="<?php echo $this->get_field_name( 'show_comment' ); ?>" />
		<label for="<?php echo $this->get_field_id( 'show_comment' ); ?>"><?php _e( 'Display post comment?','noo' ); ?></label></p>
		<?php
	}
}

register_widget('Noo_Widget_Recent_News');

class Noo_Widget_Most_Views extends WP_Widget {

	public function __construct() {
		$widget_ops = array('classname' => 'widget_most_view', 'description' => __( "Your site&#8217;s most recent Posts.",'noo') );
		parent::__construct('most-views', __('Noo Post Most View','noo'), $widget_ops);


	}

	public function widget($args, $instance) {
        extract( $args );
        extract( $instance );
        if ( ! empty( $instance['title'] ) ) {
            $title = apply_filters( 'widget_title', $instance['title'] );
        }
        echo $before_widget;
        if ( ! empty( $title ) ) {
            echo $before_title . $title . $after_title;
        }
        $array = array(
            'posts_per_page'      => $number,
            'no_found_rows'       => true,
            'post_status'         => 'publish',
            'ignore_sticky_posts' => true,
            'meta_key'           =>  'post_views_count',
            'orderby'            =>  'meta_value',
            'order'              =>  'DESC',
        );
        $query = new WP_Query($array);
        if( $query->have_posts() ):
        ?>
            <ul class="noo-mostviews">
                <?php while($query->have_posts()):
                            $query->the_post();?>
                <li>
                    <h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
                    <?php noo_content_meta(); ?>
                </li>
                <?php endwhile; ?>
            </ul>
        <?php endif; wp_reset_postdata(); ?>
        <?php
        echo $after_widget;
	}

	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
        $instance['title']    = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : ''  ;
        $instance['number']    = ( ! empty( $new_instance['number'] ) ) ? strip_tags( $new_instance['number'] ) : ''  ;

		return $instance;
	}


	public function form( $instance ) {
		$title          = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$number         = isset( $instance['number'] ) ? absint( $instance['number'] ) : 5;
		?>
		<p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:','noo' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" /></p>

		<p><label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'Number of posts to show:','noo' ); ?></label>
		<input id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="text" value="<?php echo $number; ?>" size="3" /></p>


		<?php
	}
}

register_widget('Noo_Widget_Most_Views');

class Noo_Widget_Album_Most_Views_inMonth extends WP_Widget {

    public function __construct() {
        $widget_ops = array('classname' => 'widget_most_view', 'description' => __( "Show Most view of Album in Month ",'noo') );
        parent::__construct('album-most-views', __('Noo Album Most View In Month','noo'), $widget_ops);


    }

    public function widget($args, $instance) {
        extract( $args );
        extract( $instance );
        
        echo $before_widget;
        echo $before_title . esc_html__('Most view in ' . date('F') , 'noo') . $after_title;

        $array = array(
            'posts_per_page'      => $number,
            'no_found_rows'       => true,
            'post_type'           => 'noo_album',
            'post_status'         => 'publish',
            'ignore_sticky_posts' => true,
            'meta_key'            =>  'post_views_count',
            'orderby'             =>  'meta_value',
            'order'               =>  'DESC',
        );
        $query = new WP_Query($array);
        if( $query->have_posts() ):
        ?>
            <ul class="noo-mostviews">
                <?php while($query->have_posts()):
                            $query->the_post();?>
                <li>
                    <h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
                    <p class="content-meta">
                        <span>
                            <i class="fa fa-calendar"></i>
                            <?php echo get_the_term_list(get_the_ID(),'album_genre', '', ', ', '')?>
                        </span>
                        <span><i class="fa fa-eye"></i><?php echo getPostViews(get_the_ID()); ?></span>
                    </p>
                </li>
                <?php endwhile; ?>
            </ul>
        <?php endif; wp_reset_postdata(); ?>
        <?php
        echo $after_widget;
    }

    public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['number']    = ( ! empty( $new_instance['number'] ) ) ? strip_tags( $new_instance['number'] ) : ''  ;

        return $instance;
    }


    public function form( $instance ) {
        $number         = isset( $instance['number'] ) ? absint( $instance['number'] ) : 5;
        ?>

        <p><label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'Number of album to show:','noo' ); ?></label>
        <input id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="text" value="<?php echo $number; ?>" size="3" /></p>


        <?php
    }
}

register_widget('Noo_Widget_Album_Most_Views_inMonth');



