<?php
/**
 * The Template for displaying all single products.
 *
 * Override this template by copying it to yourtheme/woocommerce/single-product.php
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header( 'shop' ); ?>
<?php
$product_layout = noo_get_option('noo_woocommerce_product_layout', 'same_as_shop');
$layout_single = $product_layout;
if($product_layout == 'same_as_shop'){
    $layout = noo_get_option('noo_shop_layout', 'fullwidth');
    $class= 'col-md-9';
    if( $layout == 'fullwidth' ){
        $class= 'col-md-12';
    }
    if($layout == 'left_sidebar'){
        $class= 'col-md-9 pull-right';
    }
    $layout_single= $layout;
}else{
    $class= 'col-md-9';
    if( $product_layout == 'fullwidth' ){
        $class= 'col-md-12';
    }
    if($product_layout == 'left_sidebar'){
        $class= 'col-md-9 pull-right';
    }
}

wp_enqueue_script( 'prettyPhoto' );
wp_enqueue_script( 'prettyPhoto-init' );
wp_enqueue_style( 'woocommerce_prettyPhoto_css' );
?>
<div id="content" class="container-wrap">
    <div class="container">
        <div class="row">
            <div class="<?php echo esc_attr($class) ; ?>">
                <?php
                    /**
                     * woocommerce_before_main_content hook
                     *
                     * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
                     * @hooked woocommerce_breadcrumb - 20
                     */
                    do_action( 'woocommerce_before_main_content' );
                ?>

                    <?php while ( have_posts() ) : the_post(); ?>

                        <?php wc_get_template_part( 'content', 'single-product' ); ?>

                    <?php endwhile; // end of the loop. ?>

                <?php
                    /**
                     * woocommerce_after_main_content hook
                     *
                     * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
                     */
                    do_action( 'woocommerce_after_main_content' );
                ?>
            </div>
            <?php
            if( $layout_single != 'fullwidth' ):
                /**
                 * woocommerce_sidebar hook
                 *
                 * @hooked woocommerce_get_sidebar - 10
                 */
                do_action( 'woocommerce_sidebar' );
            endif;
            ?>
        </div>
    </div>
</div><!--/.container-wrap-->
<?php get_footer( 'shop' ); ?>
