<?php
/**
 * BuddyPress Members Directory
 *
 * @version 3.0.0
 */

if (isset($_GET['members_table'])) {
	update_option('buddy_members_layout_temp', 'table');
}

$buddy_members_layout = woffice_get_theming_option('buddy_members_layout');
$buddy_members_layout_temp = woffice_get_theming_option('buddy_members_layout_temp');

if (!empty($buddy_members_layout_temp)) {
	$buddy_members_layout = $buddy_members_layout_temp;
}

$table_class = $buddy_members_layout;

?>

<div class="content" data-template="woffice">

	<div class="intern-padding clearfix" data-template="woffice">

		<?php bp_nouveau_before_members_directory_content(); ?>

		<?php if ( ! bp_nouveau_is_object_nav_in_sidebar() ) : ?>

			<?php bp_get_template_part( 'common/nav/directory-nav' ); ?>

		<?php endif; ?>

		<div class="screen-content">

			<?php bp_get_template_part( 'common/search-and-filters-bar' ); ?>
			<div id="members-dir-list" class="members dir-list is-<?php echo esc_attr($table_class);?>-view" data-bp-list="members">
				<div id="bp-ajax-loader"><?php bp_nouveau_user_feedback( 'directory-members-loading' ); ?></div>
			</div>

			<?php bp_nouveau_after_members_directory_content(); ?>
		</div>

	</div>

</div>
