<?php
/**
 * We get all the style options from the Theme Settings and we inject CSS in the page's header
 *
 * @return string
 */
function woffice_get_custom_css()
{

	/*---------------------------------------------------------
	**
	** MAIN FONTS SETTINGS
	**
	----------------------------------------------------------*/
	$font_main_typography = woffice_get_theming_option('font_main_typography');
	$font_headline_typography = woffice_get_theming_option('font_headline_typography');
	$font_headline_bold = woffice_get_theming_option('font_headline_bold');
	$font_headline_uppercase = woffice_get_theming_option('font_headline_uppercase');
	$dashboard_headline_uppercase = woffice_get_theming_option('dashboard_headline_uppercase');
	$menu_headline_uppercase = woffice_get_theming_option('menu_headline_uppercase');
	$main_featured_color        = woffice_get_theming_option('main_featured_color');
	$header_fixed = woffice_get_theming_option('header_fixed'); 
	$css = '';
	$theme_settings_options = get_option('woffice_theme_options');

	$font_main_ready = woffice_customization_get_array('font_main', 'font_main');
	$ff_family = isset($font_main_typography['font-family']) ? $font_main_typography['font-family'] : '';
	$ff_size = isset($font_main_typography['font-size']) ? $font_main_typography['font-size'] : '';
	$ff_line_height = isset($font_main_typography['line-height']) ? $font_main_typography['line-height'] : '';
	$hl_family = isset($font_headline_typography['font-family']) ? $font_headline_typography['font-family'] : '';
	$hl_line_height = isset($font_headline_typography['font-family']) ? $font_headline_typography['font-family'] : '';
    if(isset($font_main_typography['line-height']) && isset($font_main_typography['line-height'])) {
        $css .= $font_main_ready . '{';
        $css .= 'font-family: ' . $ff_family . ',helvetica, arial, sans-serif; ';
        $css .= 'font-size: ' . $ff_size . ';';
		$css .= 'line-height: ' . $ff_line_height . ';';
        $css .= '}';
        $css .= 'h1,h2,h3,h4,h5,h6, #content-container .infobox-head{';
        $css .= 'font-family: "' . $hl_family . '",helvetica, arial, sans-serif; ';
		$css .= 'line-height: ' . $hl_line_height. ';';
        $css .= '}';
    }

	$css .= '#content-container .intern-box.box-title h3{';
	if (woffice_validate_bool_option($dashboard_headline_uppercase)):
		$css .= 'text-transform: uppercase !important;';
	else:
		$css .= 'text-transform: none;';
	endif;
	$css .= '}';
	$css .= 'h1, h2, h3, h4, h5, h6{';
		if (woffice_validate_bool_option($font_headline_uppercase)):
			$css .= 'text-transform: uppercase;';
		endif;
		if (woffice_validate_bool_option($font_headline_bold)):
			$css .= 'font-weight: bold !important;';
		endif;
	$css .= '}';
	if ($menu_headline_uppercase == "yep"):
		$css .= '.main-item.li > a{';
		$css .= 'text-transform: uppercase;';
		$css .= '}';
	endif;

	/*---------------------------------------------------------
	**
	** MAIN/PRIMARY COLORS SETTINGS
	**
	----------------------------------------------------------*/

	$primary_background_color = woffice_customization_get_array('primary_background_color','primary_background_color');
	$border_color = woffice_customization_get_array('border_color','border_color');
	$hover_with_border = woffice_customization_get_array('hover_with_border','hover_with_border');
	$primary_text_color = woffice_customization_get_array('primary_text_color','primary_text_color');
	
	$primary_color = isset($theme_settings_options['primary-color']) ? $theme_settings_options['primary-color'] : false;

	if($primary_color) {
		$css .= $primary_background_color . '{';
			$css .= 'background-color: ' . esc_html($primary_color) . ';';
		$css .= '}';

		$css .= '#right-sidebar .widget.widget_nav_menu #menu-demo-nav .menu-item:hover a{';
			$css .= 'color: ' . esc_html($primary_color) . ';';
		$css .= '}';

		$css .= '#right-sidebar .widget.widget_nav_menu #menu-demo-nav .menu-item:hover::before {';
			$css .= 'background-color: ' . esc_html($primary_color) . ';';
		$css .= '}';

		$css .= '#right-sidebar .widget.widget_nav_menu #menu-demo-nav .menu-item::before {';
			$css .= 'background-color: ' . woffice_hex2rgba($primary_color, 0.60,false) . ';';
		$css .= '}';

		$css .= '#right-sidebar .widget.widget_nav_menu #menu-demo-nav::after {';
			$css .= 'border-left-color: ' . woffice_hex2rgba($primary_color, 0.80,false) . ';';
		$css .= '}';

		$css .= '.widget_woffice_funfacts .flexslider .flex-control-nav li a {';
			$css .= 'background-color: ' . woffice_hex2rgba($primary_color, 0.80,false) . ';';
		$css .= '}';

		$css .= $border_color . '{';
			$css .= 'border-color:' . esc_html($primary_color) . ';';
		$css .= '}';

		$css .= $hover_with_border . '{';
			$css .= 'color:'.esc_html($primary_color).'; border-color:' . esc_html($primary_color) . ';';
		$css .= '}';

		$css .= $primary_text_color . '{';
			$css .= 'color:'.esc_html($primary_color).';';
		$css .= '}';
	}

	$css .= '#user-sidebar {';
		$css .= 'background: #ffffff;';
		$css .= '}';

	/*---------------------------------------------------------
	**
	** BACKGROUND COLOR DARK
	**
	----------------------------------------------------------*/
	$background_dark = woffice_customization_get_array('background_dark','background_dark');
	$bgcolor_dark = isset($theme_settings_options['bgcolor-dark']) ? $theme_settings_options['bgcolor-dark'] : false;

	if($bgcolor_dark) {
		$css .= $background_dark . '{';
			$css .= 'background-color:'.esc_html($bgcolor_dark).';';
		$css .= '}';
	}
	
	/*---------------------------------------------------------
	**
	** BACKGROUND BODY
	**
	----------------------------------------------------------*/
	$body_background_color = isset($theme_settings_options['bgcolor-light']) ? $theme_settings_options['bgcolor-light'] : false;
	$bg_light = woffice_customization_get_array('background_light','background_light');

	if($body_background_color) {
		$css .= $bg_light . '{';
			$css .= 'background-color:'.esc_html($body_background_color).';';
		$css .= '}';
	}

	/*---------------------------------------------------------
	**
	** HEADING COLOR / TEXT COLOR DARK
	**
	----------------------------------------------------------*/
	$text_dark = woffice_customization_get_array('text_color_dark','text_color_dark');
	$text_color_dark = isset($theme_settings_options['text-color-dark']) ? $theme_settings_options['text-color-dark'] : false;

	if($text_color_dark) {
		$css .= $text_dark . '{';
			$css .= 'color:'.esc_html($text_color_dark).';';
		$css .= '}';
	}

	/*---------------------------------------------------------
	**
	** LIGHT COLOR / TEXT COLOR LIGHT
	**
	----------------------------------------------------------*/
	$text_light = woffice_customization_get_array('text_color_light','text_color_light');
	$text_color_light = isset($theme_settings_options['text-color-light']) ? $theme_settings_options['text-color-light'] : false;

	if($text_color_light) {
		$css .= $text_light . '{';
			$css .= 'color:'.esc_html($text_color_light).';';
		$css .= '}';
	}	

	/*---------------------------------------------------------
	**
	** Custom Menu colors
	**
	----------------------------------------------------------*/

	$woffice_has_custom_menu_color = woffice_get_theming_option('enable_menu_style');

	if($woffice_has_custom_menu_color) {
		$navigation_backround = woffice_get_theming_option('menu_background');
		$css .= '#navigation {';
			$css .= 'background:'.esc_html($navigation_backround).';';
		$css .= '}';

		$menu_text_color_selector = woffice_customization_get_array('menu_text_color','menu_text_color');
		$menu_text_color =  woffice_get_theming_option('menu_text_color');
		$css .= $menu_text_color_selector . '{';
			$css .= 'color:'.esc_html($menu_text_color).';';
		$css .= '}';

		$menu_hover_color =  woffice_get_theming_option('menu_hover_color');
		$css .= 'body.vertical-modern-menu .main-modern-menu li.menu-item a.current-menu-highlight, 
		body.vertical-modern-menu .main-modern-menu>li.current_page_item>a,
		body.vertical-modern-menu .main-modern-menu>li.current-menu-item>a, 
		body.vertical-modern-menu .main-modern-menu>li.current_page_ancestor>a,
		body.vertical-modern-menu .main-modern-menu li.menu-item a:hover,
		body.vertical-modern-menu .main-modern-menu li.menu-item a:hover,
		body.vertical-modern-menu .main-modern-menu li.menu-item a.current-menu-highlight,
		body.vertical-modern-menu .main-modern-menu li.menu-item:not(.current-menu-ancestor) span.click_menutoggle:hover+a,
		body.vertical-modern-menu .main-modern-menu li.menu-item.current-menu-ancestor span.click_menutoggle.caret-up:hover+a,
		body.vertical-modern-menu .main-modern-menu li.menu-item:not(.current-menu-ancestor) span.click_menutoggle:hover+a.current-menu-highlight,
		body.menu-is-horizontal .main-modern-menu li.menu-item:not(.mega-menu-col).current-menu-item>a, 
		body.menu-is-horizontal .main-modern-menu li.menu-item:not(.mega-menu-col).current-menu-parent>a, 
		body.menu-is-horizontal .main-modern-menu li.menu-item:not(.mega-menu-col).current_page_ancestor>a,
		body.menu-is-horizontal .main-modern-menu li.menu-item:not(.mega-menu-col)>a:hover,
		body.menu-is-horizontal .main-modern-menu li.menu-item:not(.mega-menu-col):hover>a{';
			$css .= 'background:'.esc_html($menu_hover_color).';';
		$css .= '}';

		$menu_hover_text_color =  woffice_get_theming_option('menu_hover_text_color');
		$css .= 'body.vertical-modern-menu .main-modern-menu li.menu-item>.click_menutoggle.stellar_heading_color::after,
		body.vertical-modern-menu .main-modern-menu li.menu-item a:hover,
		body.vertical-modern-menu .main-modern-menu li.menu-item a.current-menu-highlight, 
		body.vertical-modern-menu .main-modern-menu>li.current_page_item>a, 
		body.vertical-modern-menu .main-modern-menu>li.current-menu-item>a, 
		body.vertical-modern-menu .main-modern-menu>li.current_page_ancestor>a,
		body.vertical-modern-menu .main-modern-menu li.menu-item>.click_menutoggle.caret-up:after,
		body.vertical-modern-menu .main-modern-menu li.menu-item.current-menu-ancestor span.click_menutoggle.caret-up:hover+a,
		body.vertical-modern-menu .main-modern-menu li.menu-item:not(.current-menu-ancestor) span.click_menutoggle:hover+a,
		body.vertical-modern-menu .main-modern-menu li.menu-item:not(.current-menu-ancestor) span.click_menutoggle:hover+a.current-menu-highlight,
		body.vertical-modern-menu .main-modern-menu li.menu-item-has-children>.click_menutoggle.caret-up,
		body.vertical-modern-menu .main-modern-menu li.menu-item>.click_menutoggle.caret-up.stellar_heading_color::after,
		body.vertical-modern-menu .main-modern-menu li.menu-item ul.sub-menu li.current-menu-item > a, 
		body.vertical-modern-menu .main-modern-menu li.menu-item ul.sub-menu li.menu-item a.current-menu-highlight,
		body.vertical-modern-menu .main-modern-menu li.menu-item ul.sub-menu li.menu-item .click_menutoggle.caret-up:after,
		body.menu-is-horizontal .main-modern-menu li.menu-item:not(.mega-menu-col):hover>a,
		body.menu-is-horizontal .main-modern-menu li.menu-item:not(.mega-menu-col).current-menu-item>a, 
		body.menu-is-horizontal .main-modern-menu li.menu-item:not(.mega-menu-col).current-menu-parent>a, 
		body.menu-is-horizontal .main-modern-menu li.menu-item:not(.mega-menu-col).current_page_ancestor>a,
		body.menu-is-horizontal .main-modern-menu li.menu-item:not(.mega-menu-col)>a:hover{';
			$css .= 'color:'.esc_html($menu_hover_text_color).';';
		$css .= '}';

		$submenu_background =  woffice_get_theming_option('submenu_background');
		$css .= 'body.vertical-modern-menu .main-modern-menu li.menu-item ul.sub-menu,
		body.menu-is-horizontal .main-modern-menu li.menu-item ul.sub-menu,
		body.menu-is-horizontal .main-modern-menu li.menu-item ul.sub-menu,
		body.menu-is-horizontal ul.sub-menu:not(.sub-menu-click) li:not(.mega-menu-col):hover>.sub-menu:not(.sub-menu-click) {';
			$css .= 'background:'.esc_html($submenu_background).';';
		$css .= '}';

		$submenu_normal_color =  woffice_get_theming_option('submenu_text_color');
		$css .= 'body.vertical-modern-menu .main-modern-menu li.menu-item ul.sub-menu li.menu-item a,
		body.vertical-modern-menu .main-modern-menu li.menu-item ul.sub-menu li.menu-item .click_menutoggle:after{';
			$css .= 'color:'.esc_html($submenu_normal_color).';';
		$css .= '}';

		$submenu_hover_bg_color =  woffice_get_theming_option('submenu_hover_bg_color');
		$css .= 'body.menu-is-horizontal .main-modern-menu ul.sub-menu li.menu-item>a:hover,
		body.menu-is-horizontal .main-modern-menu ul.sub-menu li.menu-item li>a:hover,
		body.menu-is-horizontal .main-modern-menu ul.sub-menu li.menu-item:not(.mega-menu-col):hover>a,
		body.menu-is-horizontal .main-modern-menu ul.sub-menu li.menu-item:not(.mega-menu-col).current-menu-item>a{';
			$css .= 'background:'.esc_html($submenu_hover_bg_color).';';
		$css .= '}';

		$submenu_hover_text_color =  woffice_get_theming_option('submenu_hover_text_color');
		$css .= 'body.vertical-modern-menu .main-modern-menu li.menu-item ul.sub-menu li.menu-item a:hover,
		body.vertical-modern-menu .main-modern-menu li.menu-item ul.sub-menu li.current-menu-item > a,
		body.vertical-modern-menu .main-modern-menu li.menu-item ul.sub-menu li.current-menu-ancestor>a, 
		body.vertical-modern-menu .main-modern-menu li.menu-item ul.sub-menu li.current-menu-item>a, 
		body.vertical-modern-menu .main-modern-menu li.menu-item ul.sub-menu li.menu-item+.current-menu-highlight::after,
		body.vertical-modern-menu .main-modern-menu li.menu-item ul.sub-menu li.menu-item a.caret-up,
		body.vertical-modern-menu .main-modern-menu li.menu-item ul.sub-menu li.menu-item .click_menutoggle.stellar_sub_menu_color::after,
		body.vertical-modern-menu .main-modern-menu li.menu-item ul.sub-menu li.menu-item .click_menutoggle.caret-up:after,
		body.vertical-modern-menu .main-modern-menu li.menu-item ul.sub-menu li.current-menu-item > a, 
		body.vertical-modern-menu .main-modern-menu li.menu-item ul.sub-menu li.menu-item a.current-menu-highlight,
		body.vertical-modern-menu .main-modern-menu li.menu-item ul.sub-menu li.menu-item a.current-menu-highlight:hover,
		body.vertical-modern-menu .main-modern-menu li.menu-item ul.sub-menu li.menu-item span.click_menutoggle:hover+a,
		body.vertical-modern-menu .main-modern-menu li.menu-item ul.sub-menu li.current-menu-item .click_menutoggle:after,
		body.vertical-modern-menu .main-modern-menu li.menu-item ul.sub-menu li.menu-item .click_menutoggle.caret-up.stellar_sub_menu_color::after,
		body.menu-is-horizontal .main-modern-menu ul.sub-menu li.menu-item>a:hover,
		body.menu-is-horizontal .main-modern-menu ul.sub-menu li.menu-item:not(.mega-menu-col).current-menu-item>a,
		body.menu-is-horizontal .main-modern-menu ul.sub-menu li.menu-item li>a:hover,
		body.menu-is-horizontal .main-modern-menu ul.sub-menu li.menu-item:not(.mega-menu-col):hover>a{';
			$css .= 'color:'.esc_html($submenu_hover_text_color).';';
		$css .= '}';
	}

	/*---------------------------------------------------------
	**
	** Custom Menu fonts
	**
	----------------------------------------------------------*/

	$woffice_has_custom_menu_color = woffice_get_theming_option('enable_menu_typography');

	if($woffice_has_custom_menu_color){
		$menu_font_desktop = woffice_get_theming_option('menu_font_desktop');
		
		$css .= 'body.vertical-modern-menu .main-modern-menu li.menu-item a,
		body.menu-is-horizontal .main-modern-menu li.menu-item a{';
			if(isset($menu_font_desktop['font-family']) && !empty($menu_font_desktop['font-family'])){
				$css .= 'font-family:'.esc_html($menu_font_desktop['font-family']).';';
			}
			if(isset($menu_font_desktop['font-size']) && !empty($menu_font_desktop['font-size'])){
				$css .= 'font-size:'.esc_html($menu_font_desktop['font-size']).';';
			}
			if(isset($menu_font_desktop['line-height']) && !empty($menu_font_desktop['line-height'])){
				$css .= 'line-height:'.esc_html($menu_font_desktop['line-height']).';';
			}
			if(isset($menu_font_desktop['font-weight']) && !empty($menu_font_desktop['font-weight'])){
				$css .= 'font-weight:'.esc_html($menu_font_desktop['font-weight']).';';
			}
		$css .= '}';

		$menu_font_tablet = woffice_get_theming_option('menu_font_tablet');
		$css .= ' @media only screen and (max-width: 1024px) {';
			$css .= 'body.vertical-modern-menu .main-modern-menu li.menu-item a,
			body.menu-is-horizontal .main-modern-menu li.menu-item a{';
				if(isset($menu_font_tablet['font-family']) && !empty($menu_font_tablet['font-family'])){
					$css .= 'font-family:'.esc_html($menu_font_tablet['font-family']).';';
				}
				if(isset($menu_font_tablet['font-size']) && !empty($menu_font_tablet['font-size'])){
					$css .= 'font-size:'.esc_html($menu_font_tablet['font-size']).';';
				}
				if(isset($menu_font_tablet['line-height']) && !empty($menu_font_tablet['line-height'])){
					$css .= 'line-height:'.esc_html($menu_font_tablet['line-height']).';';
				}
				if(isset($menu_font_tablet['font-weight']) && !empty($menu_font_tablet['font-weight'])){
					$css .= 'font-weight:'.esc_html($menu_font_tablet['font-weight']).';';
				}
			$css .= '}}';

		$menu_font_mobile = woffice_get_theming_option('menu_font_mobile');
		$css .= ' @media only screen and (max-width: 767px) {';
			$css .= 'body.vertical-modern-menu .main-modern-menu li.menu-item a,
			body.menu-is-horizontal .main-modern-menu li.menu-item a{';
				if(isset($menu_font_mobile['font-family']) && !empty($menu_font_tablet['font-family'])){
					$css .= 'font-family:'.esc_html($menu_font_mobile['font-family']).';';
				}
				if(isset($menu_font_mobile['font-size']) && !empty($menu_font_mobile['font-size'])){
					$css .= 'font-size:'.esc_html($menu_font_mobile['font-size']).';';
				}
				if(isset($menu_font_mobile['line-height']) && !empty($menu_font_tablet['line-height'])){
					$css .= 'line-height:'.esc_html($menu_font_mobile['line-height']).';';
				}
				if(isset($menu_font_mobile['font-weight']) && !empty($menu_font_mobile['font-weight'])){
					$css .= 'font-weight:'.esc_html($menu_font_mobile['font-weight']).';';
				}
			$css .= '}}';

			// Sub Menu Fonts
			$submenu_font_desktop = woffice_get_theming_option('submenu_font_desktop');
			$css .= 'body.vertical-modern-menu .main-modern-menu li.menu-item ul.sub-menu li.menu-item a,
			body.menu-is-horizontal .main-modern-menu li.menu-item ul.sub-menu li.menu-item a{';
				if(isset($submenu_font_desktop['font-family']) && !empty($submenu_font_desktop['font-family'])){
					$css .= 'font-family:'.esc_html($submenu_font_desktop['font-family']).';';
				}
				if(isset($submenu_font_desktop['font-size']) && !empty($submenu_font_desktop['font-size'])){
					$css .= 'font-size:'.esc_html($submenu_font_desktop['font-size']).';';
				}
				if(isset($submenu_font_desktop['line-height']) && !empty($submenu_font_desktop['line-height'])){
					$css .= 'line-height:'.esc_html($submenu_font_desktop['line-height']).';';
				}
				if(isset($submenu_font_desktop['font-weight']) && !empty($submenu_font_desktop['font-weight'])){
					$css .= 'font-weight:'.esc_html($submenu_font_desktop['font-weight']).';';
				}
			$css .= '}';
	
			$submenu_font_tablet = woffice_get_theming_option('submmenu_font_tablet');
			$css .= ' @media only screen and (max-width: 1024px) {';
				$css .= 'body.vertical-modern-menu .main-modern-menu li.menu-item ul.sub-menu li.menu-item a,
				body.menu-is-horizontal .main-modern-menu li.menu-item ul.sub-menu li.menu-item a{';
					if(isset($submenu_font_tablet['font-family']) && !empty($submenu_font_tablet['font-family'])){
						$css .= 'font-family:'.esc_html($submenu_font_tablet['font-family']).';';
					}
					if(isset($submenu_font_tablet['font-size']) && !empty($submenu_font_tablet['font-size'])){
						$css .= 'font-size:'.esc_html($submenu_font_tablet['font-size']).';';
					}
					if(isset($submenu_font_tablet['line-height']) && !empty($submenu_font_tablet['line-height'])){
						$css .= 'line-height:'.esc_html($submenu_font_tablet['line-height']).';';
					}
					if(isset($submenu_font_tablet['font-weight']) && !empty($submenu_font_tablet['font-weight'])){
						$css .= 'font-weight:'.esc_html($submenu_font_tablet['font-weight']).';';
					}
				$css .= '}}';
	
			$submenu_font_mobile = woffice_get_theming_option('submmenu_font_mobile');
			$css .= ' @media only screen and (max-width: 767px) {';
				$css .= 'body.vertical-modern-menu .main-modern-menu li.menu-item ul.sub-menu li.menu-item a,
				body.menu-is-horizontal .main-modern-menu li.menu-item ul.sub-menu li.menu-item a{';
					if(isset($submenu_font_mobile['font-family']) && !empty($submenu_font_tablet['font-family'])){
						$css .= 'font-family:'.esc_html($submenu_font_mobile['font-family']).';';
					}
					if(isset($submenu_font_mobile['font-size']) && !empty($submenu_font_mobile['font-size'])){
						$css .= 'font-size:'.esc_html($submenu_font_mobile['font-size']).';';
					}
					if(isset($submenu_font_mobile['line-height']) && !empty($submenu_font_tablet['line-height'])){
						$css .= 'line-height:'.esc_html($submenu_font_mobile['line-height']).';';
					}
					if(isset($submenu_font_mobile['font-weight']) && !empty($submenu_font_mobile['font-weight'])){
						$css .= 'font-weight:'.esc_html($submenu_font_mobile['font-weight']).';';
					}
				$css .= '}}';
	}


	//MOBILE CHANGES SINCE 1.4.3

	/*---------------------------------------------------------
	**
	** HEADER SETTINGS
	**
	----------------------------------------------------------*/
	
	/*---------------------------------------------------------
	**
	** PAGE TITLE / TITLE BOX SETTINGS
	**
	----------------------------------------------------------*/
	$has_title_border = isset($theme_settings_options['show_title_box_border']) ? $theme_settings_options['show_title_box_border'] : false;
	$title_box_border = isset($theme_settings_options['title_box_bordercolor']) ? $theme_settings_options['title_box_bordercolor'] : false;
	$title_box_color = isset($theme_settings_options['title_box_color']) ? $theme_settings_options['title_box_color'] : false;
	$title_box_height = isset($theme_settings_options['title_box_height']) ? $theme_settings_options['title_box_height'] : false;
	$title_box_overlay = isset($theme_settings_options['title_box_overlay']) ? $theme_settings_options['title_box_overlay'] : false;
	$title_box_fontsize = isset($theme_settings_options['title_box_fontsize']) ? $theme_settings_options['title_box_fontsize'] : false;
	$title_box_transform = isset($theme_settings_options['title_box_transform']) ? $theme_settings_options['title_box_transform'] : false;
	$title_box_bold = isset($theme_settings_options['title_box_bold']) ? $theme_settings_options['title_box_bold'] : false;
	$title_boxbg_image = isset($theme_settings_options['title_boxbg_image']) ? $theme_settings_options['title_boxbg_image'] : false;

	if($title_box_fontsize == 'custom') {
		$title_box_fontsize = isset($theme_settings_options['title_box_custom_fontsize']) ? $theme_settings_options['title_box_custom_fontsize'] : false;
	}

	if ($has_title_border && $title_box_border) :
		$css .= '#featuredbox{';
		$css .= 'border-color: ' . esc_html($title_box_border) . ' !important;';
		$css .= 'border-bottom: 6px solid;';
		$css .= '}';
	endif;
	$css .= '#featuredbox .featured-background{';
		$css .= 'height: ' . intval($title_box_height) . 'px;';
	$css .= '}';
	$css .= '#featuredbox .pagetitle, #featuredbox .pagetitle h1{';
		$css .= 'font-size: ' . esc_html($title_box_fontsize) . 'px;';
		$css .= 'font-weight: ' . esc_html($title_box_bold) . ';';
		$css .= 'text-transform: ' . esc_html($title_box_transform) . ';';
		$css .= 'color: ' . esc_html($title_box_color) . ';';
	$css .= '}';
	$css .= '#featuredbox .featured-background{';
		$css .= 'background-position: ' . $title_boxbg_image['background-position'] . ';';
		$css .= 'background-repeat: ' . $title_boxbg_image['background-repeat'] . ';';
		$css .= 'background-attachment: ' . $title_boxbg_image['background-attachment'] . ';';
		$css .= 'background-size: ' . $title_boxbg_image['background-size'] . ';';
	$css .= '}';
	$css .= '#featuredbox .featured-layer{';
		$css .= 'background-color: ' . esc_html($title_box_overlay) . ';';
	$css .= '}';


	/*---------------------------------------------------------
	**
	** BuddyPress Cover Image
	**
	----------------------------------------------------------*/
	$boddy_press_image = isset($theme_settings_options['buddypress_default_cover_image']) ? $theme_settings_options['buddypress_default_cover_image'] : false;
	$boddy_press_overlay = isset($theme_settings_options['buddypress_cover_overlay']) ? $theme_settings_options['buddypress_cover_overlay'] : false;
	if(!$boddy_press_overlay) {
		$boddy_press_overlay = 'transparent';
	}
	$bg_position = isset($boddy_press_image['background-position']) ? $boddy_press_image['background-position'] : '';
	$bg_repeat = isset($boddy_press_image['background-repeat']) ? $boddy_press_image['background-repeat'] : '';
	$bg_attachment = isset($boddy_press_image['background-attachment']) ? $boddy_press_image['background-attachment'] : '';
	$bg_size = isset($boddy_press_image['background-size']) ? $boddy_press_image['background-size'] : '';
	$css .= '#featuredbox .is-bp-avatar{';
		$css .= 'background-position: ' . $bg_position . ';';
		$css .= 'background-repeat: ' . $bg_repeat . ';';
		$css .= 'background-attachment: ' . $bg_attachment . ';';
		$css .= 'background-size: ' . $bg_size . ';';
	$css .= '}';
	$css .= '#featuredbox .is-bp-avatar .featured-layer{';
		$css .= 'background-color: ' . esc_html($boddy_press_overlay) . ';';
	$css .= '}';

	/*---------------------------------------------------------
	**
	** WOFFICE 2.0 changes
	**
	----------------------------------------------------------*/
	

	/*---------------------------------------------------------
	**
	** FOOTER & EXTRA FOOTER SETTINGS
	**
	----------------------------------------------------------*/
	$theme_settings_options = get_option('woffice_theme_options');
	$footer_hero_image = isset($theme_settings_options['footer_hero_image']) ? $theme_settings_options['footer_hero_image'] : false;
	$hero_overlay = isset($theme_settings_options['footer_hero_overlay']) ? $theme_settings_options['footer_hero_overlay'] : false;
	$hero_image = get_template_directory_uri() . '/images/footer-hero.png';
	if($footer_hero_image) {
		$hero_image = isset($footer_hero_image['url']) ? $footer_hero_image['url'] : false;
		if(!$hero_image) {
			$hero_image = get_template_directory_uri() . '/images/footer-hero.png';
		}
	}

	$css .= '.woffice-hero-section{';
		$css .= 'background-image: url(' . $hero_image . ');';
	$css .= '}';

	$css .= '.footer-hero-content{';
		$css .= 'background-color: ' . $hero_overlay . ';';
	$css .= '}';

	
	/*---------------------------------------------------------
	**
	** SIDEBAR SETTINGS
	**
	----------------------------------------------------------*/
	$sidebar_mobile 			= woffice_get_theming_option('sidebar_mobile');
	$sidebar_min 	     		= woffice_get_theming_option('sidebar_min');
	$css .= '#right-sidebar{ height: '.esc_html($sidebar_min).'px;}';
	$css .= ' @media only screen and (max-width: 992px) {';
		$css .= '#nav-sidebar-trigger, #right-sidebar {';
			if(woffice_validate_bool_option($sidebar_mobile))
				$css .= "display: block;";
			else
				$css .= "display: none !important;";
		$css .= '}}';

	/*---------------------------------------------------------
	**
	** LOGIN PAGE SETTINGS
	**
	----------------------------------------------------------*/
	$login_background_color 	= woffice_get_theming_option('login_background_color');
	$login_background_image 	= woffice_get_theming_option('login_background_image');
	$login_background_opacity 	= woffice_get_theming_option('login_background_opacity');
	$login_logo_image 			= woffice_get_theming_option('login_logo_image');
	$login_logo_image_width 	= woffice_get_theming_option('login_logo_image_width');
	$login_logo_image_height 	= woffice_get_theming_option('login_logo_image_height');

	if ( woffice_is_custom_login_page_enabled() ) :
		$css .= '#woffice-login{';
			$css .= 'background-color: '.esc_html($login_background_color).';';
		$css .= '}';
		
		$css .= '#woffice-login-left{';
			if (isset($login_background_image["url"]) && !empty($login_background_image["url"])){
				$css .= "background-image: url(".esc_url($login_background_image["url"]).");";
			}else{ 
				$css .= "background-image: url(".get_template_directory_uri() ."/images/login-bg.png);";
			};
			$css .= "background-repeat: no-repeat;";
			$css .= "
				-webkit-background-size: cover;
				-moz-background-size: cover;
				-o-background-size: cover;
				background-size: cover;";
			$css .= "background-position: center center;";
			$css .= "opacity: ".esc_html($login_background_opacity).";";
			$css .= '}';

		if (!empty($login_logo_image_width)) {
			$css .= '#login-logo img {';
			$css .= '  width: '.intval($login_logo_image_width).'px;';
			$css .= '}';
		}


	endif;

	/*---------------------------------------------------------
	**
	** header width OPTION
	**
	----------------------------------------------------------*/
	$header_width = woffice_get_theming_option('header_width');
	if(!empty($header_width)){
		$css .= '#navigation .stellar-nav-logo #nav-logo img {';
			$css .= 'width:' . $header_width . 'px';
		$css .= '}'; 
	}


	/*---------------------------------------------------------
	**
	** PAGE LOADING OPTION
	**
	----------------------------------------------------------*/
	$page_loading 		= woffice_get_theming_option('page_loading');
	if (!$page_loading) :
		$css .= ".pace {display: none !important;}";
	endif;

	/*---------------------------------------------------------
	**
	** CUSTOM CSS
	**
	----------------------------------------------------------*/
	$custom_css 				= woffice_get_theming_option('custom_css');
	$css .= $custom_css;
	
	return $css;


}

/**
 * Include a Woffice CSS customization file
 *
 * @param $file_name - ie "color_notifications"
 * @param $array_name - ie "color_notifications"
 *
 * @return string
 */
function woffice_customization_get_array($file_name, $array_name = '') {

	require_once 'css_arrays/'.$file_name.'.php';

	if (empty($array_name))
		$array_name = $file_name;

	$values = (isset(${$array_name})) ? ${$array_name} : array();

	/**
	 * Filter to customize the dynamic CSS arrays in Woffice
	 *
	 * @param $values array
	 *
	 * @param $file_name string
	 *
	 * @return array
	 */
	$values = apply_filters('woffice_customization_array', $values, $file_name);

	return implode(", ", $values);

}

function woffice_save_custom_css() {
	update_option('woffice_custom_css', woffice_get_custom_css());
}
add_action('fw_settings_form_saved', 'woffice_save_custom_css');
add_action( 'customize_save_after','woffice_save_custom_css');

function woffice_custom_css_header() {
	echo '<!-- Custom CSS from Woffice -->';
	echo '<style type="text/css">';
		$custom_css = get_option('woffice_custom_css');
		// if (!empty($custom_css) && WP_DEBUG === false) {
		// 	echo '/*FROM : Database options*/';
		// 	woffice_echo_output($custom_css);
		// } else {
			echo '/*FROM : Dynamical load*/';
			echo woffice_get_custom_css();
		// }
	echo '</style>';
}
add_action( 'wp_head', 'woffice_custom_css_header' );

/**
* We output the Custom JS set in the theme setiings in the footer
*
*/
function woffice_custom_js() {
	$custom_js = woffice_get_theming_option( 'custom_js' );
	if ( ! empty( $custom_js ) ) {
		echo '<script type="text/javascript">';
		echo 'jQuery(document).ready(function() {';
		woffice_echo_output($custom_js);
		echo '});';
		echo '</script>';
	}

	$footer_scripts = woffice_get_theming_option( 'footer_scripts' );
	if ( ! empty( $footer_scripts ) ) {
		 woffice_echo_output($footer_scripts);
	}
}
add_action( 'wp_footer', 'woffice_custom_js',100);

/**
* Register Fonts.
*
* @return string|null
*/
function woffice_get_fonts_url() {

    $fonts_url = null;

    // Get the fonts used in the theme
	$font_main_typography = woffice_get_theming_option('font_main_typography'); 
	$font_headline_typography = woffice_get_theming_option('font_headline_typography'); 
	$font_extentedlatin = woffice_get_theming_option('font_extentedlatin');

	$system_fonts = array(
		"arial",
		"verdana",
		"trebuchet",
		"georgia",
		"times-new-roman",
		"tahoma",
		"palatino",
		"helvetica",
		"calibri",
		"myriad-pro",
		"lucida",
		"arial-black",
		"gill-sans",
		"geneva",
		"impact",
		"serif"
	);

	if (empty($font_main_typography) || !isset($font_main_typography['font-family']) || empty($font_headline_typography) || !isset($font_headline_typography['font-family']))
		return $fonts_url;

	$main_font = '';
	if(!in_array(sanitize_title($font_main_typography['font-family']), $system_fonts)) {
		$main_font = $font_main_typography['font-family'].":100,200,300,400,400italic,600,700italic,800,900";
	}

	$second_font = '';
	if(!in_array(sanitize_title($font_headline_typography['font-family']), $system_fonts)) {
		$second_font = $font_headline_typography['font-family'].":100,200,300,400,400italic,600,700italic,800,900";
	}

	if(empty($main_font) && empty($second_font))
		return $fonts_url;

	$subset = (woffice_validate_bool_option($font_extentedlatin)) ? '&subset=latin,latin-ext' : '';

	$query_args = 'family=';

	if(!empty($main_font))
		$query_args .= $main_font;

	if(!empty($second_font))
		$query_args .= '|'. $second_font;

	$query_args .= $subset;

	return '//fonts.googleapis.com/css?'.preg_replace("/ /","+",$query_args);

}

function woffice_hex2rgba( $color, $opacity = false, $is_array = false ) {

	$default = $color;
	
	if ( strpos( $color, '#' ) === 0 ) {
		$$color = $default;
	} else {
		
		preg_match( '/^rgba?[\s+]?\([\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?/i', $color, $color );

		$color = sprintf( '#%02x%02x%02x', $color[1], $color[2], $color[3] );
	
	}

	// Return default if no color provided.
	if ( empty( $color ) ) {
		return $default;
	}

	// Sanitize $color if "#" is provided.
	if ( '#' === $color[0] ) {
		$color = substr( $color, 1 );
	}

	// Check if color has 6 or 3 characters and get values.
	if ( strlen( $color ) === 6 ) {
			$hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
	} elseif ( strlen( $color ) === 3 ) {
			$hex = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
	} else {
			return $default;
	}

	// Convert hexadec to rgb.
	$rgb = array_map( 'hexdec', $hex );

	// Check if opacity is set(rgba or rgb).
	if ( false !== $opacity && '' !== $opacity ) {
		if ( abs( $opacity ) >= 1 ) {
			$opacity = $opacity / 100;
		}
		$output = 'rgba(' . implode( ',', $rgb ) . ',' . $opacity . ')';
	} else {
		$output = 'rgb(' . implode( ',', $rgb ) . ')';
	}

	if ( $is_array ) {
		return $rgb;
	} else {
		// Return rgb(a) color string.
		return $output;
	}
}