<?php
/**
 * TGM Plugin Activation file
 */

if (!function_exists('woffice_core_bundled_plugin')) {
	/**
	 * Returns Woffice plugin information
	 *
	 * @param $slug
	 * @param string $key
	 *
	 * @return array|string
	 */
	function woffice_core_bundled_plugin( $slug, $key = '' ) {
		$base_url = 'https://hub.woffice.io/storage/woffice/plugins/n1a9x/';
		$temp_base_url = 'https://xtendify.com/woffice/';
		$info     = array();

		$theme = wp_get_theme();
		
		switch ( $slug ) {

			case 'woffice-core':
				$info = array(
					'name'               => 'Woffice Core',
					'slug'               => 'woffice-core',
					'class'              => 'Woffice_Core',
					'source'             => get_template_directory() . '/inc/plugins/woffice-core.zip',
					'force_activation'   => false,
					'force_deactivation' => false,
					'required'           => true,
					'version'            => defined('WOFFICE_THEME_VERSION') ? WOFFICE_THEME_VERSION : '',
				);
				break;
			case 'buddypress':
				$info = array(
					'name'             => 'Buddypress',
					'slug'             => 'buddypress',
					'class'            => 'BuddyPress',
					'force_activation' => false,
					'required'         => false,
				);
				break;
			case 'wise-chat':
				$info = array(
					'name'             => 'Wise chat',
					'slug'             => 'wise-chat',
					'class'            => 'WiseChatContainer',
					'force_activation' => false,
					'required'         => false,
				);
				break;
			case 'revslider':
				$info = array(
					'name'               => 'Revolution Slider',
					'slug'               => 'revslider',
					'class'              => 'RevSliderFront',
					'source'             => $base_url . 'revslider.zip',
					'force_activation'   => false,
					'force_deactivation' => false,
					'required'           => false,
					'version'            => '6.7.38',
				);
				break;
			case 'js_composer':
				$info = array(
					'name'               => 'WPBakery Page builder',
					'slug'               => 'js_composer',
					'class'              => 'Vc_Manager',
					'source'             => $base_url . 'js_composer.zip',
					'force_activation'   => false,
					'force_deactivation' => false,
					'required'           => false,
					'version'            => '8.7.2',
				);
				break;
			case 'erp':
				$info = array(
					'name'             => 'WP ERP',
					'slug'             => 'erp',
					'force_activation' => false,
					'required'         => false,
				);
				break;
			case 'gamipress':
				$info = array(
					'name'             => 'GamiPress',
					'slug'             => 'gamipress',
					'force_activation' => false,
					'required'         => false,
				);
				break;
			case 'contact-form-7':
				$info = array(
					'name'             => 'Contact Form 7',
					'slug'             => 'contact-form-7',
					'force_activation' => false,
					'required'         => false,
				);
				break;
			case 'eventON':
				$info = array(
					'name'               => 'EventOn Calendar',
					'slug'               => 'eventON',
					'source'             => $base_url . 'eventON.zip',
					'force_activation'   => false,
					'force_deactivation' => false,
					'required'           => false,
					'version'            => '5.0.2',
				);
				break;
			case 'eventon-full-cal':
				$info = array(
					'name'               => 'EventOn Asset (Full Calendar ADDON)',
					'slug'               => 'eventon-full-cal',
					'source'             => $base_url . 'eventon-full-cal.zip',
					'force_activation'   => false,
					'force_deactivation' => false,
					'required'           => false,
					'version'            => '2.2.3',
				);
				break;
		}

		if ( isset( $info['source'] ) && strpos( $info['source'], $base_url ) !== false ) {
			$woffice_key = get_option( 'woffice_key' );
			$woffice_key = ( ! empty( $woffice_key ) ) ? $woffice_key : 'N/A';

			$info['source'] = $info['source'] . '?woffice_key=' . $woffice_key;
		}

		if ( ! empty( $key ) ) {
			return $info['key'];
		}

		return $info;
	}
}

if(file_exists(dirname( __FILE__ ) .'/plugins/TGM_Plugin_Activation.php' )) {
	require_once dirname( __FILE__ ) . '/plugins/TGM_Plugin_Activation.php';

	/**
	 * INSTALL PLUGINS WITH TGM PLUGIN ACTIVATION
	 */
	function _action_theme_register_required_plugins(){
		tgmpa(array(
			woffice_core_bundled_plugin('woffice-core'),
			woffice_core_bundled_plugin('buddypress'),
			woffice_core_bundled_plugin('revslider'),
			woffice_core_bundled_plugin('js_composer'),
			woffice_core_bundled_plugin('wise-chat'),
			woffice_core_bundled_plugin('vc-super-bundle'),
		
			// woffice_core_bundled_plugin('dpProEventCalendar'),
			// woffice_core_bundled_plugin('gamipress'),
			// woffice_core_bundled_plugin('erp'),
			// woffice_core_bundled_plugin('eonet-live-notifications'),
		));
	}
	add_action( 'tgmpa_register', '_action_theme_register_required_plugins' );
}

if(function_exists('vc_set_as_theme') && !function_exists('woffice_js_composer_as_theme')){
	function woffice_js_composer_as_theme() {
		vc_set_as_theme(true);
	}

	add_action( 'vc_before_init', 'woffice_js_composer_as_theme' );
}