/**
 * Addable Items Vue Application
 * Render addable items input through Vue.js
 *
 * @author Alkaweb Team
 */
Vue.component('woffice-addable-items', {

    template: '<div id="woffice-addable-items">\
        <div id="woffice-addable-items__title">\
            <h3 v-text="label"></h3>\
        </div>\
        <div v-for="(item, i) in items" class="addable-item">\
            <a href="#" class="addable-item__close text-light" @click.prevent="removeItem(i)"><i class="fas fa-times"></i></a>\
            <div class="row">\
                <div v-for="(field, key) in fields" :class="field.layout" class="addable-item__field">\
                    <div>\
                        <label>\
                            <span v-text="field.label"> <i v-if="field.help" class="fa fa-info-circle"></i></span>\
                        </label>\
                        <select v-if="field.type === \'icon-picker\'" v-model="item[field.key]">\
                            <option v-for="icon in icons">\
                                <i class="fa" :class="icon"></i> <span v-text="icon"></span>\
                            </option>\
                        </select>\
                        <input v-else type="text" v-model="item[field.key]">\
                    </div>\
                </div>\
            </div>\
        </div>\
        <div id="woffice-addable-items__actions">\
            <a href="#" @click.prevent="addItem()" class="btn btn-default"><i class="fa fa-plus-square"></i> Add</a>\
        </div>\
        <input type="hidden" :name="name" :value="itemsReady">\
    </div>',

    props: ['data', 'label', 'name'],

    /**
     * Data Wrapper
     */
    data: function () {
        return {
            items: [],
            icons: [],
            fields: [
                {
                    key: 'title',
                    label: 'Content',
                    layout: 'col-md-6'
                },
                {
                    key: 'icon',
                    label: 'Icon',
                    layout: 'col-md-6',
                    type: 'icon-picker'
                }
            ]
        }
    },

    computed: {
        itemsReady: function () {
            return JSON.stringify(this.items);
        }
    },

    mounted: function() {
        this.setIcons();
        if (this.data)
            this.items = this.data;
    },

    methods: {

        /**
         * Add a new item
         */
        addItem: function () {
            var newField = {};

            for (var fieldKey in this.fields) {
                if (!this.fields.hasOwnProperty(fieldKey))
                    continue;

                newField[this.fields[fieldKey].key] = '';
            }

            this.items.push(newField);
        },

        /**
         * Remove items
         */
        removeItem: function (key) {
            this.items.splice(key, 1);
        },

        /**
         * Set the icons library
         * https://gist.github.com/zwinnie/3ed8e7970240962bc29227533c3ae047
         *
         */
        setIcons: function () {
            this.icons = [
                "fa fa-500px",
                "fa fa-address-book",
                "fa fa-address-card",
                "fa fa-adjust",
                "fa fa-adn",
                "fa fa-align-center",
                "fa fa-align-justify",
                "fa fa-align-left",
                "fa fa-align-right",
                "fa fa-amazon",
                "fa fa-ambulance",
                "fa fa-american-sign-language-interpreting",
                "fa fa-anchor",
                "fa fa-android",
                "fa fa-angellist",
                "fa fa-angle-double-down",
                "fa fa-angle-double-left",
                "fa fa-angle-double-right",
                "fa fa-angle-double-up",
                "fa fa-angle-down",
                "fa fa-angle-left",
                "fa fa-angle-right",
                "fa fa-angle-up",
                "fa fa-apple",
                "fa fa-archive",
                "fa fa-area-chart",
                "fa fa-arrow-circle-down",
                "fa fa-arrow-circle-left",
                "fa fa-arrow-circle-o-down",
                "fa fa-arrow-circle-o-left",
                "fa fa-arrow-circle-o-right",
                "fa fa-arrow-circle-o-up",
                "fa fa-arrow-circle-right",
                "fa fa-arrow-circle-up",
                "fa fa-arrow-down",
                "fa fa-arrow-left",
                "fa fa-arrow-right",
                "fa fa-arrow-up",
                "fa fa-arrows",
                "fa fa-arrows-alt",
                "fa fa-arrows-h",
                "fa fa-arrows-v",
                "fa fa-asl-interpreting",
                "fa fa-assistive-listening-systems",
                "fa fa-asterisk",
                "fa fa-at",
                "fa fa-audio-description",
                "fa fa-automobile",
                "fa fa-backward",
                "fa fa-balance-scale",
                "fa fa-ban",
                "fa fa-bandcamp",
                "fa fa-bank",
                "fa fa-bar-chart",
                "fa fa-barcode",
                "fa fa-bars",
                "fa fa-bath",
                "fa fa-bathtub",
                "fa fa-battery",
                "fa fa-battery-0",
                "fa fa-battery-1",
                "fa fa-battery-2",
                "fa fa-battery-3",
                "fa fa-battery-4",
                "fa fa-battery-empty",
                "fa fa-battery-full",
                "fa fa-battery-half",
                "fa fa-battery-quarter",
                "fa fa-battery-three-quarters",
                "fa fa-bed",
                "fa fa-beer",
                "fa fa-bell",
                "fa fa-bell-slash",
                "fa fa-bicycle",
                "fa fa-binoculars",
                "fa fa-birthday-cake",
                "fa fa-bitbucket",
                "fa fa-bitbucket-square",
                "fa fa-bitcoin",
                "fa fa-black-tie",
                "fa fa-blind",
                "fa fa-bluetooth",
                "fa fa-bluetooth-b",
                "fa fa-bold",
                "fa fa-bolt",
                "fa fa-bomb",
                "fa fa-book",
                "fa fa-bookmark",
                "fa fa-braille",
                "fa fa-briefcase",
                "fa fa-btc",
                "fa fa-bug",
                "fa fa-building",
                "fa fa-bullhorn",
                "fa fa-bullseye",
                "fa fa-bus",
                "fa fa-buysellads",
                "fa fa-cab",
                "fa fa-calculator",
                "fa fa-calendar",
                "fa fa-camera",
                "fa fa-camera-retro",
                "fa fa-car",
                "fa fa-caret-down",
                "fa fa-caret-left",
                "fa fa-caret-right",
                "fa fa-caret-up",
                "fa fa-cart-arrow-down",
                "fa fa-cart-plus",
                "fa fa-cc",
                "fa fa-cc-amex",
                "fa fa-cc-diners-club",
                "fa fa-cc-discover",
                "fa fa-cc-jcb",
                "fa fa-cc-mastercard",
                "fa fa-cc-paypal",
                "fa fa-cc-stripe",
                "fa fa-cc-visa",
                "fa fa-certificate",
                "fa fa-chain",
                "fa fa-chain-broken",
                "fa fa-check",
                "fa fa-check-circle",
                "fa fa-check-circle",
                "fa fa-check-square",
                "fa fa-chevron-circle-down",
                "fa fa-chevron-circle-left",
                "fa fa-chevron-circle-right",
                "fa fa-chevron-circle-up",
                "fa fa-chevron-down",
                "fa fa-chevron-left",
                "fa fa-chevron-right",
                "fa fa-chevron-up",
                "fa fa-child",
                "fa fa-chrome",
                "fa fa-circle",
                "fa fa-circle-thin",
                "fa fa-clipboard",
                "fa fa-clone",
                "fa fa-close",
                "fa fa-cloud",
                "fa fa-cloud-download",
                "fa fa-cloud-upload",
                "fa fa-cny",
                "fa fa-code",
                "fa fa-code-fork",
                "fa fa-codepen",
                "fa fa-codiepie",
                "fa fa-coffee",
                "fa fa-cog",
                "fa fa-cogs",
                "fa fa-columns",
                "fa fa-comment",
                "fa fa-commenting",
                "fa fa-comments",
                "fa fa-compass",
                "fa fa-compress",
                "fa fa-connectdevelop",
                "fa fa-contao",
                "fa fa-copy",
                "fa fa-copyright",
                "fa fa-creative-commons",
                "fa fa-credit-card",
                "fa fa-credit-card-alt",
                "fa fa-crop",
                "fa fa-crosshairs",
                "fa fa-css3",
                "fa fa-cube",
                "fa fa-cubes",
                "fa fa-cut",
                "fa fa-cutlery",
                "fa fa-dashboard",
                "fa fa-dashcube",
                "fa fa-database",
                "fa fa-deaf",
                "fa fa-deafness",
                "fa fa-dedent",
                "fa fa-delicious",
                "fa fa-desktop",
                "fa fa-deviantart",
                "fa fa-diamond",
                "fa fa-digg",
                "fa fa-dollar",
                "fa fa-download",
                "fa fa-dribbble",
                "fa fa-drivers-license",
                "fa fa-dropbox",
                "fa fa-drupal",
                "fa fa-edge",
                "fa fa-edit",
                "fa fa-eercast",
                "fa fa-eject",
                "fa fa-ellipsis-h",
                "fa fa-ellipsis-v",
                "fa fa-empire",
                "fa fa-envelope",
                "fa fa-envelope-open",
                "fa fa-envelope-square",
                "fa fa-envira",
                "fa fa-eraser",
                "fa fa-etsy",
                "fa fa-eur",
                "fa fa-euro",
                "fa fa-exchange",
                "fa fa-exclamation",
                "fa fa-exclamation-circle",
                "fa fa-exclamation-triangle",
                "fa fa-expand",
                "fa fa-expeditedssl",
                "fa fa-external-link",
                "fa fa-external-link-square",
                "fa fa-eye",
                "fa fa-eye-slash",
                "fa fa-eyedropper",
                "fa fa-fa",
                "fa fa-facebook",
                "fa fa-facebook-f",
                "fa fa-facebook-official",
                "fa fa-facebook-square",
                "fa fa-fast-backward",
                "fa fa-fast-forward",
                "fa fa-fax",
                "fa fa-feed",
                "fa fa-female",
                "fa fa-fighter-jet",
                "fa fa-file",
                "fa fa-file-text",
                "fa fa-film",
                "fa fa-filter",
                "fa fa-fire",
                "fa fa-fire-extinguisher",
                "fa fa-firefox",
                "fa fa-first-order",
                "fa fa-flag",
                "fa fa-flag-checkered",
                "fa fa-flash",
                "fa fa-flask",
                "fa fa-flickr",
                "fa fa-folder",
                "fa fa-folder-open",
                "fa fa-font",
                "fa fa-font-awesome",
                "fa fa-fonticons",
                "fa fa-fort-awesome",
                "fa fa-forumbee",
                "fa fa-forward",
                "fa fa-foursquare",
                "fa fa-free-code-camp",
                "fa fa-gamepad",
                "fa fa-gavel",
                "fa fa-gbp",
                "fa fa-ge",
                "fa fa-gear",
                "fa fa-gears",
                "fa fa-genderless",
                "fa fa-get-pocket",
                "fa fa-gg",
                "fa fa-gg-circle",
                "fa fa-gift",
                "fa fa-git",
                "fa fa-git-square",
                "fa fa-github",
                "fa fa-github-alt",
                "fa fa-github-square",
                "fa fa-gitlab",
                "fa fa-gittip",
                "fa fa-glass",
                "fa fa-glide",
                "fa fa-glide-g",
                "fa fa-globe",
                "fa fa-google",
                "fa fa-google-plus",
                "fa fa-google-plus-circle",
                "fa fa-google-plus-official",
                "fa fa-google-plus-square",
                "fa fa-google-wallet",
                "fa fa-graduation-cap",
                "fa fa-gratipay",
                "fa fa-grav",
                "fa fa-group",
                "fa fa-h-square",
                "fa fa-hacker-news",
                "fa fa-hard-of-hearing",
                "fa fa-hashtag",
                "fa fa-header",
                "fa fa-headphones",
                "fa fa-heart",
                "fa fa-heartbeat",
                "fa fa-history",
                "fa fa-home",
                "fa fa-hotel",
                "fa fa-hourglass",
                "fa fa-hourglass-1",
                "fa fa-hourglass-2",
                "fa fa-hourglass-3",
                "fa fa-hourglass-end",
                "fa fa-hourglass-half",
                "fa fa-hourglass-start",
                "fa fa-houzz",
                "fa fa-html5",
                "fa fa-i-cursor",
                "fa fa-id-badge",
                "fa fa-id-card",
                "fa fa-ils",
                "fa fa-image",
                "fa fa-imdb",
                "fa fa-inbox",
                "fa fa-indent",
                "fa fa-industry",
                "fa fa-info",
                "fa fa-info-circle",
                "fa fa-inr",
                "fa fa-instagram",
                "fa fa-institution",
                "fa fa-internet-explorer",
                "fa fa-intersex",
                "fa fa-ioxhost",
                "fa fa-italic",
                "fa fa-joomla",
                "fa fa-jpy",
                "fa fa-jsfiddle",
                "fa fa-key",
                "fa fa-krw",
                "fa fa-language",
                "fa fa-laptop",
                "fa fa-lastfm",
                "fa fa-lastfm-square",
                "fa fa-leaf",
                "fa fa-leanpub",
                "fa fa-legal",
                "fa fa-level-down",
                "fa fa-level-up",
                "fa fa-life-bouy",
                "fa fa-life-buoy",
                "fa fa-life-ring",
                "fa fa-life-saver",
                "fa fa-line-chart",
                "fa fa-link",
                "fa fa-linkedin",
                "fa fa-linkedin-square",
                "fa fa-linode",
                "fa fa-linux",
                "fa fa-list",
                "fa fa-list-alt",
                "fa fa-list-ol",
                "fa fa-list-ul",
                "fa fa-location-arrow",
                "fa fa-lock",
                "fa fa-long-arrow-down",
                "fa fa-arrow-left",
                "fa fa-arrow-right",
                "fa fa-long-arrow-up",
                "fa fa-low-vision",
                "fa fa-magic",
                "fa fa-magnet",
                "fa fa-mail-forward",
                "fa fa-mail-reply",
                "fa fa-mail-reply-all",
                "fa fa-male",
                "fa fa-map",
                "fa fa-map-marker",
                "fa fa-map-pin",
                "fa fa-map-signs",
                "fa fa-mars",
                "fa fa-mars-double",
                "fa fa-mars-stroke",
                "fa fa-mars-stroke-h",
                "fa fa-mars-stroke-v",
                "fa fa-maxcdn",
                "fa fa-meanpath",
                "fa fa-medium",
                "fa fa-medkit",
                "fa fa-meetup",
                "fa fa-mercury",
                "fa fa-microchip",
                "fa fa-microphone",
                "fa fa-microphone-slash",
                "fa fa-minus",
                "fa fa-minus-circle",
                "fa fa-minus-square",
                "fa fa-mixcloud",
                "fa fa-mobile",
                "fa fa-mobile-phone",
                "fa fa-modx",
                "fa fa-money",
                "fa fa-mortar-board",
                "fa fa-motorcycle",
                "fa fa-mouse-pointer",
                "fa fa-music",
                "fa fa-navicon",
                "fa fa-neuter",
                "fa fa-object-group",
                "fa fa-object-ungroup",
                "fa fa-odnoklassniki",
                "fa fa-odnoklassniki-square",
                "fa fa-opencart",
                "fa fa-openid",
                "fa fa-opera",
                "fa fa-optin-monster",
                "fa fa-outdent",
                "fa fa-pagelines",
                "fa fa-paint-brush",
                "fa fa-paper-plane",
                "fa fa-paperclip",
                "fa fa-paragraph",
                "fa fa-paste",
                "fa fa-pause",
                "fa fa-pause-circle",
                "fa fa-paw",
                "fa fa-paypal",
                "fa fa-pencil",
                "fa fa-pencil-square",
                "fa fa-percent",
                "fa fa-phone",
                "fa fa-phone-square",
                "fa fa-photo",
                "fa fa-pie-chart",
                "fa fa-pied-piper",
                "fa fa-pied-piper-alt",
                "fa fa-pied-piper-pp",
                "fa fa-pinterest",
                "fa fa-pinterest-p",
                "fa fa-pinterest-square",
                "fa fa-plane",
                "fa fa-play",
                "fa fa-play-circle",
                "fa fa-plug",
                "fa fa-plus",
                "fa fa-plus-circle",
                "fa fa-plus-square",
                "fa fa-podcast",
                "fa fa-power-off",
                "fa fa-print",
                "fa fa-product-hunt",
                "fa fa-puzzle-piece",
                "fa fa-qq",
                "fa fa-qrcode",
                "fa fa-question",
                "fa fa-question-circle",
                "fa fa-quora",
                "fa fa-quote-left",
                "fa fa-quote-right",
                "fa fa-ra",
                "fa fa-random",
                "fa fa-ravelry",
                "fa fa-rebel",
                "fa fa-recycle",
                "fa fa-reddit",
                "fa fa-reddit-alien",
                "fa fa-reddit-square",
                "fa fa-refresh",
                "fa fa-registered",
                "fa fa-remove",
                "fa fa-renren",
                "fa fa-reorder",
                "fa fa-repeat",
                "fa fa-reply",
                "fa fa-reply-all",
                "fa fa-resistance",
                "fa fa-retweet",
                "fa fa-rmb",
                "fa fa-road",
                "fa fa-rocket",
                "fa fa-rotate-left",
                "fa fa-rotate-right",
                "fa fa-rouble",
                "fa fa-rss",
                "fa fa-rss-square",
                "fa fa-rub",
                "fa fa-ruble",
                "fa fa-rupee",
                "fa fa-s15",
                "fa fa-safari",
                "fa fa-save",
                "fa fa-scissors",
                "fa fa-scribd",
                "fa fa-search",
                "fa fa-search-minus",
                "fa fa-search-plus",
                "fa fa-sellsy",
                "fa fa-send",
                "fa fa-server",
                "fa fa-share",
                "fa fa-share-alt",
                "fa fa-share-alt-square",
                "fa fa-share-square",
                "fa fa-shekel",
                "fa fa-sheqel",
                "fa fa-shield",
                "fa fa-ship",
                "fa fa-shirtsinbulk",
                "fa fa-shopping-bag",
                "fa fa-shopping-basket",
                "fa fa-shopping-cart",
                "fa fa-shower",
                "fa fa-sign-in",
                "fa fa-sign-language",
                "fa fa-sign-out",
                "fa fa-signal",
                "fa fa-signing",
                "fa fa-simplybuilt",
                "fa fa-sitemap",
                "fa fa-skyatlas",
                "fa fa-skype",
                "fa fa-slack",
                "fa fa-sliders",
                "fa fa-slideshare",
                "fa fa-sort",
                "fa fa-sort-alpha-asc",
                "fa fa-sort-alpha-desc",
                "fa fa-sort-amount-asc",
                "fa fa-sort-amount-desc",
                "fa fa-sort-asc",
                "fa fa-sort-desc",
                "fa fa-sort-down",
                "fa fa-sort-numeric-asc",
                "fa fa-sort-numeric-desc",
                "fa fa-sort-up",
                "fa fa-soundcloud",
                "fa fa-space-shuttle",
                "fa fa-spinner",
                "fa fa-spoon",
                "fa fa-spotify",
                "fa fa-square",
                "fa fa-stack-exchange",
                "fa fa-stack-overflow",
                "fa fa-star",
                "fa fa-star-half",
                "fa fa-star-half-empty",
                "fa fa-star-half-full",
                "fa fa-steam",
                "fa fa-steam-square",
                "fa fa-step-backward",
                "fa fa-step-forward",
                "fa fa-stethoscope",
                "fa fa-sticky-note",
                "fa fa-stop",
                "fa fa-stop-circle",
                "fa fa-street-view",
                "fa fa-strikethrough",
                "fa fa-stumbleupon",
                "fa fa-stumbleupon-circle",
                "fa fa-subscript",
                "fa fa-subway",
                "fa fa-suitcase",
                "fa fa-superpowers",
                "fa fa-superscript",
                "fa fa-support",
                "fa fa-table",
                "fa fa-tablet",
                "fa fa-tachometer",
                "fa fa-tag",
                "fa fa-tags",
                "fa fa-tasks",
                "fa fa-taxi",
                "fa fa-telegram",
                "fa fa-television",
                "fa fa-tencent-weibo",
                "fa fa-terminal",
                "fa fa-text-height",
                "fa fa-text-width",
                "fa fa-th",
                "fa fa-th-large",
                "fa fa-th-list",
                "fa fa-themeisle",
                "fa fa-thermometer",
                "fa fa-thermometer-0",
                "fa fa-thermometer-1",
                "fa fa-thermometer-2",
                "fa fa-thermometer-3",
                "fa fa-thermometer-4",
                "fa fa-thermometer-empty",
                "fa fa-thermometer-full",
                "fa fa-thermometer-half",
                "fa fa-thermometer-quarter",
                "fa fa-thermometer-three-quarters",
                "fa fa-thumb-tack",
                "fa fa-thumbs-down",
                "fa fa-thumbs-o-down",
                "fa fa-thumbs-o-up",
                "fa fa-thumbs-up",
                "fa fa-ticket",
                "fa fa-times",
                "fa fa-times-circle",
                "fa fa-times-rectangle",
                "fa fa-tint",
                "fa fa-toggle-down",
                "fa fa-toggle-left",
                "fa fa-toggle-off",
                "fa fa-toggle-on",
                "fa fa-toggle-right",
                "fa fa-toggle-up",
                "fa fa-trademark",
                "fa fa-train",
                "fa fa-transgender",
                "fa fa-transgender-alt",
                "fa fa-trash",
                "fa fa-tree",
                "fa fa-trello",
                "fa fa-tripadvisor",
                "fa fa-trophy",
                "fa fa-truck",
                "fa fa-try",
                "fa fa-tty",
                "fa fa-tumblr",
                "fa fa-tumblr-square",
                "fa fa-turkish-lira",
                "fa fa-tv",
                "fa fa-twitch",
                "fa fa-twitter",
                "fa fa-twitter-square",
                "fa fa-umbrella",
                "fa fa-underline",
                "fa fa-undo",
                "fa fa-universal-access",
                "fa fa-university",
                "fa fa-unlink",
                "fa fa-unlock",
                "fa fa-unlock-alt",
                "fa fa-unsorted",
                "fa fa-upload",
                "fa fa-usb",
                "fa fa-usd",
                "fa fa-user",
                "fa fa-user-circle",
                "fa fa-user-md",
                "fa fa-user-plus",
                "fa fa-user-secret",
                "fa fa-user-times",
                "fa fa-users",
                "fa fa-vcard",
                "fa fa-venus",
                "fa fa-venus-double",
                "fa fa-venus-mars",
                "fa fa-viacoin",
                "fa fa-viadeo",
                "fa fa-viadeo-square",
                "fa fa-video-camera",
                "fa fa-vimeo",
                "fa fa-vimeo-square",
                "fa fa-vine",
                "fa fa-vk",
                "fa fa-volume-control-phone",
                "fa fa-volume-down",
                "fa fa-volume-off",
                "fa fa-volume-up",
                "fa fa-warning",
                "fa fa-wechat",
                "fa fa-weibo",
                "fa fa-weixin",
                "fa fa-whatsapp",
                "fa fa-wheelchair",
                "fa fa-wheelchair-alt",
                "fa fa-wifi",
                "fa fa-wikipedia-w",
                "fa fa-window-close",
                "fa fa-window-maximize",
                "fa fa-window-minimize",
                "fa fa-window-restore",
                "fa fa-windows",
                "fa fa-won",
                "fa fa-wordpress",
                "fa fa-wpbeginner",
                "fa fa-wpexplorer",
                "fa fa-wpforms",
                "fa fa-wrench",
                "fa fa-xing",
                "fa fa-xing-square",
                "fa fa-y-combinator",
                "fa fa-y-combinator-square",
                "fa fa-yahoo",
                "fa fa-yc",
                "fa fa-yc-square",
                "fa fa-yelp",
                "fa fa-yen",
                "fa fa-yoast",
                "fa fa-youtube",
                "fa fa-youtube-play",
                "fa fa-youtube-square"
            ]
        }

    }

});

var element =  document.getElementById('directory-edit');
if (typeof(element) !== 'undefined' && element !== null) {
    new Vue({
        el: '#directory-edit'
    });
}
