<?php
/**
 * The template used for displaying post content
 */
?>
<?php 
// CUSTOM CLASSES ADDED BY THE THEME
$post_classes = array('content', 'entry-content');
$blog_listing_content = woffice_get_theming_option('blog_listing_content','excerpt');
$hide_image_single_post = woffice_convert_to_bool_option(woffice_get_theming_option('hide_image_single_post', false));
$hide_author_box = woffice_get_theming_option('hide_author_box_single_post', false);
$hide_like_counter = woffice_get_theming_option('hide_like_counter_inside_author_box', false);
$hide_learndash_meta = woffice_get_theming_option('hide_learndash_meta', false);

if(get_post_status() == 'draft')
    array_push($post_classes, 'is-draft');
?>
	<div class="col-md-12 blog-single-col">
		<div class="blog-card-wrapper d-flex h-100 mb-3">			
			<div class="card blog_card">
				<div class="blog-thumb">
					<?php if (is_single() && !woffice_validate_bool_option($hide_image_single_post)) : ?>
						<!-- THUMBNAIL IMAGE -->
						<?php /*GETTING THE POST THUMBNAIL URL*/
							$featured_height = (function_exists('woffice_get_post_rdx_option')) ? woffice_get_post_rdx_option(get_the_ID(), 'featured_height') : '';
							Woffice_Frontend::render_featured_image_single_post($post->ID, $featured_height);
						?>
					<?php endif; ?>
				</div>
				<div class="card-body">
					<div class="row">
                        <div class="col-md-12">
                            <div class="blog-title d-flex justify-content-between">
                                <?php if (strpos(get_post_type(), 'sfwd') === FALSE || is_search()) : ?>
                                    <div class="intern-padding heading-container">
                                        <?php if (!is_single()): ?>
                                            <?php // THE TITLE
                                            if (is_sticky()):
                                                the_title( '<div class="heading"><h2><a href="' . esc_url( get_permalink() ) . '" class="font-weight-bold" rel="bookmark"><i class="fa fa-star text-yellow"></i>', '</a></h2></div>' );
                                            else: 
                                                the_title( '<div class="heading"><h2><a href="' . esc_url( get_permalink() ) . '" class="font-weight-bold" rel="bookmark">', '</a></h2></div>' );
                                            endif; ?>
                                        <?php else : ?>
                                            <?php // THE TITLE
											$show_title_box = woffice_get_theming_option('show_title_box');
											if(!woffice_validate_bool_option($show_title_box) ){
                                            the_title( '<div class="heading"><h2>', '</h2></div>' );}?>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                                <div class="post-meta">
                                <?php // We display the post meta in the top only for the blog articles
                                    if ($post->post_type == "post") : ?>
                                        <div class="intern-box">
                                            <?php // THE POST META
                                            woffice_postmetas(); ?>
                                        </div>
                                <?php endif; ?>
                            </div>
                            </div>
                        </div>
                       
                    </div>
					<div class="blog-content">
						<?php if (is_single() || $blog_listing_content == 'content'): ?>
							<?php the_content(''); ?>
						<?php elseif($blog_listing_content == 'excerpt') : ?>
							<?php the_excerpt(5); ?>
						<?php endif; ?>
					</div>
				</div>
				<div class="card-footer border-0 bg-transparent">
					<?php if (!is_single()): ?>
						<div class="blog-button">
							<a href="<?php the_permalink(); ?>" class="btn btn-default mb-0"><i class="fa fa-arrow-right"></i> <?php _e('Read More','woffice'); ?></a>
						</div>	
					<?php endif; ?>
				</div>
			</div>
		</div>
		<?php if (is_single() && get_post_type() == 'post' && !woffice_validate_bool_option($hide_author_box)) : ?>
	  			<div class="blog-authorbox clearfix">
	  				<?php echo get_avatar(get_the_author_meta('ID'), 96, '', '', array('class' => 'rounded-circle')); ?>
	  				<div class="blog-authorbox-right">

                        <?php 
					    	$display = woffice_get_name_to_display(get_the_author_meta('ID'));
					    ?>
		  				<?php 
			  				if (function_exists('bp_is_active')) {
								$mem_domain = function_exists('bp_members_get_user_url') ? bp_members_get_user_url(get_the_author_meta('ID')) : bp_core_get_user_domain(get_the_author_meta('ID'));
				  				echo '<h3><a href="' . $mem_domain . '">'.$display.'</a></h3>';
			  				} else {
				  				echo '<h3>'.$display.'</h3>';
			  				}
		  				?>
		  				<?php 
			  			$desc = get_the_author_meta('description');
			  			if(!empty($desc)) {
			  				echo '<p>'.get_the_author_meta('description').'</p>';	
			  			} ?>
						<?php if(!woffice_validate_bool_option($hide_like_counter)): ?>
		  				<div class="blog-like-container">
			  				<?php 
				  				$post_ID = get_the_id();
				  				$vote_count = get_post_meta($post_ID, "votes_count", true);
								$vote_count_disp = (empty($vote_count)) ? '0' : $vote_count; 
								echo '<p class="like-text">'.__('Have you enjoyed the post ?','woffice').'</p>';
								echo '<p class="wiki-like">';
									if(Woffice_Blog::like_user_has_already_voted($post_ID)) {
								        echo ' <span title="'.__('I like this post', 'woffice').'" class="like alreadyvoted">
								        	<i class="woffice-icon woffice-icon-like"></i>
								        </span>';
								    } else { 
								        echo '<a href="javascript:void(0)" data-post_id="'.$post_ID.'">
							                <i class="woffice-icon woffice-icon-like"></i>
							            </a>';
								    }
								    echo '<span class="count">'.$vote_count_disp.'</span>';
								echo '</p>';
							?>
						</div>
                        <?php endif; ?>
	  				</div>
	  			</div>	
	  		<?php endif; ?>
	</div>
</article>
