<?php
   /**
    * BuddyPress - Users Cover Image Header
    *
    * @since 3.0.0
    * @version 7.0.0
    */
   $profile_layout = woffice_get_theming_option('profile_layout');
   $profile_layout = (isset($_GET['profile_layout'])) ? $_GET['profile_layout'] : $profile_layout;
   ?>
<div id="cover-image-container">
   <div id="header-cover-image"></div>
   <div id="item-header-cover-image">
      <div id="item-header-avatar">
         <a href="<?php bp_displayed_user_link(); ?>">
         <?php bp_displayed_user_avatar( 'type=full' ); ?>
         </a>
      </div>
      <!-- #item-header-avatar -->
      <div id="item-header-content">
         <div class="user_info_detail">
            <div class="user_name">
               <?php if ( bp_is_active( 'activity' ) && bp_activity_do_mentions() ) : ?>
               <h2 class="user-nicename"><?php bp_displayed_user_mentionname(); ?></h2>
               <?php endif; ?>
               <?php bp_nouveau_member_hook( 'before', 'header_meta' ); ?>
            </div>
            <?php if ( bp_nouveau_member_has_meta() ) : ?>
            <div class="item-meta">
               <?php bp_nouveau_member_meta(); ?>
            </div>
            <!-- #item-meta -->
            <?php endif; ?>
         </div>
         <div class="user_social_detail">
            <?php
               bp_nouveau_member_header_buttons(
               	array(
               		'container'         => 'ul',
               		'button_element'    => 'button',
               		'container_classes' => array( 'member-header-actions' ),
               	)
               );
               ?>
            <?php
               bp_member_type_list(
               	bp_displayed_user_id(),
               	array(
               		'label'        => array(
               			'plural'   => __( 'Member Types', 'woffice' ),
               			'singular' => __( 'Member Type', 'woffice' ),
               		),
               		'list_element' => 'span',
               	)
               );
               ?>
            <?php if($profile_layout == 'horizontal') {?>
            <!-- Iten social -->
            <div class="users-single-social">
               <?php woffice_member_social_extend(); ?>
            </div>
            <!-- /Iten social -->
            <?php } ?>
         </div>
      </div>
      <!-- #item-header-content -->
   </div>
   <!-- #item-header-cover-image -->
</div>
<!-- #cover-image-container -->