<?php

    //IF Fixed we add a nav class

    $nav_opened_state = woffice_get_navigation_state();
    $sidebar_state = woffice_get_sidebar_state();
    $sidebar_show_class = ($sidebar_state != 'show') ? 'sidebar-hidden' : '';

	$is_blank_template = woffice_is_current_page_using_blank_template();
	$blank_template_class = ($is_blank_template) ? 'is-blank-template' : '';
	$navigation_toggle_class = woffice_get_navigation_toggle_class();
    $hentry_class = apply_filters('woffice_hentry_class', 'hentry');
    // We add a class if the menu is closed by default
    $navigation_hidden_class = woffice_get_navigation_class();

	$nav_toggle_class = woffice_get_navigation_toggle_class();
	$content_class = '';
	$main_content_class = woffice_main_content_classes();
    $menu_layout = woffice_get_theming_option('menu_layout','left');
	if($nav_toggle_class === 'has-navigation-hidden'){
		$content_class = "";
	}

    $is_full_height = woffice_get_theming_option('left_menu_height',true);

    if($menu_layout == 'left' && !woffice_validate_bool_option($is_full_height)) {
        $navigation_toggle_class .= ' is-left-sidebar-fixed';
    }
    
	$copyright = '';
	if(function_exists('fw')){
		$copyright = woffice_get_theming_option('footer_copyright_content');
	}
?>
		<div id="page-wrapper" <?php echo (!$nav_opened_state) ? 'class="menu-is-closed"':''; ?>>
	            <div class="wo-row"> <!-- Main row start---->
                    <div class="is-left-sidebar <?php echo esc_attr($navigation_toggle_class);?>"> <!-- Left col---->
<?php
			/*
             * The header part is removed on the blank template
             */
			if(!$is_blank_template): ?>

                <!-- STARTING THE MAIN NAVIGATION (left side) -->
                <nav id="navigation" class="<?php echo esc_attr($navigation_hidden_class); ?> mobile-hidden">
                <?php // CHECK IF LOGO NEEDS TO BE SHOW
                        $header_logo_hide = woffice_get_theming_option('header_logo_hide');
                        if (woffice_validate_bool_option($header_logo_hide) == false) { ?>
                            <!-- START LOGO -->
                            <div class="stellar-nav-logo">
                                <div id="nav-logo">
                                    <?php
                                    /**
                                    * The url of the logo in the header. By default, returns the home url
                                    *
                                    * @param string $url
                                    */
                                    $logo_link = apply_filters('woffice_logo_link_to', home_url( '/' ) );
                                    ?>

                                    <a href="<?php echo esc_url( $logo_link ); ?>">
                                        <?php
                                        $header_logo = woffice_get_theming_option('header_logo');
                                        // IF THERE IS A LOGO :
                                        if(isset($header_logo["url"]) && !empty($header_logo["url"])) :
                                            echo'<img src="'. esc_url($header_logo["url"]) .'" alt="Logo Image">';
                                        else:
                                            echo'<img src="'. get_template_directory_uri() .'/images/logo.png" alt="Logo Image">';
                                        endif; ?>
                                    </a>
                                </div>
                            </div>
                        <?php } 
					?>
					<div id="mobile-menu-canvas-close">
						<div class="mobile-canvas-header">
							<button type="button" class="close-navmenu" data-dismiss="modal" aria-hidden="true">×</button>
						</div>
					</div>
					<?php
                    /*
                     * Display the menu
                     */
                    if ( !is_user_logged_in() && has_nav_menu('public')) :
                        $settings_menu_public = array('theme_location' => 'public','menu_class' => 'main-modern-menu', 'menu' => '','container' => '','menu_id' => 'main-modern-menu','link_after' => '<span class="menu-icon fa fa-angle-down"></span>');
                        wp_nav_menu( $settings_menu_public );
                    else :
                        if ( has_nav_menu('primary') ) :
							$settings_menu_on = array('theme_location' => 'primary','menu_class' => 'main-modern-menu', 'menu' => '','container' => '','menu_id' => 'main-modern-menu','link_after' => '<span class="menu-icon fa fa-angle-down"></span>');
                            wp_nav_menu( $settings_menu_on );
                        else :
                            wp_page_menu(array('menu_id' => 'main-modern-menu', 'menu_class'  => 'main-modern-menu', 'show_home' => true));
                        endif;
                    endif; ?>

                    <?php if($menu_layout == 'top' || isset($_GET['horizontal_menu'])) {?>
                     <ul class=" mb-0 p-0 horizontal_menu_icons_wrapper">
                             <div id="nav-buttons">
                                     <div id="main-search">
                                        <span class="horizontal_menu_search_icon"></span>
                                            <?php //GET THE SEARCH FORM
                                            get_search_form(); ?>
                                     </div>

                                    <?php // Notification
                                     $show_notification_icon = woffice_get_theming_option('show_notification_icon');
                                        if ( woffice_bp_is_active( 'notifications' ) && is_user_logged_in() && $show_notification_icon ) : ?>
                                            <a href="javascript:void(0)" id="nav-notification-trigger" title="<?php _e( 'View your notifications', 'woffice' ); ?>" class="<?php echo (bp_notifications_get_unread_notification_count( bp_loggedin_user_id() ) == 0) ? "" : "active" ?>">
                                                <p class="stellar-bell">
                                                    <svg xmlns="http://www.w3.org/2000/svg" class="svg_bell svg_show" width="21" height="23" viewBox="0 0 21 23" fill="none">
                                                    <path d="M20.9999 15.6072C20.9999 16.9672 19.9123 18.0716 18.5728 18.0716H2.42709C1.08677 18.0716 0 16.9689 0 15.6072C0 14.2476 1.08597 13.1428 2.42399 13.1428C2.4223 13.1428 2.42314 8.21413 2.42314 8.21413C2.42314 3.67648 6.03875 0 10.5 0C14.9612 0 18.5768 3.67736 18.5768 8.21413V13.1422C19.9121 13.1428 21 14.2469 21 15.6071L20.9999 15.6072ZM18.5759 14.7859C17.6835 14.7859 16.9615 14.0519 16.9615 13.1423V8.2142C16.9615 4.58502 14.069 1.64334 10.4999 1.64334C6.93071 1.64334 4.03827 4.58414 4.03827 8.2142V13.1423C4.03827 14.0493 3.3146 14.7859 2.42384 14.7859C1.97792 14.7859 1.61537 15.1549 1.61537 15.6072C1.61537 16.0607 1.97791 16.4286 2.42694 16.4286H18.5727C19.0206 16.4286 19.3843 16.0593 19.3843 15.6072C19.3843 15.1552 19.0206 14.7859 18.5758 14.7859H18.5759ZM6.86523 19.3035H8.48046C8.48046 20.4377 9.38441 21.357 10.4997 21.357C11.6149 21.357 12.5189 20.4377 12.5189 19.3035H14.1341C14.1341 21.345 12.507 23 10.4997 23C8.49228 23 6.86523 21.345 6.86523 19.3035Z" fill="#2D3342"/>
                                                    </svg>
                                                    <i class="fa fa-times"></i>
                                                </p>                                                
                                            </a>
                                    <?php endif; ?>
                                    <?php  if ( woffice_bp_is_active( 'notifications' ) && is_user_logged_in() ) { woffice_notifications_menu(); } ?>
                                    <?php // WOOCOMMERCE CART TRIGGER
                                    /**
                                        * You can disable the minicart in the header form there
                                        *
                                        * @param bool
                                        */
                                    $minicart_header_enabled = apply_filters('woffice_show_minicart_in_header', true);
                                    $show_mini_Cart = woffice_get_theming_option('show_mini_Cart');
                                    if (function_exists('is_woocommerce') && $minicart_header_enabled && $show_mini_Cart) : ?>
                                        <?php //is cart empty ?
                                        if ( WC()->cart->get_cart_contents_count() > 0 ) :
                                            $cart_url_topbar = "javascript:void(0)";
                                            $cart_classes = 'active cart-content';
                                        else :
                                            $cart_url_topbar = get_permalink( wc_get_page_id( 'shop' ) );
                                            $cart_classes = "";
                                        endif; ?>
                                        <a href="<?php echo esc_url($cart_url_topbar); ?>"
                                        id="nav-cart-trigger"
                                        title="<?php _e( 'View your shopping cart', 'woffice' ); ?>"
                                        class="<?php echo esc_attr($cart_classes); ?>">
                                            <p class="stellar-mini-cart">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="23" viewBox="0 0 24 23" fill="none">
                                                    <path d="M23.4624 4.64725C23.0079 4.06641 22.3005 3.71283 21.5682 3.71283H6.18748L5.70758 1.84386C5.42975 0.75796 4.47 0.000244141 3.35889 0.000244141H0.78276C0.353435 0.000244141 -0.00012207 0.353815 -0.00012207 0.783126C-0.00012207 1.21245 0.353449 1.56601 0.78276 1.56601H3.35889C3.73765 1.56601 4.06605 1.81864 4.16716 2.1974L7.24835 14.4717C7.52618 15.5576 8.48593 16.3153 9.59704 16.3153H19.6741C20.7854 16.3153 21.7703 15.5576 22.0228 14.4717L23.9169 6.69291C24.0936 5.98575 23.9421 5.22822 23.4622 4.64725H23.4624ZM22.3765 6.33938L20.4823 14.1181C20.3813 14.4969 20.053 14.7495 19.674 14.7495H9.597C9.21823 14.7495 8.88984 14.4969 8.78873 14.1181L6.59152 5.30389H21.5682C21.8208 5.30389 22.0732 5.43021 22.2248 5.63227C22.3764 5.83434 22.4522 6.08697 22.3764 6.33943L22.3765 6.33938Z" fill="#2D3342"/>
                                                    <path d="M10.1274 17.3254C8.68775 17.3254 7.50092 18.5125 7.50092 19.9519C7.50092 21.3916 8.68793 22.5784 10.1274 22.5784C11.5671 22.5786 12.7541 21.3916 12.7541 19.9519C12.7541 18.5125 11.5671 17.3254 10.1274 17.3254ZM10.1274 20.9875C9.54658 20.9875 9.09189 20.533 9.09189 19.9519C9.09189 19.3711 9.5464 18.9164 10.1274 18.9164C10.7083 18.9164 11.1629 19.3709 11.1629 19.9519C11.1629 20.5076 10.683 20.9875 10.1274 20.9875Z" fill="#2D3342"/>
                                                    <path d="M18.8153 17.3254C17.3757 17.3254 16.1888 18.5125 16.1888 19.9519C16.1888 21.3916 17.3759 22.5784 18.8153 22.5784C20.255 22.5784 21.4418 21.3914 21.4418 19.9519C21.4167 18.5125 20.255 17.3254 18.8153 17.3254ZM18.8153 20.9875C18.2345 20.9875 17.7798 20.533 17.7798 19.9519C17.7798 19.3711 18.2343 18.9164 18.8153 18.9164C19.3962 18.9164 19.8509 19.3709 19.8509 19.9519C19.8509 20.5076 19.371 20.9875 18.8153 20.9875Z" fill="#2D3342"/>
                                                </svg>
                                            </p>
                                            <span class="woocommerce-cart-count count"><bdi>
                                                <?php echo (sizeof( WC()->cart->get_cart()) > 0) ? WC()->cart->get_cart_contents_count() : ''; ?>
                                            </bdi></span>
                                        </a>
                                    <?php endif; ?>
                                    <?php // FETCHING SIDEBAR INFO
                                    if($sidebar_state == 'show' || $sidebar_state == 'hide') :
                                        $arrow_right = '<svg class="nav-arrow-right " xmlns="http://www.w3.org/2000/svg" version="1.0" width="30px" height="30px" viewBox="0 0 512.000000 512.000000" preserveAspectRatio="xMidYMid meet">
                                        <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)" fill="#000000" stroke="none">
                                        <path d="M2370 5113 c-371 -35 -653 -114 -961 -269 -406 -203 -782 -548 -1029 -944 -179 -286 -309 -655 -362 -1025 -17 -118 -17 -512 0 -630 42 -295 120 -553 242 -800 137 -280 272 -468 494 -691 221 -220 412 -357 681 -489 188 -92 309 -137 500 -185 500 -126 1002 -102 1490 71 150 53 408 183 540 271 302 202 573 480 769 788 72 113 188 353 235 486 235 662 194 1372 -115 1993 -124 250 -263 447 -458 648 -214 222 -430 379 -711 518 -296 146 -572 225 -900 255 -102 9 -333 11 -415 3z m545 -342 c628 -106 1158 -448 1511 -977 179 -267 296 -573 351 -909 24 -153 24 -497 0 -650 -108 -668 -474 -1222 -1042 -1580 -243 -153 -537 -261 -850 -312 -154 -24 -497 -24 -650 1 -657 107 -1198 456 -1557 1006 -168 257 -281 557 -335 885 -24 153 -24 497 0 650 81 497 291 912 636 1255 382 381 862 605 1401 654 108 10 418 -4 535 -23z"/>
                                        <path d="M2655 3506 c-41 -18 -83 -69 -91 -111 -16 -86 -14 -89 289 -392 l281 -283 -796 -2 c-787 -3 -797 -3 -824 -24 -53 -39 -69 -71 -69 -134 0 -63 16 -95 69 -134 27 -21 37 -21 824 -24 l796 -2 -281 -283 c-304 -304 -305 -306 -288 -394 9 -49 69 -109 118 -118 91 -17 76 -30 549 443 383 384 438 442 443 474 17 92 29 78 -433 542 -242 242 -441 434 -459 442 -40 17 -89 17 -128 0z"/>
                                        </g>
                                        </svg>';
                                    ?>
                                     <!-- -----------new user detail place----------- -->
                                     <?php
                                        $userinfo_position = woffice_get_theming_option('header_user_position');
                                        $header_user = woffice_get_theming_option('header_user');
                                        if(woffice_validate_bool_option($header_user) && $userinfo_position == 'in_topbar'){
                                     ?>
                                        <div class="sidebar-userinfo">
                                            <div class="sidebar-userinfo_row">            
                                                <div class="user-infodetail">
                                                    <a href="javascript:void(0);" id="user-thumb" class="">
                                                        <?php // GET CURRENT USER ID
                                                            $user_ID = get_current_user_id();
                                                            echo get_avatar($user_ID);
                                                        ?>
                                                    </a>
                                                    <?php
                                                        $name_to_display = woffice_get_name_to_display();
                                                        $user_info = get_userdata($user_ID);
                                                        $user_email = $user_info->user_email;
                                                    ?>
                                                    <span class="horizontal_menu_user_toggle user-profile-trigger"></span>
                                                    <figcaption>
                                                        <h5 class="mb-0 user-name"><?php  echo esc_html($name_to_display); ?></h5>
                                                            <small class="user-email"><?php  echo esc_html($user_email); ?></small>
                                                    </figcaption>
                                                </div>
                                            </div>
                                        </div>
                                        <?php } ?>
                                        <!-- SIDEBAR TOGGLE -->
                                        <a href="javascript:void(0)" id="nav-sidebar-trigger"><?php echo $arrow_right; ?></a>
                                    <?php endif; ?>
                             </div>
                    </ul>
                <?php } ?>

                </nav>
                <!-- END MAIN NAVIGATION -->
				</div> <!--End of left col--->

                <!-- STARTING THE SIDEBAR (right side) + content behind -->
                <?php
                // FETCHING SIDEBAR POSITION
                if ($sidebar_state == "show"){
                    $class = 'with-sidebar';
                } elseif ($sidebar_state == "hide") {
                    /*We need to check if the user has already clicked the button*/
                    if( !isset($_COOKIE['Woffice_sidebar_position']) || ! apply_filters( 'woffice_cookie_sidebar_enabled', false ) ) {
                        $class = 'sidebar-hidden';
                    }
                    else {
                        $class = '';
                    }
                } else {
                    $class = 'full-width';
                }
                ?>

                <!-- START CONTENT -->
				<div class="is-center-content <?php echo esc_attr($main_content_class) .' ';?>">
                <section id="main-content" class="<?php echo esc_attr($class) .' '.esc_attr($navigation_hidden_class) .' '. esc_attr($hentry_class); ?>">

			<!-- END SIDEBAR -->
			<!-- END CONTENT -->
    <?php else:

		echo '<section id="main-content" class="full-width navigation-hidden '. esc_attr($hentry_class) .'">';

	endif;
