<?php
/**
 * Class Woffice_Alert
 * Use it like: Woffice_Alert::create()->setType('error')->setContent('Foobar')->queue();
 *
 * Used to create a Welcome page when Woffice is installed and activated.
 *
 * @since 2.5.0
 * @author Xtendify
 */

if ( ! defined( 'ABSPATH' ) ) die( 'Direct access forbidden.' );

if( ! class_exists( 'Woffice_Plugins_Licenses' ) ) {

    class Woffice_Plugins_Licenses {

        /**
         * Woffice_Notification_Handler constructor.
         */
		public function __construct() {
            
            $this->init();

        }

        public function init() {

            add_action( 'admin_menu', array($this,'woffice_register_license_menu_page') );
            $this->woffice_define_bundle_constant();
        }

        public function woffice_register_license_menu_page() {

            add_theme_page(
                'Woffice Plugin License',
                'Woffice Plugin License', 
                'manage_options',
                'woffice-plugins-license',
                array($this,'woffice_plugins_license_content')
            );

        }

        /**
         * Display a custom menu page
         */
        public function woffice_plugins_license_content() {
        ?>
        <section class="woffice-pls-wrapper">
            <div class="woffice-pls-container">
                        <?php 
                            $plugins = $this->woffice_get_plugins_lists();
                            if(!empty($plugins)) {
                                foreach($plugins as $key => $plugin) {
                                    $class = sanitize_text_field($plugin['plugin_class']);
                        ?>
                        <div class="woffice-pls-item">
                            <div class="woffice-pls-img">
                                <img src="<?php echo esc_url($plugin['plugin_img']);?>">
                            </div>
                            <div class="woffice-pls-content">
                                <?php if(file_exists($plugin['is_installded']) && class_exists($class) || $class == 'wp_job_manager_hr_bundle') { ?>
                                    <input type="text" id="woffice_<?php echo esc_attr($plugin['plugin_slug'])?>" name="" value="<?php echo sanitize_text_field($this->woffice_get_license_detail($plugin['plugin_slug'],'key')); ?>" placeholder="Enter License Key">
                                    <input type="hidden" id="woffice_<?php echo esc_attr($plugin['plugin_slug'])?>_status" value="<?php echo sanitize_text_field($this->woffice_get_license_detail($plugin['plugin_slug'],'status')); ?>">
                                    <p class="woffice-pls-info"><?php esc_html_e('Enter License Key. After Activating/Deactivating Please Click On “Save Changes” Button.','woffice');?></p>
                                    <button id="woffice_<?php echo esc_attr($plugin['plugin_slug'])?>_activate" type="button" class="woffice-pls-btn woffice-pls-activate <?php echo esc_attr($plugin['plugin_slug'])?>_activate" onclick=<?php echo "WofficeLicenceActivate('".$plugin['plugin_slug']."');"?>><?php esc_html_e('Activate','woffice');?></button>
                                    <button id="woffice_<?php echo esc_attr($plugin['plugin_slug'])?>_deactivate" type="button" class="woffice-pls-btn woffice-pls-deactivate <?php echo esc_attr($plugin['plugin_slug'])?>_deactivate" onclick=<?php echo "WofficeDeActivateLicenceKey('".$plugin['plugin_slug']."');";?>><?php esc_html_e('Deactivate','woffice');?></button>
                                <?php } else if(file_exists($plugin['is_installded']) && !class_exists($class)) { ?>
                                    <p class="woffice-pls-info">
                                        <?php echo sprintf('%s %s',$plugin['plugin_name'],__('Plugin is already installed please activate to receive latest updates.','woffice')); ?>
                                    </p>
                                <?php } else { ?>
                                    <p class="woffice-pls-info">
                                        <?php echo sprintf($plugin['description']);?>
                                    </p>
                                <?php } ?>
                            </div>
                        </div>
                    <?php   
                    }
                }
            ?>
            </div>
        </section>
        <?php
        }

        public function woffice_get_license_detail($slug,$type) {

            $license_options = get_option('woffice_license_data',true);
            $option = '';
            if($type == 'key'){
                $option = isset($license_options[$slug]['key']) ? $license_options[$slug]['key'] : '';
            }

            if($type == 'status'){
                $option = isset($license_options[$slug]['license_status']) ? $license_options[$slug]['license_status'] : '';
            }

            return $option;

        }

        public function woffice_get_plugins_lists() {

            $plugins_array = array(
                array(
                    'plugin_class' => 'WOFFICE_OKR',
                    'plugin_slug' => 'woffice_okr',
                    'plugin_img' => get_template_directory_uri() . "/images/plugin-licenses/woffice-okrs.png",
                    'is_installded' => WP_PLUGIN_DIR . '/woffice-okr/woffice-okr.php',
                    'plugin_name' => __('Woffice OKRs','woffice'),
                    'description' => __("Download <span class='highlight'> Woffice OKRs </span> allow you to Plan OKRs', Objects and link them with the appropriate tasks. <a class='woffice-propurchase-btn' href='https://woffice.io/downloads/woffice-okr?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1' target='_blank'>Buy Now</a>",'woffice'),
                    'buy_link' => esc_url('https://woffice.io/downloads/woffice-okr/')
                ),
                array(
                    'plugin_class' => 'docs_to_wiki',
                    'plugin_slug' => 'docs_to_wiki',
                    'plugin_name' => __('Docs to wiki','woffice'),
                    'description' => __("Download <span class='highlight'> Woffice Doc To Wiki </span> it allows you to display google doc on your site. <a class='woffice-propurchase-btn' href='https://woffice.io/downloads/docs-to-wiki?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1' target='_blank'>Buy Now</a>",'woffice'),
                    'plugin_img' => get_template_directory_uri() . "/images/plugin-licenses/doc-to-wiki.png",
                    'is_installded' => WP_PLUGIN_DIR . '/docs-to-wiki/docs-to-wiki.php',
                    'buy_link' => esc_url('https://woffice.io/downloads/docs-to-wiki/')
                ),
                array(
                    'plugin_class' => 'Woffice_Timeline',
                    'plugin_slug' => 'woffice_timeline',
                    'plugin_name' => __('Woffice Timeline','woffice'),
                    'description' => __("Download <span class='highlight'> Woffice Timeline </span> it allows you to display google doc on your site. <a class='woffice-propurchase-btn' href='https://woffice.io/downloads/woffice-timeline?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1' target='_blank'>Buy Now</a>",'woffice'),
                    'plugin_img' => get_template_directory_uri() . "/images/plugin-licenses/woffice-timeline.png",
                    'is_installded' => WP_PLUGIN_DIR . '/woffice-timeline/woffice-timeline.php',
                    'buy_link' => esc_url('https://woffice.io/downloads/woffice-timeline?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1')
                ),
                array(
                    'plugin_class' => 'Woffice_Advanced_Reporting',
                    'plugin_slug' => 'woffice_adreporting',
                    'plugin_name' => __('Woffice Advanced Reporting','woffice'),
                    'description' => __("Download <span class='highlight'> Woffice Advanced Reporting </span> allows you to review your Team Performance, Project Status and Total Tasks review. We keep adding new widgets monthly <a class='woffice-propurchase-btn' href='https://woffice.io/downloads/woffice-advanced-reporting?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1' target='_blank'>Buy Now</a>",'woffice'),
                    'plugin_img' => get_template_directory_uri() . "/images/plugin-licenses/advanced-reporting.png",
                    'is_installded' => WP_PLUGIN_DIR . '/woffice-advanced-reporting/woffice-advanced-reporting.php',
                    'buy_link' => esc_url('https://woffice.io/downloads/woffice-advanced-reporting/')
                ),
                array(
                    'plugin_class' => 'Woffice_Team_View',
                    'plugin_slug' => 'woffice_tmv',
                    'plugin_name' => __('Woffice Team View','woffice'),
                    'description' => __("Download <span class='highlight'> Woffice Team View </span> allows you to keep a full control of your Team and Manage their Process & Progress. <a class='woffice-propurchase-btn' href='https://woffice.io/downloads/woffice-team-view?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1' target='_blank'>Buy Now</a>",'woffice'),
                    'plugin_img' => get_template_directory_uri() . "/images/plugin-licenses/team-view.png",
                    'is_installded' => WP_PLUGIN_DIR . '/woffice-team-view/woffice-team-view.php',
                    'buy_link' => esc_url('https://woffice.io/downloads/woffice-team-view?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1')
                ),
                array(
                    'plugin_class' => 'Private_Messages',
                    'plugin_slug' => 'woffice_pm',
                    'plugin_name' => __('Private Messages','woffice'),
                    'description' => __("Download <span class='highlight'> Woffice Private Messages </span> allows you to keep a full control of your Team and Manage their Process & Progress. <a class='woffice-propurchase-btn' href='https://woffice.io/downloads/private-messages?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1' target='_blank'>Buy Now</a>",'woffice'),
                    'plugin_img' => get_template_directory_uri() . "/images/plugin-licenses/woffice-private-msg.png",
                    'is_installded' => WP_PLUGIN_DIR . '/wp-private-messages/private-messages.php',
                    'buy_link' => esc_url('https://woffice.io/downloads/private-messages?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1')
                ),
                array(
                    'plugin_class' => 'Woffice_CRMS',
                    'plugin_slug' => 'woffice_crm',
                    'plugin_name' => __('Woffice CRMs','woffice'),
                    'description' => __("Download <span class='highlight'> Woffice CRM </span> Woffice CRM is contact relationship management to increase productivity in gaining clients and business relationships. <a class='woffice-propurchase-btn' href='https://woffice.io/downloads/woffice-crm?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1' target='_blank'>Buy Now</a>", 'woffice'),
                    'plugin_img' => get_template_directory_uri() . "/images/plugin-licenses/woffice-crm.png",
                    'is_installded' => WP_PLUGIN_DIR . '/woffice-crm/woffice-crm.php',
                    'buy_link' => esc_url('https://woffice.io/downloads/woffice-crm?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1')
                ),
                array(
                    'plugin_class' => 'Woffice_Crm_Enhancements',
                    'plugin_slug' => 'woffice_crm_enhancements',
                    'plugin_name' => __('Woffice CRM Enhancements','woffice'),
                    'description' => __("Download <span class='highlight'> Woffice CRM Enhancements</span> Woffice CRM Enhancements is advance version of Woffice CRM plugin which use to increase productivity in gaining clients and business relationships. <a class='woffice-propurchase-btn' href='https://woffice.io/downloads/woffice-crm-enhancements?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1' target='_blank'>Buy Now</a>", 'woffice'),
                    'plugin_img' => get_template_directory_uri() . "/images/plugin-licenses/crm-enhancement.png",
                    'is_installded' => WP_PLUGIN_DIR . '/woffice-crm-enhancements/woffice-crm-enhancements.php',
                    'buy_link' => esc_url('https://woffice.io/downloads/woffice-crm-enhancements?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1')
                ),
                array(
                    'plugin_class' => 'Advanced_Events',
                    'plugin_slug' => 'advanced_events',
                    'plugin_name' => __('Advanced Events','woffice'),
                    'description' => __("Download <span class='highlight'> Advanced Events</span> Advanced Events is plugin help user display the today's tasks and todos on calendar page. Which help user to see current events and todos on calendar page. <a class='woffice-propurchase-btn' href='https://woffice.io/downloads/advanced-events?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1' target='_blank'>Buy Now</a>", 'woffice'),
                    'plugin_img' => get_template_directory_uri() . "/images/plugin-licenses/advanced-event.png",
                    'is_installded' => WP_PLUGIN_DIR . '/advanced-events/advanced-events.php',
                    'buy_link' => esc_url('https://woffice.io/downloads/advanced-events?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1')
                ),
                array(
                    'plugin_class' => 'Woffice_Credit_System',
                    'plugin_slug' => 'wocs_csai',
                    'plugin_name' => __('Woffice Credit System','woffice'),
                    'description' => '',
                    'plugin_img' => get_template_directory_uri() . "/images/plugin-licenses/woffice_ai.png",
                    'is_installded' => WP_PLUGIN_DIR . '/woffice-core/woffice-credit-system/woffice-credits.php',
                    'buy_link' => esc_url('')
                ),
                array(
                    'plugin_class' => 'WofficeCustomPostTypesupportforWooCommerce',
                    'plugin_slug' => 'woffice_cpt_key',
                    'plugin_name' => __('Woffice Custom Post type for WooCommerce','woffice'),
                    'description' => __('Download <span class="highlight"> Woffice Woocommerce Custom Post Type</span> to create post product. <a class="woffice-propurchase-btn" href="https://woffice.io/downloads/custom-post-type-support-for-woocommerce?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1" target="_blank">Buy Now</a>','woffice'),
                    'plugin_img' => get_template_directory_uri() . "/images/plugin-licenses/woo-cpt.png",
                    'is_installded' => WP_PLUGIN_DIR . '/custom-post-type-support-for-woocommerce/custom-post-type-support-for-woocommerce.php',
                    'buy_link' => esc_url('https://woffice.io/downloads/custom-post-type-support-for-woocommerce?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1')
                ),
                array(
                    'plugin_class' => 'WOAE',
                    'plugin_slug' => 'woffice_woae',
                    'plugin_name' => __('Woffice Advanced Email','woffice'),
                    'description' => __('Download <span class="highlight"> Woffice Advanced Email</span> to create email template. <a class="woffice-propurchase-btn" href="https://woffice.io/downloads/woffice-advanced-email?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1" target="_blank">Buy Now </a>','woffice'),
                    'plugin_img' => get_template_directory_uri() . "/images/plugin-licenses/advanced-email.png",
                    'is_installded' => WP_PLUGIN_DIR . '/woffice-advanced-emails/woffice-advanced-email.php',
                    'buy_link' => esc_url('https://woffice.io/downloads/woffice-advanced-email?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1')
                ),
                array(
                    'plugin_class' => 'WOFFICE_SUBSCRIPTION',
                    'plugin_slug' => 'wowcps',
                    'plugin_name' => __('Woffice Subscriptions','woffice'),
                    'description' => __('Download <span class="highlight"> Subscriptions for WooCommerce & Woffice </span> to create email template. <a class="woffice-propurchase-btn" href="https://woffice.io/downloads/woffice-subscription?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1" target="_blank">Buy Now</a>','woffice'),
                    'plugin_img' => get_template_directory_uri() . "/images/plugin-licenses/woffice-subscription.png",
                    'is_installded' => WP_PLUGIN_DIR . '/woffice-subscription/woffice-subscritpion.php',
                    'buy_link' => esc_url('https://woffice.io/downloads/woffice-subscription?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1')
                ),
                array(
                    'plugin_class' => 'WOKSS_KANBAN',
                    'plugin_slug' => 'wokss_kanban',
                    'plugin_name' => __('Woffice Kanban','woffice'),
                    'description' => __("Download <span class='highlight'> Woffice Kanban Style Shorting </span> Woffice Kanban Style Shorting allows you to short out your Tasks in a better Kanban style view. Have the options to switch at different states and help organize your view better. <a class='woffice-propurchase-btn' href='https://woffice.io/downloads/woffice-kanban?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1' target='_blank'>Buy Now</a>",'woffice'),
                    'plugin_img' => get_template_directory_uri() . "/images/plugin-licenses/woffice-kanban.png",
                    'is_installded' => WP_PLUGIN_DIR . '/woffice-kanban/woffice-kanban-style-shorting.php',
                    'buy_link' => esc_url('https://woffice.io/downloads/woffice-kanban?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1')
                ),
                array(
                    'plugin_class' => 'Woffice_Advanced_Tasks',
                    'plugin_name' => __('Woffice Advanced Tasks','woffice'),
                    'description' => __("Download <span class='highlight'> Advanced tasks for woffice </span> Advanced Tasks for Woffice is a Woffice Plugin that enhance the UI of Woffice tasks and adding more features for the end user. <a class='woffice-propurchase-btn' href='https://woffice.io/downloads/advanced-tasks-for-woffice?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1' target='_blank'>Buy Now</a>",'woffice'),
                    'plugin_slug' => 'advanced_tasks_for_woffice',
                    'plugin_img' => get_template_directory_uri() . "/images/plugin-licenses/advanced-tasks.png",
                    'is_installded' => WP_PLUGIN_DIR . '/advanced-tasks-for-woffice/advanced-tasks-for-woffice.php',
                    'buy_link' => esc_url('https://woffice.io/downloads/advanced-tasks-for-woffice?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1')
                ),
                array(
                    'plugin_class' => 'Wftm',
                    'plugin_name' => __('Woffice Team Management','woffice'),
                    'description' => __("Download <span class='highlight'> Woffice Team Management </span> Crucial tool for building relationships, giving feedback, setting goals, and addressing concerns, all aimed at enhancing teamwork and individual growth.<a class='woffice-propurchase-btn' href='https://woffice.io/downloads/woffice-team-management?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1' target='_blank'>Buy Now</a>",'woffice'),
                    'plugin_slug' => 'woffice_team_management',
                    'plugin_img' => get_template_directory_uri() . "/images/plugin-licenses/team-management.png",
                    'is_installded' => WP_PLUGIN_DIR . '/advanced-tasks-for-woffice/advanced-tasks-for-woffice.php',
                    'buy_link' => esc_url('https://woffice.io/downloads/advanced-tasks-for-woffice?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1')
                ),

                array(
                    'plugin_class' => 'wp_job_manager_hr_bundle',
                    'plugin_name' => __('Woffice HR Bundle','woffice'),
                    'description' => __("Download <span class='highlight'> Woffice HR Bundle </span> Crucial tool for building relationships, giving feedback, setting goals, and addressing concerns, all aimed at enhancing teamwork and individual growth.<a class='woffice-propurchase-btn' href='https://woffice.io/downloads/woffice-team-management?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1' target='_blank'>Buy Now</a>",'woffice'),
                    'plugin_slug' => 'wp_job_manager_hr_bundle',
                    'plugin_img' => get_template_directory_uri() . "/images/plugin-licenses/hr-bundle.png",
                    'is_installded' => '',
                    'buy_link' => esc_url('https://woffice.io/downloads/advanced-tasks-for-woffice?utm_source=themeforest&utm_medium=theme-settings&utm_campaign=promo-theme&utm_id=1')
                ),
                
            );

            return $plugins_array;

        }

        public function woffice_define_bundle_constant() {
            if(!defined('WP_JOB_MANAGER_HR_BUNDLE_STORE_URL')){
                define('WP_JOB_MANAGER_HR_BUNDLE_STORE_URL','https://woffice.io/');
            }
            if(!defined('WP_JOB_MANAGER_HR_BUNDLE_ITEM_ID')){
                define('WP_JOB_MANAGER_HR_BUNDLE_ITEM_ID',5187);
            }

            if(!defined('WP_JOB_MANAGER_HR_BUNDLE_EDD_AJAX')){
                define('WP_JOB_MANAGER_HR_BUNDLE_EDD_AJAX',false);
            }

            
            
        }
    }
}

$Woffice_Plugins_Licenses = new Woffice_Plugins_Licenses();