<?php
/**
 * Class Woffice_Welcome
 *
 * Used to create a Welcome page when Woffice is installed and activated.
 *
 * @since 2.1.3
 * @author Xtendify
 */

if( ! class_exists( 'Woffice_Welcome' ) ) {
    class Woffice_Welcome
    {

        /**
         * Woffice_Welcome constructor
         */
        public function __construct()
        {
            add_action('admin_init', array($this, 'woffice_theme_activation_redirect'));
            add_action('admin_menu', array($this, 'welcome_screen_pages'));
            add_action('admin_head', array($this, 'woffice_welcome_screen_remove_menus'));
        }


        /**
         * Redirect after Woffice has been activated
         */
        public function woffice_theme_activation_redirect()
        {
            if (isset($_GET['activated'])) {
                wp_redirect(admin_url('themes.php?page=woffice-welcome'));
            }
        }

        /**
         * Add the page to dashboard
         */
        public function welcome_screen_pages()
        {
            add_submenu_page(
                'themes.php', // Parent slug
                'Welcome to Woffice !',
                'Welcome to Woffice !',
                'read',
                'woffice-welcome',
                array($this, 'woffice_welcome_screen_content')
            );
        }

        /**
         * Remove the menu from the submenu
         */
        public function woffice_welcome_screen_remove_menus()
        {
            remove_submenu_page('index.php', 'woffice-welcome');
        }

        /**
         * Content of the dashboard page
         * Called from : welcome_screen_pages()
         *
         * @return void
         */
        public function woffice_welcome_screen_content()
        {

            ?>
            <div class="woffice-welcome-wrapper">
                <section class="woffice-welcome-banner">
                    <div class="woffice-welcome-container">
                        <div class="left_content">
                            <h2><?php _e('Welcome To The','woffice');?> <span><?php _e( "Woffice",'woffice');?></span></h2>
                            <p class="para">
                                <?php _e("Greetings! Let's unfold the magic of a top-performing and the only feature-rich intranet/extranet WordPress theme. Keep exploring Woffice to know more about its multipurpose traits.",'woffice');?>
                            </p>
                            <div class="general-count">
                                <ul>
                                    <li>
                                        <h3><?php _e( '100%','woffice');?></h3>
                                        <p><?php _e( 'Performance','woffice')?></p>
                                    </li>
                                    <li>
                                        <h3><?php _e('32k+', 'woffice');?></h3>
                                        <p><?php _e( 'Customers', 'woffice');?></p>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="seo_img_content">
                            <img src="<?php echo esc_url(get_template_directory_uri() . "/images/welcome/welcome-banner1.png"); ?>" alt="girl" class="img-fluid girl">
                        </div>
                    </div>
                    <div class="woffice-welcome-support">
                        <ul>
                            <li>
                                <img src="<?php echo esc_url(get_template_directory_uri() . "/images/welcome/buddypress.png"); ?>" alt="">
                                <a href="<?php echo esc_url("https://stellar.woffice.io/members/"); ?>" target="_blank"><?php _e('BuddyPress','woffice');?></a>
                            </li>
                            <li>
                                <img src="<?php echo esc_url(get_template_directory_uri() . "/images/welcome/Learnpress.png"); ?>" alt="">
                                <a href="<?php echo esc_url("https://stellar.woffice.io/"); ?>" target="_blank"><?php _e('LearnPress','woffice');?></a>
                            </li>
                            <li>
                                <img src="<?php echo esc_url(get_template_directory_uri() . "/images/welcome/Learndash.png"); ?>" alt="">
                                <a href="<?php echo esc_url("https://stellar.woffice.io/"); ?>" target="_blank"><?php _e('LearnDash','woffice');?></a>
                            </li>
                            <li>
                                <img src="<?php echo esc_url(get_template_directory_uri() . "/images/welcome/Paid membership.png"); ?>" alt="">
                                <a href="<?php echo esc_url("https://stellar.woffice.io/members/"); ?>" target="_blank"><?php _e('Paid Membershi Pro','woffice');?></a>
                            </li>
                            <li>
                                <img src="<?php echo esc_url(get_template_directory_uri() . "/images/welcome/directory extension.png") ?>" alt="">
                                <a href="<?php echo esc_url("https://stellar.woffice.io/directory/"); ?>" target="_blank"><?php _e('Directory Extension', 'woffice');?></a>
                            </li>
                            <li class="welcome-many-more">
                                <a href="<?php echo esc_url("https://woffice.io/products/"); ?>" target="_blank"><?php _e('Many more','woffice');?></a>
                            </li>
                        </ul>
                    </div>
                </section>
                <div class="woffice-welcome-inner">
                    <h5 class="welcome-started-overlay"><?php _e('GETTING STARTED GETTING STARTED GETTING STA','woffice');?></h5>
                    <section class="welcome-started-wrapper">
                        <div class="welcome-started-container">
                            <div class="welcome-started-left">
                                <h2><span class="heighlight-dark"><?php _e('Create A','woffice');?></span> <span class="heighlight-pink"><?php _e('Central Hub','woffice');?></span> <span class="heighlight-dark"><?php _e('For','woffice');?></span><br> <?php _e("Your Team's Communication",'woffice');?></h2>
                                <p>
                                    <?php _e('Utilize Woffice to manage projects, allocate tasks, track progress, <br/>implement discussion forums, build a knowledge base, and develop a <br/> dedicated communication platform to help your team stay organized.','woffice');?>
                                </p>
                                <div class="getstarted-btn-wrapper">
                                    <a href="<?php echo esc_url(admin_url('/themes.php?page=woffice_theme_options'));?>" class="getstarted_btn">
																		<?php _e('get started','woffice');?>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
                                            <path d="M1.76606 9.62362H17.1367L14.257 6.74394C13.4299 5.91681 14.6706 4.67615 15.4978 5.50328L18.1203 8.12994L19.871 9.8834C20.2103 10.2247 20.2103 10.776 19.871 11.1173L15.4978 15.4957C15.3314 15.6667 15.1023 15.7626 14.8637 15.7606C14.076 15.7605 13.6895 14.8011 14.257 14.2549L17.1435 11.3753H1.72077C0.507679 11.3151 0.598256 9.56323 1.76606 9.62362Z" fill="white"/>
                                        </svg>
                                    </a>
                                </div>
                            </div>
                            <div class="welcome-started-right">
                                <div class="welcome-started-rightimg">
                                    <a href="<?php echo esc_url('https://www.youtube.com/watch?v=_tOtM5htx6Y&pp=ygUHd29mZmljZQ%3D%3D');?>" target="_blank"">
                                        <img src="<?php echo esc_url(get_template_directory_uri() . "/images/welcome/play-icon.png"); ?>" alt="" class="img-fluid play-icon">
                                    </a>
                                    <img src="<?php echo esc_url(get_template_directory_uri() . "/images/welcome/woffice-banner.png"); ?>" alt="" class="img-fluid woffice-banner">
                                </div>
                            </div>
                        </div>
                    </section>
                    <section class="welcome-addons-wrapper">
                        <div class="welcome-addons-container">
                            <div class="welcome-addons-item">
                                <span class="welcome-addons-pin"><?php _e("ADDON", 'woffice');?></span>
                                <img src="<?php echo esc_url(get_template_directory_uri() . "/images/welcome/woocommerce.png"); ?>" alt="">
                                <h3 for="">
                                    <a href="<?php echo esc_url('https://woffice.io/downloads/custom-post-type-support-for-woocommerce/');?>" target="_blank"><?php _e('WooCommerce','woffice');?></a>
                                </h3>
                            </div>
                            <div class="welcome-addons-item">
                                <span class="welcome-addons-pin"><?php _e('ADDON','woffice');?></span>
                                <img src="<?php echo esc_url(get_template_directory_uri() . "/images/welcome/advance_email.png"); ?>" alt="">
                                <h3 for=""><a href="<?php echo esc_url('https://woffice.io/downloads/woffice-advanced-emails/');?>" target="_blank"><?php _e('Advanced Emails','woffice');?></a></h3>
                            </div>
                            <div class="welcome-addons-item">
                                <span class="welcome-addons-pin"><?php _e('ADDON','woffice');?></span>
                                <img src="<?php echo esc_url(get_template_directory_uri() . "/images/welcome/open_aI.png"); ?>" alt="">
                                <h3 for=""><a href="<?php echo esc_url('https://woffice.io/downloads/woffice-credits/');?>" target="_blank"><?php _e('Open AI','woffice');?></a></h3>
                            </div>
                            <div class="welcome-addons-item">
                                <span class="welcome-addons-pin"><?php _e('ADDON','woffice');?></span>
                                <img src="<?php echo esc_url(get_template_directory_uri() . "/images/welcome/calendar-event.png"); ?>" alt="">
                                <h3 for="" target="_blank"><a href="<?php echo esc_url('https://woffice.io/products/');?>"><?php _e('Calendar Event','woffice');?></a></h3>
                            </div>
                            <div class="welcome-addons-item">
                                <span class="welcome-addons-pin"><?php _e('ADDON','woffice');?></span>
                                <img src="<?php echo esc_url(get_template_directory_uri() . "/images/welcome/docs_to_wiki.png"); ?>" alt="">
                                <h3 for=""><a href="<?php echo esc_url('https://woffice.io/downloads/docs-to-wiki/');?>" target="_blank"><?php _e('Docs To Wiki','woffice');?></a></h3>
                            </div>
                            <div class="welcome-addons-item">
                                <span class="welcome-addons-pin"><?php _e('ADDON','woffice');?></span>
                                <img src="<?php echo esc_url(get_template_directory_uri() . "/images/welcome/crm.png"); ?>" alt="">
                                <h3 for=""><a href="<?php echo esc_url('https://woffice.io/downloads/woffice-crm/');?>" ><?php _e('Woffice CRM','woffice');?></a></h3>
                            </div>
                            <div class="welcome-addons-item">
                                <span class="welcome-addons-pin"><?php _e('ADDON','woffice');?></span>
                                <img src="<?php echo esc_url(get_template_directory_uri() . "/images/welcome/team_view.png"); ?>" alt="">
                                <h3 for=""><a href="<?php echo esc_url('https://woffice.io/downloads/woffice-team-view/');?>" target="_blank"><?php _e('Team View','woffice');?></a></h3>
                            </div>
                            <div class="welcome-addons-item">
                                <span class="welcome-addons-pin"><?php _e('ADDON','woffice');?></span>
                                <img src="<?php echo esc_url(get_template_directory_uri() . "/images/welcome/kanban.png"); ?>" alt="">
                                <h3 for=""><a href="<?php echo esc_url('https://woffice.io/downloads/woffice-kanban/');?>" target="_blank"><?php _e('Woffice Kanban','woffice');?></a></h3>
                            </div>
                        </div>
                    </section>
                </div>
            </div>
            <section class="welcome-btns-wrapper">
                    <div class="welcome-btns-container">
                        <ul class="welcome-btns-lists">
                            <li class="welcome-btns-item">
                                <a href="<?php echo esc_url('https://woffice.io/feature-requests/')?>" target="_blank">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
                                        <mask id="mask0_3984_10" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="0" y="0" width="25" height="25">
                                        <path d="M0 -1.90735e-06H25V25H0V-1.90735e-06Z" fill="white"/>
                                        </mask>
                                        <g mask="url(#mask0_3984_10)">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M4.648 24.0741L12.4971 20.0135L20.3461 24.0741L18.8953 15.3731L25 9.19558L16.4528 7.88432L12.4971 2.28882e-05L8.54129 7.88436L0 9.19559L6.0989 15.3729L4.648 24.0741ZM6.57287 21.4338L7.66586 14.879L3.05025 10.204L9.51259 9.21197L12.4971 3.26355L15.4816 9.21201L21.9479 10.2041L17.3283 14.8788L18.4213 21.4338L12.4971 18.369L6.57287 21.4338Z" fill="white"/>
                                        </g>
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M11.7659 16.6666L15.7408 12.2617L14.7025 11.1111L11.7659 14.3654L10.2975 12.7383L9.25928 13.8888L11.7659 16.6666Z" fill="white"/>
                                    </svg>
                                    <?php _e('Feature Request','woffice');?>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo esc_url(WOFFICE_DOC_URL); ?>" target="_blank">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 22 22" fill="none">
                                        <path d="M18.6398 4.5662L14.4966 0.646508C14.0559 0.229582 13.4791 0 12.8724 0H4.98438C3.68126 0 2.62109 1.06017 2.62109 2.36328V19.6367C2.62109 20.9398 3.68126 22 4.98438 22H17.0156C18.3187 22 19.3789 20.9398 19.3789 19.6367V6.28298C19.3789 5.63634 19.1095 5.01059 18.6398 4.5662ZM17.3878 5.15625H14.1797C14.0612 5.15625 13.9648 5.05987 13.9648 4.94141V1.91795L17.3878 5.15625ZM17.0156 20.7109H4.98438C4.39205 20.7109 3.91016 20.229 3.91016 19.6367V2.36328C3.91016 1.77096 4.39205 1.28906 4.98438 1.28906H12.6758V4.94141C12.6758 5.77066 13.3504 6.44531 14.1797 6.44531H18.0898V19.6367C18.0898 20.229 17.6079 20.7109 17.0156 20.7109Z" fill="white"/>
                                        <path d="M15.5977 8.59375H6.14453C5.78858 8.59375 5.5 8.88233 5.5 9.23828C5.5 9.59423 5.78858 9.88281 6.14453 9.88281H15.5977C15.9536 9.88281 16.2422 9.59423 16.2422 9.23828C16.2422 8.88233 15.9536 8.59375 15.5977 8.59375Z" fill="white"/>
                                        <path d="M15.5977 12.0312H6.14453C5.78858 12.0312 5.5 12.3198 5.5 12.6758C5.5 13.0317 5.78858 13.3203 6.14453 13.3203H15.5977C15.9536 13.3203 16.2422 13.0317 16.2422 12.6758C16.2422 12.3198 15.9536 12.0312 15.5977 12.0312Z" fill="white"/>
                                        <path d="M9.26922 15.4688H6.14453C5.78858 15.4688 5.5 15.7573 5.5 16.1133C5.5 16.4692 5.78858 16.7578 6.14453 16.7578H9.26922C9.62517 16.7578 9.91375 16.4692 9.91375 16.1133C9.91375 15.7573 9.62517 15.4688 9.26922 15.4688Z" fill="white"/>
                                    </svg>
                                    <?php _e('Documentation','woffice');?>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo esc_url('https://woffice.io/support/')?>" target="_blank">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" viewBox="0 0 26 26" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M4.11297 12.7687C4.07707 12.8046 4.0625 12.8457 4.0625 12.8808V16.4558C4.0625 17.0795 4.57623 17.5933 5.19999 17.5933H6.60829C6.70124 17.5933 6.77086 17.5236 6.77086 17.4308V12.8808C6.77086 12.7928 6.69539 12.7183 6.60829 12.7183H4.22503C4.18998 12.7183 4.14885 12.7328 4.11297 12.7687ZM2.4375 12.8808C2.4375 11.9011 3.2455 11.0933 4.22503 11.0933H6.60829C7.60455 11.0933 8.39586 11.907 8.39586 12.8808V17.4308C8.39586 18.4212 7.5987 19.2183 6.60829 19.2183H5.19999C3.67875 19.2183 2.4375 17.977 2.4375 16.4558V12.8808Z" fill="white"/>
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M12.9998 4.05164C9.2561 4.05164 6.229 7.07872 6.229 10.8225V11.9166C6.229 12.3654 5.86524 12.7291 5.4165 12.7291C4.96778 12.7291 4.604 12.3654 4.604 11.9166V10.8225C4.604 6.18124 8.35858 2.42664 12.9998 2.42664C17.6411 2.42664 21.3957 6.18124 21.3957 10.8225V11.9058C21.3957 12.3545 21.0319 12.7183 20.5832 12.7183C20.1344 12.7183 19.7707 12.3545 19.7707 11.9058V10.8225C19.7707 7.07872 16.7436 4.05164 12.9998 4.05164Z" fill="white"/>
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M20.6352 17.6092C21.0752 17.6976 21.3601 18.1258 21.2718 18.5658C20.6987 21.4187 18.1829 23.5624 15.1668 23.5624H14.0835C13.6347 23.5624 13.271 23.1987 13.271 22.7499C13.271 22.3012 13.6347 21.9374 14.0835 21.9374H15.1668C17.394 21.9374 19.255 20.3544 19.6786 18.2458C19.767 17.8058 20.1953 17.5208 20.6352 17.6092Z" fill="white"/>
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M19.2795 12.7687C19.2436 12.8046 19.229 12.8457 19.229 12.8808V17.4308C19.229 17.5187 19.3045 17.5933 19.3916 17.5933H20.7457C21.402 17.5933 21.9374 17.0579 21.9374 16.4016V12.8808C21.9374 12.7928 21.862 12.7183 21.7749 12.7183H19.3916C19.3565 12.7183 19.3154 12.7328 19.2795 12.7687ZM17.604 12.8808C17.604 11.9011 18.412 11.0933 19.3916 11.0933H21.7749C22.771 11.0933 23.5624 11.907 23.5624 12.8808V16.4016C23.5624 17.9553 22.2995 19.2183 20.7457 19.2183H19.3916C18.3953 19.2183 17.604 18.4045 17.604 17.4308V12.8808Z" fill="white"/>
                                    </svg>
                                    <?php _e('Support','woffice');?>
                                </a>
                            </li>
                        </ul>
                    </div>
                </section>
            <?php
        }
    }
}

/**
 * Let's fire it :
 */
 new Woffice_Welcome();



