<?php

if (!class_exists('WofficePluginsLicence')) :

	class WofficePluginsLicence
	{

		protected static $_instance = null;

		public static function instance()
		{
			if (is_null(self::$_instance)) {
				self::$_instance = new self();
			}
			return self::$_instance;
		}

		public function __construct()
		{
			add_action('admin_enqueue_scripts', array($this, 'woffice_related_script'));
			add_action('wp_ajax_woffice_plugins_licence_activate', array($this, 'woffice_plugins_licence_activate'));
			add_action('wp_ajax_nopriv_woffice_plugins_licence_activate', array($this, 'woffice_plugins_licence_activate'));
			add_action('wp_ajax_woffice_plugins_licence_deactivate', array($this, 'woffice_plugins_licence_deactivate'));
			add_action('wp_ajax_nopriv_woffice_plugins_licence_deactivate', array($this, 'woffice_plugins_licence_deactivate'));
			add_action('admin_footer',array($this,'woffice_plugins_licence_key'));
		}
		public function woffice_related_script($hook)
		{
			wp_enqueue_script('woffice-licence-plugins-js',  get_template_directory_uri() . '/js/licence-plugins.min.js', array('jquery'));
			wp_localize_script('woffice-licence-plugins-js', 'licencedata', array('ajax_url' => admin_url('admin-ajax.php'),'nonce' => wp_create_nonce('license-nonce')));
			wp_enqueue_script( 'jquery-ui-dialog' ); 
			wp_enqueue_style( 'wp-jquery-ui-dialog' );
		
		}

		/**
		 * Activate licence Ajax
		 *
		 */
		public function woffice_plugins_licence_activate()
		{

			if ( !wp_verify_nonce( $_POST['nonce'], 'license-nonce' ) ) {
				die( __('Sorry! Direct Access is not allowed.', "woffice"));
			}
			
			$plugins_key =	isset($_POST['plugins_key']) ? sanitize_text_field(trim($_POST['plugins_key'])) : false;
			$plugins_slug =	isset($_POST['plugins_slug']) ? sanitize_text_field($_POST['plugins_slug']) : false;
			
			$theme_settings_options = get_option('woffice_theme_options');
			if ($plugins_slug) {
				switch ($plugins_slug) {

					case 'woffice_cpt_key':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$Woffice_Wo_CPT_License = new Woffice_Wo_CPT_License();
							// data to send in our API request
							$wocpt_licence_deactivate = $Woffice_Wo_CPT_License->wocpt_licence_activate($license);
							$license_status = isset($wocpt_licence_deactivate['license_data']->license) ? $wocpt_licence_deactivate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($wocpt_licence_deactivate);
							exit();
						} else {
							$message = __('New licence key must be save before the activate.', 'woffice');
							$response = array("type" => 'success', 'message' => $message, 'license_data' => $license_data,"plugins_slug" => 'woffice_cpt_key');
							echo json_encode($response);
							exit();
						}
						break;
						
					case 'woffice_woae':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$woffice_woae_License = new Plugin_Item_Activator();
							$woffice_woae_licence_activate = $woffice_woae_License->licence_activate();
							$license_status = isset($woffice_woae_licence_activate['license_data']->license) ? $woffice_woae_licence_activate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($woffice_woae_licence_activate);
							exit();
						} else {
							$message = __('New licence key must be save before the activate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'wowcps':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$Woffice_wosubscribe_License = new Plugin_Item_Activator();
							// data to send in our API request
							$wosubscribe_licence_deactivate = $Woffice_wosubscribe_License->licence_activate();
							$license_status = isset($wosubscribe_licence_deactivate['license_data']->license) ? $wosubscribe_licence_deactivate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($wosubscribe_licence_deactivate);
							exit();
						} else {
							$message = __('New licence key must be save before the activate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;

					case 'wp_job_manager_hr_bundle':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$Woffice_wpjm_stat_License = new Plugin_Item_Activator();
							$wpjm_stat_activate = $Woffice_wpjm_stat_License->licence_activate();
							$license_status = isset($wpjm_stat_activate['license_data']->license) ? $wpjm_stat_activate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($wpjm_stat_activate);
							exit();
						} else {
							$message = __('New licence key must be save before the activate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'wokss_kanban':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$Woffice_wokss_kanban_License = new Plugin_Item_Activator();
							$wokss_kanban_licence_activate = $Woffice_wokss_kanban_License->licence_activate();
							$license_status = isset($wokss_kanban_licence_activate['license_data']->license) ? $wokss_kanban_licence_activate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($wokss_kanban_licence_activate);
							exit();
						} else {
							$message = __('New licence key must be save before the activate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;

					case 'advanced_tasks_for_woffice':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$Woffice_advanced_tasks_License = new Plugin_Item_Activator();
							$wokss_advanced_tasks_activate = $Woffice_advanced_tasks_License->licence_activate();
							$license_status = isset($wokss_advanced_tasks_activate['license_data']->license) ? $wokss_advanced_tasks_activate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($wokss_advanced_tasks_activate);
							exit();
						} else {
							$message = __('New licence key must be save before the activate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'docs_to_wiki':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$Woffice_docs_to_wiki_License = new Plugin_Item_Activator();
							$docs_to_wiki_licence_activate = $Woffice_docs_to_wiki_License->licence_activate();
							$license_status = isset($docs_to_wiki_licence_activate['license_data']->license) ? $docs_to_wiki_licence_activate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($docs_to_wiki_licence_activate);
							exit();
						} else {
							$message = __('New licence key must be save before the activate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'woffice_timeline':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$woffice_timeline_License = new Plugin_Item_Activator();
							$woffice_timeline_licence_activate = $woffice_timeline_License->licence_activate();
							$license_status = isset($woffice_timeline_licence_activate['license_data']->license) ? $woffice_timeline_licence_activate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($woffice_timeline_licence_activate);
							exit();
						} else {
							$message = __('New licence key must be save before the activate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'woffice_adreporting':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$woffice_adreporting_License = new Plugin_Item_Activator();
							$woffice_adreporting_licence_activate = $woffice_adreporting_License->licence_activate();
							$license_status = isset($woffice_adreporting_licence_activate['license_data']->license) ? $woffice_adreporting_licence_activate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($woffice_adreporting_licence_activate);
							exit();
						} else {
							$message = __('New licence key must be save before the activate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'woffice_tmv':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$woffice_tmv_License = new Plugin_Item_Activator();
							$woffice_tmv_licence_activate = $woffice_tmv_License->licence_activate();
							$license_status = isset($woffice_tmv_licence_activate['license_data']->license) ? $woffice_tmv_licence_activate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($woffice_tmv_licence_activate);
							exit();
						} else {
							$message = __('New licence key must be save before the activate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'woffice_pm':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$woffice_pm_License = new Plugin_Item_Activator();
							$woffice_pm_licence_activate = $woffice_pm_License->licence_activate();
							$license_status = isset($woffice_pm_licence_activate['license_data']->license) ? $woffice_pm_licence_activate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($woffice_pm_licence_activate);
							exit();
						} else {
							$message = __('New licence key must be save before the deactivate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'woffice_okr':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$woffice_okr_License = new Plugin_Item_Activator();
							$woffice_okr_licence_activate = $woffice_okr_License->licence_activate();
							$license_status = isset($woffice_okr_licence_activate['license_data']->license) ? $woffice_okr_licence_activate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($woffice_okr_licence_activate);
							exit();
						} else {
							$message = __('Please Enter License key', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'woffice_crm':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$woffice_crm_License = new Plugin_Item_Activator();
							$woffice_crm_licence_activate = $woffice_crm_License->licence_activate();
							$license_status = isset($woffice_crm_licence_activate['license_data']->license) ? $woffice_crm_licence_activate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($woffice_crm_licence_activate);
							exit();
						} else {
							$message = __('New licence key must be save before the deactivate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'woffice_crm_enhancements':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$woffice_crm_enhancements_License = new Plugin_Item_Activator();
							$woffice_crm_enhancements_licence_activate = $woffice_crm_enhancements_License->licence_activate();
							$license_status = isset($woffice_crm_enhancements_licence_activate['license_data']->license) ? $woffice_crm_enhancements_licence_activate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($woffice_crm_enhancements_licence_activate);
							exit();
						} else {
							$message = __('New licence key must be save before the deactivate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'advanced_events':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$woffice_advanced_events_License = new Plugin_Item_Activator();
							$woffice_advanced_events_licence_activate = $woffice_advanced_events_License->licence_activate();
							$license_status = isset($woffice_advanced_events_licence_activate['license_data']->license) ? $woffice_advanced_events_licence_activate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($woffice_advanced_events_licence_activate);
							exit();
						} else {
							$message = __('New licence key must be save before the deactivate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'wocs_csai':
						$woffice_wocs_csai_key_option = $theme_settings_options['woffice_wocs_csai'];

						if ($plugins_key) {
							$license ='';
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$woffice_wocs_csai_License = new Plugin_Item_Activator();
							$woffice_wocs_csai_licence_activate = $woffice_wocs_csai_License->licence_activate();
							$license_status = isset($woffice_wocs_csai_licence_activate['license_data']->license) ? $woffice_wocs_csai_licence_activate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($woffice_wocs_csai_licence_activate);
							exit();
						} else {
							$message = __('New licence key must be save before the deactivate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'woffice_team_management':
						$woffice_wocs_csai_key_option = $theme_settings_options['woffice_team_management'];

						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$woffice_wocs_csai_License = new Plugin_Item_Activator();
							$woffice_wocs_csai_licence_activate = $woffice_wocs_csai_License->licence_activate();
							$license_status = isset($woffice_wocs_csai_licence_activate['license_data']->license) ? $woffice_wocs_csai_licence_activate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($woffice_wocs_csai_licence_activate);
							exit();
						} else {
							$message = __('New licence key must be save before the deactivate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					default:

						$message = __('An error occurred, please try again.', 'woffice');
						break;
				}
				
			} else {
				$response = array("type" => 'unsuccessful', 'message' => 'Slug Missing', 'license_data' => '');
				echo json_encode($response);
				exit();
			}
		}
		/**
		 * Deactivate licence Ajax
		 *
		 */
		public function woffice_plugins_licence_deactivate() {

			if ( !wp_verify_nonce( $_POST['nonce'], 'license-nonce' ) || !current_user_can('manage_options') ) {
				die( __('Sorry! Direct Access is not allowed.', "woffice"));
			}

			$plugins_key =	isset($_POST['plugins_key']) ? sanitize_text_field(trim($_POST['plugins_key'])) : false;
			$plugins_slug =	isset($_POST['plugins_slug']) ? sanitize_text_field($_POST['plugins_slug']) : false;
			$theme_settings_options = get_option('woffice_theme_options');
			
			if ($plugins_slug) {
				switch ($plugins_slug) {
					case 'woffice_cpt_key':
						if ($plugins_key == $get_db_woffice_cpt_key) {
							$Woffice_Wo_CPT_License = new Woffice_Wo_CPT_License();
							// data to send in our API request
							$wocpt_licence_deactivate = $Woffice_Wo_CPT_License->wocpt_licence_deactivate($license);
							$license_status = isset($wocpt_licence_deactivate['license_data']->license) ? $wocpt_licence_deactivate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($wocpt_licence_deactivate);
							exit();
						} else {
							$message = __('New licence key must be save before the deactivate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '',"plugins_slug" => 'woffice_cpt_key');
							echo json_encode($response);
							exit();
						}
						break;
					case 'woffice_woae':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$woffice_woae_License = new Plugin_Item_Activator();
							$woffice_woae_licence_deactivate = $woffice_woae_License->licence_deactivate();
							$license_status = isset($woffice_woae_licence_deactivate['license_data']->license) ? $woffice_woae_licence_deactivate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($woffice_woae_licence_deactivate);
							exit();
						} else {
							$message = __('New licence key must be save before the deactivate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'wowcps':
						if ($plugins_key) {
							$Woffice_wosubscribe_License = new Plugin_Item_Activator();
							$wosubscribe_licence_deactivate = $Woffice_wosubscribe_License->licence_deactivate();
							$license_status = isset($wosubscribe_licence_deactivate['license_data']->license) ? $wosubscribe_licence_deactivate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($wosubscribe_licence_deactivate);
							exit();
						} else {
							$message = __('New licence key must be save before the deactivate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'wp_job_manager_hr_bundle':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$Woffice_wpjm_stat_License = new Plugin_Item_Activator();
							$wpjm_stat_licence_deactivate = $Woffice_wpjm_stat_License->licence_deactivate();
							$license_status = isset($wpjm_stat_licence_deactivate['license_data']->license) ? $wpjm_stat_licence_deactivate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($wpjm_stat_licence_deactivate);
							exit();
						} else {
							$message = __('New licence key must be save before the deactivate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'wokss_kanban':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$Woffice_wokss_kanban_License = new Plugin_Item_Activator();
							$wokss_kanban_licence_deactivate = $Woffice_wokss_kanban_License->licence_deactivate();
							$license_status = isset($wokss_kanban_licence_deactivate['license_data']->license) ? $wokss_kanban_licence_deactivate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($wokss_kanban_licence_deactivate);
							exit();
						} else {
							$message = __('New licence key must be save before the deactivate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'advanced_tasks_for_woffice':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$Woffice_advanced_tasks_License = new Plugin_Item_Activator();
							$advanced_tasks_licence_deactivate = $Woffice_advanced_tasks_License->licence_deactivate();
							$license_status = isset($advanced_tasks_licence_deactivate['license_data']->license) ? $advanced_tasks_licence_deactivate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($advanced_tasks_licence_deactivate);
							exit();
						} else {
							$message = __('New licence key must be save before the deactivate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'docs_to_wiki':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$Woffice_docs_to_wiki_License = new Plugin_Item_Activator();
							$docs_to_wiki_licence_deactivate = $Woffice_docs_to_wiki_License->licence_deactivate();
							$license_status = isset($docs_to_wiki_licence_deactivate['license_data']->license) ? $docs_to_wiki_licence_deactivate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($docs_to_wiki_licence_deactivate);
							exit();
						} else {
							$message = __('New licence key must be save before the deactivate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'woffice_timeline':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$woffice_timeline_License = new Plugin_Item_Activator();
							$woffice_timeline_licence_deactivate = $woffice_timeline_License->licence_deactivate();
							$license_status = isset($woffice_timeline_licence_deactivate['license_data']->license) ? $woffice_timeline_licence_deactivate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($woffice_timeline_licence_deactivate);
							exit();
						} else {
							$message = __('New licence key must be save before the deactivate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'woffice_adreporting':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$woffice_adreporting_License = new Plugin_Item_Activator();
							$woffice_adreporting_licence_deactivate = $woffice_adreporting_License->licence_deactivate();
							$license_status = isset($woffice_adreporting_licence_deactivate['license_data']->license) ? $woffice_adreporting_licence_deactivate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($woffice_adreporting_licence_deactivate);
							exit();
						} else {
							$message = __('New licence key must be save before the deactivate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'woffice_tmv':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$woffice_tmv_License = new Plugin_Item_Activator();
							$woffice_tmv_licence_deactivate = $woffice_tmv_License->licence_deactivate();
							$license_status = isset($woffice_tmv_licence_deactivate['license_data']->license) ? $woffice_tmv_licence_deactivate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($woffice_tmv_licence_deactivate);
							exit();
						} else {
							$message = __('New licence key must be save before the deactivate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'woffice_pm':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$woffice_pm_License = new Plugin_Item_Activator();
							$woffice_pm_licence_deactivate = $woffice_pm_License->licence_deactivate();
							$license_status = isset($woffice_pm_licence_deactivate['license_data']->license) ? $woffice_pm_licence_deactivate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($woffice_pm_licence_deactivate);
							exit();
						} else {
							$message = __('New licence key must be save before the deactivate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'woffice_okr':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$woffice_okr_License = new Plugin_Item_Activator();
							$woffice_okr_licence_deactivate = $woffice_okr_License->licence_deactivate();
							$license_status = isset($woffice_okr_licence_deactivate['license_data']->license) ? $woffice_okr_licence_deactivate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($woffice_okr_licence_deactivate);
							exit();
						} else {
							$message = __('New licence key must be save before the deactivate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'woffice_crm':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$woffice_crm_License = new Plugin_Item_Activator();
							$woffice_crm_licence_deactivate = $woffice_crm_License->licence_deactivate();
							$license_status = isset($woffice_crm_licence_deactivate['license_data']->license) ? $woffice_crm_licence_deactivate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($woffice_crm_licence_deactivate);
							exit();
						} else {
							$message = __('New licence key must be save before the deactivate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'woffice_crm_enhancements':
						if ($plugins_key ) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$woffice_crm_enhancements_License = new Plugin_Item_Activator();
							$woffice_crm_enhancements_licence_deactivate = $woffice_crm_enhancements_License->licence_deactivate();
							$license_status = isset($woffice_crm_enhancements_licence_deactivate['license_data']->license) ? $woffice_crm_enhancements_licence_deactivate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($woffice_crm_enhancements_licence_deactivate);
							exit();
						} else {
							$message = __('New licence key must be save before the deactivate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
										
					case 'advanced_events':
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$woffice_advanced_events_License = new Plugin_Item_Activator();
							$woffice_advanced_events_licence_deactivate = $woffice_advanced_events_License->licence_deactivate();
							$license_status = isset($woffice_advanced_events_licence_deactivate['license_data']->license) ? $woffice_advanced_events_licence_deactivate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($woffice_advanced_events_licence_deactivate);
							exit();
						} else {
							$message = __('New licence key must be save before the deactivate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;

					case 'wocs_csai':
						$woffice_wocs_csai_key_option = $theme_settings_options['woffice_wocs_csai'];
						if ($plugins_key) {
							$license ='';
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$woffice_wocs_csai_License = new Plugin_Item_Activator();
							$woffice_wocs_csai_licence_deactivate = $woffice_wocs_csai_License->licence_deactivate();
							$license_status = isset($woffice_wocs_csai_licence_deactivate['license_data']->license) ? $woffice_wocs_csai_licence_deactivate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($woffice_wocs_csai_licence_deactivate);
							exit();
						} else {
							$message = __('New licence key must be save before the deactivate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					case 'woffice_team_management':
						$woffice_wocs_csai_key_option = $theme_settings_options['woffice_tean_management'];
						if ($plugins_key) {
							$this->update_woffice_license_key($plugins_slug,$plugins_key);
							$woffice_wocs_csai_License = new Plugin_Item_Activator();
							$woffice_wocs_csai_licence_deactivate = $woffice_wocs_csai_License->licence_deactivate();
							$license_status = isset($woffice_wocs_csai_licence_deactivate['license_data']->license) ? $woffice_wocs_csai_licence_deactivate['license_data']->license : '';
							$this->update_woffice_license_status($plugins_slug,$license_status);
							echo json_encode($woffice_wocs_csai_licence_deactivate);
							exit();
						} else {
							$message = __('New licence key must be save before the deactivate.', 'woffice');
							$response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '');
							echo json_encode($response);
							exit();
						}
						break;
					default:
						$message = __('An error occurred, please try again.', 'woffice');
						break;
				}
			} else {
				$response = array("type" => 'unsuccessful', 'message' => 'Slug Missing', 'license_data' => '');
				echo json_encode($response);
				exit();
			}
		}

		public function update_woffice_license_key($slug,$license_key) {
		
			$woffice_license_data = get_option('woffice_license_data');
	
			if(empty($woffice_license_data) || !is_array($woffice_license_data)){
				$woffice_license_data = array();
			}
			if(!isset($woffice_license_data[$slug])){
				$woffice_license_data[$slug] = array();
			}
			if(!isset($woffice_license_data[$slug]['key'])) {
				$woffice_license_data[$slug]['key'] = $license_key;
			} else {
				$woffice_license_data[$slug]['key'] = $license_key;
			}
	
			update_option('woffice_license_data',$woffice_license_data);
		}
	
		public function update_woffice_license_status($slug,$license_status){
	
			$woffice_license_data = get_option('woffice_license_data');
	
			if(empty($woffice_license_data)){
				$woffice_license_data = array();
			}
			if(!isset($woffice_license_data[$slug])){
				$woffice_license_data[$slug] = array();
			}
			if(!isset($woffice_license_data[$slug]['license_status'])) {
				$woffice_license_data[$slug]['license_status'] = $license_status;
			} else {
				$woffice_license_data[$slug]['license_status'] = $license_status;
			}
			
	
			update_option('woffice_license_data',$woffice_license_data);
		}
	
	/**	 
	 *
	 * Set the actions modal which is show the output of ai actions.
	 *
	 * @since   5.1.9
	 */
    public function woffice_plugins_licence_key() {
		?>
			<div id="wolicencekey" class="hidden" style="min-width:550px, text-align:center">
				<div class="modal-dialog">
					<div class="modal-content">
				
						<!-- Modal Header -->
						<div class="modal-header">
						<span class="modal-title-resultfor"></span>
						</div>
						<div class="modal-body">
							<div class="key_re_type"></div>					
						</div>
					</div>
				</div>
			</div>
		<?php
		
			}
	}
endif;

function WOFFICERELATED()
{
	return WofficePluginsLicence::instance();
}

WOFFICERELATED();
