<?php
/**
 * Wolmart Elementor Single Product Notice Widget
 */
defined( 'ABSPATH' ) || die;

use Elementor\Controls_Manager;
use Elementor\Core\Schemes\Color;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

class Wolmart_Single_Product_Notice_Elementor_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'wolmart_sproduct_notice';
	}

	public function get_title() {
		return esc_html__( 'Woo Notices', 'wolmart-core' );
	}

	public function get_icon() {
		return 'wolmart-elementor-widget-icon eicon-woocommerce-notices';
	}

	public function get_categories() {
		return array( 'wolmart_single_product_widget' );
	}

	public function get_keywords() {
		return array( 'single', 'product', 'woocommerce', 'notice', 'notices' );
	}

	public function get_script_depends() {
		$depends = array();
		if ( wolmart_is_elementor_preview() ) {
			$depends[] = 'wolmart-elementor-js';
		}
		return $depends;
	}

	public function has_widget_inner_wrapper(): bool {
		return ! Elementor\Plugin::$instance->experiments->is_feature_active( 'e_optimized_markup' );
	}

	protected function register_controls() {
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		if ( apply_filters( 'wolmart_single_product_builder_set_product', false ) ) {
			woocommerce_output_all_notices();
			do_action( 'wolmart_single_product_builder_unset_product' );
		}
	}
}
