<?php
defined( 'ABSPATH' ) || die;

/**
 * Wolmart Container Element
 *
 * Extended Element_Container Class
 *
 * @since 1.8.1
 */
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

add_action( 'elementor/frontend/container/before_render', 'wolmart_container_render_attributes', 10, 1 );
class Wolmart_Element_Container extends Elementor\Includes\Elements\Container {

	/**
	 * Render the element JS template.
	 *
	 * @return void
	 */
	protected function content_template() {
		?>
		<#

		if ( 'boxed' === settings.content_width ) { #>
			<div class="e-con-inner">
		<#
			if ( 'yes' === settings.section_content_type ) {
				view.addRenderAttribute( 'con-data', 'class', 'con-data' );
				view.addRenderAttribute( 'con-data', 'data-c-fluid', 'true' );
			}
		}
		if ( settings.background_video_link ) {
			let videoAttributes = 'autoplay muted playsinline';

			if ( ! settings.background_play_once ) {
				videoAttributes += ' loop';
			}

			view.addRenderAttribute( 'background-video-container', 'class', 'elementor-background-video-container' );

			if ( ! settings.background_play_on_mobile ) {
				view.addRenderAttribute( 'background-video-container', 'class', 'elementor-hidden-phone' );
			}
			#>
			<div {{{ view.getRenderAttributeString( 'background-video-container' ) }}}>
				<div class="elementor-background-video-embed"></div>
				<video class="elementor-background-video-hosted elementor-html5-video" {{ videoAttributes }}></video>
			</div>
		<# } #>
		<div class="elementor-shape elementor-shape-top"></div>
		<div class="elementor-shape elementor-shape-bottom"></div>

		<# if ( 'boxed' === settings.content_width ) { #>
			</div>
			<# if ( 'yes' === settings.section_content_type ) {  #>
				<div {{{ view.getRenderAttributeString( 'con-data' ) }}}></div>
			<# } #>
		<# } #>
		<?php
	}

	protected function register_controls() {
		parent::register_controls();

		$this->start_controls_section(
			'section_general',
			array(
				'label' => esc_html__( 'Wolmart Settings', 'wolmart-core' ),
				'tab'   => Controls_Manager::TAB_LAYOUT,
			)
		);

			$this->add_control(
				'section_content_type',
				array(
					'label'       => esc_html__( 'Wrap with Container-Fluid', 'wolmart-core' ),
					'type'        => Controls_Manager::SWITCHER,
					'render_type' => 'template',
					'condition'   => array(
						'content_width' => 'boxed',
					),
				)
			);

			$this->add_responsive_control(
				'extend_con_width',
				array(
					'label'       => esc_html__( 'Sub Container\'s Columns Spacing', 'wolmart-core' ),
					'description' => esc_html__( 'Extend container width if it has sub-containers that have paddings so that it could be same in width with other containers.', 'wolmart-core' ),
					'type'        => Controls_Manager::SLIDER,
					'size_units'  => array(
						'px',
						'rem',
					),
					'range'       => array(
						'px'  => array(
							'min' => 0,
							'max' => 100,
						),
						'rem' => array(
							'min' => 0,
							'max' => 10,
						),
					),
					'selectors'   => array(
						'{{WRAPPER}}' => '--wolmart-con-ex-width: {{SIZE}}{{UNIT}}',
					),
					'condition'   => array(
						'content_width' => 'boxed',
					),
				),
				array(
					'position' => array(
						'of' => 'content_width',
					),
				)
			);

			$this->add_control(
				'section_content_sticky',
				array(
					'label' => esc_html__( 'Sticky Content', 'wolmart-core' ),
					'type'  => Controls_Manager::SWITCHER,
				)
			);

			$this->add_control(
				'section_content_sticky_auto',
				array(
					'label'     => esc_html__( 'Auto Show On Scroll', 'wolmart-core' ),
					'type'      => Controls_Manager::SWITCHER,
					'condition' => array(
						'section_content_sticky' => 'yes',
					),
				)
			);

			$this->add_responsive_control(
				'section_sticky_padding',
				array(
					'label'      => esc_html__( 'Sticky Padding', 'wolmart-core' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => array(
						'px',
						'%',
					),
					'selectors'  => array(
						'{{WRAPPER}}.fixed' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
					'condition'  => array(
						'section_content_sticky' => 'yes',
					),
				)
			);

			$this->add_control(
				'section_sticky_bg',
				array(
					'label'     => esc_html__( 'Sticky Background', 'wolmart-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}}.fixed' => 'background-color: {{VALUE}}',
					),
					'condition' => array(
						'section_content_sticky' => 'yes',
					),
				)
			);

		$this->end_controls_section();

		$this->update_control(
			'color_link',
			array(
				'selectors' => array(
					'.elementor-element-{{ID}} a' => 'color: {{VALUE}}',
				),
			)
		);

		$this->update_control(
			'color_link_hover',
			array(
				'selectors' => array(
					'.elementor-element-{{ID}} a:hover' => 'color: {{VALUE}}',
				),
			)
		);

		$this->start_controls_section(
			'wolmart_typography_style',
			array(
				'label' => esc_html__( 'Wolmart Typography', 'wolmart-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				array(
					'name'     => 'telephone_typography',
					'selector' => '.elementor-element-{{ID}}',
				)
			);

		$this->end_controls_section();
	}

	/**
	 * Before rendering the container content. (Print the opening tag, etc.)
	 *
	 * @return void
	 * @since 1.8.1
	 */
	public function before_render() {
		$settings = $this->get_settings_for_display();
		$link     = $settings['link'];

		if ( ! empty( $link['url'] ) ) {
			$this->add_link_attributes( '_wrapper', $link );
		}

		?>
		<<?php $this->print_html_tag(); ?> <?php $this->print_render_attribute_string( '_wrapper' ); ?>>
		<?php
		if ( $this->is_boxed_container( $settings ) ) {
			?>
			<div class="e-con-inner">
			<?php
		}

		$this->render_video_background();

		if ( ! empty( $settings['shape_divider_top'] ) ) {
			$this->render_shape_divider( 'top' );
		}

		if ( ! empty( $settings['shape_divider_bottom'] ) ) {
			$this->render_shape_divider( 'bottom' );
		}
	}
}

if ( ! function_exists( 'wolmart_container_render_attributes' ) ) {
	/**
	 * Add render attributes for container.
	 *
	 * @since 1.8.1
	 */
	function wolmart_container_render_attributes( $self ) {
		$settings = $self->get_settings_for_display();
		$options  = array( 'class' => '' );

		if ( 'boxed' == $settings['content_width'] && isset( $settings['section_content_type'] ) && 'yes' == $settings['section_content_type'] ) {
			$options['class'] .= 'c-fluid';
		}

		if ( $settings['background_image'] && $settings['background_image']['url'] && function_exists( 'wolmart_get_option' ) && wolmart_get_option( 'lazyload' ) ) {
			// Lazyload background image
			if ( ! is_admin() && ! is_customize_preview() && ! wolmart_doing_ajax() ) {
				if ( empty( $settings['background_color'] ) ) {
					$options['style'] = 'background-color:' . wolmart_get_option( 'lazyload_bg' ) . ';';
				}
				$options['data-lazy'] = esc_url( $settings['background_image']['url'] );
			}
		}

		if ( isset( $settings['section_content_sticky'] ) && $settings['section_content_sticky'] ) {
			$options['class'] .= ' sticky-content fix-top';
		}
		if ( isset( $settings['section_content_sticky_auto'] ) && $settings['section_content_sticky_auto'] ) {
			$options['data-sticky-options'] = '{\'scrollMode\': true}';
		}

		$self->add_render_attribute(
			array(
				'_wrapper' => $options,
			)
		);
	}
}
