<?php
/**
 * Text Marquee widget
 *
 * @since 1.9.0
 */

// direct load is not allowed
defined( 'ABSPATH' ) || die;

use Elementor\Plugin;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

class Wolmart_Marquee_Elementor_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'wolmart_widget_marquee';
	}

	public function get_title() {
		return esc_html__( 'Marquee', 'wolmart-core' );
	}

	public function get_icon() {
		return 'wolmart-elementor-widget-icon eicon-animation-text';
	}

	public function get_categories() {
		return array( 'wolmart_widget' );
	}

	public function get_keywords() {
		return array( 'marquee', 'text', 'image' );
	}

	protected function is_dynamic_content(): bool {
		return false;
	}

	public function get_style_depends() {
		return array( 'wolmart-marquee' );
	}

	public function has_widget_inner_wrapper(): bool {
		return ! Plugin::$instance->experiments->is_feature_active( 'e_optimized_markup' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_marquee_content',
			array(
				'label' => esc_html__( 'Marquee Content', 'wolmart-core' ),
			)
		);

		$this->add_control(
			'marquee_type',
			array(
				'label'       => esc_html__( 'Marquee Type', 'wolmart-core' ),
				'description' => esc_html__( 'Select text or image type for marquee.', 'wolmart-core' ),
				'type'        => Controls_Manager::SELECT,
				'default'     => 'text',
				'options'     => array(
					'text'  => esc_html__( 'Text', 'wolmart-core' ),
					'image' => esc_html__( 'Image', 'wolmart-core' ),
				),
			)
		);

		$this->add_control(
			'marquee_layout',
			array(
				'label'       => esc_html__( 'Marquee Layout', 'wolmart-core' ),
				'description' => esc_html__( 'Select layout of marquee.', 'wolmart-core' ),
				'type'        => Controls_Manager::CHOOSE,
				'default'     => 'horizontal',
				'options'     => array(
					'vertical'   => array(
						'title' => esc_html__( 'Vertical', 'wolmart-core' ),
						'icon'  => 'eicon-navigation-vertical',
					),
					'horizontal' => array(
						'title' => esc_html__( 'Horizontal', 'wolmart-core' ),
						'icon'  => 'eicon-navigation-horizontal',
					),
				),
				'condition'   => array(
					'marquee_type' => 'image',
				),
			)
		);

		$this->add_responsive_control(
			'max_height',
			array(
				'label'       => esc_html__( 'Max Height', 'wolmart-core' ),
				'description' => esc_html__( 'Set max height of marquee wrapper.', 'wolmart-core' ),
				'type'        => Controls_Manager::SLIDER,
				'size_units'  => array( 'px', 'rem' ),
				'range'       => array(
					'px' => array(
						'step' => 1,
						'min'  => 0,
						'max'  => 1000,
					),
					'%'  => array(
						'step' => 1,
						'min'  => 0,
						'max'  => 100,
					),
				),
				'selectors'   => array(
					'{{WRAPPER}} .marquee' => '--wolmart-marquee-height: {{SIZE}}{{UNIT}};',
				),
				'condition'   => array(
					'marquee_type'   => 'image',
					'marquee_layout' => 'vertical',
				),
			)
		);

		$this->add_control(
			'anim_direction',
			array(
				'label'       => esc_html__( 'Animation Direction', 'wolmart-core' ),
				'description' => esc_html__( 'Select text marquee animation direction.', 'wolmart-core' ),
				'type'        => Controls_Manager::CHOOSE,
				'default'     => 'ltr',
				'options'     => array(
					'ltr' => array(
						'title' => esc_html__( 'Right to Left', 'wolmart-core' ),
						'icon'  => 'eicon-arrow-left',
					),
					'rtl' => array(
						'title' => esc_html__( 'Left to Right', 'wolmart-core' ),
						'icon'  => 'eicon-arrow-right',
					),
				),
				'conditions'  => array(
					'relation' => 'or',
					'terms'    => array(
						array(
							'name'     => 'marquee_type',
							'operator' => '===',
							'value'    => 'text',
						),
						array(
							'name'     => 'marquee_layout',
							'operator' => '===',
							'value'    => 'horizontal',
						),
					),
				),
			)
		);

		$this->add_control(
			'anim_direction2',
			array(
				'label'       => esc_html__( 'Animation Direction', 'wolmart-core' ),
				'description' => esc_html__( 'Select text marquee animation direction.', 'wolmart-core' ),
				'type'        => Controls_Manager::CHOOSE,
				'default'     => 'up',
				'options'     => array(
					'up'   => array(
						'title' => esc_html__( 'Bottom to Top', 'wolmart-core' ),
						'icon'  => 'eicon-arrow-up',
					),
					'down' => array(
						'title' => esc_html__( 'Top to Bottom', 'wolmart-core' ),
						'icon'  => 'eicon-arrow-down',
					),
				),
				'condition'   => array(
					'marquee_type'   => 'image',
					'marquee_layout' => 'vertical',
				),
			)
		);

		$this->add_control(
			'anim_speed',
			array(
				'label'       => esc_html__( 'Animation Speed (s)', 'wolmart-core' ),
				'description' => esc_html__( 'Select the animation speed.', 'wolmart-core' ),
				'type'        => Controls_Manager::NUMBER,
				'default'     => '25',
				'selectors'   => array(
					'{{WRAPPER}} .marquee' => '--wolmart-marquee-animation-duration: {{SIZE}}s;',
				),
			)
		);

		$this->add_control(
			'marquee_overflow',
			array(
				'label'     => esc_html__( 'Overflow', 'wolmart-core' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => '',
				'options'   => array(
					''       => esc_html__( 'Default', 'wolmart-core' ),
					'hidden' => esc_html__( 'Hidden', 'wolmart-core' ),
				),
				'selectors' => array(
					'{{WRAPPER}} .marquee' => 'overflow: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'text_content',
			array(
				'label'       => esc_html__( 'Text Content', 'wolmart-core' ),
				'description' => esc_html__( 'Type the text content for marquee.', 'wolmart-core' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => array(
					'active' => true,
				),
				'default'     => esc_html__( 'Add your text content', 'wolmart-core' ),
				'placeholder' => esc_html__( 'Enter your text content', 'wolmart-core' ),
				'condition'   => array(
					'marquee_type' => 'text',
				),
			)
		);

		$this->add_control(
			'marquee_images',
			array(
				'label'       => esc_html__( 'Add Images', 'wolmart-core' ),
				'type'        => Controls_Manager::GALLERY,
				'default'     => array(),
				'show_label'  => false,
				'description' => esc_html__( 'Insert images from the library', 'wolmart-core' ),
				'dynamic'     => array(
					'active' => true,
				),
				'condition'   => array(
					'marquee_type' => 'image',
				),
			)
		);

		$this->add_control(
			'content_repeat',
			array(
				'label'       => esc_html__( 'Number of Content Repeats', 'wolmart-core' ),
				'description' => esc_html__( 'Select how much do you want to repeat your content in marquee.', 'wolmart-core' ),
				'type'        => Controls_Manager::SELECT,
				'default'     => '3',
				'options'     => array(
					'3' => esc_html__( '3', 'wolmart-core' ),
					'4' => esc_html__( '4', 'wolmart-core' ),
					'5' => esc_html__( '5', 'wolmart-core' ),
					'6' => esc_html__( '6', 'wolmart-core' ),
					'7' => esc_html__( '7', 'wolmart-core' ),
					'8' => esc_html__( '8', 'wolmart-core' ),
				),
			)
		);

		$this->add_control(
			'text_type',
			array(
				'label'       => esc_html__( 'Text Type', 'wolmart-core' ),
				'description' => esc_html__( 'Select the text type.', 'wolmart-core' ),
				'type'        => Controls_Manager::SELECT,
				'default'     => 'default',
				'options'     => array(
					'default' => esc_html__( 'Default', 'wolmart-core' ),
					'outline' => esc_html__( 'Outline', 'wolmart-core' ),
				),
				'condition'   => array(
					'marquee_type' => 'text',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_marquee_style',
			array(
				'label' => esc_html__( 'Content Style', 'wolmart-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

			$this->add_responsive_control(
				'image_size',
				array(
					'label'       => esc_html__( 'Image Size', 'wolmart-core' ),
					'description' => esc_html__( 'Type a certain number for marquee image size.', 'wolmart-core' ),
					'type'        => Controls_Manager::SLIDER,
					'size_units'  => array( 'px', '%' ),
					'range'       => array(
						'px' => array(
							'step' => 1,
							'min'  => 0,
							'max'  => 1000,
						),
						'%'  => array(
							'step' => 1,
							'min'  => 0,
							'max'  => 100,
						),
					),
					'selectors'   => array(
						'{{WRAPPER}} .marquee' => '--wolmart-marquee-image-size: {{SIZE}}{{UNIT}};',
					),
					'condition'   => array(
						'marquee_type' => 'image',
					),
				)
			);

			$this->add_control(
				'text_color',
				array(
					'label'       => esc_html__( 'Text Color', 'wolmart-core' ),
					'description' => esc_html__( 'Controls the text color.', 'wolmart-core' ),
					'type'        => Controls_Manager::COLOR,
					'selectors'   => array(
						'{{WRAPPER}} .marquee' => '--wolmart-marquee-color: {{VALUE}};',
					),
					'condition'   => array(
						'marquee_type' => 'text',
						'text_type!'   => 'outline',
					),
				)
			);

			$this->add_control(
				'text_hv_color',
				array(
					'label'       => esc_html__( 'Text Hover Color', 'wolmart-core' ),
					'description' => esc_html__( 'Controls the text hover color.', 'wolmart-core' ),
					'type'        => Controls_Manager::COLOR,
					'selectors'   => array(
						'{{WRAPPER}} .marquee' => '--wolmart-marquee-hover-color: {{VALUE}};',
					),
					'condition'   => array(
						'marquee_type' => 'text',
						'text_type!'   => 'outline',
					),
				)
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				array(
					'name'      => 'text_typography',
					'selector'  => '{{WRAPPER}} .marquee .marquee-inner-content',
					'condition' => array(
						'marquee_type' => 'text',
					),
				)
			);

			$this->add_responsive_control(
				'content_spacing',
				array(
					'label'       => esc_html__( 'Space Between', 'wolmart-core' ),
					'description' => esc_html__( 'Type a certain number for spacing between content.', 'wolmart-core' ),
					'type'        => Controls_Manager::SLIDER,
					'size_units'  => array( 'px', 'rem', 'em' ),
					'selectors'   => array(
						'{{WRAPPER}} .marquee' => '--wolmart-marquee-item-spacing: {{SIZE}}{{UNIT}};',
					),
				)
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_text_outline_style',
			array(
				'label'     => esc_html__( 'Outline Style', 'wolmart-core' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'marquee_type' => 'text',
					'text_type'    => 'outline',
				),
			)
		);

			$this->add_control(
				'text_outline_width',
				array(
					'label'       => esc_html__( 'Outline Width (px)', 'wolmart-core' ),
					'description' => esc_html__( 'Type a certain number for outline width.', 'wolmart-core' ),
					'type'        => Controls_Manager::SLIDER,
					'range'       => array(
						'px' => array(
							'step' => 1,
							'min'  => 1,
							'max'  => 10,
						),
					),
					'selectors'   => array(
						'{{WRAPPER}} .marquee' => '--wolmart-marquee-stroke-width: {{SIZE}}px;',
					),
				)
			);

			$this->start_controls_tabs( 'text_outline_style' );

			$this->start_controls_tab(
				'text_outline_normal_style',
				array(
					'label' => esc_html__( 'Normal', 'wolmart-core' ),
				)
			);

			$this->add_control(
				'text_outline_color',
				array(
					'label'       => esc_html__( 'Outline Color', 'wolmart-core' ),
					'description' => esc_html__( 'Controls the outline color.', 'wolmart-core' ),
					'type'        => Controls_Manager::COLOR,
					'selectors'   => array(
						'{{WRAPPER}} .marquee' => '--wolmart-marquee-stroke-color: {{VALUE}};',
					),
				)
			);

			$this->add_control(
				'text_outline_bg_color',
				array(
					'label'       => esc_html__( 'Background Color', 'wolmart-core' ),
					'description' => esc_html__( 'Controls the text background color.', 'wolmart-core' ),
					'type'        => Controls_Manager::COLOR,
					'selectors'   => array(
						'{{WRAPPER}} .marquee' => '--wolmart-marquee-fill-color: {{VALUE}};',
					),
				)
			);

			$this->end_controls_tab();

			$this->start_controls_tab(
				'text_outline_hover_style',
				array(
					'label' => esc_html__( 'Hover', 'wolmart-core' ),
				)
			);

			$this->add_control(
				'text_outline_hv_color',
				array(
					'label'       => esc_html__( 'Outline Color', 'wolmart-core' ),
					'description' => esc_html__( 'Controls the outline hover color.', 'wolmart-core' ),
					'type'        => Controls_Manager::COLOR,
					'selectors'   => array(
						'{{WRAPPER}} .marquee' => '--wolmart-marquee-stroke-hover-color: {{VALUE}};',
					),
				)
			);

			$this->add_control(
				'text_outline_hv_bg_color',
				array(
					'label'       => esc_html__( 'Background Color', 'wolmart-core' ),
					'description' => esc_html__( 'Controls the text hover background color.', 'wolmart-core' ),
					'type'        => Controls_Manager::COLOR,
					'selectors'   => array(
						'{{WRAPPER}} .marquee' => '--wolmart-marquee-fill-hover-color: {{VALUE}};',
					),
				)
			);

			$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();
	}

	protected function render() {
		$atts = $this->get_settings_for_display();
		require __DIR__ . '/render-marquee-elementor.php';
	}
}
