<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://amentotech.com/
 * @since             1.0.0
 * @package           Workreap_Customized_Task_Offers_Addon
 *
 * @wordpress-plugin
 * Plugin Name:       Workreap - Customized Offers
 * Plugin URI:        https://codecanyon.net/user/amentotech/portfolio
 * Description:       This addon will allow to create an customised offer to the buyers.
 * Version:           3.3.3
 * Author:            Amentotech
 * Author URI:        https://themeforest.net/user/amentotech/portfolio
 * Text Domain:       customized-task-offer
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

define( 'WORKREAP_CUSTOMIZED_TASK_OFFERS_VERSION', '3.3.3' );
define( 'WORKREAP_CUSTOMIZED_TASK_OFFERS', plugin_dir_path( __FILE__ ));
define( 'WORKREAP_CUSTOMIZED_TASK_OFFERS_URI', plugin_dir_url( __FILE__ ));

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-customized-task-offers-activator.php
 */
function workreap_customized_task_offers_addon_activate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-customized-task-offers-activator.php';
	Workreap_Customized_Task_Offers_Addon_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-customized-task-offers-deactivator.php
 */
function workreap_customized_task_offers_addon_deactivate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-customized-task-offers-deactivator.php';
	Workreap_Customized_Task_Offers_Addon_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'workreap_customized_task_offers_addon_activate' );
register_deactivation_hook( __FILE__, 'workreap_customized_task_offers_addon_deactivate' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'helpers/customized-task-offers-emails.php';
require plugin_dir_path( __FILE__ ) . 'includes/class-customized-task-offers.php';
require plugin_dir_path( __FILE__ ) . 'public/partials/functions.php';
require plugin_dir_path( __FILE__ ) . 'public/partials/ajax-hooks.php';
require plugin_dir_path( __FILE__ ) . 'public/partials/hooks.php';
require plugin_dir_path( __FILE__ ) . 'public/partials/template-loader.php';
/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function workreap_customized_task_offers_addon_run() {
	$plugin = new Workreap_Customized_Task_Offers_Addon();
	$plugin->run();

}
workreap_customized_task_offers_addon_run();

/**
 * Load plugin textdomain
 *
 * @since 1.0.0
 */
add_action( 'init', 'workreap_customized_task_offers_addon_load_textdomain' );
function workreap_customized_task_offers_addon_load_textdomain() {
  	load_plugin_textdomain( 'customized-task-offer', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
}

add_action( 'acf/include_fields', function() {
	if ( ! function_exists( 'acf_add_local_field_group' ) ) {
		return;
	}

	acf_add_local_field_group( array(
	'key' => 'group_67c6c09f56fb5',
	'title' => 'Custom offers options',
	'fields' => array(
		array(
			'key' => 'field_67c6c0a000eb7',
			'label' => 'Enable guppy users',
			'name' => 'enable_guppy_users',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => 'To enable this, only employers who have previously sent or received messages from the current freelancer will be listed when creating a custom offer.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				0 => 'False',
				1 => 'True',
			),
			'default_value' => 0,
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'allow_in_bindings' => 0,
			'layout' => 'vertical',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_67c6c17500eb8',
			'label' => 'Number of employers',
			'name' => 'number_of_employers',
			'aria-label' => '',
			'type' => 'number',
			'instructions' => 'Display the number of employers in the dropdown.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_67c6c0a000eb7',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => 100,
			'min' => '',
			'max' => '',
			'allow_in_bindings' => 0,
			'placeholder' => '',
			'step' => '',
			'prepend' => '',
			'append' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'page_template',
				'operator' => '==',
				'value' => 'templates/add-offer.php',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );
} );

