<?php

/**
 * Class 'Workreap_Dispute' defines the cusotm post type
 * 
 * @package     Workreap
 * @subpackage  Workreap/admin/cpt
 * @author      Amentotech <info@amentotech.com>
 * @link        http://amentotech.com/
 * @version     1.0
 * @since       1.0
 */

if (!class_exists('Workreap_Dispute')) {

    class Workreap_Dispute {

        /**
         * @access  public
         * @Init Hooks in Constructor
         */
        public function __construct() {
            add_action('init', array(&$this, 'init_directory_type'));
            add_action('add_meta_boxes', array(&$this, 'workreap_dispute_detail'), 10, 2);
            add_filter('manage_disputes_posts_columns', array(&$this, 'disputes_columns_add'));
		    add_action('manage_disputes_posts_custom_column', array(&$this, 'disputes_columns'),10, 2);
        }
        /**
	 * @Prepare Columns
	 * @return {post}
	 */
	public function disputes_columns_add($columns) {
		$columns['type'] 		        = esc_html__('Type','workreap');
        $columns['_sender_type'] 		= esc_html__('Disputed by','workreap');
        $columns['dispute_reason'] 		= esc_html__('Dispute reason','workreap');
        $columns['amount'] 		        = esc_html__('Total amount','workreap');
        $columns['_employer_id'] 		= esc_html__('Employer','workreap');
        $columns['_freelancer_id'] 		= esc_html__('Freelancer','workreap');
		return $columns;
	}

		/**
	 * @Get Columns
	 * @return {}
	 */
	public function disputes_columns($case) {
		global $post;
		$user_identity		= workreap_get_linked_profile_id($post->ID,'post');
        $_dispute_order     = get_post_meta($post->ID, '_dispute_order', true);
        $payment_type       = !empty($_dispute_order) ? get_post_meta($_dispute_order, 'payment_type', true) : '--';
		switch ($case) {
            case 'amount':
                $order = wc_get_order( $_dispute_order );
                if ( $order ) {
                    echo esc_html($order->get_total());
                }
			break;
            case '_freelancer_id':
                $_freelancer_id     = get_post_meta($post->ID, '_freelancer_id', true);
                $profile_id        = workreap_get_linked_profile_id($_freelancer_id,'','freelancers');
				echo esc_html( get_the_title($profile_id) );
			break;
            case '_employer_id':
                $_employer_id     = get_post_meta($post->ID, '_employer_id', true);
                $_employer_id        = workreap_get_linked_profile_id($_employer_id,'','employers');
				echo esc_html( get_the_title($_employer_id) );
			break;
            case 'dispute_reason':
                $_dispute_key     = get_post_meta($post->ID, '_dispute_key', true);
				echo esc_html( ucfirst($_dispute_key) );
			break;
			case 'type':
				echo esc_html( ucfirst($payment_type) );
			break;
            case '_sender_type':
                $sender_type = get_post_meta($post->ID, '_send_by', true);
                if($sender_type == 'employers'){
                    echo esc_html__('Employer', 'workreap');
                }else{
                    echo esc_html__('Freelancer', 'workreap');
                }
			break;
			default:
                break;
		}
	}
        /**
         * @Init Post Type
         * @return {post}
         */
        public function init_directory_type() {
            $this->prepare_post_type();
        }

        /**
         * @Prepare Post Type Category
         * @return post type
         */
        public function prepare_post_type() {            
            $labels = array(
                'name'				=> esc_html__('Disputes', 'workreap'),
                'all_items' 		=> esc_html__('Disputes', 'workreap'),
                'singular_name' 	=> esc_html__('Disputes', 'workreap'),
                'add_new' 			=> esc_html__('Add dispute', 'workreap'),
                'add_new_item' 		=> esc_html__('Add new dispute', 'workreap'),
                'edit' 				=> esc_html__('Edit', 'workreap'),
                'edit_item' 		=> esc_html__('Edit dispute', 'workreap'),
                'new_item' 			=> esc_html__('New dispute', 'workreap'),
                'view' 				=> esc_html__('View dispute', 'workreap'),
                'view_item' 		=> esc_html__('View dispute', 'workreap'),
                'search_items' 		=> esc_html__('Search dispute', 'workreap'),
                'not_found' 		=> esc_html__('No dispute found', 'workreap'),
                'not_found_in_trash'=> esc_html__('No dispute found in trash', 'workreap'),
                'parent' 			=> esc_html__('Parent dispute', 'workreap'),
            );
			
            $args = array(
                'labels' 				=> $labels,
                'description' 			=> esc_html__('This is where you can add new Dispute ', 'workreap'),
                'public' 				=> false,
                'supports' 				=> array('title','editor', 'comments'),
                'show_ui' 				=> true,
                'capability_type' 		=> 'post',
                'map_meta_cap' 			=> true,
                'publicly_queryable' 	=> false,
                'exclude_from_search' 	=> true,
                'hierarchical' 			=> false,
                'menu_position' 		=> 10,
                'rewrite' 				=> array('slug' => 'dispute', 'with_front' => true),
                'show_in_menu' 			=> 'edit.php?post_type=freelancers',
                'query_var' 			=> false,
                'has_archive' 			=> false,
				'capabilities' 			=> array('create_posts' => false)
            );
			
            register_post_type('disputes', $args);     
        }

        /**
		 * @Linked Profile metabox
		 * @return {post}
		 */
		public function workreap_dispute_detail($post_type, $post) {
            $user_id        = get_post_meta($post->ID, '_send_by', true);
            $linked_profile = workreap_get_linked_profile_id( $user_id );
            
            if(empty($linked_profile)) {return;}

            add_meta_box(
                'linked_profile', esc_html__('Linked details', 'workreap'), array(&$this, 'workreap_dispute_detail_meta'), 'disputes', 'side', 'high'
            );

        }
        
        /**
		 * @Linked Profile metabox
		 * @return {post}
		 */
		public function workreap_dispute_detail_meta($post) {
            $_dispute_key           = get_post_meta($post->ID, '_dispute_key', true);
            $task_id                = get_post_meta($post->ID, '_task_id', true);
            $disputed_order_id      = get_post_meta($post->ID, '_dispute_order', true);
            $freelancer_id              = get_post_meta($post->ID, '_freelancer_id', true);
            $post_type              = get_post_type($disputed_order_id);
            $post_status            = get_post_status( $post->ID );
            $title                      = esc_html__('View task order', 'workreap');
            $employer_id                   = get_post_field('post_author', $post->ID);
            $linked_employer_profile	= workreap_get_linked_profile_id($freelancer_id);
            $linked_freelancer_profile	= workreap_get_linked_profile_id($employer_id);
            $proj_serv_id               = !empty($service_order_id) ? $service_order_id : '';
            ?>
			<ul class="review-info">
                <li> <?php echo esc_html($_dispute_key);?></li>
                <li>
                    <span class="push-right">
                        <a target="_blank" href="<?php echo esc_url(get_edit_post_link( $disputed_order_id ));?>"><?php echo esc_html($title); ?></a>
                    </span>
                </li>
                <li>
                    <span class="push-right">
                        <a target="_blank" href="<?php echo esc_url(get_edit_post_link($linked_freelancer_profile));?>"><?php esc_html_e('View employer profile', 'workreap'); ?></a>
                    </span>
                </li>
                <li>
                    <span class="push-right">
                        <a target="_blank" href="<?php echo esc_url(get_the_permalink( $linked_employer_profile ));?>"><?php esc_html_e('View freelancer profile', 'workreap'); ?></a>
                    </span>
                </li>
                
			</ul>
            
			<?php
        }
    
    }

    new Workreap_Dispute();
}