<?php
/**
 *
 * Class 'GuppyNotifications' defines User active or deactive
 *
 * @package     Workreap
 * @subpackage  Workreap/helpers/templates
 * @author      Amentotech <info@amentotech.com>
 * @link        https://codecanyon.net/user/amentotech/portfolio
 * @version     1.0
 * @since       1.0
 */
if (!class_exists('GuppyNotifications')) {

	class GuppyNotifications extends Workreap_Email_helper {

		public function __construct() {
			//do stuff here
		}

		/**
		 * Chat notification email
		 */
		public function send_chat_notification_email( $params = '' ) {
			global $workreap_settings;
			extract( $params );

			$email_to        = ! empty( $email_to ) ? $email_to : '';
			$username   = ! empty( $username ) ? $username : '';
			$sender_name   = ! empty( $sender_name ) ? $sender_name : '';
			$message   = ! empty( $message ) ? $message : '';
			$reply   = ! empty( $reply ) ? $reply : '';

			$subject_default = esc_html__( 'Message Received from {{sender_name}}', 'workreap' ); //default email subject
			$contact_default = wp_kses( __( 'You have received a new message from {{sender_name}}.<br/> The message content is:<br/> {{message}}<br/> Please click on {{reply}} to reply.', 'workreap' ), //default email content
				array(
					'a'      => array(
						'href'  => array(),
						'title' => array()
					),
					'br'     => array(),
					'em'     => array(),
					'strong' => array(),
				) );

			$subject       = ! empty( $workreap_settings['subject_guppy_message_user_email'] ) ? $workreap_settings['subject_guppy_message_user_email'] : $subject_default; //getting subject
			$email_content = ! empty( $workreap_settings['content_guppy_message_user_email'] ) ? $workreap_settings['content_guppy_message_user_email'] : $contact_default; //getting content
			$greeting      = ! empty( $workreap_settings['greeting_guppy_message_user_email'] ) ? $workreap_settings['greeting_guppy_message_user_email'] : '';
			$reply_link = $this->process_email_links( $reply, esc_html__( 'Reply', 'workreap' ) ); //project/post link

			$subject = str_replace( "{{username}}", $username, $subject );
			$subject = str_replace( "{{sender_name}}", $sender_name, $subject );
			$subject = str_replace( "{{message}}", $message, $subject );
			$subject = str_replace( "{{reply}}", $reply_link, $subject );

			$email_content = str_replace( "{{username}}", $username, $email_content );
			$email_content = str_replace( "{{sender_name}}", $sender_name, $email_content );
			$email_content = str_replace( "{{message}}", $message, $email_content );
			$email_content = str_replace( "{{reply}}", $reply_link, $email_content );

			/* data for greeting */
			$greeting = str_replace( "{{username}}", $username, $greeting );
			$greeting = str_replace( "{{sender_name}}", $sender_name, $greeting );
			$greeting = str_replace( "{{message}}", $message, $greeting );
			$greeting = str_replace( "{{reply}}", $reply_link, $greeting );

			$body = $this->workreap_email_body( $email_content, $greeting );
			$body = apply_filters( 'workreap_guppy_message_notification_content', $body );
			wp_mail( $email_to, $subject, $body ); //send Email
		}
	}
}