<?php
/**
 *  Account settings
 *
 * @package     Workreap
 * @subpackage  Workreap/templates/dashboard
 * @author      Amentotech <info@amentotech.com>
 * @link        https://codecanyon.net/user/amentotech/portfolio
 * @version     1.0
 * @since       1.0
*/

global $current_user, $workreap_settings, $userdata, $post;
$user_type		  	= apply_filters('workreap_get_user_type', $current_user->ID );
if( function_exists('workreap_get_account_settings') ){
	$linked_profile	= workreap_get_linked_profile_id($current_user->ID,'',$user_type);
}

$social_list		= function_exists('workreap_get_social_media_icons_list') ? apply_filters('workreap_get_social_media_icons_list','')	: array();
$freelancer_socials	= !empty($workreap_settings['freelancer_socials']) ? $workreap_settings['freelancer_socials'] : array();
$db_socials			= get_post_meta($linked_profile, 'social_options', true);
?>

<div class="wr-social-wrapper wr-dhb-profile-settings">
	<div class="wr-dhb-mainheading">
		<h2><?php esc_html_e('Social profile items','workreap');?></h2>
	</div>
	<div class="wr-dhb-box-wrapper">
		<form id="wr_social_form" class="wr-themeform">
            <fieldset>
			<div class="wr-profileform__holder">
				<div class="wr-profileform__detail wr-social-info">
					<?php foreach( $freelancer_socials as $freelancer_social ){
						$social_options	= !empty($social_list[$freelancer_social]) ? $social_list[$freelancer_social] : $freelancer_social;
						if( empty($social_options) ){
							continue;
						}
						$icon		= !empty( $social_options['icon'] ) ? $social_options['icon'] : '';
						$classes	= !empty( $social_options['classses'] ) ? $social_options['classses'] : '';
						$placeholder	= !empty( $social_options['placeholder'] ) ? $social_options['placeholder'] : '';
						$color			= !empty( $social_options['color'] ) ? $social_options['color'] : '#484848';
						$social_url	= !empty( $db_socials[$freelancer_social] ) ? $db_socials[$freelancer_social] : '';
						if ( $icon != 'fa fa-twitter' ) {
							$social_i_class = '<i class="wt-icon ' . esc_attr( $icon ) . '" style="color:'. esc_attr( $color ) .'"></i>';
						} else {
							$social_i_class = '<span><svg width="68" height="68" viewBox="0 0 68 68" fill="none" xmlns="http://www.w3.org/2000/svg">
							<rect x="1" y="1" width="66" height="66" rx="13" stroke="white" stroke-width="2"/>
							<path d="M44.3906 17.75H49.8594L37.8281 31.5781L52.0469 50.25H40.9531L32.2031 38.9219L22.2812 50.25H16.7344L29.625 35.5625L16.0312 17.75H27.4375L35.25 28.1406L44.3906 17.75ZM42.4375 46.9688H45.4844L25.7969 20.875H22.5156L42.4375 46.9688Z" fill="white"/>
							</svg></span>';
						}
						?>
						 <div class="form-group-half wr-profilesocial__content <?php echo esc_attr( $classes ); ?>">
							<?php echo do_shortcode($social_i_class); ?>
							<input type="text" name="social[<?php echo esc_attr($freelancer_social);?>]" class="form-control" value="<?php echo esc_attr($social_url); ?>" placeholder="<?php echo esc_attr($placeholder); ?>">
						</div>
						
					<?php }?>
				</div>
			</div>
			<div class="wr-profileform__holder">
				<div class="wr-dhbbtnarea wr-dhbbtnareav2">
					<em><?php esc_html_e('Click “update now” to update latest changes made by you','workreap');?></em>
					<a href="javascript:void(0);" data-id="<?php echo intval($current_user->ID);?>" id="wr_update_social_profile" class="wr-btn"><?php esc_html_e('Update now','workreap');?> </a>
				</div>
			</div>
            </fieldset>
		</form>
	</div>
</div>
