<?php
add_action( 'admin_init', 'wpj_change_options_after_update_action' );
function wpj_change_options_after_update_action() {

	if ( get_option( 'wpjobster_installed_date' ) ) {
		// Update reCaptcha options - v6.2.7.2 to v6.2.8
		if ( ! get_option( 'wpj_update_recaptcha_options_v628' ) ) {
			$settings_options = get_option( 'jobster_settings' );

			if ( $settings_options ) {
				$settings_options['wpjobster_enable_user_register_reCaptcha'] = $settings_options['wpjobster_enable_user_reCaptcha'];
				$settings_options['wpjobster_enable_user_login_reCaptcha']    = $settings_options['wpjobster_enable_user_reCaptcha'];

				update_option( 'jobster_settings', $settings_options );
			}

			update_option( 'wpj_update_recaptcha_options_v628', 'done' );
		}

		// Add Emails content - v6.2.3 to v6.2.4
		if ( ! get_option( 'wpj_add_emails_content_for_notifications_v624' ) ) {
			update_option( 'uz_email_withdraw_req_confirmation_en_subject', 'You have requested a withdrawal' );
			update_option( 'uz_email_withdraw_req_confirmation_en_message',
				'Hello ##receiver_username##,'.PHP_EOL.PHP_EOL.

				'We have received your request. It will be processed within 2 to 3 working days.'.PHP_EOL.PHP_EOL.
				'Please click the following link in order to confirm your request: '.PHP_EOL.
				'##withdrawal_email_verification##'.PHP_EOL.PHP_EOL.

				'Withdraw details:'.PHP_EOL.
				'Amount: ##amount_withdrawn##'.PHP_EOL.
				'Method: ##withdraw_method##'.PHP_EOL.PHP_EOL.

				'Thank you,'.PHP_EOL.
				'##your_site_name## Team' );

			update_option( 'wpj_add_emails_content_for_notifications_v624', 'done' );
		}

		// Add SMS content - v6.2.3 to v6.2.4
		if ( ! get_option( 'wpj_add_sms_content_for_notifications_v624' ) ) {
			update_option( 'uz_sms_withdraw_req_confirmation_en_message',

				'Hello ##receiver_username##,'.PHP_EOL.PHP_EOL.

				'We have received your request. It will be processed within 2 to 3 working days.'.PHP_EOL.PHP_EOL.
				'Please click the following link in order to confirm your request: '.PHP_EOL.
				'##withdrawal_email_verification##'.PHP_EOL.PHP_EOL.

				'Amt: ##amount_withdrawn##'.PHP_EOL.
				'Method: ##withdraw_method##' );

			update_option( 'wpj_add_sms_content_for_notifications_v624', 'done' );
		}

		// Add authentication pages - v6.1.8.2 to v6.1.9
		if ( ! get_option( 'wpj_add_jobs_overview_page' ) ) {
			if ( ! wpj_get_page_by_title( 'Jobs Map Overview' ) )
				wpj_insert_page( 'wpjobster_jobs_map_overview_page_id', 'Jobs Map Overview', wpj_reset_page_action( '', 'Jobs Map Overview', false ) );

			update_option( 'wpj_add_jobs_overview_page', 'done' );
		}

		// Add auth menu - v6.1.4 to v6.1.5
		if ( ! get_option( 'wpj_add_auth_menu_v615' ) ) {
			$authentication_menu = wpj_get_menu_id_by_slug( 'authentication-menu' ) ? wpj_get_menu_id_by_slug( 'authentication-menu' ) : wp_create_nav_menu( 'Authentication Menu' );

			wp_update_nav_menu_item( $authentication_menu, 0, [
				'menu-item-object-id' => wpj_get_option( 'wpjobster_login_page_id' ),
				'menu-item-title'     => 'Login',
				'menu-item-classes'   => 'login-link',
				'menu-item-type'      => 'post_type',
				'menu-item-object'    => 'page',
				'menu-item-status'    => 'publish'
			] );

			wp_update_nav_menu_item( $authentication_menu, 0, [
				'menu-item-object-id' => wpj_get_option( 'wpjobster_register_page_id' ),
				'menu-item-title'     => 'Register',
				'menu-item-classes'   => 'register-link',
				'menu-item-type'      => 'post_type',
				'menu-item-object'    => 'page',
				'menu-item-status'    => 'publish'
			] );

			$locations = get_theme_mod( 'nav_menu_locations' );

			$main_menu     = get_term_by( 'name', 'Header Main Menu', 'nav_menu' );
			$dropdown_menu = get_term_by( 'name', 'Header User Dropdown Menu', 'nav_menu' );

			$locations['wpjobster_responsive_left_menu']           = $authentication_menu;
			$locations['wpjobster_responsive_right_menu']          = isset( $main_menu->term_id ) ? $main_menu->term_id : '';
			$locations['wpjobster_responsive_left_loggedin_menu']  = isset( $dropdown_menu->term_id ) ? $dropdown_menu->term_id : '';
			$locations['wpjobster_responsive_right_loggedin_menu'] = isset( $main_menu->term_id ) ? $main_menu->term_id : '';

			set_theme_mod( 'nav_menu_locations', $locations );

			update_option( 'wpj_add_auth_menu_v615', 'done' );
		}

		// Change auth register button colour - v6.1.3.3 to v6.1.4
		if ( is_array( get_option( 'jobster_design' ) ) && wpj_get_option( 'wpj_change_load_more_button_colour' ) != 'done' ) {
			$design_options = get_option( 'jobster_design' );

			if ( $design_options ) {
				$design_options['user_account_load_more_button_bg_colour']       = $design_options['site_primary_color'];
				$design_options['user_account_load_more_button_hover_bg_colour'] = $design_options['site_primary_color'];

				update_option( 'jobster_design', $design_options );
			}

			update_option( 'wpj_change_load_more_button_colour', 'done' );
		}

		if ( ! get_option( 'wpj_add_job_badge_orders_table_v614' ) ) {
			update_option( 'sql_imported', '' );
			update_option( 'wpj_add_job_badge_orders_table_v614', 'done' );
		}

		// Add Emails content - v6.1.2.1 to v6.1.3
		if ( ! get_option( 'wpj_add_emails_content_for_badges_v614' ) ) {
			update_option( 'uz_email_badge_admin_new_en_subject', 'New badge purchased on your site' );
			update_option( 'uz_email_badge_admin_new_en_message',
				'Hello admin,'.PHP_EOL.PHP_EOL.

				'A new badge has been purchased on your site by user ##username##:'.PHP_EOL.PHP_EOL.

				'Bage description: <b>##badge_title##</b>'.PHP_EOL.
				'Bage price: <b>##badge_price##</b>'.PHP_EOL.PHP_EOL.

				'Thank you,'.PHP_EOL.
				'##your_site_name## Team' );

			update_option( 'uz_email_badge_new_en_subject', 'New badge purchased on your site' );
			update_option( 'uz_email_badge_new_en_message',
				'Hello ##receiver_username##,'.PHP_EOL.PHP_EOL.

				'You bought a new badge'.PHP_EOL.PHP_EOL.

				'Bage description: <b>##badge_title##</b>'.PHP_EOL.
				'Bage price: <b>##badge_price##</b>'.PHP_EOL.PHP_EOL.

				'Thank you,'.PHP_EOL.
				'##your_site_name## Team' );

			update_option( 'wpj_add_emails_content_for_badges_v614', 'done' );
		}

		// Add SMS content - v6.1.2.1 to v6.1.3
		if ( ! get_option( 'wpj_add_sms_content_for_badges_v614' ) ) {
			update_option( 'uz_sms_badge_admin_new_en_message',
				'Hello admin,'.PHP_EOL.PHP_EOL.

				'A new badge has been purchased on your site by user ##username##:'.PHP_EOL.PHP_EOL.

				'Bage description: <b>##badge_title##</b>'.PHP_EOL.
				'Bage price: <b>##badge_price##</b>'.PHP_EOL.PHP_EOL.

				'Thank you,'.PHP_EOL.
				'##your_site_name## Team' );

			update_option( 'uz_sms_badge_new_en_message',
				'Hello ##receiver_username##,'.PHP_EOL.PHP_EOL.

				'You bought a new badge'.PHP_EOL.PHP_EOL.

				'Bage description: <b>##badge_title##</b>'.PHP_EOL.
				'Bage price: <b>##badge_price##</b>'.PHP_EOL.PHP_EOL.

				'Thank you,'.PHP_EOL.
				'##your_site_name## Team' );

			update_option( 'wpj_add_sms_content_for_badges_v614', 'done' );
		}

		// Add Emails content - v6.1.2.1 to v6.1.3
		if ( ! get_option( 'wpj_add_emails_content_for_notifications_v613' ) ) {
			update_option( 'uz_email_pending_payment_expires_en_subject', 'Pending payment ##transaction_number## will expire soon' );
			update_option( 'uz_email_pending_payment_expires_en_message',
				'Hello ##receiver_username##,'.PHP_EOL.PHP_EOL.

				'We would like to remind you that the pending payment for transaction number ##transaction_number## will expire soon.'.PHP_EOL.
				'Please complete the payment.'.PHP_EOL.PHP_EOL.

				'Job name: <a href="##job_link##"><b>##job_name##</b></a>'.PHP_EOL.PHP_EOL.
				'Transaction number: ##transaction_number##'.PHP_EOL.
				'Transaction page: ##transaction_page_link##'.PHP_EOL.PHP_EOL.

				'Regards,'.PHP_EOL.
				'##your_site_name## Team' );

			update_option( 'uz_email_incomplete_order_en_subject', 'Don\'t forget to order what do you have in the cart :)' );
			update_option( 'uz_email_incomplete_order_en_message',
				'Hello ##receiver_username##,'.PHP_EOL.PHP_EOL.

				'It\'s normal for other things to interfere with your shopping session, so this is a message to remind you that you\'ve been to the checkout page for these products but haven\'t completed the purchase process.'.PHP_EOL.PHP_EOL.

				'[start_list]'.PHP_EOL.
				'<a href="##job_link##"><b>##job_name##</b></a>'.PHP_EOL.
				'[end_list]'.PHP_EOL.PHP_EOL.

				'{job_checkout_viewed_listings}'.PHP_EOL.PHP_EOL.

				'Thank you,'.PHP_EOL.
				'##your_site_name## Team' );

			update_option( 'wpj_add_emails_content_for_notifications_v613', 'done' );
		}

		// Add SMS content - v6.1.2.1 to v6.1.3
		if ( ! get_option( 'wpj_add_sms_content_for_notifications_v613' ) ) {
			update_option( 'uz_sms_pending_payment_expires_en_message',
				'Hello ##receiver_username##,'.PHP_EOL.PHP_EOL.

				'We would like to remind you that the pending payment for transaction number ##transaction_number## will expire soon.'.PHP_EOL.
				'Please complete the payment.'.PHP_EOL.PHP_EOL.

				'Job name: <a href="##job_link##"><b>##job_name##</b></a>'.PHP_EOL.PHP_EOL.
				'Transaction number: ##transaction_number##'.PHP_EOL.
				'Transaction page: ##transaction_page_link##'.PHP_EOL.PHP_EOL.

				'Thank you,'.PHP_EOL.
				'##your_site_name## Team' );

			update_option( 'uz_sms_incomplete_order_en_message',
				'Hello ##receiver_username##,'.PHP_EOL.PHP_EOL.

				'It\'s normal for other things to interfere with your shopping session, so this is a message to remind you that you\'ve been to the checkout page for these products but haven\'t completed the purchase process.'.PHP_EOL.PHP_EOL.

				'[start_list]'.PHP_EOL.
				'<a href="##job_link##"><b>##job_name##</b></a>'.PHP_EOL.
				'[end_list]'.PHP_EOL.PHP_EOL.

				'Thank you,'.PHP_EOL.
				'##your_site_name## Team' );

			update_option( 'wpj_add_sms_content_for_notifications_v613', 'done' );
		}

		// Change auth register button colour - v6.1.2.1 to v6.1.3
		if ( is_array( get_option( 'jobster_design' ) ) && wpj_get_option( 'wpj_change_register_button_colour' ) != 'done' ) {
			$design_options = get_option( 'jobster_design' );

			if ( $design_options ) {
				$design_options['register_bg_colour_options_header']             = $design_options['site_primary_color'];
				$design_options['register_bg_hover_colour_options_header']       = $design_options['site_primary_color'];
				$design_options['register_front_bg_colour_options_header']       = $design_options['site_primary_color'];
				$design_options['register_front_bg_hover_colour_options_header'] = $design_options['site_primary_color'];

				update_option( 'jobster_design', $design_options );
			}

			update_option( 'wpj_change_register_button_colour', 'done' );
		}

		// Migrate 'wpjobster_enable_processingfee_tax' to 'wpjobster_tax_over' - v6.1.1 to v6.1.2
		if ( ! get_option( 'wpj_change_tax_over_option' ) ) {
			if ( wpj_get_option( 'wpjobster_enable_processingfee_tax' ) == 'yes' || wpj_get_option( 'wpjobster_enable_processingfee_tax' ) == 1 )
				if ( class_exists( 'Redux' ) ) Redux::set_option( 'jobster_settings', 'wpjobster_tax_over', 'job_and_pf' );
			else
				if ( class_exists( 'Redux' ) ) Redux::set_option( 'jobster_settings', 'wpjobster_tax_over', 'job' );

			update_option( 'wpj_change_tax_over_option', 'done' );
		}

		// Add authentication pages - v6.0.9 to v6.1.0
		if ( ! get_option( 'wpj_add_authentication_pages' ) ) {
			if ( ! wpj_get_page_by_title( 'Authentication - Register' ) )
				wpj_insert_page( 'wpjobster_register_page_id', 'Authentication - Register', wpj_reset_page_action( '', 'Authentication - Register', false ) );

			if ( ! wpj_get_page_by_title( 'Authentication - Forgot Password' ) )
				wpj_insert_page( 'wpjobster_forgot_password_page_id', 'Authentication - Forgot Password', wpj_reset_page_action( '', 'Authentication - Forgot Password', false ) );

			if ( ! wpj_get_page_by_title( 'Authentication - Login' ) )
				wpj_insert_page( 'wpjobster_login_page_id', 'Authentication - Login', wpj_reset_page_action( '', 'Authentication - Login', false ) );

			update_option( 'wpj_add_authentication_pages', 'done' );
		}

		// Update translsatepress settings
		if ( wpj_get_option( 'wpj_update_translatepress_settings' ) != 'done' ) {

			if ( class_exists( 'TRP_Translate_Press' ) ) {
				$trp_settings = get_option( 'trp_settings' );
				$trp_settings['trp-ls-floater'] = 'no';
				update_option( 'trp_settings', $trp_settings );

				update_option( 'wpj_update_translatepress_settings', 'done' );
			}
		}

		// Migration from v5 to v6
		if ( ! get_option( 'wpjobster_skip_migration' ) ) {

			// Deactivate child
			if ( wpj_get_option( 'wpj_deactivate_child_theme' ) != 'done' ) {
				if ( get_stylesheet() == 'wpjobster-child' )
					switch_theme( 'wpjobster' );

				update_option( 'wpj_deactivate_child_theme', 'done' );
			}

			// Payment instructions from ACF to META
			if ( wpj_get_option( 'wpj_v6_move_payment_content_from_acf_to_meta' ) != 'done' && function_exists( 'get_field' ) ) {
				update_post_meta( wpj_get_option( 'wpjobster_checkout_page_id' ), 'payment_instructions_title', get_field( 'payment_instructions_title', 'options' ) );
				update_post_meta( wpj_get_option( 'wpjobster_checkout_page_id' ), 'payment_instructions_description', get_field( 'payment_instructions_text', 'options' ) );

				update_option( 'wpj_v6_move_payment_content_from_acf_to_meta', 'done' );
			}

			// User description from OPTION to WP BIOGRAPHICAL INFO
			if ( wpj_get_option( 'wpj_v6_move_user_description_from_personal_info_to_biographical_info' ) != 'done' ) {
				$users = get_users();
				if ( $users ) {
					foreach ( $users as $key => $user ) {
						update_user_meta( $user->ID, 'description', get_user_meta( $user->ID, 'personal_info', true ) );
					}
				}

				update_option( 'wpj_v6_move_user_description_from_personal_info_to_biographical_info', 'done' );
			}

			// Change checkout option name
			if ( wpj_get_option( 'wpj_v6_change_extra_on_checkout_page_option_name' ) != 'done' ) {
				update_option( 'wpjobster_checkout_extra_enabled', wpj_get_option( 'wpjobster_purchase_this_extra_enabled' ) );

				update_option( 'wpj_v6_change_extra_on_checkout_page_option_name', 'done' );
			}

			// Change attachment max filesize option name
			if ( wpj_get_option( 'wpj_v6_change_attachment_max_filesize_option_name' ) != 'done' ) {
				update_option( 'wpjobster_max_attachment_upload_size', wpj_get_option( 'wpjobster_max_message_attachments_upload_size' ) );

				update_option( 'wpj_v6_change_attachment_max_filesize_option_name', 'done' );
			}

			// Change all users to sidebar option name
			if ( wpj_get_option( 'wpj_v6_change_all_users_to_sidebar_option_name' ) != 'done' ) {
				update_option( 'wpjobster_all_users_to_sidebar', wpj_get_option( 'all_users_to_sidebar' ) );

				update_option( 'wpj_v6_change_all_users_to_sidebar_option_name', 'done' );
			}

			// Import old OPTIONS to REDUX
			if ( is_array( get_option( 'jobster_settings' ) ) && wpj_get_option( 'wpj_v6_import_old_options' ) != 'done' ) {
				$options = get_option( 'jobster_settings' );

				if ( $options ) {
					foreach ( $options as $key => $option ) {
						if ( get_option( $key ) == 'yes' )
							$options[$key] = 1;
						elseif ( get_option( $key ) == 'no' )
							$options[$key] = 0;
						else
							$options[$key] = get_option( $key );

						// Mimes
						if ( $key == 'wpjobster_allowed_mime_types' && get_option( $key ) )
							$options[$key] = implode( ',', get_option( $key ) );

						// Filters
						if ( $key == 'wpj_filter_words1' || $key == 'wpj_filter_words2' || $key == 'wpj_filter_words3' || $key == 'wpj_filter_emails' || $key == 'wpj_filter_phone_numbers' ) {
							$fw1 = $fw2 = $fw3 = $fe = $fpn = [];

							$filter_categories = [ 'privatemessages', 'transactionpages', 'joblistings', 'requestlistings', 'userprofiles' ];

							foreach ( $filter_categories as $filter ) {
								if ( wpj_get_option( 'wpjobster_filter_words_' . $filter ) != 'no' )        $fw1[] = $filter;
								if ( wpj_get_option( 'wpjobster_filter_words2_' . $filter ) != 'no' )       $fw2[] = $filter;
								if ( wpj_get_option( 'wpjobster_filter_words3_' . $filter ) != 'no' )       $fw3[] = $filter;
								if ( wpj_get_option( 'wpjobster_filter_email_' . $filter ) != 'no' )        $fe[]  = $filter;
								if ( wpj_get_option( 'wpjobster_filter_phonenumbers_' . $filter ) != 'no' ) $fpn[] = $filter;
							}

							if ( $key == 'wpj_filter_words1' )        $options[$key] = $fw1;
							if ( $key == 'wpj_filter_words2' )        $options[$key] = $fw2;
							if ( $key == 'wpj_filter_words3' )        $options[$key] = $fw3;
							if ( $key == 'wpj_filter_emails' )        $options[$key] = $fe;
							if ( $key == 'wpj_filter_phone_numbers' ) $options[$key] = $fpn;
						}

						// Character Limits
						if ( $key == 'wpj_job_title_character_limits' )
							$options[$key] = [ '1' => get_option( 'wpjobster_characters_jobtitle_min' ), '2' => get_option( 'wpjobster_characters_jobtitle_max' ) ];
						if ( $key == 'wpj_job_description_character_limits' )
							$options[$key] = [ '1' => get_option( 'wpjobster_characters_description_min' ), '2' => get_option( 'wpjobster_characters_description_max' ) ];
						if ( $key == 'wpj_job_package_title_character_limits' )
							$options[$key] = [ '1' => get_option( 'wpjobster_characters_job_package_title_min' ), '2' => get_option( 'wpjobster_characters_job_package_title_max' ) ];
						if ( $key == 'wpj_job_package_description_character_limits' )
							$options[$key] = [ '1' => get_option( 'wpjobster_characters_job_package_description_min' ), '2' => get_option( 'wpjobster_characters_job_package_description_max' ) ];
						if ( $key == 'wpj_job_instructions_character_limits' )
							$options[$key] = [ '1' => get_option( 'wpjobster_characters_instructions_min' ), '2' => get_option( 'wpjobster_characters_instructions_max' ) ];
						if ( $key == 'wpj_job_extra_description_character_limits' )
							$options[$key] = [ '1' => get_option( 'wpjobster_characters_extradescription_min' ), '2' => get_option( 'wpjobster_characters_extradescription_max' ) ];
						if ( $key == 'wpj_request_title_character_limits' )
							$options[$key] = [ '1' => get_option( 'wpjobster_characters_request_title_min' ), '2' => get_option( 'wpjobster_characters_request_title_max' ) ];
						if ( $key == 'wpj_request_description_character_limits' )
							$options[$key] = [ '1' => get_option( 'wpjobster_characters_request_min' ), '2' => get_option( 'wpjobster_characters_request_min' ) ];
						if ( $key == 'wpj_custom_extra_character_limits' )
							$options[$key] = [ '1' => get_option( 'wpjobster_characters_customextra_min' ), '2' => get_option( 'wpjobster_characters_customextra_max' ) ];
						if ( $key == 'wpj_feedback_message_character_limits' )
							$options[$key] = [ '1' => get_option( 'wpjobster_characters_feedback_min' ), '2' => get_option( 'wpjobster_characters_feedback_max' ) ];
						if ( $key == 'wpj_private_message_character_limits' )
							$options[$key] = [ '1' => get_option( 'wpjobster_characters_message_min' ), '2' => get_option( 'wpjobster_characters_message_max' ) ];

						// Price Limits
						if ( $key == 'wpj_package_amount_price_limits' )
							$options[$key] = [ '1' => get_option( 'wpjobster_min_package_amount' ), '2' => get_option( 'wpjobster_max_package_amount' ) ];

						if ( $key == 'wpj_custom_offer_amount_price_limits' )
							$options[$key] = [ '1' => get_option( 'wpjobster_offer_price_min' ), '2' => get_option( 'wpjobster_offer_price_max' ) ];

						for ( $i = 0; $i < 4; $i++ ) {
							if ( $key == 'wpj_job_price_limits_level' . $i )
								$options[$key] = [ '1' => get_option( 'wpjobster_get_level' . $i . '_min_amount' ), '2' => get_option( 'wpjobster_get_level' . $i . '_max_amount' ) ];
							if ( $key == 'wpj_job_price_limits_subscription_level' . $i )
								$options[$key] = [ '1' => get_option( 'wpjobster_subscription_min_job_price_level' . $i ), '2' => get_option( 'wpjobster_subscription_max_job_price_level' . $i ) ];

							if ( $key == 'wpj_job_extra_price_limits_level' . $i )
								$options[$key] = [ '1' => get_option( 'wpjobster_get_level' . $i . '_min_extra_amount' ), '2' => get_option( 'wpjobster_get_level' . $i . '_max_extra_amount' ) ];
							if ( $key == 'wpj_job_extra_price_limits_subscription_level' . $i )
								$options[$key] = [ '1' => get_option( 'wpjobster_subscription_min_extra_price_level' . $i ), '2' => get_option( 'wpjobster_subscription_max_extra_price_level' . $i ) ];

							if ( $key == 'wpj_custom_extra_price_limits_level' . $i )
								$options[$key] = [ '1' => get_option( 'wpjobster_get_level' . $i . '_min_customextrasamount' ), '2' => get_option( 'wpjobster_get_level' . $i . '_customextrasamount' ) ];
							if ( $key == 'wpj_custom_extra_price_limits_subscription_level' . $i )
								$options[$key] = [ '1' => get_option( 'wpjobster_subscription_min_customextrasamount_level' . $i ), '2' => get_option( 'wpjobster_subscription_max_customextrasamount_level' . $i ) ];
						}

					}

					// Flexible Fees
					$key = 'flexible-fee-settings';

					$fee_arr = [
						'redux_repeater_data' => array( '0' => array( 'title' => '' ) ),
						'flexible_fee_over'   => array( 0 ),
						'level0_flexible_fee' => array( get_option( 'wpjobster_percent_fee_taken_range0_level0' ) ),
						'level1_flexible_fee' => array( get_option( 'wpjobster_percent_fee_taken_range0_level1' ) ),
						'level2_flexible_fee' => array( get_option( 'wpjobster_percent_fee_taken_range0_level2' ) ),
						'level3_flexible_fee' => array( get_option( 'wpjobster_percent_fee_taken_range0_level3' ) ),
					];

					if ( get_option( 'wpjobster_percent_fee_taken_range1_base' ) ) {
						array_push( $fee_arr['redux_repeater_data'], [ 'title' => '' ] );
						array_push( $fee_arr['flexible_fee_over'], get_option( 'wpjobster_percent_fee_taken_range1_base' ) );
						array_push( $fee_arr['level0_flexible_fee'], get_option( 'wpjobster_percent_fee_taken_range1_level0' ) );
						array_push( $fee_arr['level1_flexible_fee'], get_option( 'wpjobster_percent_fee_taken_range1_level1' ) );
						array_push( $fee_arr['level2_flexible_fee'], get_option( 'wpjobster_percent_fee_taken_range1_level2' ) );
						array_push( $fee_arr['level3_flexible_fee'], get_option( 'wpjobster_percent_fee_taken_range1_level3' ) );
					}

					if ( get_option( 'wpjobster_percent_fee_taken_range2_base' ) ) {
						array_push( $fee_arr['redux_repeater_data'], [ 'title' => '' ] );
						array_push( $fee_arr['flexible_fee_over'], get_option( 'wpjobster_percent_fee_taken_range2_base' ) );
						array_push( $fee_arr['level0_flexible_fee'], get_option( 'wpjobster_percent_fee_taken_range2_level0' ) );
						array_push( $fee_arr['level1_flexible_fee'], get_option( 'wpjobster_percent_fee_taken_range2_level1' ) );
						array_push( $fee_arr['level2_flexible_fee'], get_option( 'wpjobster_percent_fee_taken_range2_level2' ) );
						array_push( $fee_arr['level3_flexible_fee'], get_option( 'wpjobster_percent_fee_taken_range2_level3' ) );
					}

					if ( get_option( 'wpjobster_percent_fee_taken_range3_base' ) ) {
						array_push( $fee_arr['redux_repeater_data'], [ 'title' => '' ] );
						array_push( $fee_arr['flexible_fee_over'], get_option( 'wpjobster_percent_fee_taken_range3_base' ) );
						array_push( $fee_arr['level0_flexible_fee'], get_option( 'wpjobster_percent_fee_taken_range3_level0' ) );
						array_push( $fee_arr['level1_flexible_fee'], get_option( 'wpjobster_percent_fee_taken_range3_level1' ) );
						array_push( $fee_arr['level2_flexible_fee'], get_option( 'wpjobster_percent_fee_taken_range3_level2' ) );
						array_push( $fee_arr['level3_flexible_fee'], get_option( 'wpjobster_percent_fee_taken_range3_level3' ) );
					}

					$options[$key] = $fee_arr;

					// Tax
					$key = 'country-tax-settings';

					if ( get_option( 'wpjobster_country_taxes_percentage' ) ) {
						$redux_repeater_data = $country_name = $country_tax = [];

						foreach ( get_option( 'wpjobster_country_taxes_percentage' ) as $t_key => $t_value ) {
							$redux_repeater_data[] = [ 'title' => '' ];
							$country_name[]        = strtoupper( $t_key );
							$country_tax[]         = $t_value;
						}

						$tax_arr = [
							'redux_repeater_data' => $redux_repeater_data,
							'country_name'        => $country_name,
							'country_tax'         => $country_tax
						];

						$options[$key] = $tax_arr;
					}

					// Site currency
					$key = 'add-new-currency';

					$currency_arr = [
						'redux_repeater_data' => array( '0' => array( 'title' => '' ) ),
						'currency_name'       => array( get_option( 'wpjobster_currency_1' ) ),
						'curency_symbol'      => array( get_option( 'wpjobster_currency_symbol_1' ) ),
					];

					for ( $i = 2; $i <= 10; $i++ ) {
						if ( get_option( 'wpjobster_currency_' . $i ) ) {
							array_push( $currency_arr['redux_repeater_data'], [ 'title' => '' ] );
							array_push( $currency_arr['currency_name'], get_option( 'wpjobster_currency_' . $i ) );
							array_push( $currency_arr['curency_symbol'], get_option( 'wpjobster_currency_symbol_' . $i ) );
						}
					}

					$options[$key] = $currency_arr;

					// Badges
					$key = 'badge-list-settings';

					$redux_repeater_data = $wpj_badge_text = $wpj_badge_icon = $wpj_badge_price = $wpj_badge_min_rating = $wpj_badge_min_reviews = [];

					if ( get_option( 'wpj_user_badges_data' ) ) {
						foreach ( get_option( 'wpj_user_badges_data' ) as $b_key => $b_value ) {
							$redux_repeater_data[]   = [ 'title' => '' ];
							$wpj_badge_text[]        = get_option( 'wpj_user_badges_data' )[$b_key]['text'];
							$wpj_badge_icon[]        = get_option( 'wpj_user_badges_data' )[$b_key]['icon'];
							$wpj_badge_price[]       = get_option( 'wpj_user_badges_data' )[$b_key]['price'];
							$wpj_badge_min_rating[]  = get_option( 'wpj_user_badges_data' )[$b_key]['min_rating'];
							$wpj_badge_min_reviews[] = get_option( 'wpj_user_badges_data' )[$b_key]['min_reviews'];
						}
					}

					$badge_arr = [
						'redux_repeater_data'   => $redux_repeater_data,
						'wpj_badge_text'        => $wpj_badge_text,
						'wpj_badge_icon'        => $wpj_badge_icon,
						'wpj_badge_price'       => $wpj_badge_price,
						'wpj_badge_min_rating'  => $wpj_badge_min_rating,
						'wpj_badge_min_reviews' => $wpj_badge_min_reviews,
					];

					$options[$key] = $badge_arr;

					// Topup
					$key = 'topup-packages-settings';

					if ( wpj_topup_packages_table_exist() ) {
						$results = wpj_get_topup_package( 'cost, credit', [], 'results' );

						if ( $results ) {
							$redux_repeater_data = $topup_cost = $topup_credit = [];

							foreach ( $results as $row ) {
								$redux_repeater_data[] = [ 'title' => '' ];
								$topup_cost[]          = $row->cost;
								$topup_credit[]        = $row->credit;
							}

							$topup_arr = [
								'redux_repeater_data' => $redux_repeater_data,
								'topup_cost'          => $topup_cost,
								'topup_credit'        => $topup_credit
							];

							$options[$key] = $topup_arr;
						}
					}

					// END
					update_option( 'jobster_settings', $options );

					update_option( 'wpj_v6_import_old_options', 'done' );
				}
			}

			// Import old CUSTOMIZER options to REDUX
			if ( is_array( get_option( 'jobster_design' ) ) && wpj_get_option( 'wpj_v6_import_old_customizer_options' ) != 'done' ) {
				$design_options = get_option( 'jobster_design' );

				if ( $design_options ) {
					foreach ( $design_options as $d_key => $d_option ) {
						if ( get_theme_mod( $d_key ) ) {

							if ( $d_key == 'site_width' ) {
								$design_options[$d_key]['width'] = get_theme_mod( 'site_width_value' ) . ( get_theme_mod( 'site_width_type' ) == 'percentage' ? '%' : 'px' );
								$design_options[$d_key]['units'] = get_theme_mod( 'site_width_type' ) == 'percentage' ? '%' : 'px';

							} elseif ( $d_key == 'site_primary_color' ) {
								$design_options[$d_key] = get_theme_mod( 'primary_color' );

							} elseif ( $d_key == 'site_secondary_color' ) {
								$design_options[$d_key] = get_theme_mod( 'secondary_color' );

							} elseif ( $d_key == 'site_logo' || $d_key == 'footer_logo_image' ) {
								$design_options[$d_key] = [];

								$logo_data = wp_get_attachment_metadata( wpj_get_attachment_id_from_url( get_theme_mod( $d_key ) ) );

								$design_options[$d_key]['id']        = wpj_get_attachment_id_from_url( get_theme_mod( $d_key ) );
								$design_options[$d_key]['height']    = $logo_data['height'];
								$design_options[$d_key]['width']     = $logo_data['width'];
								$design_options[$d_key]['url']       = get_theme_mod( $d_key );
								$design_options[$d_key]['thumbnail'] = get_theme_mod( $d_key );

							} elseif (
								$d_key == 'logo_spacing'
								|| $d_key == 'footer_logo_spacing'
								|| $d_key == 'no_image_icon_options_job'
								|| $d_key == 'lets_meet_rich_icon_options_request'
								|| $d_key == 'no_image_icon_options_user'
								|| $d_key == 'level1_icon_options_user'
								|| $d_key == 'level2_icon_options_user'
								|| $d_key == 'level3_icon_options_user'
								|| $d_key == 'level1_card_icon_options_user'
								|| $d_key == 'level2_card_icon_options_user'
								|| $d_key == 'level3_card_icon_options_user'
							) {
								$design_options[$d_key]['padding-top']    = get_theme_mod( $d_key )['top'];
								$design_options[$d_key]['padding-right']  = get_theme_mod( $d_key )['right'];
								$design_options[$d_key]['padding-bottom'] = get_theme_mod( $d_key )['bottom'];
								$design_options[$d_key]['padding-left']   = get_theme_mod( $d_key )['left'];
								$design_options[$d_key]['units']          = 'px';

							} elseif ( $d_key == 'scroll_icon_color' ) {
								$design_options[$d_key]['regular'] = get_theme_mod( $d_key )['link'];

							} elseif ( $d_key == 'scroll_to_top_border' ) {
								$design_options[$d_key]['border-top']    = get_theme_mod( 'scroll_to_top_border_size' );
								$design_options[$d_key]['border-right']  = get_theme_mod( 'scroll_to_top_border_size' );
								$design_options[$d_key]['border-bottom'] = get_theme_mod( 'scroll_to_top_border_size' );
								$design_options[$d_key]['border-left']   = get_theme_mod( 'scroll_to_top_border_size' );
								$design_options[$d_key]['border-style']  = get_theme_mod( 'scroll_to_top_border_style' );
								$design_options[$d_key]['border-color']  = get_theme_mod( 'scroll_to_top_border_color' );

							} elseif ( $d_key == 'main-font-settings' ) {
								$design_options[$d_key]['font-family'] = get_theme_mod( 'primary_font_family' )['font-family'];
								$design_options[$d_key]['font-size']   = get_theme_mod( 'primary_font_family' )['font-size'];
								$design_options[$d_key]['line-height'] = get_theme_mod( 'primary_font_family' )['line-height'];
								$design_options[$d_key]['color']       = get_theme_mod( 'primary_font_family' )['color'];
								$design_options[$d_key]['font-weight'] = get_theme_mod( 'primary_font_family' )['font-weight'];

							} elseif ( $d_key == 'header-menus-settings' ) {
								$design_options[$d_key]['font-family'] = get_theme_mod( 'header_font_family' )['font-family'];
								$design_options[$d_key]['font-size']   = get_theme_mod( 'header_font_family' )['font-size'];
								$design_options[$d_key]['line-height'] = get_theme_mod( 'header_font_family' )['line-height'];
								$design_options[$d_key]['color']       = get_theme_mod( 'header_font_family' )['color'];
								$design_options[$d_key]['font-weight'] = get_theme_mod( 'header_font_family' )['font-weight'];

							} elseif ( $d_key == 'footer-menus-settings' ) {
								$design_options[$d_key]['font-family'] = get_theme_mod( 'footer_font_family' )['font-family'];
								$design_options[$d_key]['font-size']   = get_theme_mod( 'footer_font_family' )['font-size'];
								$design_options[$d_key]['line-height'] = get_theme_mod( 'footer_font_family' )['line-height'];
								$design_options[$d_key]['color']       = get_theme_mod( 'footer_font_family' )['color'];
								$design_options[$d_key]['font-weight'] = get_theme_mod( 'footer_font_family' )['font-weight'];

							} elseif (
								$d_key == 'h1-font-settings'
								|| $d_key == 'h2-font-settings'
								|| $d_key == 'h3-font-settings'
								|| $d_key == 'h4-font-settings'
								|| $d_key == 'h5-font-settings'
								|| $d_key == 'h6-font-settings'
							) {
								$design_options[$d_key]['font-family'] = get_theme_mod( 'secondary_font_family' )['font-family'];
								$design_options[$d_key]['line-height'] = get_theme_mod( 'secondary_font_family' )['line-height'];
								$design_options[$d_key]['color']       = get_theme_mod( 'secondary_font_family' )['color'];
								$design_options[$d_key]['font-weight'] = get_theme_mod( 'secondary_font_family' )['font-weight'];

							} elseif ( $d_key == 'chat_sidebar_text_color' ) {
								$design_options[$d_key]['regular'] = get_theme_mod( 'chat_sidebar_text_color' );
								$design_options[$d_key]['hover']   = get_theme_mod( 'chat_sidebar_text_hover_color' );

							} elseif ( $d_key == 'chat_responsive_sidebar_head_text_color' ) {
								$design_options[$d_key]['regular'] = get_theme_mod( 'chat_responsive_sidebar_head_color' );
								$design_options[$d_key]['hover']   = get_theme_mod( 'chat_responsive_sidebar_head_color' );

							} elseif ( $d_key == 'chat_box_head_buttons_color' ) {
								$design_options[$d_key]['regular'] = get_theme_mod( 'chat_box_head_buttons_color' );
								$design_options[$d_key]['hover']   = get_theme_mod( 'chat_box_head_hover_buttons_color' );
								$design_options[$d_key]['focus']   = get_theme_mod( 'chat_box_head_focus_buttons_color' );

							} elseif ( $d_key == 'chat_box_footer_buttons_color' ) {
								$design_options[$d_key]['regular'] = get_theme_mod( 'chat_box_footer_buttons_color' );
								$design_options[$d_key]['hover']   = get_theme_mod( 'chat_box_footer_hover_buttons_color' );

							} else {
								$design_options[$d_key] = get_theme_mod( $d_key );

							}
						}
					}

					// Cards
					$d_key = 'image_demo';

					if ( is_array( get_theme_mod( $d_key ) ) ) {
						$design_options[$d_key] = [ 'redux_repeater_data' => array( array( 'title' => '' ) ), 'card_item' => array() ];

						foreach ( get_theme_mod( $d_key ) as $key => $image ) {
							$design_options[$d_key]['redux_repeater_data'][$key]['title'] = '';

							$design_options[$d_key]['card_item'][$key]['id']        = $image['link_url'];
							$design_options[$d_key]['card_item'][$key]['height']    = 50;
							$design_options[$d_key]['card_item'][$key]['width']     = 50;
							$design_options[$d_key]['card_item'][$key]['url']       = wp_get_attachment_image_url( $image['link_url'] );
							$design_options[$d_key]['card_item'][$key]['thumbnail'] = wp_get_attachment_image_url( $image['link_url'] );
						}
					}

					// Social icons
					$d_key = 'social_media_list';

					if ( wp_get_nav_menu_items( 'social-media-menu' ) ) {
						$design_options[$d_key] = [ 'redux_repeater_data' => array( array( 'title' => '' ) ), 'social_media_icon_name' => array(), 'social_media_link' => array() ];

						foreach ( wp_get_nav_menu_items( 'social-media-menu' ) as $key => $icon ) {
							$design_options[$d_key]['redux_repeater_data'][$key]['title'] = '';

							if ( strtolower( $icon->title ) == strtolower( 'facebook' ) ) $title = 'facebook f';
							elseif ( strtolower( $icon->title ) == strtolower( 'google+' ) )  $title = 'google';
							else $title = strtolower( $icon->title );

							$design_options[$d_key]['social_media_icon_name'][$key] = $title;
							$design_options[$d_key]['social_media_link'][$key]      = $icon->url;

						}
					}

					// END
					update_option( 'jobster_design', $design_options );

					update_option( 'wpj_v6_import_old_customizer_options', 'done' );
				}
			}

		}

	}

}